// Persistence of Vision Ray Tracer Scene Description File
// File: TrackSolidBridge.inc
// Vers: 3.1
// Desc: Solid tunnel bridge
// Date: 3/??/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end


#include "TrackCrossSection.inc"
#include "TrackConnects.inc"

#declare SolidBridgeOutlineNumPoints = 31;
#declare SolidBridgeOutline = array[31] {	< 0.05, 0.00>,< 0.00, 0.05>,< 0.00, 0.25>, // lower left corner
												< 0.00, 0.45>,< 0.05, 0.50>,< 0.25, 0.50>, // Top left corner
												< 1.71, 0.52>,< 3.13, 0.68>,< 4.73, 1.13>,< 6.78, 1.95>,
												< 9.00, 2.70>,<10.00, 2.93>,
												<11.00, 3.00>,<11.20, 3.01>,<11.45, 3.00>,<11.49, 2.95>,
												<11.50, 2.80>,<11.50, 2.55>,<11.45, 2.50>,<11.05, 2.45>,
												<10.47, 2.25>,<10.22, 1.78>,<10.05, 0.44>,
												<10.00, 0.05>,< 9.95, 0.00>,< 9.50, 0.00>,< 8.00, 0.00>,
												< 2.00, 0.00>,< 1.00, 0.00>,< 0.50, 0.00>,< 0.25, 0.00>}
#declare SolidBridgeTrackSubtractionNumPoints = 15;
#declare SolidBridgeTrackSubtraction = array[15] 
						{	<-1.00, 0.50>,<-0.50, 0.50>,< 0.25, 0.50>, 
							< 1.71, 0.52>,< 3.13, 0.68>,< 4.73, 1.13>,< 6.78, 1.95>,
							< 9.00, 2.70>,<10.00, 2.93>,
							<11.00, 3.00>,<11.20, 3.01>,<11.45, 3.00>,<12.50, 3.00>,
							<12.50, 4.00>,< 0.00, 4.00>
						}
												
#declare SolidBridgeBlock1Track = prism {
	linear_sweep
	cubic_spline
	0,
	-TrackCrossSectionSize.x, // width of the cross section
	SolidBridgeOutlineNumPoints+3, // Last points to close the curve.
	#local Count = 0;
	#while (Count < SolidBridgeOutlineNumPoints)
		SolidBridgeOutline[Count],
		#local Count = Count+1;
	#end
	SolidBridgeOutline[0],
	SolidBridgeOutline[1],
	SolidBridgeOutline[2]
	rotate -90*x
	//translate <0,0,-TrackCrossSectionCenter.x>
}	
#declare SolidBridgeTrackSubtractionTrack = prism {
	linear_sweep
	cubic_spline
	0,
	-TrackGrooveSize.x, // width of the cross section
	SolidBridgeTrackSubtractionNumPoints+3, // Last points to close the curve.
	#local Count = 0;
	#while (Count < SolidBridgeTrackSubtractionNumPoints)
		SolidBridgeTrackSubtraction[Count] - <TrackGrooveSize.y,TrackGrooveSize.y>,
		#local Count = Count+1;
	#end
	SolidBridgeTrackSubtraction[0] - <TrackGrooveSize.y,TrackGrooveSize.y>,
	SolidBridgeTrackSubtraction[1] - <TrackGrooveSize.y,TrackGrooveSize.y>,
	SolidBridgeTrackSubtraction[2] - <TrackGrooveSize.y,TrackGrooveSize.y>
	rotate -90*x
	//translate <0,0,-TrackCrossSectionCenter.x>
}	

#local BridgeLength = TrackUnitLength+TrackMiniUnitLength;

#declare SolidBridge1TrackConnectsPosition = array[2] {<0,0,0>,<BridgeLength,TrackRiserHeight,0>}
#declare SolidBridge1TrackNumConnects = 2;
#declare SolidBridge1TrackConnectsAngle = array[2] {<0,180,0>, <0,0,0>}
#declare SolidBridge1TrackConnectsGender = array[2] {0,1}
#declare SolidBridge1Block = difference{
	object {
		SolidBridgeBlock1Track
	}
	object {
		SolidBridgeTrackSubtractionTrack
		translate <0,0,TrackGroovePosition[0].x>
	}
	object {
		SolidBridgeTrackSubtractionTrack
		translate <0,0,TrackGroovePosition[1].x>
	}
	translate <0,0,-TrackCrossSectionSize.x/2>
	scale <BridgeLength/11.5,TrackRiserHeight/2.5,1>
}
#declare SolidBridge1Track = union {
	object {
		TrackMaleConnect1
		translate SolidBridge1TrackConnectsPosition[1]
	}
	difference {
		object {SolidBridge1Block}
		object {
			TrackFemaleConnect1
			scale <1,2,1>
			translate <0,-0.25,0>
		}
	}
}



#declare SolidBridge2TrackConnectsPosition = array[2] {<0,0,0>,<BridgeLength,-TrackRiserHeight,0>}
#declare SolidBridge2TrackNumConnects = 2;
#declare SolidBridge2TrackConnectsAngle = array[2] {<0,180,0>, <0,0,0>}
#declare SolidBridge2TrackConnectsGender = array[2] {0,1}
#declare SolidBridge2Track = union {
	object {
		TrackMaleConnect1
		translate SolidBridge2TrackConnectsPosition[1]
	}
	difference {
		object {
			SolidBridge1Block
			rotate y*180
			translate SolidBridge2TrackConnectsPosition[1]
		}
		object {
			TrackFemaleConnect1
			scale <1,2,1>
			translate <0,-0.25,0>
		}
	}
}

#if (Render = 1)
	#include "TrackTextures.inc"

	camera
	{
	  location  <6,10,-5>
	  //right <16,0,0>
	  //up <12,0,0>
	  look_at   <6,2,1>
	}
	object {SolidBridge1Track
		texture {TrackWood_T}
	}

/*
	camera
	{
	  location  SolidBridgeOutline[12] + <0, .5, -1>
	  //right <16,0,0>
	  //up <12,0,0>
	  look_at   SolidBridgeOutline[12]
	}
*/
	background{color rgb 1}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color red 1.0  green 1.0  blue 1.0  // light's color
	  translate <0, 15, -10>
	}
	light_source
	{
	  0*x // light's position (translated below)
	  color red 1.0  green 1.0  blue 1.0  // light's color
	  translate <0, 15, 0>
	}
	#local Count = 0;
	#while (Count < SolidBridgeOutlineNumPoints)
		sphere {
			SolidBridgeOutline[Count],
			0.05
			pigment {color rgb <1,0,0>}
		}
		#local Count = Count + 1;
	#end
#end
