// Persistence of Vision Ray Tracer Scene Description File
// File: TrackSupport1.inc
// Vers: 3.1
// Desc: 
// Date: 3/14/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end


#include "TrackCrossSection.inc"

//TrackRiserHeight

#declare Support1OutlineNumPoints = 12;
#declare Support1Outline = array[12]

#declare Support1Profile = array[6] {<-3.0,.5>,<-2.8,.5>,<-2.6,0>,<2.6,0>,<2.8,.5>,<3.0,.5>}

#local Count = 0;
#while (Count < 6)
	#declare Support1Outline[Count] = Support1Profile[Count]/2.54;
	#local Count = Count + 1;
#end
#local Count = Count -1;
#while (Count > -1)
	#declare Support1Outline[5+(6-Count)] = Support1Profile[Count]/2.54-<0,TrackRiserHeight>;
	#local Count = Count -1;
#end

#declare Support1TrackNumConnects = 2;
#declare Support1TrackConnectsPosition = array[2] {<0,0,0>,<0,0,0>}
#declare Support1TrackConnectsAngle = array[2] {<0,180,0>, <0,0,0>}
#declare Support1TrackConnectsGender = array[2] {0,1} // This is standard, and a hack.
#declare Support1TrackDepth = 1;
#declare Support1Track = prism {
	linear_sweep
	linear_spline
	-Support1TrackDepth/2, // from
	Support1TrackDepth/2, // to
	Support1OutlineNumPoints + 1,
	#local Count = 0;
	#while (Count < Support1OutlineNumPoints)
		Support1Outline[Count],
		#local Count = Count + 1;
	#end
	Support1Outline[0]
	rotate -90*x
	rotate 90*y
}
//#declare Support2Track = prism

#if (Render = 1)
	#include "colors.inc"
	#include "TrackTextures.inc"
	object {
		Support1Track
		texture {TrackWood_T}
	}
	sphere {
		0,
		.5
		pigment {Red}
	}
	camera
	{
	  location  <0.0 , 2.0 ,-10.0>
	  look_at   <0.0 , 0.0 , 0.0>
	}
	background{White}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color red 1.0  green 1.0  blue 1.0  // light's color
	  translate <0, 30, -20>
	}
#end


