// Persistence of Vision Ray Tracer Scene Description File
// File: TrackTSplit.inc
// Vers: 3.1
// Desc: T Split track
// Date: 4/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end


#include "TrackCrossSection.inc"
#include "TrackConnects.inc"

#local Radius = TrackShortCurveRadius;
#local InnerRadius = Radius - TrackCrossSectionSize.x/2;
#local OuterRadius = InnerRadius + TrackCrossSectionSize.x;
	
// This is a 90deg arc.
#declare ShortCurveBlockRExtension = intersection {
	lathe{
		linear_spline
		TrackCrossSectionRExtension2NumPoints+1,
		#local Count = 0;
		#while (Count < TrackCrossSectionRExtension2NumPoints)
			TrackCrossSectionRExtension2[Count] + <InnerRadius,0>,
			#local Count = Count+1;
		#end
		TrackCrossSectionRExtension2[0] + <InnerRadius,0>
	}
	box {
		<0,-.1,0>,
		<OuterRadius+4,TrackCrossSectionSize.y+.1,OuterRadius+4>
	}
}	

#declare TSplitTrackConnectsAngle = array[3] {<0,180,0>, <0,270,0>, <0,0,0>}
#declare TSplitTrackConnectsPosition = array[3] {<0,0,0>, <Radius,0,Radius>,<TrackUnitLength,0,0>}
#declare TSplitTrackNumConnects = 3;

#declare LongStraightBlock = prism {
	linear_sweep
	linear_spline
	TSplitTrackConnectsPosition[0].x,
	TSplitTrackConnectsPosition[2].x,
	TrackCrossSectionRExtension2NumPoints+1, // Last point to close the curve.
	#local Count = 0;
	#while (Count < TrackCrossSectionRExtension2NumPoints)
		TrackCrossSectionRExtension2[Count],
		#local Count = Count+1;
	#end
	TrackCrossSectionRExtension2[0]
	rotate 180*y
	rotate 90*x
	rotate 90*y
	translate <0,0,-TrackCrossSectionCenter.x>
}


#declare TSplitTrackConnectsGender = array[3] {0,1,1}

#declare TSplitBlock = intersection {
	object {
		ShortCurveBlockRExtension
		rotate 90*y
		translate <0,0,Radius>
//		pigment {color rgb <1,0,0>}
	}
	object {
		ShortCurveBlockRExtension
		rotate 180*y
		translate <2*Radius,0.0001,Radius>
//		pigment {color rgb <0,1,0>}
	}
	object {LongStraightBlock
		translate <0,-0.0001,0>
//		pigment {color rgb <0,0,1>}
	}
}	

#include "TrackFunctions.inc"

#declare TSplitFMMTrackConnectsAngle = TSplitTrackConnectsAngle
#declare TSplitFMMTrackConnectsPosition = TSplitTrackConnectsPosition
#declare TSplitFMMTrackNumConnects = TSplitTrackNumConnects;
#declare TSplitFMMTrackConnectsGender = array[3] {0,1,1}

#declare TSplitFMMTrack = AddConnects(TSplitBlock, 
											TSplitFMMTrackConnectsAngle,
											TSplitFMMTrackConnectsPosition,
											TSplitFMMTrackConnectsGender,
											TSplitFMMTrackNumConnects)
											
#declare TSplitFFMTrackConnectsAngle = TSplitTrackConnectsAngle
#declare TSplitFFMTrackConnectsPosition = TSplitTrackConnectsPosition
#declare TSplitFFMTrackNumConnects = TSplitTrackNumConnects;
#declare TSplitFFMTrackConnectsGender = array[3] {0,0,1}

#declare TSplitFFMTrack = AddConnects(TSplitBlock, 
											TSplitFFMTrackConnectsAngle,
											TSplitFFMTrackConnectsPosition,
											TSplitFFMTrackConnectsGender,
											TSplitFFMTrackNumConnects)
											
#declare TSplitMFFTrackConnectsAngle = TSplitTrackConnectsAngle
#declare TSplitMFFTrackConnectsPosition = TSplitTrackConnectsPosition
#declare TSplitMFFTrackNumConnects = TSplitTrackNumConnects;
#declare TSplitMFFTrackConnectsGender = array[3] {1,0,0}

#declare TSplitMFMTrack = AddConnects(TSplitBlock, 
											TSplitMFFTrackConnectsAngle,
											TSplitMFFTrackConnectsPosition,
											TSplitMFFTrackConnectsGender,
											TSplitMFFTrackNumConnects)
											
#declare TSplitMMFTrackConnectsAngle = TSplitTrackConnectsAngle
#declare TSplitMMFTrackConnectsPosition = TSplitTrackConnectsPosition
#declare TSplitMMFTrackNumConnects = TSplitTrackNumConnects;
#declare TSplitMMFTrackConnectsGender = array[3] {1,1,0}

#declare TSplitMMFTrack = AddConnects(TSplitBlock, 
											TSplitMMFTrackConnectsAngle,
											TSplitMMFTrackConnectsPosition,
											TSplitMMFTrackConnectsGender,
											TSplitMMFTrackNumConnects)
											

#if (Render = 1)
	#include "TrackTextures.inc"

	object {
		TSplitFMMTrack
		texture {TrackWood_T}
		translate <-1,0,-1>
	}
		object {
		TSplitFFMTrack
		texture {TrackWood_T}
		translate <-1,0,5>
	}
	object {
		TSplitMFMTrack
		texture {TrackWood_T}
		translate <8,0,-1>
	}
	object {
		TSplitMMFTrack
		texture {TrackWood_T}
		translate <8,0,5>
	}

	camera
	{
	  location  <7.0 , 20.0 , 3.0>
	  look_at   <7.0 , 0.0 , 3.0>
	}
	background{color rgb 1}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color 1.5  // light's color
	  translate <-10, 10, -20>
	}
#end

