// Persistence of Vision Ray Tracer Scene Description File
// File: TrackTextures.inc
// Vers: 3.1
// Desc: Textures for my wooden train tracks.
// Date: 3/9/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#ifndef (Detail_Level)
	#local Detail_Level = 10; // 0..10
#end

#if (Detail_Level > 3)
	// wood texture isn't very pricy, low detail level.
	#declare TrackWood_T = texture {
		pigment {
			wood
			turbulence <0.01,0.1,0.1> // should have some!
			color_map { [0.00 color <251,236,206>/256]
						[0.90 color <251,219,175>/256] 
						[0.95 color <232,194,139>/256]
						[1.00 color <197,162,113>/256]} // optional color map
			frequency 2
			octaves 3
			lambda 1.2
			rotate 90*y
			ramp_wave
			scale <2, 0.5, 0.2>
		}
		finish {
			brilliance 1.0
			ambient 0.1
			diffuse 0.6
		}
	}
	texture {
		pigment {
			wood
			turbulence <0.2,0.3,0.2> // should have some!
			color_map { [0.00 color <251,236,206>/256 + <0,0,0,0.7>]
						[0.90 color <251,219,175>/256 + <0,0,0,0.5>] 
						[0.95 color <232,194,139>/256 + <0,0,0,0.3>]
						[1.00 color <197,162,113>/256 + <0,0,0,0.3>]} // optional color map
			rotate 90*y
			scale <1, 0.1, 0.1>
		}
		finish {
			brilliance 1.0
			ambient 0.1
			diffuse 0.6
		}
	}
#else
	#declare TrackWood_T = texture {pigment { color <251,236,206>/256}}
#end


#if (Render = 1)

	// Featured object(s)
	#include "TrackXSplit.inc"
	object {
		XSplitTrack
		texture {TrackWood_T}
	}
	/*cylinder{<4,0,0>,<4,3,0>,2
		texture {TrackWood_T}
	}*/
	/*box {
		0,3
		texture {TrackWood_T}
		rotate 45*y
		translate 2*x
	}
	*/	
	global_settings {ambient_light 1}
	plane{
		y,
		0
		pigment {color rgb <0,0.5,0.5>}
	}
	camera
	{
	  location  <4, 5 , -5>
	  look_at   <4 , 0.0 , 0>
	}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*1.3  // light's color
	  translate <50 , 50 , -50>
	}
	
	background {color <1,1,1>}
#end

	
