// Persistence of Vision Ray Tracer Scene Description File
// File: TrackXSplit.inc
// Vers: 3.1
// Desc: Star Switch
// Date: 2/23/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end


#include "TrackCrossSection.inc"
#include "TrackConnects.inc"

#local Radius = TrackShortCurveRadius;
#local InnerRadius = Radius - TrackCrossSectionSize.x/2;
#local OuterRadius = InnerRadius + TrackCrossSectionSize.x;
	
// This is a 90deg arc.
#declare ShortCurveBlockRExtension = intersection {
	lathe{
		linear_spline
		TrackCrossSectionRExtension2NumPoints+1,
		#local Count = 0;
		#while (Count < TrackCrossSectionRExtension2NumPoints)
			TrackCrossSectionRExtension2[Count] + <InnerRadius,0>,
			#local Count = Count+1;
		#end
		TrackCrossSectionRExtension2[0] + <InnerRadius,0>
	}
	box {
		<0,-.1,0>,
		<OuterRadius+4,TrackCrossSectionSize.y+.1,OuterRadius+4>
	}
}	

#declare XSplitTrackConnectsAngle = array[4] {<0,180,0>, <0,270,0>, <0,0,0>, <0,90,0>}
#declare XSplitTrackConnectsPosition = array[4] {<0,0,0>, <Radius,0,Radius>,<TrackUnitLength,0,0>, <Radius,0,-Radius>}
#declare XSplitTrackNumConnects = 4;

#declare LongStraightBlock = prism {
	linear_sweep
	linear_spline
	XSplitTrackConnectsPosition[0].x,
	XSplitTrackConnectsPosition[2].x,
	TrackCrossSectionDoubleExtension2NumPoints+1, // Last point to close the curve.
	#local Count = 0;
	#while (Count < TrackCrossSectionDoubleExtension2NumPoints)
		TrackCrossSectionDoubleExtension2[Count],
		#local Count = Count+1;
	#end
	TrackCrossSectionDoubleExtension2[0]
	rotate 180*y
	rotate 90*x
	rotate 90*y
	translate <0,0,-TrackCrossSectionCenter.x>
}

#declare XSplitTrackConnectsGender = array[3] {0,1,1}

#declare XSplitBlock = intersection {
	object {
		ShortCurveBlockRExtension
		rotate 90*y
		translate <0,0,Radius>
//		pigment {color rgb <1,0,0>}
	}
	object {
		ShortCurveBlockRExtension
		rotate 180*y
		translate <2*Radius,0.0001,Radius>
//		pigment {color rgb <0,1,0>}
	}
	object {
		ShortCurveBlockRExtension
		rotate 270*y
		translate <2*Radius,0.0002,-Radius>
//		pigment {color rgb <1,0,1>}
	}
	object {
		ShortCurveBlockRExtension
		rotate 360*y
		translate <0,0.0003,-Radius>
//		pigment {color rgb <0,1,1>}
	}
	object {LongStraightBlock
		translate <0,-0.0001,0>
//		pigment {color rgb <0,0,1>}
	}
	object {LongStraightBlock
		rotate 90*y
		translate <TrackUnitLength/2,-0.0002,TrackUnitLength/2>
//		pigment {color rgb <1,0,1>}
	}
}	

#include "TrackFunctions.inc"

#declare XSplitTrackConnectsAngle = XSplitTrackConnectsAngle
#declare XSplitTrackConnectsPosition = XSplitTrackConnectsPosition
#declare XSplitTrackNumConnects = XSplitTrackNumConnects;
#declare XSplitTrackConnectsGender = array[4] {0,0,1,1}

#declare XSplitTrack = AddConnects(XSplitBlock, 
										XSplitTrackConnectsAngle,
										XSplitTrackConnectsPosition,
										XSplitTrackConnectsGender,
										XSplitTrackNumConnects)
											
											

#if (Render = 1)
	#include "colors.inc"
	#include "TrackTextures.inc"
	object {
		XSplitTrack
		texture {TrackWood_T}
	}
	camera
	{
	  location  <7.0 , 20.0 , 3.0>
	  look_at   <7.0 , 0.0 , 3.0>
	}
	background{White}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color 1.5  // light's color
	  translate <-10, 30, -20>
	}
#end

