// Persistence of Vision Ray Tracer Scene Description File
// File: TrainCarBase.inc
// Vers: 3.1
// Desc: General Train Car components and constants
// Date: 4/16/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#include "MyTextures.inc"

#declare MagnetBlack_T = texture {pigment {color rgb <0,0,0>}}
#declare BlackEnamel_T = MakeEnamel_T(color rgb <0.05,0.05,0.05>)
#declare TrainYellow_P = color rgb <1,1,0>;
#declare TrainWheelRed_P = color rgb <0.95,0.1,0.1>;

#include "TrackCrossSection.inc"

// Train parameters
#declare TrainBaseWidth = TrackGroovePosition[1].x - TrackGroovePosition[0].x - TrackGrooveSize.x/2;
#declare TrainWheelDiameter = 1/2.54;
#declare TrainOffset = TrackCrossSectionSize.y-TrackGrooveSize.y;

#declare TrainCarBaseBlockSize  = <11,2,5>*TrainBaseWidth/5;
#declare TrainCarBaseBlock = superellipsoid {
	<0.1,0.1>
	scale TrainCarBaseBlockSize/2
	texture { BlackEnamel_T}
}

#declare TrainWheelSize = <1/2,1/2,1/8>;
#declare TrainWheelTire = lathe
{
	cubic_spline
	19,
	<0,0>,<4,0>,<8,0>,<12,0>,<14,0>,<14,2>+2*<cos(pi/4),-sin(pi/4)>,<16,2>,<14,2>+2*<cos(pi/4),sin(pi/4)>,<14,4>,<13,4>,<12,4>,<11,4>,<10,4>,<8,5>,<8,6>,<7,7>,<6,6>,<4,4>,<0,4>//,<0,0>,<0,4>
	MakePlastic_T(TrainWheelRed_P)
	scale 1/64
	rotate -90*x
}

#declare TrainWheelHub = sphere
{
	<0,0,0>,
	6/64
	scale <1,1,1/3>
	translate <0,0,-6/64>
	
	texture {ShinySteel_T}
}


#declare TrainWheel = union
{
	object {TrainWheelTire}
	object {TrainWheelHub}
}



#declare TrainMagnetSize = <0.65+0.6*0.35,2*0.85,2*0.85> *TrainBaseWidth/5;
#declare TrainMagnet = union {
	#local Hc = 0.65 *TrainBaseWidth/5;
	#local Rc = 0.85 *TrainBaseWidth/5;
	#local Rs = Rc - 0.15 *TrainBaseWidth/5;
	cylinder {
		<0,0,0>,
		<-Hc,0,0>,
		Rc 
		texture {MagnetBlack_T}
	}
	sphere{
		<0,0,0>,
		Rs
		scale <0.35,1,1>
		translate -Hc*x
		texture {ShinySteel_T}
	}
}

#declare TrainCarBaseSize = TrainCarBaseBlockSize + <2*TrainMagnetSize.x,TrainWheelSize.y/4+0.05,0>;
#declare TrainCarBaseTopLocation = TrainCarBaseSize.y + TrainOffset;
#declare TrainCarBase = union {
	union {
		object {TrainMagnet translate <-TrainCarBaseBlockSize.x/2,TrainCarBaseBlockSize.y/2,0>}
		object {TrainCarBaseBlock translate <0,TrainCarBaseBlockSize.y/2,0>}
		object {TrainMagnet rotate 180*y translate <TrainCarBaseBlockSize.x/2,TrainCarBaseBlockSize.y/2,0>}
		
		translate TrainWheelSize.y/4*y
		translate 0.05*y // clearance
	}
	object {TrainWheel translate <-TrainCarBaseBlockSize.x/3,TrainWheelSize.y/2,-TrainCarBaseBlockSize.z/2>}
	object {TrainWheel translate < TrainCarBaseBlockSize.x/3,TrainWheelSize.y/2,-TrainCarBaseBlockSize.z/2>}
	object {TrainWheel translate <-TrainCarBaseBlockSize.x/3,TrainWheelSize.y/2,-TrainCarBaseBlockSize.z/2> rotate 180*y}
	object {TrainWheel translate < TrainCarBaseBlockSize.x/3,TrainWheelSize.y/2,-TrainCarBaseBlockSize.z/2> rotate 180*y}

	// bottom of wheels is now at y=0.
	// position on top of track. (in groove)
	translate TrainOffset*y
}


#if (Render = 1)
	#include "colors.inc"
	#include "TrackTextures.inc"

	object {TrainCarBase}


	#include "TrackShortStraight.inc"
	#include "TrackTextures.inc"
	object {
		ShortStraightTrack
		texture {TrackWood_T}
		translate <-2,0,0>
	}
	global_settings {ambient_light 3}
	camera
	{
	  location  <3 , 1, -2>
	  look_at   <0.0 , 0.0 , 0.0>
	}
	background{White}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color rgb 1  // light's color
	  translate <0, 10, -20>
	}
#end
