// Persistence of Vision Ray Tracer Scene Description File
// File: TrainCars.inc
// Vers: 3.1
// Desc: General Train Car components and constants
// Date: 4/16/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#include "TrainCarBase.inc"

#include "TrainTippyCar.inc"

//**********************************
// Box Car
//**********************************
#declare TrainBoxCarTopSize = TrainCarBaseBlockSize*<0.9,2.25,0.8>;
#declare TrainBoxCarTop = union {
	superellipsoid {
		<0.1,0.1>
		translate 1*y
		scale TrainBoxCarTopSize/2
	}
	object {
		TrainMagnet
		rotate -90*z
		translate TrainBoxCarTopSize.y*y
	}
}

#declare TrainTankerCarTop = union {
	superellipsoid {
		<1.0,0.1>
		rotate 90*y
		translate 1*y
		scale TrainBoxCarTopSize/2
	}
	object {
		TrainMagnet
		rotate -90*z
		translate TrainBoxCarTopSize.y*y
	}
}

#macro MakeTrainBoxCar(Color)
	union {
		object {
			TrainBoxCarTop
			
			MakeEnamel_T(Color)
			translate TrainCarBaseTopLocation*y
		}
		object {
			TrainCarBase
		}
	}
#end
	
#macro MakeTrainTankerCar(Color)
	union {
		object {
			TrainTankerCarTop
			
			MakeEnamel_T(Color)
			translate TrainCarBaseTopLocation*y
		}
		object {
			TrainCarBase
		}
	}
#end

#declare GoldLeaf_T = texture {
	pigment {color rgb <0.9,0.7,0.4>}
	finish {
		ambient 0.5
		brilliance 4
		diffuse 0.5
		metallic
		specular 0.80
		roughness 1/80
		reflection 0.3
	}
}

#declare TrainTitleBoxCar = union {
	difference{
		object {
			TrainBoxCarTop
			
			MakeEnamel_T(color rgb <0,0,0.5>)
		}
		#local CountX = 0;
		#while(CountX < 3)
			#local CountY = 0;
			#while(CountY < 3)
				text {
					ttf "Kidprint.ttf", "The City", 0.25, 0
					texture {GoldLeaf_T}
					scale <1/2,1/2 *0.9,1>
					translate <-TrainBoxCarTopSize.x/2+0.125,TrainBoxCarTopSize.y*1/2+1/16,-TrainBoxCarTopSize.z/2-0.125>
					translate <CountX*1/128,CountY*1/128,0>
				}
				text {
					ttf "Kidprint.ttf", "Imagined", 0.25, 0
					texture {GoldLeaf_T}
					scale <1/2,1/2 *0.9,1>
					translate <-TrainBoxCarTopSize.x/2+0.125,0.125,-TrainBoxCarTopSize.z/2-0.125>
					translate <CountX*1/128,CountY*1/128,0>
				}
				#local CountY = CountY + 1;
			#end
			#local CountX = CountX + 1;
		#end
		translate TrainCarBaseTopLocation*y
	}
	object {
		TrainCarBase
	}
}

#declare TrainNameBoxCar = union {
	difference{
		object {
			TrainBoxCarTop
			
			MakeEnamel_T(color rgb <0.7,0,0>)
		}
		#local CountX = 0;
		#while(CountX < 3)
			#local CountY = 0;
			#while(CountY < 3)
				text {
					ttf "Kidprint.ttf", "Katherine", 0.25, 0
					texture {GoldLeaf_T}
					scale <1/2,1/2 *0.9,1>
					translate <-TrainBoxCarTopSize.x/2+1/16,TrainBoxCarTopSize.y*1/2,-TrainBoxCarTopSize.z/2-0.125>
					translate <CountX*1/128,CountY*1/128,0>
				}
				text {
					ttf "Kidprint.ttf", "Smith", 0.25, 0
					texture {GoldLeaf_T}
					scale <1/2,1/2 *0.9,1>
					translate <-TrainBoxCarTopSize.x/4,1/16,-TrainBoxCarTopSize.z/2-0.125>
					translate <CountX*1/128,CountY*1/128,0>
				}
				#local CountY = CountY + 1;
			#end
			#local CountX = CountX + 1;
		#end
		translate TrainCarBaseTopLocation*y	
	}
	object {
		TrainCarBase
	}
}



#if (Render = 1)
	#include "colors.inc"
	#include "TrackTextures.inc"

	MakeTrainBoxCar(color rgb <0.2,0.8,1.0>)
	object {
		MakeTrainTankerCar(color rgb <1.0,0.1,0.1>)
		translate TrainCarBaseSize.x*x
	}
	object {MakeTrainTippyCar( color rgb <1.0,0.1,0.1>)
		translate 2*TrainCarBaseSize.x*x
	}
	object {
		TrainNameBoxCar
		translate 3*TrainCarBaseSize.x*x
	}
	object {TrainTitleBoxCar
		translate 4*TrainCarBaseSize.x*x
	}
	#include "TrainEngine2.inc"
	object {
		TrainEngine2
		translate 5*TrainCarBaseSize.x*x
	}
	//object {TrainCarBase}


	#include "TrackLongStraight.inc"
	#include "TrackTextures.inc"
	object {
		LongStraightTrack
		texture {TrackWood_T}
		translate <-2,0,0>
	}
	object {
		LongStraightTrack
		texture {TrackWood_T}
		translate <-2+TrackUnitLength,0,0>
	}
	global_settings {ambient_light 2}
	camera
	{
	  location  <8 , 1, -4>
	  look_at   <8.0 , 1.0 , 0.0>
	  orthographic
	}
	background{White}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color rgb 1 // light's color
	  translate <0, 10, 20>
	}
#end
