// Persistence of Vision Ray Tracer Scene Description File
// File: TrainEngine2.inc
// Vers: 3.1
// Desc: Train Engine
// Date: 3/15/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#include "colors.inc"
#include "TrackCrossSection.inc"
#include "TrainCarBase.inc"

#declare Engine2TopHeight = 1;
#declare Engine2FrontHeight = 3/4;
#declare Engine2Body = union{
	superellipsoid {
		<0.1,0.1>
		translate <1,1,0>
		scale <TrainCarBaseBlockSize.x/3,Engine2TopHeight,TrainCarBaseBlockSize.z>*1/2
		translate -TrainCarBaseBlockSize.x/2*x
	}
	superellipsoid {
		<0.1,0.1>
		translate <0,1,0>
		scale <TrainCarBaseBlockSize.x,Engine2FrontHeight-2/16,TrainCarBaseBlockSize.z>*1/2
	}
	superellipsoid {
		<1,0.1>
		rotate 90*y
		scale <1,1/2,1>
		scale <TrainCarBaseBlockSize.x,Engine2FrontHeight,TrainCarBaseBlockSize.z>*1/2
		translate <0,6.5/16,0>
	}
	texture {BlackEnamel_T}
}

#declare Engine2Chimney = lathe {
	cubic_spline
	12
	<2,-2>,<2,0>,<2,2>,<3,4>,<4,6>,<6,8>,<7,10>,<6,11>,<5,11>,<4,11>,<0,10>,<-1,9>
	MakeEnamel_T(color rgb <1,0,0>)
	scale 1/32
}

#declare TrainEngine2 = union
{
	object {TrainCarBase}
	union {
		object {Engine2Body}
		object {Engine2Chimney translate < TrainCarBaseBlockSize.x/4,Engine2FrontHeight-2/16,0>}
		translate <0,TrainCarBaseTopLocation-0.25,0>
	}
}


#if (Render = 1)
	#include "colors.inc"
	#include "TrackTextures.inc"
	object {
		TrainEngine2
	}
	#include "TrackShortStraight.inc"
	#include "TrackTextures.inc"
	object {
		ShortStraightTrack
		texture {TrackWood_T}
		translate <-2,0,0>
	}
	global_settings {ambient_light 3}
	camera
	{
	  location  <2 , 2.5, -5>
	  look_at   <0.0 , 0.0 , 0.0>
	}
	background{White}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color red 1.0  green 1.0  blue 1.0  // light's color
	  translate <0, 10, -20>
	}
#end
