// Persistence of Vision Ray Tracer Scene Description File
// File: TrainTippyCar.inc
// Vers: 3.1
// Desc: A train car with a tippy grain or something bin
// Date: 4/16/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#include "TrainCarBase.inc"

#declare TrainCarBaseBlockSize  = <11,2,5>*TrainBaseWidth/5;

#declare TrainTroughSize = <9.5,3.75,5>;

#declare TrainTroughSupport = difference{
	#local Rs = 1.25;
	#local Bh = 3;
	#local Rp = 0.25;
	#local D = 0.35;
	union {
		box {
			<0.001,0,-Rs>,
			<D,Bh,Rs>
		}
		cylinder {
			<0.001,Bh,0>,
			<D,Bh,0>,
			Rs
			clipped_by {
				plane {-y, Bh}
			}
		}
	}
	cylinder {
		<0-0.1,Bh,0>,
		<D+0.1,Bh,0>,
		Rp
	}
	scale TrainBaseWidth/5
}		
#declare Sqrt2 = sqrt(2);

#declare TrainTrough = union{
	#local Bh = 3;
	#local OutsideCorner = < 4.85,4, 2.2>;
	#local BeadRadius = 0.35/2;
	union {
		// this was a difference of cubes, but I got picky...
		// End Boards
		union {
			prism {
				linear_spline
				linear_sweep
				-OutsideCorner.x+BeadRadius,
				+OutsideCorner.x-BeadRadius,
				7,
				<0,0.5>,
				<-(OutsideCorner.z+BeadRadius/Sqrt2-BeadRadius),OutsideCorner.y-BeadRadius/Sqrt2>,	
				<-(OutsideCorner.z-BeadRadius/Sqrt2-BeadRadius),OutsideCorner.y+BeadRadius/Sqrt2>,	
				<0,2*BeadRadius*Sqrt2+0.5>,
				<+OutsideCorner.z-BeadRadius/Sqrt2-BeadRadius,OutsideCorner.y+BeadRadius/Sqrt2>,	
				<+OutsideCorner.z+BeadRadius/Sqrt2-BeadRadius,OutsideCorner.y-BeadRadius/Sqrt2>,
				<0,0.5>
				rotate -90*x
				rotate 90*y
			}
			prism {
				linear_spline
				linear_sweep
				-OutsideCorner.x,
				-OutsideCorner.x+BeadRadius*2,
				6,
				<0,0.5>,
				<-(OutsideCorner.z+BeadRadius/Sqrt2-BeadRadius),OutsideCorner.y-BeadRadius/Sqrt2>,	
				<-OutsideCorner.z,OutsideCorner.y>,	
				<+OutsideCorner.z,OutsideCorner.y>,	
				<+OutsideCorner.z+BeadRadius/Sqrt2-BeadRadius,OutsideCorner.y-BeadRadius/Sqrt2>,
				<0,0.5>
				rotate -90*x
				rotate -90*y
			}
			prism {
				linear_spline
				linear_sweep
				+OutsideCorner.x,
				+OutsideCorner.x-BeadRadius*2,
				6,
				<0,0.5>,
				<-(OutsideCorner.z+BeadRadius/Sqrt2-BeadRadius),OutsideCorner.y-BeadRadius/Sqrt2>,	
				<-OutsideCorner.z,OutsideCorner.y>,	
				<+OutsideCorner.z,OutsideCorner.y>,	
				<+OutsideCorner.z+BeadRadius/Sqrt2-BeadRadius,OutsideCorner.y-BeadRadius/Sqrt2>,
				<0,0.5>
				rotate -90*x
				rotate -90*y
			}
		}
			/*difference {
				box {
					<-4.75,0,0>,
					<4.75,4*Sqrt2,4*Sqrt2>
				}
				box {
					<-4.5,0.25/Sqrt2*3/2,0.25/Sqrt2*3/2>,
						<4.5,4*Sqrt2,4*Sqrt2,>
				}
				rotate -45*x
			}*/
		// Little Pins to go in the holes
		cylinder {
			<-5.5,Bh,0>,
			<-(OutsideCorner.x-BeadRadius),Bh,0>,
			Rp
		}
		cylinder {
			<OutsideCorner.x-BeadRadius,Bh,0>,
			<5.5,Bh,0>,
			Rp
		}
	}
	// gratuitous close up detial.
	#local CornerCap = union {
		cylinder {
			<BeadRadius,0,0>,<BeadRadius,0,2*BeadRadius>,BeadRadius
			clipped_by {plane {-z+x, 0}}
		}
		cylinder {
			<0,0,BeadRadius>,<2*BeadRadius,0,BeadRadius>,BeadRadius
			clipped_by {plane {+z-x, 0}}
		}
	}
	union{
		object{CornerCap              translate OutsideCorner*<-1,1,-1>}
		object{CornerCap rotate  90*y translate OutsideCorner*<-1,1, 1>}
		object{CornerCap rotate 180*y translate OutsideCorner*< 1,1, 1>}
		object{CornerCap rotate 270*y translate OutsideCorner*< 1,1,-1>}
		cylinder {	(OutsideCorner-<BeadRadius,0,BeadRadius*2>)*<-1,1,-1>, 
					(OutsideCorner-<BeadRadius,0,BeadRadius*2>)*<-1,1, 1>,BeadRadius}
		cylinder {	(OutsideCorner-<BeadRadius,0,BeadRadius*2>)*< 1,1,-1>, 
					(OutsideCorner-<BeadRadius,0,BeadRadius*2>)*< 1,1, 1>,BeadRadius}

		cylinder {	(OutsideCorner-<BeadRadius*2,0,BeadRadius>)*<-1,1, 1>, 
					(OutsideCorner-<BeadRadius*2,0,BeadRadius>)*< 1,1, 1>,BeadRadius}
		cylinder {	(OutsideCorner-<BeadRadius*2,0,BeadRadius>)*<-1,1,-1>, 
					(OutsideCorner-<BeadRadius*2,0,BeadRadius>)*< 1,1,-1>,BeadRadius}
		//pigment {color rgb <1,1,0>}
	}
	scale TrainBaseWidth/5
}		

#macro MakeTrainTippyCar(Color)
	union {
		object {TrainCarBase}
	
		object {
			TrainTroughSupport
			translate -TrainCarBaseBlockSize.x/2*x
			translate TrainCarBaseTopLocation*y
			MakePlastic_T(TrainYellow_P)
		}
		object {
			TrainTroughSupport
			rotate 180*y
			translate +TrainCarBaseBlockSize.x/2*x
			translate TrainCarBaseTopLocation*y
			MakePlastic_T(TrainYellow_P)
		}
		object {
			TrainTrough
			translate TrainCarBaseTopLocation*y
			MakePlastic_T(Color)
		}
	}
#end

#if (Render = 1)
	#include "colors.inc"
	#include "TrackTextures.inc"

	MakeTrainTippyCar(color rgb <0,0,0.5>)


	#include "TrackShortStraight.inc"
	#include "TrackTextures.inc"
/*	object {
		ShortStraightTrack
		texture {TrackWood_T}
		translate <-2,0,0>
	}
*/	global_settings {ambient_light 3}
	camera
	{
	  location  <-1 , 3, -2>
	  look_at   <0.0 ,1.5 , 0.0>
	}
	background{White}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color red 1.0  green 1.0  blue 1.0  // light's color
	  translate <0, 20, -10>
	}
	light_source
	{
	  0*x // light's position (translated below)
	  color red 1.0  green 1.0  blue 1.0  // light's color
	  translate <-10, 5, 0>
	}
	light_source
	{
	  0*x // light's position (translated below)
	  color red 1.0  green 1.0  blue 1.0  // light's color
	  translate <0, 0, -10>
	 }
#end
