// Persistence of Vision Ray Tracer Scene Description File
// File: WoodCutOutTrees.inc
// Vers: 3.1
// Desc: Toy cookie cutter trees.
// Date: 3/12/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#include "MyTextures.inc"

#declare WoodCutOutTree_T = MakeEnamel_T(color rgb <0.1,0.55,0.1>)//pigment{color rgb <0.1,0.55,0.1> }//<77,137,88>/256}

#declare WoodCutOutTree1OutlineNumPoints = 29;
#declare WoodCutOutTree1Outline = array[WoodCutOutTree1OutlineNumPoints] {
< 0.0000, 0.0000>
< 0.0000, 0.0776>
< 0.0431, 0.1379>
< 0.1034, 0.1466>
< 0.1034, 0.2414>
< 0.0172, 0.2759>
<-0.0086, 0.3621>
< 0.0345, 0.4741>
< 0.0172, 0.6121>
< 0.0776, 0.7155>
< 0.0948, 0.8362>
< 0.1379, 0.9224>
< 0.1379, 0.9655>
< 0.1897, 1.0000>
< 0.2414, 0.9655>
< 0.2500, 0.9138>
< 0.2931, 0.8362>
< 0.2931, 0.7241>
< 0.3621, 0.6121>
< 0.3534, 0.4569>
< 0.3879, 0.3448>
< 0.3707, 0.2759>
< 0.2845, 0.2328>
< 0.2759, 0.1466>
< 0.3534, 0.1379>
< 0.3793, 0.0603>
< 0.3707, 0.0000>
< 0.3000, 0.0000>
< 0.1500, 0.0000>}

#declare WoodCutOutTallTreeHeight = 3;
#declare WoodCutOutThickness = .5;

#declare WoodCutOutTree1 = prism {
	linear_sweep
	cubic_spline
	0,
	WoodCutOutThickness
	WoodCutOutTree1OutlineNumPoints+3, // Last point to close the curve.
	#local Count = 0;
	#while (Count < WoodCutOutTree1OutlineNumPoints)
		WoodCutOutTree1Outline[Count],
		#local Count = Count+1;
	#end
	WoodCutOutTree1Outline[0],
	WoodCutOutTree1Outline[1],
	WoodCutOutTree1Outline[2]
	
	rotate -90*x
	scale <3,3,1>
	
	texture {WoodCutOutTree_T}
}	

#macro MakeWoodCutOutTreeForest(TreeCount,Radius,Seed)
	#local RTree = seed(Seed);
	#local Count = 0;
	#while (Count < TreeCount)
		object {
			WoodCutOutTree1
			rotate rand(RTree)*360*y
			translate (<rand(RTree),0.5,rand(RTree)>-0.5)*Radius
		}
		#local Count = Count + 1;
	#end
#end


#if (Render = 1)
	#include "colors.inc"
	#include "TrackTextures.inc"
	object {
		WoodCutOutTree1
	}
	camera
	{
	  location  <0.0 , 2.5 ,-4.0>
	  look_at   <0.0 , 1.5 , 0.0>
	}
	background{White}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color red 1.0  green 1.0  blue 1.0  // light's color
	  translate <3, 10, -20>
	}
#end
