//*****************************************************************************************************************************
// scene environment
//*****************************************************************************************************************************
#version unofficial MegaPov 0.4;
#local quality = 1;
#declare cam_l = <1,100,-1000>;     
#declare cam_lat =  <0,0,0>;
            
global_settings {
	max_trace_level 30
	number_of_waves 20
	post_process {
//		focal_blur{vlength(cam_l-cam_lat),vlength(cam_l-cam_lat), 8}
//		soft_glow{1,8}
	}
	#if (quality >=1)
		#if(quality >= 2)
	  		// High Quality - slow rendering
		  	ini_option "+QR"
		  	ini_option "Preview_Start_Size=8"
		  	ini_option "Preview_End_Size=4"
		  
		  	radiosity{
			    count 80             // CHANGE range from 20 to 150
			    nearest_count 6      // CHANGE range from 3 to 10
			    error_bound 1        // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
			                         //   1 : preview_end_size = 4
			                         //   3 : preview_end_size = 8
			                         //   use preview_start_size = 16 (or 8 for high quality)
			                         // you can go lower than 1, but then you probably will want to set
			                         // preview_end_size to 2, which is really slow
			    recursion_limit 4    // CHANGE
			    
			    low_error_factor .5  // leave this
			    gray_threshold 0.0   // leave this
			    minimum_reuse 0.015  // leave this
			    brightness 1         // leave this
			    
			    max_sample 1         // CHANGE - this should be the same as the brightest object
			    adc_bailout 0.01/1   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
			    normal on
		  	}
		#else
		  	// Medium Quality - works for most scenes
		  	ini_option "+QR"
		  	ini_option "Preview_Start_Size=16"
		  	ini_option "Preview_End_Size=8"
		  
		  	radiosity{
			    count 40             // CHANGE range from 20 to 150
			    nearest_count 3      // CHANGE range from 3 to 10
			    error_bound 3        // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
			                         //   1 : preview_end_size = 4
			                         //   3 : preview_end_size = 8
			                         //   use preview_start_size = 16
			                         // you can go lower than 1, but then you probably will want to set
			                         // preview_end_size to 2, which is really slow
			    recursion_limit 3    // CHANGE
			    
			    low_error_factor .5  // leave this
			    gray_threshold 0.0   // leave this
			    minimum_reuse 0.015  // leave this
			    brightness 1         // leave this
			    
			    max_sample 1         // CHANGE - this should be the same as the brightest object
			    adc_bailout 0.01/1   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
			    normal on
			}
		#end
	#end
}

#declare T_Snow = texture {
	pigment {
		rgb 1
	}
	normal {
		granite 0.01 scale 20
	}
	finish {
		ambient 0
		diffuse 0.99
		roughness 1
	}
}

#declare T_Rock = texture {
	pigment {
		granite
		scale 3
		colour_map {
			[0 rgb <0.3,0.1,0.1>]
			[1 rgb <0.2,0.1,0.1>]
		}
	}
	normal {
		granite 0.2
	}
	finish {
		diffuse 0.8
		ambient 0
	}
}

#declare T_Landscape = texture {
	slope y*3,y,<0.5,1>,<0,1>
	texture_map {
		[1/3 T_Rock]
		[1/3 T_Snow]
	}
}

#declare _landscape = function { "ridgedmf",<1,2,10,1.1,2> }

#declare landscape = isosurface {
	function {
		_landscape(x,0,z)-y
	}
	eval
	max_gradient 35
	accuracy 0.001
	sign -1
	contained_by { box { <-1000,-3,-1000> <1000,3,1000> } }
	scale <4,1,4>
	scale 1/3
	texture { T_Landscape }
	scale 3
	scale 250
	hollow
}

object { landscape }

#local cam_l = <0,2,0>+trace(landscape,cam_l+y*1000000,y*-1);
#local cam_lat = <0,0,0>+trace(landscape,cam_lat+y*1000000,y*-1);

light_source {
	<1,1,-0.1>*1000000
	rgb #if (quality >=1) <1,1,0.5> #else <1,1,1> #end
}

#local CamZ = 1;

#local CamD = vnormalize(cam_lat-cam_l);
#local CamR = vnormalize(vcross(y,CamD));
#local CamU = vnormalize(vcross(CamD,CamR));

camera {
  location cam_l
  up CamU
  right CamR*4/3
  direction CamD*CamZ
}        

sky_sphere {
	pigment {
		planar
		colour_map {
			[0.8 rgb <0,0,0.8>]
			[1 rgb <0,0.5,1>]
		}
	}
}
