//
#version unofficial Megapov 0.4;
//=============================
#local Render = 0;
//=============================
#if(Render)
// ==== POV-Ray Includes ====
#include "colors.inc"	   // Standard Color definitions
#include "textures.inc"	   // Standard Texture definitions
#include "mega_metals.inc" // MegaPOV Metals definitions 
#include "hasard.inc"      // Hasard de R.Gelaude     
#include "etalon.inc"      // Etalon le metre (m)  

#end

//================================
#declare T_Crasse = texture {
        pigment {
                wrinkles
                color_map {
                        [0.0 Clear]
                        [1.0 DarkBrown*.5 filter 0.5]
                }
        }
}


                                 
#declare T_au_441= texture { pigment { color rgb <2.000,1.8,1.8> }
                                           finish { ambient 0.1 diffuse 0.9 } 
                                           }
                                 texture { T_Crasse scale 0.3 }
                                 

#declare M_au_44=material { 
                                texture { T_au_441   }
                           scale 10  
}

                        
//-----------------------------------
//==========STORE_PTMG_PetitMAg===========
#declare M_Bare=material {Mega_M_Brass_1A }

#declare M_Store_ptmg=material {  texture {
                        pigment {  checker color rgb 2, rgb <1,0,0> }
                        finish {ambient 0.4 diffuse 0.6  phong 1 phong_size 40 }
                        scale <.8,1,50> rotate y*90 translate y*-5}
                            texture {T_Crasse scale 5 }
                             texture {T_Crasse scale 1 }
                         
}

#local hStore_ptmg = 1;
#local lStore_ptmg = 2;
#local lgStore_ptmg = 3;
#declare hyptn = sqrt ((hStore_ptmg*hStore_ptmg)+(lStore_ptmg*lStore_ptmg));
#declare Store_ptmg = union { cylinder { < 0,0,0><0,hStore_ptmg,0>5*cm}
                          cylinder {<-lStore_ptmg,0,0><0,  0,0>5*cm}
                          cylinder {<-lStore_ptmg,0,0><0,hStore_ptmg,0>5*cm}
}
#declare Store_ptmg = union { 
        object { Store_ptmg }
        cylinder {<0,0,0><0,0,lgStore_ptmg>5*cm}
        cylinder {<-lStore_ptmg,0,0><-lStore_ptmg,0,lgStore_ptmg>5*cm}
         cylinder {<0,hStore_ptmg,0><0,hStore_ptmg,lgStore_ptmg>5*cm}
         object { Store_ptmg translate z*lgStore_ptmg}
        }
#declare Tissu_Store_ptmg = box { <-hyptn-.1,-.1><0.05,.005,lgStore_ptmg+.1> material {M_Store_ptmg  }}
#declare Store_ptmg = union { 
         object { Store_ptmg } 
         object { Tissu_Store_ptmg rotate <0,0,degrees((hStore_ptmg/lStore_ptmg))> translate <0,hStore_ptmg+0.15,0>}
         material{ M_Bare} rotate y*180
}

#declare i= 3.8;
#declare Store_ptmg = union {  
        #while (i < 25)
                #if (i < 22 )
                object { Store_ptmg  translate z*i  }
                #end // If 
                #declare i=i+lgStore_ptmg+1;
        #end // While
}   
// fin Store_ptmg
//-=========MegaStore_ptmg_ET_BATIMENT===========    
#declare Col_Bal = 
lathe{
	cubic_spline
	14,
	<0.000000,0.900261>,
	<0.148069,0.989102>,
	<0.148069,0.900261>,
	<0.088842,0.870647>,
	<0.148069,0.811419>,
	<0.236911,0.633736>,
	<0.236911,0.426439>,
	<0.088842,0.189529>,
	<0.148069,0.100687>,
	<0.148069,0.011846>,
	<0.000000,0.100687>,
	<0.000000,0.900261>,
	<0.148069,0.989102>,
	<0.148069,0.900261>
	pigment {rgb <1,0.95,0.85>*2}
}

#declare Balcon=union { 
                object {Col_Bal translate <1.2,0,0>}
                object {Col_Bal translate <1.2,0,1>}
                object {Col_Bal translate <1.2,0,2>}       
                object {Col_Bal translate <1.2,0,3>}
                object {Col_Bal translate <1.2,0,4>}
                object {Col_Bal translate <1.2,0,5>}
                object {Col_Bal translate <1.2,0,6>}
                object {Col_Bal translate <1.2,0,7>}
                object {Col_Bal translate <1.2,0,8>}
                object {Col_Bal translate <1.2,0,9>}
                object {Col_Bal translate <1.2,0,10>}
                object {Col_Bal translate <1.2,0,11>}
                object {Col_Bal translate <1.2,0,12>}
                object {Col_Bal translate <1.2,0,13>}
                object {Col_Bal translate <1.2,0,14>}
                box{ <0.9,1,-.2><1.3,1.15,15>}
                box{ <0.9,0,-.2><1.3,0.15,15>}
                box{<-1,0,0><1.2,0.15,15>}
                object {Col_Bal translate <0.8,0,0>}
                object {Col_Bal translate <0.2,0,0>}
                box{<-1,1,-.4><1.3,1.15,0.0>}
                box{<-1,0,-.4><1.3,0.15,0.0>}
                object {Col_Bal translate <0.8,0,14>}
                object {Col_Bal translate <0.2,0,14>}  
                box{<-1,1,14.8><1.3,1.15,15.2>}
                box{<-1,0,14.8><1.3,0.15,15.2>}
                pigment {rgb <1,0.95,0.85>*2}
                normal {granite .01}
                translate z*.5
                
                
}

#declare Balcon= union {
        object {Balcon }
        object {Balcon translate y*3}
        object {Balcon translate y*6}
}
//--------------------------------
#declare M_Vitre=material { texture { pigment { rgbf <1,1,1,.9> } 
                                      finish { 
                                                  specular 1
                                                  roughness 0.001
                                                  ambient 0
                                                  diffuse 0
                                                  reflection 0.1
                                                }

                                      }
                                      interior {ior 1.5}  
}

                        
#declare Fenetre_au_44 = union {
                                box { <-.025,0,0.0><0.25,2,1.9>  }//pigment {rgb <2,0,0>}}//
                                box { <-.025,0,.93><0.025,2,.96> material {M_Bare }}
}

#declare k=.5;
#declare Fenetre_au_44 =
 union {  
        #while (k < 25)
                #if (k < 20 )
                object { Fenetre_au_44 translate z*k  }
                 #end
                 #declare k=k+5;
        #end // While
 }   
 
 
#declare Fenetre_au_44= union {
        object {Fenetre_au_44 }
        object {Fenetre_au_44 translate y*3}
        object {Fenetre_au_44 translate y*6}
        material {M_Vitre}
}

//------------

#declare Trou_Fenetre=box {<-4,0,0><1,2,2>   material {M_au_44} }
#declare i=0.5;
#declare Trou_Fenetre=
 union {  
        #while (i < 25)
                #if (i < 25 )
                object { Trou_Fenetre translate z*i  }
                 #end
                 #declare i=i+5;
        #end // While
}   
#declare Trou_Fenetre= union {
        object {Trou_Fenetre }
        object {Trou_Fenetre translate y*3}
        object {Trou_Fenetre translate y*6}
        
}

//--------------------------------
#declare au_44= difference { 
                                box {<0,-1,0><-10,15,20> }  
                                box {<0.1,-1,0><-9.9,14.8,19.9> }
                                object {Trou_Fenetre}
                                
                              
}
#declare au_44= union { 
                        object { au_44 }
                        difference  {
                            box {<-1,0,0><-1.2,11.9,19.9> }
                            object {Trou_Fenetre translate <0,4.5,1>}
                            }
                            material {M_au_44} 
}
#declare au_44= union {
      //  light_source {0*x rgb <.8,.8,.9> translate <-5,8,7.5>}
                           object { au_44 translate <0,0,0,>}     
                          object { Store_ptmg translate <-1,2,0> }
                        //  object {Balcon translate <-.2,4.,0>}
                          object {Fenetre_au_44 translate<-1,4.5,1>}
}

//============================
//////////////////////////////////////
#if (Render)
//-----------------------------------
//  camera  Autor : Jean Montambeault
//------------------------------------
#declare Zoom=1.5;
#declare Right=4/3*x;   // pour changer le rapport x/y ;                        
//------------------------------------
#include "camera.inc" 
//Camera (25, 10, 20, <4.75,5,-5>,no)
//Camera (Distance, Azimut, Elevation, CentreD_Interet,FocalBlur) 
Camera (25, 10, 20,<4.75,5,-5>,no) 
//=====================================
light_source { 0*x rgb <1,0.95,0.85> translate <-100, 1000,-1000>}
//light_source { 0*x rgb 1 translate <-100,100, -100>}
plane { y,0 pigment {rgb .8} }
background { rgb .8}
//===================================== 
union {
       
       object { au_44 rotate y*180 translate <20,10*cm,15+8.2+15.2>  }     // 
       //   object { au_44 }
      rotate y*15
      translate x*-5 
        }

//====================================
#end  //fin if_Render              