// Persistence of Vision Ray Tracer Scene echafdag.inc
// autor Martial.Rameaux
#version unofficial Megapov 0.4;
//=============================    
#local Render=0;
//=============================
#if (Render )
#include "colors.inc"  
#include "hasard.inc"  
#include "Mega_metals.inc"
#include "etalon.inc"
#end
#include "WOODMAPS.INC"
#include "WOODS.INC"

//=============================
#declare M_Poteau_Echf=material {
                        texture {
                                pigment { rgb <0.9,0.9,.95>}
                                finish {ambient 0.3 diffuse 0.6 phong 1 reflection 0.3}
                        }
}
#declare T_Platre     = texture {
                                pigment {
                                leopard 
                                color_map {
                                [0.0 rgbf <1,1,1,0.3>]
                                [0.5 rgbf <1,1,1,1>]
                                [0.7 rgbf <1,1,1,.2>]
                                [1.0 rgbf <1,1,1,0.8>]
                                }
                                turbulence .6 omega 1 lambda 5.0 octaves 5 phase 2
                        }
                        finish {ambient 0.3 diffuse .6  }
                        scale <.5,1.0,1> 
}  

#declare M_Bastin_Ech =material { texture {T_Wood10}texture {T_Platre}}

#declare Lg_Ech=5*m;
#declare Transversal_Echf=union {
                                 cylinder {x*-.1,x*1.3,5*cm  }
                                 sphere { 0,8*cm }
                                 sphere { 0,8*cm translate x*1.2} 
                                material {M_Poteau_Echf }
}
#declare Trans_Obliq_Echf=union {
                                cylinder {<0,0,0><0,3,Lg_Ech>5*cm}
                                sphere { 0,8*cm }
                                sphere { 0,8*cm translate y*3} 
                                cylinder {<0,3,0><0,0,Lg_Ech>5*cm}
                                sphere { 0,8*cm translate <0,0,Lg_Ech>} 
                                sphere { 0,8*cm translate <0,3,Lg_Ech>} 
                                sphere { 0,12*cm translate <0,1.5,Lg_Ech/2>}
                               // translate x*1.2
                                material {M_Poteau_Echf }
}
#declare Trans_Obliq_Echf=union {
                                object {Trans_Obliq_Echf translate <0,.5,0>}
                                object {Trans_Obliq_Echf translate <1.2,.5,0>}

}

#declare Poteau_Echf= union {
                              cylinder {<0,0,0><0,15,0>5*cm}
                              cylinder {<0,0,0><0,.1,0>10*cm}
                              cylinder {<0,0,0><0,15,0>5*cm translate <1.2,0,0>} 
                              cylinder {<0,0,0><0,.1,0>10*cm translate <1.2,0,0>} 
                              material {M_Poteau_Echf }
}
#declare Poteau_Echf_1= union {
       object {Poteau_Echf}
        object {Transversal_Echf translate y*4.}
         object {Transversal_Echf translate y*6.}
          object {Transversal_Echf translate y*8.}
           object {Transversal_Echf translate y*10.}
            object {Transversal_Echf translate y*12.}
            
          
}
#declare Poteau_Echf_2= union {
       object {Poteau_Echf}
        object {Transversal_Echf translate y*4.2}
         object {Transversal_Echf translate y*6.2}
          object {Transversal_Echf translate y*8.2}
           object {Transversal_Echf translate y*10.2}
            object {Transversal_Echf translate y*12.2}
          
}
#declare Bastin_Ech =union {
                            box {<0.1,0,-.2><.3,.1,Lg_Ech+.2> material {M_Bastin_Ech}}
                            box {<0.32,0,-.2><.58,.12,Lg_Ech+.2> material {M_Bastin_Ech}}
                            box {<0.60,0,-.2><.80,.13,Lg_Ech+.2> material {M_Bastin_Ech}}
                            box {<0.82,0,-.2><1.02,.1,Lg_Ech+.2> material {M_Bastin_Ech}}
                            box {<1.05,0,-.2><1.16,.1,Lg_Ech+.2> material {M_Bastin_Ech}}
}

                            
                                
#declare Poteaux_Echf_1= union {
                                object {Poteau_Echf_1}
                                object {Poteau_Echf_1 translate z*Lg_Ech }
                                object {Trans_Obliq_Echf translate y*.3  }
                                object {Trans_Obliq_Echf translate y*4.3 }
                                object {Trans_Obliq_Echf translate y*8.3 }
                                object {Trans_Obliq_Echf translate y*12.3}
                                object {Bastin_Ech translate y*4}
                                object {Bastin_Ech translate y*6}
                                object {Bastin_Ech translate y*8}
                                object {Bastin_Ech translate y*10}
                                object {Bastin_Ech translate y*12}
                                
}
#declare Poteaux_Echf_2= union {
                                object {Poteau_Echf_2}
                                object {Poteau_Echf_2 translate z*Lg_Ech}
                                object {Trans_Obliq_Echf }
                                object {Trans_Obliq_Echf translate y*4 }
                                object {Trans_Obliq_Echf translate y*8 }
                                object {Trans_Obliq_Echf translate y*12}
                                object {Bastin_Ech translate y*4.2}
                                object {Bastin_Ech translate y*6.2}
                                object {Bastin_Ech translate y*8.2}
                                object {Bastin_Ech translate y*10.2}
                                object {Bastin_Ech translate y*12.2}
                                
}

#declare Echafaudage =union {
                        object {Poteaux_Echf_1 } 
                        object {Poteaux_Echf_2 translate z*(Lg_Ech+.2)}
                        object {Poteaux_Echf_1 translate z*((Lg_Ech*2)+.4)}
}             

//======Mur en Travaux================
#declare M_Sous_Mur_Travaux= material {
                                texture {
                                  pigment {
                                            brick  color rgb .7  , color rgb<1,0.5,0.5>
                                            brick_size <2,1,1>   
                                            mortar     .15       
                                  }
                                   finish {ambient 0.3 diffuse 0.6 phong 0.2 phong_size 10}
                                 normal {granite .1}
                                }
                                scale .3
}

#declare M_Mur_Travaux = material {
                                texture {
                                        pigment {
                                                granite 
                                                color_map {
                                                        [0.0 rgb <0.8,0.8,0.7>]
                                                        [0.5 rgb <0.5,0.5,0.3>]
                                                        [1.0 rgb <1.0,1.0,1.0>]
                                                }
                                        }
                                        finish {ambient 0.3 diffuse 0.6 phong 0.2 phong_size 10}
                                        normal {granite .5}
                                }
                                texture {T_Platre }
}
#declare T_Sale     = texture {
                                pigment {
                                leopard 
                                color_map {
                                [0.0 rgbf <0.9,0.9,0.9,1.0>]
                                [0.5 rgbf <0.9,0.9,0.9,0.4>]
                                [1.0 rgbf <0.9,0.9,0.9,0.8>]
                                }
                                turbulence .6 omega 1 lambda 5.0 octaves 5 phase 2
                        }
                        finish {ambient 0.3 diffuse .6  }
                        scale <.2,1.2,1.> 
}  

#declare Mur_Travaux =union {
                             box { <-.15,0,0><-.2,15,Lg_Ech*3>  material { M_Sous_Mur_Travaux }}
                             box { <-.15,0,0><0,15,Lg_Ech*3>  material { M_Mur_Travaux }}
}
#declare Trou = box {<-1,0,0><1,1.5,1> material{M_Sous_Mur_Travaux}}
#declare Trou =union {
                        object {Trou translate <0,1.2,1>}
                        object {Trou translate <0,4,1>}
                        object {Trou translate <0,7,1>}
                        object {Trou translate <0,10,1>}
}

#declare Mur_Travaux =difference {
                                object {Mur_Travaux}
                                
                                object {Trou translate <0,0,1>}
                                object {Trou translate <0,0,5>}
                                object {Trou translate <0,0,9>}
                                object {Trou translate <0,0,12>}
}
#declare Mur_A_Reparer=height_field { png "mur_trx.png"  
                        scale <1.3,.5,1.5>*2
                        water_level 0.5
                        smooth  
                        pigment { rgbf 1}
                        rotate x*-90 
}

#declare Mur_Travaux =difference {
                                object {Mur_Travaux} 
                               
                             object {Mur_A_Reparer rotate y*90 translate <.95,5,5>} 
                             object {Mur_A_Reparer rotate y*90 translate <.95,5,2>} 
                             object {Mur_A_Reparer rotate y*90 translate <.95,3,5>} 
                             object {Mur_A_Reparer rotate y*90 translate <.95,3,6>} 
                             object {Mur_A_Reparer rotate y*90 translate <.95,1,6>}
                             object {Mur_A_Reparer rotate y*90 translate <.95,2,7>}
                             
                             object {Mur_A_Reparer rotate y*90 translate <.95,3,10>} 
                             object {Mur_A_Reparer rotate y*90 translate <.95,6,12>} 
                             object {Mur_A_Reparer rotate y*90 translate <.95,8,12>}
                             object {Mur_A_Reparer rotate y*90 translate <.95,2,12>}
                                }


//=====Lumieres===================
#declare Lumiere_Mur =union {
                light_source {
                                0*x
                                rgb <1,1,.98>*.5 
                                translate <5,20,5>
                                spotlight 
                                radius 10
                                falloff 12
                                point_at <0,5,4>
                                fade_distance 20
                                fade_power 1
                                
                }
                
                                
light_source {
                                0*x
                                rgb <1,1,.98>*.5 
                                translate <5,20,13>
                                spotlight 
                                radius 10
                                falloff 12
                                point_at <0,5,13>
                                fade_distance 20
                                fade_power 1
                               
 }
}

//===Sol_En_Travaux================
#declare RAND1=function{noise3d(x*40,y,z*40)}
#declare FUNC1=function{ y+abs(x+2)*0.15-0.2-noise3d(x*2,0,z)*0.5
               -noise3d(x*12,0,z*12)*0.03-RAND1*0.012-noise3d(x*125,y*5,z*125)*0.005
               -noise3d(x*300,y*100,z*300)*0.002-noise3d(x*1000,y*400,z*1000)*0.0005}

#declare Sol_Travaux=isosurface {
     function{ FUNC1 }
     contained_by{ box {<0, -0.1,0>, <5, 0.9, 15>}}  
     method 2
   //  eval
     max_gradient 2.6     
     pigment { function { RAND1*(y+0.2)*0.12+y*0.3}
       color_map {[0.000, 0.006  color rgb <1.000,0.094,0.094>  color rgb <1.000,0.945,0.945>]
                  [0.006, 0.008  color rgb <1.000,0.878,0.878>  color rgb <0.984,0.929,0.929>]
                  [0.008, 0.025  color rgb <1.000,0.973,0.973>  color rgb <1.000,0.518,0.518>]
                  [0.025, 0.035  color rgb <1.000,0.984,0.984>  color rgb <0.737,0.725,0.624>]
                  [0.035, 0.050  color rgb <0.737,0.671,0.110>  color rgb <0.737,0.671,0.106>]
                  [0.050, 1.000  color rgb <0.737,0.671,0.106>  color rgb <0.827,0.788,0.149>]}
       frequency 0.2
     }
     normal { 
        function  {noise3d(x*345,y*345,z*345)*0.15}
        slope_map { [0 <1, 1>]  [0.4 <0, 1>] } scale 0.1
     }              
     finish {phong 0.04}
}    


#declare Mur_Travaux=union {
                           object {Lumiere_Mur} 
                           object {Mur_Travaux }
                           object {Sol_Travaux }
}


//====================================
#if (Render)       
//====================================
// CAMERA Autor : Jean Montambeault
//------------------------------------
#declare Zoom=1.5;
#declare Right=4/3*x;   // pour changer le rapport x/y ;                        
//------------------------------------
#include "camera.inc" 
//Camera (Distance, Azimut, Elevation, CentreD_Interet,Focalblur)
Camera (25, 20, 20, <0,0,0>,0)
//=====================================
light_source { 0*x color rgb <0.961,0.933,0.796>*.8 translate <0,2000,-4000>}             // 
background {color rgbt <0.153,0.169,0.170>}
plane {y,0.1 pigment {rgb 0.6} }
//================================================
//camera {location <0,1,-5> direction z*1.5 look_at 0}
  // 
  #declare Cfz=15
union { 
object {Echafaudage translate <4.5,10*cm,Cfz+8.2> } 
object {Mur_Travaux translate <4  ,10*cm,Cfz+8> }

rotate y*15
translate <-5,.1,0>                          
}  
//Etalon(0)        

//===================================
#end // if Render       