// Persistence of Vision Ray Tracer Scene Goutiere.inc
#version unofficial Megapov 0.4;
//=============================
#local Render=0;

#if (Render)
//===============================================
#include "colors.inc"	   // Standard Color definitions
#include "textures.inc"	   // Standard Texture definitions
#include "mega_metals.inc" // MegaPOV Metals definitions
#include "hasardg.inc" 
//================================================
camera { location <0,10,-10> right 1.33*x look_at  <0,5,0>} 
light_source { 0*x rgb 1 translate <-0,10,-100>}
background { Blue*0.5 }
//=====Declaration Mesures Etalon le metre (m)===
#declare  m =1;
#declare cm =1 /100*m;
#declare mm =1/1000*m;
#declare hm =   100*m;
#declare km =  1000*m;

#end 
//================================================ 

#declare T_Crasse = texture {
        pigment {
                wrinkles
                color_map {
                        [0.0 Clear]
                        [1.0 DarkBrown*.5 filter 0.5]
                }
        }
}
#declare Fct_granite=function { 
                pigment {granite turbulence 0.1
                          color_map { [0 rgb 1] [1 rgb 0] }
                       scale 0.1 
                       }
                }
#declare Fct_bozo=function {pigment { bozo}}
#declare Fct_Rouille=function {Fct_granite + Fct_bozo*.5}


#declare T_Rouille = texture {
	pigment {
		granite
		color_map {
			[0 DarkTan*.5]
			[0.7 DarkBrown*.5]
			[1 Orange*.5]
		}
	}
	normal{ granite .6 scale .1 }
	finish{ ambient .4 diffuse .6
		specular .3 roughness .5
	}
}
#declare T_Metal_Pourri = texture {
	pigment { color rgb<.8, .85, 1>*.6 }
	normal { bumps .8 scallop_wave scale 2 }
	finish { ambient .3 diffuse .6
		specular .3 roughness .5
		metallic
	}
}
#declare T_Alu = texture {
	pigment { color rgb<.9, .92, .95>*.7 }
	normal { bumps .2 scallop_wave scale .5 }
	finish { ambient .3 diffuse .6
		specular .5 roughness .05
		metallic
	}
}
#declare T_Alu_Rouille = texture {
	bozo
	scale 3
	texture_map {
		[0.0 T_Alu ]
		[1.0 T_Rouille scale 5 ]
	}
	warp { reset_children }
	warp { turbulence 1 lambda 2 octaves 3 }
}


#declare T_Joint=
texture {
	bozo
	scale 3
	texture_map {
		[0.0 T_Alu ]
		[1.0 T_Rouille scale 5 ]
	}
	warp { reset_children }
	warp { turbulence 1 lambda 2 octaves 3 }
}



// Mega_M_Chrome_5A }
//#declare T_Joint    = texture {T_Joint_Goutiere }
#declare N_Gouttiere=normal{ function (Fct_Rouille*exp(x*y+z)*1.2) }
//================================================ 
#declare hg  =   2.5*m;  //hauteur goutiere
#declare rg  =  10*cm;   // rayon goutier
#declare rj  =  12.5*cm;
#declare rej =  1.2*cm;
#declare Vctg=   .8;
#declare   i =   0;
//========================================================

#declare Goutiere=  union {
        #while ( i < 8)
                #declare Co=.81;  
                #declare Random=Rand()*Vctg;
                #if (Random <= Vctg/2 ) 
                #declare Random = - Random;
                #end 
                
        union {
                cylinder { <0,0,><0,hg,0>rg rotate <0,0,  Random > } 
                torus { rj,rej texture {T_Joint }scale <1,3,1> translate y*hg} 
                torus { rj,rej texture {T_Joint } scale <1,3,1> translate y*hg*2} 
                
                material {      
                         texture {
	bozo
	scale 3
	texture_map {
		[0.0 T_Alu ]
		[Rand()*1.1 T_Rouille scale 5 ]
		[1.0 T_Alu ]
	}
	warp { reset_children }
	warp { turbulence 1 lambda 2 octaves 3 }
}
                        
                }
 
                translate <0,(hg*i),0> 
                 }
       #declare i = i + 1;
       #end        
}

//===============
#if (Render)
object {Goutiere}
#end
             