#version unofficial Megapov 0.4;
//=============================
#local Render = 0; 
//=============================
#if(Render)
// ==== POV-Ray Includes ====
#include "colors.inc"	   // Standard Color definitions
#include "textures.inc"	   // Standard Texture definitions
#include "mega_metals.inc" // MegaPOV Metals definitions 
#include "hasard.inc"      // Hasard de R.Gelaude     
#include "etalon.inc"      // Etalon le metre (m)
#local vitre=0;  
#end
//============================
#declare Font_Pov="arial.ttf"
#declare T_Bare=material {Mega_M_Brass_1A}
#declare M_Ensg_H=material {
                  texture {              
                        pigment { color rgb <0.0,10,5>}
                        finish { ambient 1 diffuse 1.0 phong 1 reflection 0}
                  }
                 
}
#declare M_Graph=material {
                  texture {
                      pigment { rgb <0.3,0.3,1>}
                      finish {ambient 0.3 diffuse 0.6 specular 0.1 metallic reflection .1} 
                  } 
                  texture {
                      pigment { rgbf <0.5,0.3,0,0.9>}
                      finish {ambient 0.3 diffuse 0.6 specular 0.1 metallic 
                      irid {
			0.35
			thickness .4
			turbulence .5
		       }
                      } 
                  }
                  
                  interior{
        		ior 1.5
        		caustics 1
	}
}
                      
#declare M_Graph_Vitre=material {
               texture {
                        pigment {rgb 1 }//color rgbf <0.3, 0.3, 0.9, 0.3>  }
                       finish {
                          ambient 0.1
                          diffuse 0.1
                          metallic
                          reflection 1
                          specular 1
                          roughness 0.001
                           irid {
			0.35
			thickness .1
			turbulence .5
		       }
                       }
               }
           /*    interior {ior 2.45 
                        fade_distance 8
        		fade_power 1 
        		caustics 1
        		}*/
}

    
#declare Barre=cylinder {<-.8,0.2,2*cm><5*cm,0.2,2*cm>2*cm material {T_Bare}}
#declare Enseigne_H=
                    union {
                        #declare EsegH=0.3;
                        text { ttf Font_Pov
                                "G" EsegH,0
                                scale <1,1.2,1>
                              //  rotate z*-45
                                translate <0,4,0>*1.2
                        }
                         text { ttf Font_Pov 
                                "R" EsegH,0
                              scale <1,1.2,1>
                                translate <0,3,0>*1.2
                         }
                         text { ttf Font_Pov 
                                "A" EsegH,0 
                              scale <1,1.2,1>
                                translate <0,2,0>*1.2
                                //rotate z*15
                         }
                           text { ttf Font_Pov 
                                "P" EsegH,0 
                              scale <1,1.2,1>
                                translate <0,1,0>*1.2
                                //rotate z*15
                           }
                             text { ttf Font_Pov 
                                "H" EsegH,0 
                              scale <1,1.2,1>
                                translate <0,0,0>
                                //rotate z*15
                        }
                        material { M_Ensg_H }
                       rotate y*90
               
}
        
        

#declare M_Plc_Graph=material { texture {
                                pigment {color rgb <0.059,0.565,0.525> }
                                finish { ambient 0.3 diffuse 0.4 reflection 0.2}
                                }
}

#declare Plc_Graph =box{<.5,0,0><11.5,.1,9.8> material {M_Plc_Graph} }       
       
#declare Etg0=  
       difference {
         box{<0,0,0><8,4,10>}
         box{<.5,0,-6><7.5,3.8,9.8>}
       }
#declare Etg0_vitre=box{<.5,0,0><7.5,3.8,0.05> material {M_Graph_Vitre}}
#declare Etg0=union { object {Etg0} #if (vitre) object {Etg0_vitre} #end }

#declare Etg1=difference {
        box{<0,0,-1.1><8,3,10> }
        box{<.5,0.1,-6><7.5,2.8,9.8> }
}
#declare Etg1_vitre=box{<.5,0.1,-1.1><7.5,2.8,0.05> material {M_Graph_Vitre}}
#declare Etg1=union { object {Etg1}  #if (vitre) object {Etg1_vitre} #end }

#declare Etg2=difference {
        box{<0,-4,0><8,3.2,10> rotate x*-20 translate y*4}
        box{<.5,-4.1,-6><7.5,3,9.8>  rotate x*-20 translate y*4}
}
#declare Etg2_vitre=box{<.5,-4.1,0><7.5,3,0.05>   material {M_Graph_Vitre}rotate x*-20 translate y*4}
#declare Etg2=union { object {Etg2} #if (vitre) object {Etg2_vitre} #end }

#declare Graph=
                union {
                        object {Plc_Graph}
                        object { Etg0}
                        object {Etg2}
                      object {Etg1 translate y*7}
                      object {Etg1 translate y*10} 
                      object {Etg1 translate y*13} 
                        object {Enseigne_H translate <-.50,5,-.5>}
                        material { M_Graph }
                       // rotate y*-90
                       
                }
                
 
        
                
//============================
//////////////////////////////////////
#if (Render)
//-----------------------------------
//  camera  Autor : Jean Montambeault
//------------------------------------
#declare Zoom=1.5;
#declare Distance =50;
#declare Azimut = 0; 	// angle de dplacement                       
#declare Elevation =20; // angle en degrs au-dessus (positif) ou en-dessous (ngatif) du plan XZ ; 
                        // cet angle se limite  : 90 > Elevation > -90. C'est absolument ncessaire.
#declare Right=4/3*x;   // pour changer le rapport x/y ;                        
#declare CentreD_Interet = <-0,5,4>;
#declare Up=y;
#declare Angle=0;

#declare FocalBlur=false; // true pour enclencher le focal blur
#declare Aperture=0.3;	  // adapter les valeurs 	
#declare BlurSamples=30;
#declare FocalPoint=<0,20,0>;

//------------------------------------
#include "camera.inc" 
Camera (Distance, Azimut, Elevation, CentreD_Interet,FocalBlur) //, Angle
//=====================================
light_source { 0*x rgb 1 translate <0, 1000,-1000>}
//light_source { 0*x rgb 2 translate <-10,-100,-100>}
plane { y,0 pigment {rgb  .5}hollow }
//===================================== 
  
object { Graph }

//====================================
#end  //fin if_Render                                