// Fichier Store.inc for MegaStore 
#version unofficial Megapov 0.4;
//=============================
#local Render = 0;
//=============================
#if(Render) 
#local vitre = 0;
// ==== POV-Ray Includes ====
#include "colors.inc"	   // Standard Color definitions
#include "textures.inc"	   // Standard Texture definitions
#include "mega_metals.inc" // MegaPOV Metals definitions 
#include "hasard.inc"      // Hasard de R.Gelaude     
#include "etalon.inc"      // Etalon le metre (m)  


#end

//=======TEXTURES=====================
#declare T_Bare=material {Mega_M_Brass_1A }

#declare Isof_Dome_N=function {pigment {leopard color_map{[0.0 rgb 1][1.0 rgb 0]}scale <1,10,1>}}

#declare M_MegaStore=material { texture {pigment {color rgb <0.30, 0.20, 0.10>}
                                   //     normal {function Isof_Dome_N*(x*y*z)*3}
                                        finish {
                                            ambient 0.35
                                            brilliance 2
                                            diffuse 0.3
                                            metallic
                                            reflect_metallic
                                            blinn 2.0 facets 0.28
                                            reflection 0.15
                                        }
                                        }
                                        interior {ior 20}
}



#declare M_MegaStore_Vtr =material {
                        texture {
                                  pigment { rgbf <0.98,0.98,1,.99>} //<0.98,0.98,1,.8>  
                                  finish {
                                          ambient 0.35
                                          diffuse 0.3
                                          
                                         reflect_metallic 0.1
                                         blinn 3.0 facets .1
                                         reflection_blur 0.001
                                                 
                                       
                                         reflection <0.5,0.5,1>
                                          specular 1
                                          roughness 0.001
                                          
                                        }  
                        }
                        interior {ior 1.5 }  //  dispersion 1.05  disp_nelems 15
          
}                            


                        
#declare M_Ensg_megapov=material {M_MegaStore }


#declare T_Escalier = 
        texture {pigment { rgb <1.000,0.953,0.145>  }
           finish {ambient 0.3 diffuse 0.6  }
        }
        
#declare T_Plancher_MegaStore=texture {pigment {   hexagon
                                rgb<0,rand(hasard),rand(hasard)>,
                                rgb<0,rand(hasard),rand(hasard)>,
                                rgb<0,rand(hasard),rand(hasard)>}
         scale .2
}   

#declare M_MegaStore_Batiment=material{
                                texture {
                                        pigment {rgb <0.6,.6,1>}
                                        finish { ambient 0.3 diffuse 0.6  
                                       //  reflection 1                               
                                        }        
                                }
}

 
//=====FORME MegaStore=============================================
#declare h_MegaStore = 15;

#declare Enseig_megapov=height_field { png "mgStore.png"  
                      //  scale <299/252,.05,1.1>*3
                        scale <1,.05,1.1>*3
                        water_level 0.5
                        smooth inverse material {M_Ensg_megapov }
                        rotate x*-90 
}

#declare Bastin=union {box{<0,0,0><8*cm,h_MegaStore,5*cm>} sphere {0,15*cm}}
#declare Plancher_MegaStore= cylinder {<0,0,0><0,.01,0>1.95 texture {T_Plancher_MegaStore}}
#declare Tourel_Vitre=difference{
                        cylinder {<0,-0.5,0><0,h_MegaStore,0>2 } 
                        cylinder {<0,-.1,0><0,h_MegaStore-.01,0>1.99 } 
                  material{M_MegaStore_Vtr}  //
                  
                 //  material {M_Cafe_Mur }   
}
#local i=0;
#local j=3;
#declare Tourel=union { 
                 #if (vitre)  object {Tourel_Vitre }  #end
                object {Plancher_MegaStore}
                #while (i < 360)
                        object {Bastin  translate  x*2 rotate y*i }
                        torus  {2,5*cm translate y*j}
                                #declare i=i+45;
                                #declare j=j+2;
                                #end
                                material {T_Bare }
                      
}

                        
#declare Colone_Rampe= cylinder {<0,0,0><0,h_MegaStore,0>.5 material {T_Bare }} 

#local Lg_R=1.5; //largeur Rampe
#local i=0;
#local j=0;

#declare Escalier=box {  <0,.09,0><1,.14,.30> }   
#declare Escalier=union {
                        #while ( j < h_MegaStore-2 )
                        object {Escalier 
                                texture { T_Escalier pigment { rgb<0,rand(hasard),rand(hasard)>} }
                                        translate x*-Lg_R
                                        rotate y*i
                                        translate y*j
                                        #declare j=j+.15;
                                        #declare i=i+13;                 
                        }
                        #end
}

#local i=0;   
#local j=0;  
#local k=0;
#local m=0;

#declare Rampe_Esc =sphere  {0,5*cm material { T_Bare } }
#declare Rampe_Tringle= cylinder {<0,0,0><0,1.05,0>5*cm material { T_Bare } }
#declare Rampe_Esc = union {
                        #while ( j < h_MegaStore )
                        object {Rampe_Esc 
                                        translate x*-Lg_R
                                        rotate y*i
                                        translate y*j 
                        }
                        object {Rampe_Esc 
                                        translate x*-.55
                                        rotate y*i
                                        translate y*j 
                        }
                                #declare j=j+.015;
                                #declare i=i+1.3;                 
                        #end   
                        
}
//------------
#local i=0;   
#local j=0;  
#declare Rampe_Tringle=union {
                        #while ( j < h_MegaStore )
                                object {Rampe_Tringle translate x*-Lg_R rotate y*i  translate y*j}                                         
                                #declare j=j+.30;
                                #declare i=i+26;                 
                        #end   
                        
}
//---------
#declare Escalier  = union { object { Rampe_Esc  translate y*1.05} 
                             object { Escalier }   //   
                             object {Rampe_Tringle} 
                             object {Colone_Rampe}
                             }     
// Lumieres ---------                                                       
#declare Feux=light_source { 0*x color rgb <0.878,0.761,0.439>*5 
                                spotlight translate <0,30,0> //<-10,30,-5> 
                                radius 5 falloff 10 tightness 12
                                point_at 0 //y*h_MegaStore
                                fade_distance 15
                                fade_power 2
                              //  shadowless
}
#declare Feux2=light_source { 0*x color rgb <0.878,0.761,0.439>
                                spotlight translate <-15,80,0> //<-10,30,-5> 
                                radius 5 falloff 10 tightness 12
                                point_at <4,0,0> //y*h_MegaStore
                                fade_distance 80
                                fade_power 2
                              //  shadowless
}
//-----Sol et entre etage 
#declare Sol_Batiment=  box{<-2,0,2><2,.1,48>  texture {T_Plancher_MegaStore} }

#declare Sol_Entre_Etage_Batiment= box {<-2,0,2><1.9,3*cm,44>  }
#declare Sol_Entre_Etage_Batiment= union { //box {<-2,0,48><1.9,3*cm,50>}  
                                           object { Sol_Entre_Etage_Batiment}    
                                           texture {T_Plancher_MegaStore}
}
#declare MegaStore_Batiment =union { 
 #if (vitre)    box{<-2,-.5,2><-1.98,h_MegaStore,48>  material{M_MegaStore_Vtr} }   #end

        box{< 2,-.5,2>< 1.90,h_MegaStore,48>  material {M_MegaStore_Batiment }}
        }
       
//---------------
#declare Bastin_Horz = cylinder {<0,0,0><0,0,48>5*cm material {T_Bare }}
#declare i=0;
#declare j=2;
#declare k=3;
#declare MegaStore_Batiment = union { 
                               object { Escalier translate <0,0,46>}   //17
                               object {Sol_Batiment }
                               object {MegaStore_Batiment}
                              #while (i < 50)    
                               object {Bastin  material {T_Bare } translate  <-2.05,0,j>  }
                               object {Bastin_Horz translate <-2,k,0.0> }
                               object {Sol_Entre_Etage_Batiment translate <0,k,0.0> }
                                             #if (j <= 45)
                                                #declare j=j+5;  // bastin vertical
                                               #end 
                                             #if (k <= h_MegaStore)
                                                #declare k=k+2; 
                                              #end  
                                            #declare i=i+1;
                                           
                                           #end
                                           
                                           
                                           
} 
//-----SOLDE TOUT ARTICLE--------
#declare T_Solde =texture {
                           pigment { rgb <1,0,0> }
                           finish { ambient 0.3 diffuse .6 reflection 0.3 }
}
#declare Texte_Solde = text { ttf "arial" "     Mega"  
                               0.01,0 
                               translate y*1.5
}
#declare Texte_Solde =union {
                 object {Texte_Solde }
                 text { ttf "arial" "store tout pour Pov"
                            0.01,0 
                 }
                rotate y*90
}
#declare Texte_Solde =union {
             //     object {Texte_Solde  texture {T_Solde }rotate x*10 }
              //   object {Texte_Solde  texture {T_Solde }rotate x*10 translate y*3}
                object {Texte_Solde  texture {T_Solde }rotate x*10 translate y*6}
        scale <1,1,1>         
}
#declare MegaStore_Batiment = union {
        object { MegaStore_Batiment }  
        object {Texte_Solde translate <-2.5,1,44>}
        
        }
//==========STORE===========
#declare T_Crasse = texture {
        pigment {
                wrinkles
                color_map {
                        [0.0 Clear]
                        [1.0 DarkBrown*.5 filter 0.5]
                }
        }
}

#declare M_Store=material {  texture {
                        pigment {  checker color rgb 2, Blue }
                        finish {ambient 0.4 diffuse 0.6  phong 1 phong_size 40 }
                        scale <.8,1,50> rotate y*90 translate y*-5}
                            texture {T_Crasse scale 5 }
                            scale <1000,1,1>
                            
                         
}

#local hStore = 1;
#local lStore = 2;
#declare hyptn = sqrt ((hStore*hStore)+(lStore*lStore));
#declare hyptn = hyptn/2;

#declare Store = union { cylinder { < 0,0,0><0,hStore,0>5*cm}
                          cylinder {<-lStore,0,0><0,  0,0>5*cm}
                          cylinder {<-lStore,0,0><0,hStore,0>5*cm}
}
#declare Store = union { 
        object { Store }
        cylinder {<0,0,0><0,0,5>5*cm}
        cylinder {<-lStore,0,0><-lStore,0,5>5*cm}
         cylinder {<0,hStore,0><0,hStore,5>5*cm}
         object { Store translate z*5}
        }
#declare Tissu_Store = box { <-hyptn,-.1><hyptn,.005,5.1> material {M_Store  }}
#declare Tissu_Store_Pend= box{ <-.01,-.3,0><.01,0,5>material {M_Store  }}
            
         
           
#declare Store = union { 
         object { Store } 
         object { Tissu_Store rotate <0,0,degrees(tan(hStore/lStore))> translate <-1,.7,0>}   // 
         object { Tissu_Store_Pend translate <-2,0,0>}
         material{ T_Bare}
}

#declare i= 5;
#declare Store = union {  
                object { Store translate z*5  }
                 object { Store translate z*10.5  }
                  object { Store translate z*16 }
                   object { Store translate z*21.5  }
                    object { Store translate z*27  }
                    object { Store translate z*32.5 }
                    object { Store translate z*38  }
                    object { Store translate z*43.5  }
}
        
// fin Store
//-=========MegaStore_ET_BATIMENT===========           
#declare MegaStore =union {
                /**/    object { Tourel rotate y*-10} 
                        object { Escalier }      
                        object { Enseig_megapov scale .5  translate <-3.4,3.0,-.3> }
                        object { Feux }   
                        object { MegaStore_Batiment } 
                        object { Store translate <-2,3,0>}
                        material { M_MegaStore }
                       
}
                
//============================
//////////////////////////////////////
#if (Render)
//-----------------------------------
//  camera  Autor : Jean Montambeault
//------------------------------------
#declare Zoom=3;
#declare Right=4/3*x;   // pour changer le rapport x/y ;                        
//------------------------------------
#include "camera.inc" 
//Camera (25, 10, 20, <4.75,5,-5>,no)
//Camera (Distance, Azimut, Elevation, CentreD_Interet,FocalBlur) 
Camera (25, 10, 20, <7,5,-5>,no) 
//=====================================
light_source { 0*x rgb 1 translate <-100, 1000,-1000>}
//light_source { 0*x rgb 1 translate <-100,100, -100>}
plane { y,0 pigment {rgb .8} }
background { rgb .8}
//===================================== 
union {
       object { MegaStore translate <17,10*cm,4>  }
        
        rotate y*15
       translate x*-5 
        }

//====================================
#end  //fin if_Render              