//
#version unofficial Megapov 0.4;
//=============================
#local Render = 0;
//=============================
#if(Render)
// ==== POV-Ray Includes ====
#include "colors.inc"	   // Standard Color definitions
#include "textures.inc"	   // Standard Texture definitions
#include "mega_metals.inc" // MegaPOV Metals definitions 
#include "hasard.inc"      // Hasard de R.Gelaude     
#include "etalon.inc"      // Etalon le metre (m)  
#end
//================================
#declare T_Crasse = texture {
        pigment {
                wrinkles
                color_map {
                        [0.0 Clear]
                        [1.0 DarkBrown*.5 filter 0.5]
                }
        }
}


                                 
#declare T_Petit_Mag1= texture { pigment { rgb <.9,.8,.6> } //color rgb <1.000,.95,.85> }
                                           finish { ambient 0.3 diffuse 0.9 } 
                                           normal {granite .2}
                                           }
                                
                                 

#declare M_Petit_Mag=material { 
                                texture { T_Petit_Mag1   }  
                                 texture { T_Crasse scale 0.2 }
                                  texture { T_Crasse scale 0.2 }
                           scale 10  
}

                        
//-----------------------------------
//==========STORE_PTMG_PetitMAg===========
#declare M_Bare=material {Mega_M_Brass_1A }

#declare M_Store_ptmg=material {  texture {
                        pigment {  checker color rgb 2, rgb <0,2,0> }
                        finish {ambient 0.4 diffuse 0.6  phong 1 phong_size 40 }
                        scale <.8,1,50> rotate y*90 translate y*-5}
                            texture {T_Crasse scale 5 }
                             texture {T_Crasse scale 1 }
                         
}

#local hStore_ptmg = .5;
#local lStore_ptmg = 1.3;
#local lgStore_ptmg =6;
#declare hyptn = sqrt ((hStore_ptmg*hStore_ptmg)+(lStore_ptmg*lStore_ptmg));
#declare Store_ptmg = union { cylinder { < 0,0,0><0,hStore_ptmg,0>5*cm}
                          cylinder {<-lStore_ptmg,0,0><0,  0,0>5*cm}
                          cylinder {<-lStore_ptmg,0,0><0,hStore_ptmg,0>5*cm}
}
#declare Store_ptmg = union { 
        object { Store_ptmg }
        cylinder {<0,0,0><0,0,lgStore_ptmg>5*cm}
        cylinder {<-lStore_ptmg,0,0><-lStore_ptmg,0,lgStore_ptmg>5*cm}
         cylinder {<0,hStore_ptmg,0><0,hStore_ptmg,lgStore_ptmg>5*cm}
         object { Store_ptmg translate z*lgStore_ptmg}
        }
#declare Tissu_Store_ptmg = box { <-hyptn-.1,-.1><0.05,.005,lgStore_ptmg+.1> material {M_Store_ptmg  }}

#declare Store_ptmg = union { 
         object { Store_ptmg } 
        object { Tissu_Store_ptmg rotate <0,0,degrees(tan(hStore_ptmg/lStore_ptmg))> translate <0,hStore_ptmg+0.15,0>}
        box {<0,0,-.1><.01,-.3,lgStore_ptmg> material {M_Store_ptmg  }translate <-lStore_ptmg,0,0>}
         material{ M_Bare} rotate y*180
}

#declare Store_ptmg =object { Store_ptmg translate z*9  }
               
                 

//----Etalages---
#include "woodmaps.inc"
#include "woods.inc"

#declare Etalages1=union {
                      difference {
                        box { < 0.0,.50,0><1.50,1,1.0> }
                        box {<0.02,.55,0><1.48,2,.98> }
                      }
                      difference {
                        box { < 1.50,.50,1><1,1,1.5> }
                        box {< 1.48,.55,0.48><.98,1,1.48>  }
                      }
                      box {< 1.50,-.1,0.00><1.40,.5,0.05>}//pieds
                      box {< 1.50,-.1,1.50><1.40,.5,1.45>}
                      box {< 0.00,-.1,0.00><0.10,.5,0.1> }
}
#declare Etalages2=union {
                      difference {
                        box { < 0.0,.50,0><1.50,1,1.0> }
                        box { <0.02,.55,0><1.48,2,.98> }
                      }
                      difference {
                        box { < 1.50,.50,1><1,1,1.5> }
                        box { < 1.48,.55,0.48><.98,1,1.48>  }
                        translate z*-.5
                      }
                      box {< 1.50,-.1,0.00><1.40,.5,0.05>}//pieds
                      box {< 1.50,-.1,1.50><1.40,.5,1.45>}
                      box {< 0.00,-.1,0.00><0.10,.5,0.1> }
}

#declare Etalages=union {
        light_source {0*x rgb <0.961,0.933,0.796>  translate <.5,1,3> fade_distance 1 fade_power 1}             
        object {Etalages1 }
        object {Etalages2 translate z*3}
        #version official 3.1; // See Doc Megapov
        texture { T_Wood11 }
        #version unofficial MegaPov 0.4;
}

//---- fin Store_ptmg
                                     
//-=========MegaStore_ptmg_ET_BATIMENT===========    
//--------------------------------
#declare M_Vitre=material { texture { pigment { rgbf <1,.9,.89,.9> } 
                                      finish { 
                                                  specular 1
                                                  roughness 0.001
                                                  ambient 0.0
                                                  diffuse 0.0
                                                  reflection 0.2
                                                }

                                      }
                                      interior {ior 1.5}  
}

                        
#declare Fenetre_Petit_Mag = union {
                               box { <-.025,0,0.0><-.005,2,1.9>  }//pigment {rgb <2,0,0>}}//
                               box { <-.025,0,.91><-.005,2,0.99> material {M_Bare }}
                             //  box { <-.025,1.5,0><-.005,1.6,1.9> material {M_Bare }}
}
#declare Fenetre_Petit_Mag =
 union {  
                object { Fenetre_Petit_Mag translate z*0  }
                object { Fenetre_Petit_Mag translate z*5 }
                object { Fenetre_Petit_Mag translate z*10 }
 }   
 
 
#declare Fenetre_Petit_Mag= union {
       
        object {Fenetre_Petit_Mag translate y*3}
        object {Fenetre_Petit_Mag translate y*6}
         object {Fenetre_Petit_Mag translate y*9}
          object {Fenetre_Petit_Mag translate y*12}
      material {M_Vitre}   
}

//------------
#declare T_Sous_Sur_Fenetre=texture {pigment {rgb 1.2}}
                         texture {T_Crasse scale 5 }
#declare Sous_Sur_Fenetre=union {
                        box{ <-.2,0,0><.3,.15,2> }
                        box {<-.2,-1,-1><.2,1,1>rotate x*45  clipped_by{box {<-5,0,-3><5,2,3>}}
                                scale <1,.3,.8> translate <0,2,1>} 
                         texture {T_Sous_Sur_Fenetre}
}

#declare Balconet=difference {
         torus {.5,5*cm }
          plane { -z,0 }
          plane { x,0}
} 

#declare Sous_Sur_Fenetre=union {
 object { Sous_Sur_Fenetre}
object { Balconet translate <0,.5,0.5> }                 
object { Balconet rotate x*180 translate <0,.5,1.5> }                 
cylinder {<.5,.5,0.5><.5,.5,1.5>5*cm} 
//pigment {rgb <1,1,0>}
 material {M_Bare}
}

#declare Sous_Sur_Fenetre =
 union {  
                object { Sous_Sur_Fenetre translate z*1  }
                object { Sous_Sur_Fenetre translate z*6 }
                object { Sous_Sur_Fenetre translate z*11 }
 }   
#declare Sous_Sur_Fenetre= union {
        object {Sous_Sur_Fenetre translate y*3}
        object {Sous_Sur_Fenetre translate y*6}
         object {Sous_Sur_Fenetre translate y*9}
          object {Sous_Sur_Fenetre translate y*12}
}


//-------------
#declare Trou_Fenetre=box {<-4,0,0><1,2,2>   material {M_Petit_Mag} }
#declare Trou_Fenetre=
 union {  
                object { Trou_Fenetre translate z*1 }
                object { Trou_Fenetre translate z*6 }
                object { Trou_Fenetre translate z*11  }
            
                
}   
#declare Trou_Fenetre= union {
        object {Trou_Fenetre translate y*3}
        object {Trou_Fenetre translate y*6}
         object {Trou_Fenetre translate y*9}
          object {Trou_Fenetre translate y*12}
}
#declare Trou_Porte= box {<-1,-.1,0><2,2,1.5>}
//--------------------------------
#declare Petit_Mag= difference { 
                                box {<0,-1,0><-10,15,15> }  
                                box {<-0.1,-1,0><-9.9,14.8,14.9> }
                                object {Trou_Fenetre}
                                object {Trou_Porte translate z*6}
}
#declare Petit_Mag= union { 
                        object { Petit_Mag }
                        object {Sous_Sur_Fenetre }
   
                        difference  {
                            box {<-1,0,0><-1.2,11.9,14.9> }
                            object {Trou_Fenetre translate <0.0,4.5,1>}
                            }
                            material {M_Petit_Mag} 
}
//=====TOUT PETIT MAG =======================
#declare Petit_Mag= union {
        light_source {0*x rgb <1,.9,.85> translate <-5,8,5>}
                           object { Petit_Mag translate <0,0,0,>}     
                           object { Store_ptmg translate <-0,2,0> }
                             object {Etalages translate <0,0,4>}
                            object {Fenetre_Petit_Mag translate<0,0,1>}
}

//============================
//////////////////////////////////////
#if (Render)
//-----------------------------------
//  camera  Autor : Jean Montambeault
//------------------------------------
#declare Zoom=1.5;
#declare Right=5/6*x;   // pour changer le rapport x/y ;                        
//------------------------------------
#include "camera.inc" 
//Camera (25, 10, 20, <4.75,5,-5>,no)
//Camera (Distance, Azimut, Elevation, CentreD_Interet,FocalBlur) 
Camera (25, 10, 20, <4.75,5,-5>,no)
//Camera (25, 10, 1, <0,1,15+8.2+15.2>,no)
//Camera (25, 90, 2, <-5,5,2>,no)
//=====================================
light_source { 0*x color rgb <0.961,0.933,0.796>*.8 translate <0,2000,-4000>}             // 

background {color rgbt <0.153,0.169,0.170>}
plane { y,0 pigment {rgb .8} }
//===================================== 
union {
       
         object { Petit_Mag translate <0,10*cm,15+8.2+15.2>  }     // 
  rotate y*15
 translate x*-5 
        }

fog {
	distance 500
	color rgbt<0.2, 0.2, 0.7, 0.2>
	turbulence 0.2
	turb_depth 0.3
}
fog {
	distance 10
	color rgbft<0.2 0.2, 0.2,0.0,0.0>
	fog_type 2
	turbulence 0.2
	turb_depth 0.3
	fog_offset 1.5
	fog_alt 1
}


#end  //fin if_Render   

