// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

#version 3.1

#include "colors.inc"
  
  
#declare withGlass = yes ;
#declare withFenetre = yes ;

global_settings
{
  assumed_gamma 1.0
  ambient_light .7
}

// ----------------------------------------
camera
{
  location <60,100, -250>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 15,  0.0>
}
        
#debug str (clock + (30 *  cos (clock /100 *180 *pi/180)) , 10,4)
    
// ----------------------------------------
plane { y, 0 pigment {color rgb <0.7,0.5,0.3>}}



#declare antigrav =    
cylinder { <0,.1,0> <0,100,0>, 3  texture {pigment {color rgbt <1,1,1,.9>} finish {specular 1 reflection .3}}
	interior { ior 1.3
		}
	hollow yes
	}

#declare objCage = 
merge
{    
  difference {
  	union {
		sphere {<0,6,0>, 2 }
		sphere {<0,2,0>, 2 }
  	}
  	cylinder{ <0,2,0> <0,6,0>, 2 }
  	}

	
	cylinder{ <sin (90 * pi/180) * 2, 2,cos (90 *pi/180) * 2> <sin (90 * pi/180) * 2,6,cos (90 *pi/180) * 2>, .1 }
	cylinder{ <sin (180 * pi/180) * 2, 2,cos (180 *pi/180) * 2> <sin (180 * pi/180) * 2,6,cos (180 *pi/180) * 2>, .1 }
	cylinder{ <sin (270 * pi/180) * 2, 2,cos (270 *pi/180) * 2> <sin (270 * pi/180) * 2,6,cos (270 *pi/180) * 2>, .1 }
	cylinder{ <sin (360 * pi/180) * 2, 2,cos (360 *pi/180) * 2> <sin (360 * pi/180) * 2,6,cos (360 *pi/180) * 2>, .1 }
	
	torus {2, .1 translate <0,1.5,0>}
	torus {2, .1 translate <0,2,0>}                       
	
	torus {2, .1 translate <0,4.5,0>}
	torus {2, .1 translate <0,4,0>}
	
texture {pigment {color rgb <.5.5.5>} finish {specular .8}}	

translate <0,clock, 0>


}                  
        
                
#declare mySeed = seed (34) ;


#declare edifice1 = 
union
{
merge 
{
difference
{         
	merge
	  {
	  box {<-46,12,0> <30,100,40> }
	  box {<-21,0,0> <-3,12,40> }
          box {<-46,0,0> <30,1,40> }

	  }
    cylinder { <-12,.1,0> <-12,100,0>, 3}
    cylinder { <-20,.1,0> <-20,100,0>, 3}
    cylinder { <-4,.1,0> <-4,100,0>, 3}    
    cylinder { <25, .1,0> <25, 100,0>, 3}

#if (withFenetre = yes)    
    #declare j = 3 ;
    #while (j > 0 ) 
	  #declare i = 19;
      #while (i >= 0) 
    	
        box {<-23 - j * 7, 15 +i*4, -1> <-19 - j *7, 15 + i *4 + 3,1>}
        #declare i = i -2 ;
      #end
      #declare j = j - 1;
    #end                 
    
    #declare j = 3 ;
    #while (j > 0 ) 
	  #declare i = 19;
      #while (i >= 0) 
    	
        box {<26 - j * 7, 15 +i*4, -1> <22 - j *7, 15 + i *4 + 3,1>}
        #declare i = i -2 ;
      #end
      #declare j = j - 1;
    #end
 #end   
    texture {pigment {color rgb <.8,.8,.8>} normal {bumps .3 scale 2}}
}                        

#if (withFenetre = yes)
#declare j = 3 ;
#while (j >0) 
  #declare i = 19 ;
  #while (i>=0) 
    box {<-23 -j * 7, 15 + i *4, -.1> <-19 -j*7,15 + i *4 + 3,0> texture {pigment {color rgbt <1,1,1,.9>} finish {specular 1 reflection .3}}
      	interior { ior 1.3
	    	}
	    hollow yes} 
   #declare i = i -2 ;
  #end
  #declare j = j - 1 ;
#end

#declare j = 3 ;
#while (j >0) 
  #declare i = 19 ;
  #while (i>=0) 
    box {<26 -j * 7, 15 + i *4, -.1> <22 -j*7,15 + i *4 + 3,0> texture {pigment {color rgbt <1,1,1,.9>} finish {specular 1 reflection .3}}
      	interior { ior 1.3
	    	}
	    hollow yes} 
   #declare i = i -2 ;
  #end
  #declare j = j - 1 ;
#end          

#end
    

union
{
cylinder { <-43,0,3> <-43,12,3>, 3}
cylinder { <-43,0,17> <-43,12,17>, 3}
cylinder { <27,0,17> <27,12,17>, 3}
cylinder { <25,0,3> <25,12,3>, 3}
texture {pigment {color rgb <.8,.8,.8>}}
}

}                                          

#if (withGlass = yes)
object {antigrav translate <-20, 0,0>} 
object {antigrav translate <-12,0,0>} 
object {antigrav translate <-4,0,0>} 
object {antigrav translate <27,0,0>} 
#end

object {objCage rotate <0,75,0> translate <-12,0,0>}
object {objCage translate <-20, rand (mySeed) *100 , 0>}
object {objCage translate <-4, rand (mySeed) *100, 0> }
object {objCage translate <27, rand (mySeed) *100, 0> }



}
           
#declare mySpot =
light_source 
{
 <-12,1,-10>,1  spotlight
 radius 10
 falloff 15
 point_at   <-12,100,0>
 
}

light_source 
{
 <75,250,-100>,.6
}
    

object {edifice1 }
object {edifice1 translate <76,0,0>}
object {edifice1 translate <152,0,0>}
object {edifice1 rotate <0, -90,0> translate <-46,0,-30>}
object {edifice1 rotate <0, -90,0> translate <-46,0,-106>}


#declare trottoir=
box {<0,0,0> <10,1,-10> texture {pigment {color rgb <.5,.5,.5>} finish {specular .2}}	
}

#declare parc=
box {<- 46 +10.4, 0, -10.4> <200,1, -200> texture {pigment {color rgb <0,.3,0>} }finish {reflection 0} normal {wrinkles 10 scale 3}}

object {parc} 

#declare i = 0 ;
#while (i <100 ) 
  #object {trottoir translate <i * 10.4 -46,0,0>}                                                        
 #object {trottoir translate <-46,0,i * -10.4 + 10.4>}                                                        

  #declare i = i + 1 ;
#end            


#include "craneo.inc"

object {visage scale .04 rotate <0,-90,90> translate <55, -24, -85> 
pigment {color rgb <.1, 0, 0>
      
}
finish {diffuse .1
        specular .9
        phong .9
        
        reflection .01
metallic on 

} }
                

intersection           
{
  object {visage scale .042 rotate <0,-90,90> translate <57, -24, -85>}
  box {<- 46 +10.4, 0, -10.4> <200,3, -200>}                                        
  texture {pigment {color rgb <.5,.5,.5>} finish {specular .2}  }
}           

  
#declare lampadaire =
merge 
{
cylinder {<0,0,0><0,10,0>, .25  }
difference {
torus {2,.3 rotate <90,0,90>}
box {<-3,-3,-1> <3,0,1>}
box {<-3,0,-1> <-.5,3,1>}
translate <-2,8,0>
}
texture {pigment {color rgb <0,0,0>} finish{specular 1 reflection .06  metallic on }}
}



#declare i = 2 ;
#while (i <100 ) 
  #object {lampadaire rotate <0,90,0> translate <i * 10.4 -46,0,-10>}                                                        
 #object {lampadaire translate <-36,0,i * -10.4 + 10.4>}                                                        

  #declare i = i + 2 ;
#end            

