//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 2 lights, 6 textures and 569 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.01 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 04/19/2000    (19.04.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

/* // Scene Comment

This scene was created with Moray V3.01 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <0.819608,0.811765,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

#include "colors.inc"

//fog {
//  fog_type 2    // Ground Fog
//  distance     100.0
//  color <0.4,0.4,0.4,0.90,0.90>
//  up           <0,0,1>
//  fog_offset   0.0
//  fog_alt    100.0
//}

camera {  //  Camera StdCam1
   fisheye
   angle 145.0
  location  <0.0, 0.0, 460.0>
  direction <0.0,     0.0,  0.7669>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <61.979, 89.863, 38.158>
  // Focal blur settings
  focal_point  <61.979, 89.863, 38.158> // Always Lookat
  aperture     1.8
  blur_samples 15
  confidence   0.95
  variance     0.02
}

//
// *******  L I G H T S *******
//

light_source {   // fill_light
  <-171.295, 0.000, 1800.000>
// color rgb <0.453, 0.453, 0.475>

  color rgb <0.22, 0.22, 0.24>
  shadowless
}

light_source {   // main_light
  <3247.457, 1365.0, 3000.000>
  color rgb <0.871, 0.871, 0.800>
//  atmospheric_attenuation on
}


// sky sphere

  sky_sphere {

    pigment {
      gradient y
      color_map {
        [ 0.5  color CornflowerBlue ]
        [ 1.0  color MidnightBlue ]
      }

      scale 2
      translate -1
      rotate <-45.0,0.0,0.0>



    }

    pigment {
      bozo
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 0.1 color rgb <0.85, 0.85, 0.85>
                   color rgb <0.75, 0.75, 0.75>]
          [0.1 0.5 color rgb <0.75, 0.75, 0.75>
                   color rgbt <1, 1, 1, 1>]
          [0.5 1.0 color rgbt <1, 1, 1, 1>
                   color rgbt <1, 1, 1, 1>]
      }
      scale <0.2, 0.5, 0.2>
    }
    rotate -135*x
  }





//
// ********  TEXTURES  *******
//

#include "ptowers4fe.inc"



//
// ********  REFERENCED OBJECTS  *******
//

#declare Cube002 = object {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <7.0, 7.0, 0.2>
    translate  <500.0, 0.0, 0.75>
  }
}
#declare Cube70 = object {
  box { // Cube70
    <-1, -1, -1>, <1, 1, 1>
    scale <7.0, 7.0, 0.2>
    translate  <500.067374, 0.0, -0.597488>
  }
}
#declare alayer_glass = union {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr7
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    Cobalt_Blue_Glass
  }
  scale <0.36, 0.36, 0.16>
}
#declare alayer_wall = union {
  cylinder { // Cylndr9
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr10
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr11
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr12
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr13
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr14
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr15
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr16
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    Stainless_Steel
  }
  scale <0.36, 0.36, 0.16>
  translate  -2.0*z
}
#declare alayer_railing = union {
  cylinder { // Cylndr17
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube6
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr18
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr19
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr20
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr21
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr22
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr23
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr24
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    railing
  }
  scale <0.38, 0.38, 0.08>
  translate  -2.0*z
}
#declare astory = union {
  object { alayer_glass }
  object { alayer_wall }
  object { alayer_railing }
  translate  2.0*z
}
#declare alayer_glass1 = union {
  cylinder { // Cylndr25
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr26
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr27
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr28
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr29
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr30
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr31
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr32
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    Cobalt_Blue_Glass
  }
  scale <0.34, 0.34, 0.16>
}
#declare alayer_wall1 = union {
  cylinder { // Cylndr33
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube9
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube10
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr34
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr35
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr36
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr37
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr38
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr39
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr40
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    Stainless_Steel
  }
  scale <0.34, 0.34, 0.16>
  translate  -2.0*z
}
#declare alayer_railing1 = union {
  cylinder { // Cylndr41
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube11
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube12
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr42
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr43
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr44
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr45
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr46
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr47
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr48
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    railing
  }
  scale <0.36, 0.36, 0.08>
  translate  -2.0*z
}
#declare astory60 = union {
  object { alayer_glass1 }
  object { alayer_wall1 }
  object { alayer_railing1 }
  scale <0.9, 0.9, 1.0>
  translate  250.0*z
}
#declare alayer_glass2 = union {
  cylinder { // Cylndr49
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube13
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube14
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr50
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr51
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr52
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr53
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr54
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr55
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr56
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    Cobalt_Blue_Glass
  }
  scale <0.34, 0.34, 0.16>
}
#declare alayer_wall2 = union {
  cylinder { // Cylndr57
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube15
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube16
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr58
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr59
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr60
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr61
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr62
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr63
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr64
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    Stainless_Steel
  }
  scale <0.34, 0.34, 0.16>
  translate  -2.0*z
}
#declare alayer_railing2 = union {
  cylinder { // Cylndr65
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube17
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube18
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr66
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr67
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr68
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr69
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr70
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr71
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr72
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    railing
  }
  scale <0.36, 0.36, 0.08>
  translate  -2.0*z
}
#declare astory77 = union {
  object { alayer_glass2 }
  object { alayer_wall2 }
  object { alayer_railing2 }
  scale <0.68, 0.68, 1.0>
  translate  320.0*z
}
#declare alayer_glass3 = union {
  cylinder { // Cylndr73
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube19
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube20
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr74
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr75
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr76
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr77
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr78
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr79
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr80
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    Cobalt_Blue_Glass
  }
  scale <0.34, 0.34, 0.16>
}
#declare alayer_wall3 = union {
  cylinder { // Cylndr81
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube21
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube22
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr82
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr83
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr84
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr85
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr86
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr87
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr88
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    Stainless_Steel
  }
  scale <0.34, 0.34, 0.16>
  translate  -2.0*z
}
#declare alayer_railing3 = union {
  cylinder { // Cylndr89
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube23
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube24
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr90
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr91
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr92
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr93
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr94
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr95
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr96
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    railing
  }
  scale <0.36, 0.36, 0.08>
  translate  -2.0*z
}
#declare astory86 = union {
  object { alayer_glass3 }
  object { alayer_wall3 }
  object { alayer_railing3 }
  scale <0.62, 0.62, 1.0>
  translate  360.0*z
}
#declare alayer_glass4 = union {
  cylinder { // Cylndr129
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube33
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube34
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr130
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr131
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr132
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr133
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr134
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr135
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr136
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    Cobalt_Blue_Glass
  }
  scale <0.36, 0.36, 0.16>
}
#declare alayer_wall4 = union {
  cylinder { // Cylndr137
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube35
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube36
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr138
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr139
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr140
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr141
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr142
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr143
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr144
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    Stainless_Steel
  }
  scale <0.36, 0.36, 0.16>
  translate  -2.0*z
}
#declare alayer_railing4 = union {
  cylinder { // Cylndr145
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube37
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube38
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr146
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr147
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr148
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr149
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr150
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr151
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr152
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    railing
  }
  scale <0.38, 0.38, 0.08>
  translate  -2.0*z
}
#declare astory90 = union {
  object { alayer_glass4 }
  object { alayer_wall4 }
  object { alayer_railing4 }
  translate  2.0*z
}
#declare alayer_glass5 = union {
  cylinder { // Cylndr161
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube41
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube42
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr162
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr163
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr164
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr165
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr166
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr167
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr168
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    Cobalt_Blue_Glass
  }
  scale <0.34, 0.34, 0.16>
}
#declare alayer_wall5 = union {
  cylinder { // Cylndr169
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube43
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube44
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr170
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr171
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr172
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr173
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr174
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr175
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr176
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    Stainless_Steel
  }
  scale <0.34, 0.34, 0.16>
  translate  -2.0*z
}
#declare alayer_railing5 = union {
  cylinder { // Cylndr177
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube45
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube46
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr178
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr179
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr180
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr181
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr182
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr183
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr184
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    railing
  }
  scale <0.36, 0.36, 0.08>
  translate  -2.0*z
}
#declare astory166 = union {
  object { alayer_glass5 }
  object { alayer_wall5 }
  object { alayer_railing5 }
  scale <0.9, 0.9, 1.0>
  translate  250.0*z
}
#declare alayer_glass6 = union {
  cylinder { // Cylndr193
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube49
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube50
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr194
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr195
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr196
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr197
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr198
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr199
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr200
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    Cobalt_Blue_Glass
  }
  scale <0.34, 0.34, 0.16>
}
#declare alayer_wall6 = union {
  cylinder { // Cylndr201
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube51
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube52
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr202
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr203
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr204
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr205
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr206
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr207
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr208
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    Stainless_Steel
  }
  scale <0.34, 0.34, 0.16>
  translate  -2.0*z
}
#declare alayer_railing6 = union {
  cylinder { // Cylndr209
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube53
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube54
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr210
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr211
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr212
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr213
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr214
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr215
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr216
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    railing
  }
  scale <0.36, 0.36, 0.08>
  translate  -2.0*z
}
#declare astory175 = union {
  object { alayer_glass6 }
  object { alayer_wall6 }
  object { alayer_railing6 }
  scale <0.68, 0.68, 1.0>
  translate  320.0*z
}
#declare alayer_glass7 = union {
  cylinder { // Cylndr225
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube57
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube58
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr226
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr227
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr228
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr229
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr230
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr231
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr232
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    Cobalt_Blue_Glass
  }
  scale <0.34, 0.34, 0.16>
}
#declare alayer_wall7 = union {
  cylinder { // Cylndr233
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube59
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube60
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr234
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr235
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr236
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr237
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr238
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr239
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr240
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    Stainless_Steel
  }
  scale <0.34, 0.34, 0.16>
  translate  -2.0*z
}
#declare alayer_railing7 = union {
  cylinder { // Cylndr241
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube61
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube62
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr242
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr243
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr244
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr245
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr246
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr247
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr248
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    railing
  }
  scale <0.36, 0.36, 0.08>
  translate  -2.0*z
}
#declare astory179 = union {
  object { alayer_glass7 }
  object { alayer_wall7 }
  object { alayer_railing7 }
  scale <0.62, 0.62, 1.0>
  translate  360.0*z
}
#declare Cube76 = object {
  box { // Cube76
    <-1, -1, -1>, <1, 1, 1>
    scale <7.0, 7.0, 0.2>
    translate  <500.0, 0.0, 0.75>
  }
}
#declare Cube82 = object {
  box { // Cube82
    <-1, -1, -1>, <1, 1, 1>
    scale <7.0, 7.0, 0.2>
    translate  <500.067374, 0.0, -0.597488>
  }
}




//
// ********  OBJECTS  *******
//





#declare CSG001 = union {
  object { Cube002 }
  object { // Cube65->Cube002
    Cube002
    translate  1.0*z
  }
  object { // Cube66->Cube002
    Cube002
    translate  2.0*z
  }
  object { // Cube67->Cube002
    Cube002
    translate  3.0*z
  }
  object { // Cube68->Cube002
    Cube002
    translate  4.0*z
  }
  object { // Cube69->Cube002
    Cube002
    translate  5.0*z
  }
  object { Cube70 }
  object { // Cube71->Cube70
    Cube70
    rotate -0.0*y
    translate  <0.0, 0.0, -1.0>
  }
  object { // Cube72->Cube70
    Cube70
    rotate -0.0*y
    translate  <0.0, 0.0, -2.0>
  }
  object { // Cube73->Cube70
    Cube70
    rotate -0.0*y
    translate  <0.0, 0.0, -3.0>
  }
  object { // Cube74->Cube70
    Cube70
    rotate -0.0*y
    translate  <0.0, 0.0, -4.0>
  }
  object { // Cube75->Cube70
    Cube70
    rotate -0.0*y
    translate  <0.0, 0.0, -5.0>
  }
}
#declare Skyball1 = difference {
  sphere { // Sphere001
    <0,0,0>,1
    scale 7.0
    translate  500.0*x
  }
  object { CSG001 }
  sphere { // Sphere5
    <0,0,0>,1
    scale 7.0
    translate  500.0*x
  }
  texture {
    Stainless_Steel
  }
  scale 0.75
  translate  <125.0, 0.0, 10.0>
}
#declare mast1 = union {
  sphere { // Sphere002
    <0,0,0>,1
    scale 0.75
    translate  <500.0, -0.007219, 39.492781>
  }
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.5, 1.5, 20.0>
    rotate 180.0*x
    translate  <500.0, 0.0, 40.0>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1
    scale <1.5, 1.5, 30.0>
    translate  <500.0, 0.0, -10.0>
  }
  object { Skyball1 }
  texture {
    Stainless_Steel
  }
  translate  <-500.0, 0.0, 409.0>
}
#declare chunk1 = union {
  object { astory }
  object { // astory1->astory
    astory
    translate  4.0*z
  }
  object { // astory58->astory
    astory
    translate  232.0*z
  }
  object { // astory59->astory
    astory
    translate  236.0*z
  }
  object { // astory57->astory
    astory
    translate  228.0*z
  }
  object { // astory56->astory
    astory
    translate  224.0*z
  }
  object { // astory55->astory
    astory
    translate  220.0*z
  }
  object { // astory54->astory
    astory
    translate  216.0*z
  }
  object { // astory53->astory
    astory
    translate  212.0*z
  }
  object { // astory52->astory
    astory
    translate  208.0*z
  }
  object { // astory51->astory
    astory
    translate  204.0*z
  }
  object { // astory50->astory
    astory
    translate  200.0*z
  }
  object { // astory49->astory
    astory
    translate  196.0*z
  }
  object { // astory48->astory
    astory
    translate  192.0*z
  }
  object { // astory47->astory
    astory
    translate  188.0*z
  }
  object { // astory46->astory
    astory
    translate  184.0*z
  }
  object { // astory45->astory
    astory
    translate  180.0*z
  }
  object { // astory44->astory
    astory
    translate  176.0*z
  }
  object { // astory43->astory
    astory
    translate  172.0*z
  }
  object { // astory42->astory
    astory
    translate  168.0*z
  }
  object { // astory41->astory
    astory
    translate  164.0*z
  }
  object { // astory40->astory
    astory
    translate  160.0*z
  }
  object { // astory39->astory
    astory
    translate  156.0*z
  }
  object { // astory38->astory
    astory
    translate  152.0*z
  }
  object { // astory37->astory
    astory
    translate  148.0*z
  }
  object { // astory36->astory
    astory
    translate  144.0*z
  }
  object { // astory35->astory
    astory
    translate  140.0*z
  }
  object { // astory34->astory
    astory
    translate  136.0*z
  }
  object { // astory33->astory
    astory
    translate  132.0*z
  }
  object { // astory32->astory
    astory
    translate  128.0*z
  }
  object { // astory31->astory
    astory
    translate  124.0*z
  }
  object { // astory30->astory
    astory
    translate  120.0*z
  }
  object { // astory29->astory
    astory
    translate  116.0*z
  }
  object { // astory28->astory
    astory
    translate  112.0*z
  }
  object { // astory27->astory
    astory
    translate  108.0*z
  }
  object { // astory26->astory
    astory
    translate  104.0*z
  }
  object { // astory25->astory
    astory
    translate  100.0*z
  }
  object { // astory24->astory
    astory
    translate  96.0*z
  }
  object { // astory23->astory
    astory
    translate  92.0*z
  }
  object { // astory22->astory
    astory
    translate  88.0*z
  }
  object { // astory21->astory
    astory
    translate  84.0*z
  }
  object { // astory20->astory
    astory
    translate  80.0*z
  }
  object { // astory19->astory
    astory
    translate  76.0*z
  }
  object { // astory18->astory
    astory
    translate  72.0*z
  }
  object { // astory17->astory
    astory
    translate  68.0*z
  }
  object { // astory16->astory
    astory
    translate  64.0*z
  }
  object { // astory15->astory
    astory
    translate  60.0*z
  }
  object { // astory14->astory
    astory
    translate  56.0*z
  }
  object { // astory13->astory
    astory
    translate  52.0*z
  }
  object { // astory12->astory
    astory
    translate  48.0*z
  }
  object { // astory11->astory
    astory
    translate  44.0*z
  }
  object { // astory10->astory
    astory
    translate  40.0*z
  }
  object { // astory9->astory
    astory
    translate  36.0*z
  }
  object { // astory8->astory
    astory
    translate  32.0*z
  }
  object { // astory7->astory
    astory
    translate  28.0*z
  }
  object { // astory6->astory
    astory
    translate  24.0*z
  }
  object { // astory5->astory
    astory
    translate  20.0*z
  }
  object { // astory4->astory
    astory
    translate  16.0*z
  }
  object { // astory3->astory
    astory
    translate  12.0*z
  }
  object { // astory2->astory
    astory
    translate  8.0*z
  }
  texture {
    Stainless_Steel
  }
}
#declare caplayer = union {
  cylinder { // Cylndr97
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube25
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube26
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr98
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr99
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr100
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr101
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr102
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr103
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr104
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    caplayertexture
  }
  scale <0.36, 0.36, 0.32>
  translate  240.0*z
}
#declare Chunk2 = union {
  object { // astory76->astory60
    astory60
    translate  64.0*z
  }
  object { // astory75->astory60
    astory60
    translate  60.0*z
  }
  object { // astory74->astory60
    astory60
    translate  56.0*z
  }
  object { // astory73->astory60
    astory60
    translate  52.0*z
  }
  object { // astory72->astory60
    astory60
    translate  48.0*z
  }
  object { // astory71->astory60
    astory60
    translate  44.0*z
  }
  object { // astory70->astory60
    astory60
    translate  40.0*z
  }
  object { // astory69->astory60
    astory60
    translate  36.0*z
  }
  object { // astory68->astory60
    astory60
    translate  32.0*z
  }
  object { // astory67->astory60
    astory60
    translate  28.0*z
  }
  object { // astory66->astory60
    astory60
    translate  24.0*z
  }
  object { // astory65->astory60
    astory60
    translate  20.0*z
  }
  object { // astory64->astory60
    astory60
    translate  16.0*z
  }
  object { // astory63->astory60
    astory60
    translate  12.0*z
  }
  object { // astory62->astory60
    astory60
    translate  8.0*z
  }
  object { // astory61->astory60
    astory60
    translate  4.0*z
  }
  object { astory60 }
  translate  -4.0*z
}
#declare caplayer2 = union {
  cylinder { // Cylndr105
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube27
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube28
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr106
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr107
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr108
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr109
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr110
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr111
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr112
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    caplayertexture
  }
  scale <0.31, 0.31, 0.16>
  translate  312.0*z
}
#declare Chunk3 = union {
  object { // astory85->astory77
    astory77
    translate  32.0*z
  }
  object { // astory84->astory77
    astory77
    translate  28.0*z
  }
  object { // astory83->astory77
    astory77
    translate  24.0*z
  }
  object { // astory82->astory77
    astory77
    translate  20.0*z
  }
  object { // astory81->astory77
    astory77
    translate  16.0*z
  }
  object { // astory80->astory77
    astory77
    translate  12.0*z
  }
  object { // astory79->astory77
    astory77
    translate  8.0*z
  }
  object { // astory78->astory77
    astory77
    translate  4.0*z
  }
  object { astory77 }
  translate  -4.0*z
}
#declare caplayer3 = union {
  cylinder { // Cylndr113
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube29
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube30
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr114
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr115
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr116
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr117
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr118
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr119
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr120
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    caplayertexture
  }
  scale <0.23, 0.23, 0.16>
  translate  350.0*z
}
#declare Chunk4 = union {
  object { // astory89->astory86
    astory86
    translate  12.0*z
  }
  object { // astory88->astory86
    astory86
    translate  8.0*z
  }
  object { // astory87->astory86
    astory86
    translate  4.0*z
  }
  object { astory86 }
  translate  -6.0*z
}
#declare caplayer4 = union {
  cylinder { // Cylndr121
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube31
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube32
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr122
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr123
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr124
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr125
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr126
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr127
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr128
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    caplayertexture
  }
  scale <0.21, 0.21, 0.16>
  translate  368.0*z
}
#declare tower1 = union {
  object { chunk1 }
  object { caplayer }
  object { Chunk2 }
  object { caplayer2 }
  object { Chunk3 }
  object { caplayer3 }
  object { Chunk4 }
  object { caplayer4 }
}
#declare chunk2 = union {
  object { astory90 }
  object { // astory91->astory90
    astory90
    translate  4.0*z
  }
  object { // astory92->astory90
    astory90
    translate  232.0*z
  }
  object { // astory93->astory90
    astory90
    translate  236.0*z
  }
  object { // astory94->astory90
    astory90
    translate  228.0*z
  }
  object { // astory95->astory90
    astory90
    translate  224.0*z
  }
  object { // astory96->astory90
    astory90
    translate  220.0*z
  }
  object { // astory97->astory90
    astory90
    translate  216.0*z
  }
  object { // astory98->astory90
    astory90
    translate  212.0*z
  }
  object { // astory99->astory90
    astory90
    translate  208.0*z
  }
  object { // astory100->astory90
    astory90
    translate  204.0*z
  }
  object { // astory101->astory90
    astory90
    translate  200.0*z
  }
  object { // astory102->astory90
    astory90
    translate  196.0*z
  }
  object { // astory103->astory90
    astory90
    translate  192.0*z
  }
  object { // astory104->astory90
    astory90
    translate  188.0*z
  }
  object { // astory105->astory90
    astory90
    translate  184.0*z
  }
  object { // astory106->astory90
    astory90
    translate  180.0*z
  }
  object { // astory107->astory90
    astory90
    translate  176.0*z
  }
  object { // astory108->astory90
    astory90
    translate  172.0*z
  }
  object { // astory109->astory90
    astory90
    translate  168.0*z
  }
  object { // astory110->astory90
    astory90
    translate  164.0*z
  }
  object { // astory111->astory90
    astory90
    translate  160.0*z
  }
  object { // astory112->astory90
    astory90
    translate  156.0*z
  }
  object { // astory113->astory90
    astory90
    translate  152.0*z
  }
  object { // astory114->astory90
    astory90
    translate  148.0*z
  }
  object { // astory115->astory90
    astory90
    translate  144.0*z
  }
  object { // astory116->astory90
    astory90
    translate  140.0*z
  }
  object { // astory117->astory90
    astory90
    translate  136.0*z
  }
  object { // astory118->astory90
    astory90
    translate  132.0*z
  }
  object { // astory119->astory90
    astory90
    translate  128.0*z
  }
  object { // astory120->astory90
    astory90
    translate  124.0*z
  }
  object { // astory121->astory90
    astory90
    translate  120.0*z
  }
  object { // astory122->astory90
    astory90
    translate  116.0*z
  }
  object { // astory123->astory90
    astory90
    translate  112.0*z
  }
  object { // astory124->astory90
    astory90
    translate  108.0*z
  }
  object { // astory125->astory90
    astory90
    translate  104.0*z
  }
  object { // astory126->astory90
    astory90
    translate  100.0*z
  }
  object { // astory127->astory90
    astory90
    translate  96.0*z
  }
  object { // astory128->astory90
    astory90
    translate  92.0*z
  }
  object { // astory129->astory90
    astory90
    translate  88.0*z
  }
  object { // astory130->astory90
    astory90
    translate  84.0*z
  }
  object { // astory131->astory90
    astory90
    translate  80.0*z
  }
  object { // astory132->astory90
    astory90
    translate  76.0*z
  }
  object { // astory133->astory90
    astory90
    translate  72.0*z
  }
  object { // astory134->astory90
    astory90
    translate  68.0*z
  }
  object { // astory135->astory90
    astory90
    translate  64.0*z
  }
  object { // astory136->astory90
    astory90
    translate  60.0*z
  }
  object { // astory137->astory90
    astory90
    translate  56.0*z
  }
  object { // astory138->astory90
    astory90
    translate  52.0*z
  }
  object { // astory139->astory90
    astory90
    translate  48.0*z
  }
  object { // astory140->astory90
    astory90
    translate  44.0*z
  }
  object { // astory141->astory90
    astory90
    translate  40.0*z
  }
  object { // astory142->astory90
    astory90
    translate  36.0*z
  }
  object { // astory143->astory90
    astory90
    translate  32.0*z
  }
  object { // astory144->astory90
    astory90
    translate  28.0*z
  }
  object { // astory145->astory90
    astory90
    translate  24.0*z
  }
  object { // astory146->astory90
    astory90
    translate  20.0*z
  }
  object { // astory147->astory90
    astory90
    translate  16.0*z
  }
  object { // astory148->astory90
    astory90
    translate  12.0*z
  }
  object { // astory149->astory90
    astory90
    translate  8.0*z
  }
  texture {
    Stainless_Steel
  }
}
#declare caplayer1 = union {
  cylinder { // Cylndr153
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube39
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube40
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr154
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr155
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr156
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr157
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr158
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr159
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr160
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    caplayertexture
  }
  scale <0.36, 0.36, 0.32>
  translate  240.0*z
}
#declare Chunk5 = union {
  object { // astory150->astory166
    astory166
    translate  64.0*z
  }
  object { // astory151->astory166
    astory166
    translate  60.0*z
  }
  object { // astory152->astory166
    astory166
    translate  56.0*z
  }
  object { // astory153->astory166
    astory166
    translate  52.0*z
  }
  object { // astory154->astory166
    astory166
    translate  48.0*z
  }
  object { // astory155->astory166
    astory166
    translate  44.0*z
  }
  object { // astory156->astory166
    astory166
    translate  40.0*z
  }
  object { // astory157->astory166
    astory166
    translate  36.0*z
  }
  object { // astory158->astory166
    astory166
    translate  32.0*z
  }
  object { // astory159->astory166
    astory166
    translate  28.0*z
  }
  object { // astory160->astory166
    astory166
    translate  24.0*z
  }
  object { // astory161->astory166
    astory166
    translate  20.0*z
  }
  object { // astory162->astory166
    astory166
    translate  16.0*z
  }
  object { // astory163->astory166
    astory166
    translate  12.0*z
  }
  object { // astory164->astory166
    astory166
    translate  8.0*z
  }
  object { // astory165->astory166
    astory166
    translate  4.0*z
  }
  object { astory166 }
  translate  -4.0*z
}
#declare caplayer5 = union {
  cylinder { // Cylndr185
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube47
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube48
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr186
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr187
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr188
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr189
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr190
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr191
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr192
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    caplayertexture
  }
  scale <0.31, 0.31, 0.16>
  translate  312.0*z
}
#declare Chunk6 = union {
  object { // astory167->astory175
    astory175
    translate  32.0*z
  }
  object { // astory168->astory175
    astory175
    translate  28.0*z
  }
  object { // astory169->astory175
    astory175
    translate  24.0*z
  }
  object { // astory170->astory175
    astory175
    translate  20.0*z
  }
  object { // astory171->astory175
    astory175
    translate  16.0*z
  }
  object { // astory172->astory175
    astory175
    translate  12.0*z
  }
  object { // astory173->astory175
    astory175
    translate  8.0*z
  }
  object { // astory174->astory175
    astory175
    translate  4.0*z
  }
  object { astory175 }
  translate  -4.0*z
}
#declare caplayer6 = union {
  cylinder { // Cylndr217
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube55
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube56
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr218
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr219
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr220
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr221
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr222
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr223
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr224
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    caplayertexture
  }
  scale <0.23, 0.23, 0.16>
  translate  350.0*z
}
#declare Chunk7 = union {
  object { // astory176->astory179
    astory179
    translate  12.0*z
  }
  object { // astory177->astory179
    astory179
    translate  8.0*z
  }
  object { // astory178->astory179
    astory179
    translate  4.0*z
  }
  object { astory179 }
  translate  -6.0*z
}
#declare caplayer7 = union {
  cylinder { // Cylndr249
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-20.417521, 49.682634, 0.0>
  }
  box { // Cube63
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    translate  6.0*z
  }
  box { // Cube64
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 50.0, 6.0>
    rotate -45.0*z
    translate  6.0*z
  }
  cylinder { // Cylndr250
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, 23.139857, 0.0>
  }
  cylinder { // Cylndr251
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <21.098105, 50.363218, 0.0>
  }
  cylinder { // Cylndr252
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, -21.778689, 0.0>
  }
  cylinder { // Cylndr253
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <49.682634, 21.778689, 0.0>
  }
  cylinder { // Cylndr254
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-49.682634, -23.139857, 0.0>
  }
  cylinder { // Cylndr255
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <-22.459273, -51.043802, 0.0>
  }
  cylinder { // Cylndr256
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 12.0>
    translate  <19.736937, -51.043802, 0.0>
  }
  texture {
    caplayertexture
  }
  scale <0.21, 0.21, 0.16>
  translate  368.0*z
}
#declare tower2 = union {
  object { chunk2 }
  object { caplayer1 }
  object { Chunk5 }
  object { caplayer5 }
  object { Chunk6 }
  object { caplayer6 }
  object { Chunk7 }
  object { caplayer7 }
  translate  100.0*y
}
#declare CSG2 = union {
  object { Cube76 }
  object { // Cube77->Cube76
    Cube76
    translate  1.0*z
  }
  object { // Cube78->Cube76
    Cube76
    translate  2.0*z
  }
  object { // Cube79->Cube76
    Cube76
    translate  3.0*z
  }
  object { // Cube80->Cube76
    Cube76
    translate  4.0*z
  }
  object { // Cube81->Cube76
    Cube76
    translate  5.0*z
  }
  object { Cube82 }
  object { // Cube83->Cube82
    Cube82
    rotate -0.0*y
    translate  <0.0, 0.0, -1.0>
  }
  object { // Cube84->Cube82
    Cube82
    rotate -0.0*y
    translate  <0.0, 0.0, -2.0>
  }
  object { // Cube85->Cube82
    Cube82
    rotate -0.0*y
    translate  <0.0, 0.0, -3.0>
  }
  object { // Cube86->Cube82
    Cube82
    rotate -0.0*y
    translate  <0.0, 0.0, -4.0>
  }
  object { // Cube87->Cube82
    Cube82
    rotate -0.0*y
    translate  <0.0, 0.0, -5.0>
  }
}
#declare Skyball2 = difference {
  sphere { // Sphere2
    <0,0,0>,1
    scale 7.0
    translate  500.0*x
  }
  object { CSG2 }
  sphere { // Sphere4
    <0,0,0>,1
    scale 7.0
    translate  500.0*x
  }
  texture {
    Stainless_Steel
  }
  scale 0.7
  translate  <150.0, 0.0, 10.0>
}
#declare mast2 = union {
  sphere { // Sphere3
    <0,0,0>,1
    scale 0.75
    translate  <500.0, 0.0, 39.5>
  }
  cone { // Cone2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.5, 1.5, 20.0>
    rotate 180.0*x
    translate  <500.0, 0.0, 40.0>
  }
  cylinder { // Cylndr257
    <0,0,1>, <0,0,0>, 1
    scale <1.5, 1.5, 30.0>
    translate  <500.0, 0.0, -10.0>
  }
  object { Skyball2 }
  texture {
    Stainless_Steel
  }
  translate  <-500.0, 100.0, 409.0>
}
#declare squares_2 = union {
  box { // Cube89
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 5.0>
    rotate <-10.0, -10.0, -45.0>
    translate  <-0.0, -2.828427, 0.0>
  }
  box { // Cube90
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 5.0>
    rotate <10.0, 10.0, -45.0>
    translate  <0.0, 2.828427, 0.0>
  }
  box { // Cube91
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 5.0>
    rotate <-10.0, 10.0, -45.0>
    translate  <-2.828427, 0.0, 0.0>
  }
  box { // Cube92
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 5.0>
    rotate <10.0, -10.0, -45.0>
    translate  <2.828427, -0.0, 0.0>
  }
}
#declare squares_1 = union {
  box { // Cube93
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 5.0>
    rotate <-10.0, -10.0, 0.0>
    translate  <2.0, -2.0, 0.0>
  }
  box { // Cube94
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 5.0>
    rotate <10.0, 10.0, 0.0>
    translate  <-2.0, 2.0, 0.0>
  }
  box { // Cube95
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 5.0>
    rotate <-10.0, 10.0, 0.0>
    translate  <-2.0, -2.0, 0.0>
  }
  box { // Cube96
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 5.0>
    rotate <10.0, -10.0, 0.0>
    translate  <2.0, 2.0, 0.0>
  }
}
#declare circles_1 = union {
  cylinder { // Cylndr258
    <0,0,1>, <0,0,0>, 1
    scale <-1.0, -1.0, -10.0>
    rotate <-10.0, -10.0, 157.702332>
    translate  <-0.541196, 1.306563, 5.0>
  }
  cylinder { // Cylndr259
    <0,0,1>, <0,0,0>, 1
    scale <-1.0, -1.0, -10.0>
    rotate <10.0, 10.0, 157.702332>
    translate  <0.541196, -1.306563, 5.0>
  }
  cylinder { // Cylndr260
    <0,0,1>, <0,0,0>, 1
    scale <-1.0, -1.0, -10.0>
    rotate <10.0, -10.0, 157.702332>
    translate  <-1.306563, -0.541196, 5.0>
  }
  cylinder { // Cylndr261
    <0,0,1>, <0,0,0>, 1
    scale <-1.0, -1.0, -10.0>
    rotate <-10.0, 10.0, 157.702332>
    translate  <1.306563, 0.541196, 5.0>
  }
}
#declare circles_2 = union {
  cylinder { // Cylndr262
    <0,0,1>, <0,0,0>, 1
    scale <-1.0, -1.0, -10.0>
    rotate <-10.0, -10.0, -157.297668>
    translate  <-1.306563, 0.541196, 5.0>
  }
  cylinder { // Cylndr263
    <0,0,1>, <0,0,0>, 1
    scale <-1.0, -1.0, -10.0>
    rotate <10.0, 10.0, -157.297668>
    translate  <1.306563, -0.541196, 5.0>
  }
  cylinder { // Cylndr264
    <0,0,1>, <0,0,0>, 1
    scale <-1.0, -1.0, -10.0>
    rotate <10.0, -10.0, -157.297668>
    translate  <-0.541196, -1.306563, 5.0>
  }
  cylinder { // Cylndr265
    <0,0,1>, <0,0,0>, 1
    scale <-1.0, -1.0, -10.0>
    rotate <-10.0, 10.0, -157.297668>
    translate  <0.541196, 1.306563, 5.0>
  }
}
#declare taper_stuff = union {
  object { squares_2 }
  object { squares_1 }
  object { circles_1 }
  object { circles_2 }
  cone { // plug
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <-3.8, -3.8, -12.447523>
    rotate -180.0*z
    translate  7.338156*z
  }
  texture {
    Stainless_Steel
  }
}
#declare trim_taper2 = intersection {
  box { // Cube88
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Plane_Grey
    }
    scale <6.655837, 6.358325, 3.608601>
    translate  <-0.096615, 0.0, -0.096615>
  }
  object { taper_stuff }
  texture {
    Stainless_Steel
  }
  scale <2.9, 2.9, 4.35>
  translate  385.0*z
}
#declare squares_3 = union {
  box { // Cube98
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 5.0>
    rotate <-10.0, -10.0, -45.0>
    translate  <-0.0, -2.828427, 0.0>
  }
  box { // Cube99
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 5.0>
    rotate <10.0, 10.0, -45.0>
    translate  <0.0, 2.828427, 0.0>
  }
  box { // Cube100
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 5.0>
    rotate <-10.0, 10.0, -45.0>
    translate  <-2.828427, 0.0, 0.0>
  }
  box { // Cube101
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 5.0>
    rotate <10.0, -10.0, -45.0>
    translate  <2.828427, -0.0, 0.0>
  }
}
#declare squares_4 = union {
  box { // Cube102
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 5.0>
    rotate <-10.0, -10.0, 0.0>
    translate  <2.0, -2.0, 0.0>
  }
  box { // Cube103
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 5.0>
    rotate <10.0, 10.0, 0.0>
    translate  <-2.0, 2.0, 0.0>
  }
  box { // Cube104
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 5.0>
    rotate <-10.0, 10.0, 0.0>
    translate  <-2.0, -2.0, 0.0>
  }
  box { // Cube105
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 5.0>
    rotate <10.0, -10.0, 0.0>
    translate  <2.0, 2.0, 0.0>
  }
}
#declare circles_3 = union {
  cylinder { // Cylndr266
    <0,0,1>, <0,0,0>, 1
    scale <-1.0, -1.0, -10.0>
    rotate <-10.0, -10.0, 157.702332>
    translate  <-0.541196, 1.306563, 5.0>
  }
  cylinder { // Cylndr267
    <0,0,1>, <0,0,0>, 1
    scale <-1.0, -1.0, -10.0>
    rotate <10.0, 10.0, 157.702332>
    translate  <0.541196, -1.306563, 5.0>
  }
  cylinder { // Cylndr268
    <0,0,1>, <0,0,0>, 1
    scale <-1.0, -1.0, -10.0>
    rotate <10.0, -10.0, 157.702332>
    translate  <-1.306563, -0.541196, 5.0>
  }
  cylinder { // Cylndr269
    <0,0,1>, <0,0,0>, 1
    scale <-1.0, -1.0, -10.0>
    rotate <-10.0, 10.0, 157.702332>
    translate  <1.306563, 0.541196, 5.0>
  }
}
#declare circles_4 = union {
  cylinder { // Cylndr270
    <0,0,1>, <0,0,0>, 1
    scale <-1.0, -1.0, -10.0>
    rotate <-10.0, -10.0, -157.297668>
    translate  <-1.306563, 0.541196, 5.0>
  }
  cylinder { // Cylndr271
    <0,0,1>, <0,0,0>, 1
    scale <-1.0, -1.0, -10.0>
    rotate <10.0, 10.0, -157.297668>
    translate  <1.306563, -0.541196, 5.0>
  }
  cylinder { // Cylndr272
    <0,0,1>, <0,0,0>, 1
    scale <-1.0, -1.0, -10.0>
    rotate <10.0, -10.0, -157.297668>
    translate  <-0.541196, -1.306563, 5.0>
  }
  cylinder { // Cylndr273
    <0,0,1>, <0,0,0>, 1
    scale <-1.0, -1.0, -10.0>
    rotate <-10.0, 10.0, -157.297668>
    translate  <0.541196, 1.306563, 5.0>
  }
}
#declare taper_stuff1 = union {
  object { squares_3 }
  object { squares_4 }
  object { circles_3 }
  object { circles_4 }
  cone { // plug1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <-3.8, -3.8, -12.447523>
    rotate -180.0*z
    translate  7.338156*z
  }
  texture {
    Stainless_Steel
  }
}
#declare trim_taper1 = intersection {
  box { // Cube97
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Plane_Grey
    }
    scale <6.655837, 6.358325, 3.608601>
    translate  <-0.096615, 0.0, -0.096615>
  }
  object { taper_stuff1 }
  texture {
    Stainless_Steel
  }
  scale <2.9, 2.9, 4.35>
  translate  <0.0, 100.0, 385.0>
}
union { // Buildings
  cylinder { // brace1
    <0,0,1>, <0,0,0>, 1
    texture {
      Stainless_Steel
    }
    scale <1.5, 1.5, 40.0>
    rotate -45.0*x
    translate  <0.0, 22.0, 134.0>
  }
  box { // skywalk
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stainless_Steel
    }
    scale <6.0, 50.0, 6.0>
    translate  <0.0, 46.521039, 170.0>
  }
  object { mast1 }
  object { tower1 }
  object { tower2 }
  object { mast2 }
  cylinder { // brace2
    <0,0,1>, <0,0,0>, 1
    texture {
      Stainless_Steel
    }
    scale <1.5, 1.5, 40.0>
    rotate 45.0*x
    translate  <0.0, 78.0, 134.0>
  }
  object { trim_taper2 }
  object { trim_taper1 }
  box { // skywalk_roof_peak
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stainless_Steel
    }
    scale <2.5, 50.0, 6.5>
    translate  <0.0, 46.521039, 175.0>
  }
}




difference { // CSG002
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale 20000.0
//    translate  <1732.484076, 0.0, -13667.374381>
      translate  <1732.484076, 0.0, -17000 >
     }
  sphere { // Sphere003
    <0,0,0>,1
    scale 20000.0
    translate  20000.0*z
  }
  texture {
        ground
  }
}
