// Persistence of Vision Ray Tracer Scene Description File
// File:inc
// Vers: 3.1
// Desc: apartment building
// Date: 04/18/00
// Auth: Teri Hoskins
//

#version 3.1;

#include "colors.inc"  
#include "column.inc" 
#include "streetlight.inc"

global_settings
{
  assumed_gamma 1.0
}   

//--------------TEXTURES------------------------     
  
// >>> Grnt17 (from file "stoneold.inc", line 39) <<<

// Constants from file "stones1.inc"
#declare T_Grnt17 = texture {
  pigment {
    granite
    turbulence 0.6
    color_map {
      [0.000, 0.303 color rgbf <0.000, 0.239, 0.000, 0.000>
      color rgbf <0.333, 0.294, 0.000, 0.000>]
      [0.303, 0.588 color rgbf <0.333, 0.294, 0.000, 0.000>
      color rgbf <0.000, 0.239, 0.341, 0.000>]
      [0.588, 0.790 color rgbf <0.000, 0.239, 0.341, 0.000>
      color rgbf <0.000, 0.020, 0.000, 0.000>]
      [0.790, 1.001 color rgbf <0.000, 0.020, 0.000, 0.000>
      color rgbf <0.000, 0.239, 0.000, 0.000>]
    }
  }
}

#declare Grnt17 = texture {
  T_Grnt17 
}

// >>> NurseryGlass (from file "sjvtextr.inc", line 49) <<<

// Constants from file "colors.inc"
#declare White = rgb 1;

// Constants from file "textures.inc"
#declare Glass_Finish = finish {
  specular 1
  roughness 0.001
  ambient 0
  diffuse 0
  reflection 0.1
  ior 1.5
}

#declare NurseryGlass_Blue = texture {
  pigment {
    color Blue filter 0.75 
  }
  finish {
    Glass_Finish 
  }
}  

// >>> Black_Dull (from file "povlab.inc", line 1130) <<<
#declare Black_Dull = texture {
  pigment {
    color rgb <0, 0, 0> 
  }
  finish {
    phong 0.2 
  }
}

// >>> AberGrPP (from file "povlab.inc", line 5588) <<<
#declare AberGrPP = texture {
  pigment {
    granite
    turbulence 0.70
    color_map {
      [0.00 color rgb<0.20, 0.20, 0.20>]
      [0.31 color rgb<0.57, 0.53, 0.51>]
      [1.00 color rgb<0.77, 0.66, 0.64>]
    }
  }
  normal {
    bumps 0.10
    scale <0.20, 0.20, 0.20>
  }
  finish {
    ambient 0.50
    diffuse 1.00
    specular 0.50
    roughness 0.01
    metallic
    reflection 0.11
    crand 0.250
  }
}
texture {
  pigment {
    colour rgbf<1.00, 1.00, 1.00, 1.00>
  }
  finish {
    ambient 0.50
    brilliance 1.50
    //phong 0.90
    //phong_size 80
  }
}

// >>> Sunny_Cloud_Sky (from file "povlab.inc", line 5211) <<<
#declare Sunny_Cloud_Sky = texture {
  pigment {
    bozo
    turbulence 0.5
    octaves 3 
    lambda 6 
    color_map {
      [0.0 0.1 color rgb <2/3, 2/3, 1>
      color rgb <2/3, 2/3, 1> ]
      [1.0 color rgb <1, 1, 1,> ]
    }
  }
  finish {
    ambient 1 diffuse 0 
  }
  scale <0.1666,0.1666,0.1666> 
}


//-----------------SCENE------------------
//------------------REGULAR SIDE WALL CONSTRUCTION   30x12x0.05 ------------------
   
#declare wall=
box{<0,0,0><1,1,0> texture{pigment{image_map{png "forest.png" once}}}scale<30,12,1>}

#declare r_s_wall1=difference{
object{wall}
box{<0,0,0><3,4,0.2> texture{Grnt17 } translate<6,4,-0.1>} 
box{<0,0,0><3,4,0.2> texture{Grnt17 } translate<11,4,-0.1>}
box{<0,0,0><3,4,0.2> texture{Grnt17 } translate<20,4,-0.1>}
box{<0,0,0><3,4,0.2> texture{Grnt17 } translate<25,4,-0.1>}
box{<0,0,0><2,2,0.2> texture{Grnt17 } translate<16,7,-0.1>} }

 //object{r_s_wall1}   

//---------------SMALL WINDOW SASH------------
#declare sash1=difference{
box{<0,0,0><2,0.1,0.2>texture{ Grnt17 }}
box{<0,0,0><0.5,0.5,0.5> texture{ Grnt17 }rotate<0,0,45>translate<0,0,-0.25>}  
box{<0,0,0><0.5,0.5,0.5> texture{ Grnt17 }rotate<0,0,45>translate<2.0,0,-0.25>} }

#declare s_w_sash=union{
object{sash1}
object{sash1 rotate<0,0,90>translate<1.99,0,0>}
object{sash1 rotate<0,0,-90>translate<0,1.99,0>}
object{sash1 rotate<0,0,180>translate<1.99,2,0>}
box{<0,0,0><2.2,2.2,0.01>texture{NurseryGlass_Blue}translate<-0.1,-0.1,-0.05>}}  

//------------LARGE WINDOW SASHES---------------  

#declare sash_bar=difference{
box{<0,0,0><3,0.3,0.5>texture{Grnt17}}
cylinder{<0,0,0><3.5,0,0>, 0.15 texture{ Grnt17}translate<-0.25,0.0,0.0>}}

#declare l_w_sash=union{
object{s_w_sash scale<1.5,2,1>}
box{<0,0,0><3,0.1,0.8>texture{ Grnt17}translate<0,0.2,-0.3>} 
object{sash_bar translate<0,0,-0.3>}         
object{sash_bar rotate<0,180,0>translate<3,0,0.5>}
box{<0,0,0><2.8,0.1,0.2> texture{ Grnt17}translate<0.1,2,0>}//bar in middle of window  
box{<0,0,0><3.2,4.2,0.01>texture{NurseryGlass_Blue}translate<-0.1,-0.1,-0.05>}
}   

//-------------------REGULAR SIDE WALL AND WINDOW SASHES------------------

#declare r_s_wall=union{
object{r_s_wall1}
object{s_w_sash translate<16,7,-0.05>}
object{l_w_sash translate<6,4,-0.1>}  
object{l_w_sash translate<11,4,-0.1>} 
object{l_w_sash translate<20,4,-0.1>}
object{l_w_sash translate<25,4,-0.1>} }

//object{r_s_wall}


//------------------REGULAR PATIO---------------

#declare r_patio=union{
box{<0,0,0><8,0.1,0.1> texture{Black_Dull}translate<0,4,0>}//top rail 
box{<0,0,0><0.3,5,0.1> texture{Black_Dull}translate<-0.15,-0.9,4>} // back pole
box{<0,0,0><0.3,5,0.1> texture{Black_Dull}translate<7.85,-0.9,4>} // back pole 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}}//front left corner pole       
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<8,0,0>}//front right corner pole
box{<0,0,0><8,0.1,4> texture{Black_Dull}}//bottom 
box{<0,0,0><0.1,0.1,4> texture{Black_Dull}translate<0,4,0>}//top left side rail
box{<0,0,0><0.1,0.1,4> texture{Black_Dull}translate<8,4,0>}//top right side rail  
//box{<0,0,0><0.3,4.25,0.1> texture{Black_Dull}rotate<-77.5,0,0>translate<-0.15,-0.80,4.20>}// left support    
//box{<0,0,0><0.3,4.25,0.1> texture{Black_Dull}rotate<-77.5,0,0>translate<7.85,-0.80,4.20>}//right support
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,3.75>} //left rails  
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,3.5>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,3.25>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,3>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,2.75>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,2.5>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,2.25>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,2>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,1.75>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,1.5>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,1.25>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,1>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,0.75>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,0.5>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,0.25>}
 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<8,0,3.75>}//right rails   
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<8,0,3.5>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<8,0,3.25>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<8,0,3>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<8,0,2.75>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<8,0,2.5>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<8,0,2.25>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<8,0,2>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<8,0,1.75>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<8,0,1.5>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<8,0,1.25>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<8,0,1>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<8,0,0.75>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<8,0,0.5>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<8,0,0.25>}  
                                                       
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<7.75,0,0>} //front rails  
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<7.5,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<7.25,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<7,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<6.75,0,0>}  
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<6.5,0,0>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<6.25,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<6,0,0>}  
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<5.75,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<5.5,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<5.25,0,0>}        
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<5,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<4.75,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<4.5,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<4.25,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<4,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<3.75,0,0>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<3.5,0,0>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<3.25,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<3,0,0>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<2.75,0,0>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<2.5,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<2.25,0,0>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<2,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<1.75,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<1.5,0,0>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<1.25,0,0>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<1,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0.75,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0.5,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0.25,0,0>} }  

//------------------REGULAR FRONT WALL-------------------------

#declare r_f_wall1=difference{
object{wall}
box{<0,0,0><12,14,0.5>texture{Grnt17}translate<20,-1,-0.25>}
box{<0,0,0><6,8,0.5>texture{Grnt17}translate<2,2,-0.25>}
box{<0,0,0><6,4,0.5>texture{Grnt17}translate<12,5,-0.25>}} 

#declare r_f_wall=union{
object{r_f_wall1}   
object{s_w_sash scale<1.5,4,1> translate<2,2,-0.01>}  
object{s_w_sash scale<1.5,4,1> translate<5,2,-0.01>}
object{s_w_sash scale<3,2,1> translate<12,5,-0.01>}
object{r_patio translate<1,2,-4.1>}}

//object{r_f_wall}    

//---------------COLUMNS FOR POSH APARTMENT FRONT-------------
#declare column1=object{column texture{Grnt17}}


#declare small_corner_column=difference{   
object{column texture{Grnt17}}
box{<0,0,0><8,8.5,8> texture{Grnt17}translate<0,-0.25,-3>}
 }
//object{small_corner_column}    

//--------------PATIO RAILS FOR POSH APARTMENTS------------
 
#declare side_rails=union{
box{<0,0,0><0.1,0.1,4> texture{Black_Dull}translate<0,4,0>}//top left side rail                                                         
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}}//front left corner pole    
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<-0.15,0,4>} // back pole
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,3.75>} //left rails  
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,3.5>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,3.25>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,3>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,2.75>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,2.5>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,2.25>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,2>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,1.75>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,1.5>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,1.25>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,1>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,0.75>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,0.5>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0,0,0.25>} } 
                                                               

 
#declare front_rails=union{
box{<0,0,0><8,0.1,0.1> texture{Black_Dull}translate<0,4,0>}//top rail
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<7.75,0,0>} //front rails  
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<7.5,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<7.25,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<7,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<6.75,0,0>}  
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<6.5,0,0>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<6.25,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<6,0,0>}  
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<5.75,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<5.5,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<5.25,0,0>}        
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<5,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<4.75,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<4.5,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<4.25,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<4,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<3.75,0,0>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<3.5,0,0>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<3.25,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<3,0,0>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<2.75,0,0>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<2.5,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<2.25,0,0>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<2,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<1.75,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<1.5,0,0>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<1.25,0,0>} 
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<1,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0.75,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0.5,0,0>}
box{<0,0,0><0.1,4,0.1> texture{Black_Dull}translate<0.25,0,0>} }


//---------------FRONT WALL FOR POSH APARTMENTS------------

#declare posh_wall_part=difference{
object{wall}                                                            
box{<0,0,0><32,8,0.5>texture{Grnt17}translate<-1,2,-0.2>}}   

//----------INNER WALL AND WINDOWS FOR POSH APARTMENT----------

#declare p_inner=difference{
object{wall}
box{<0,0,0><6,4,0.5>texture{Grnt17}translate<2,4,-0.25>} 
box{<0,0,0><6,4,0.5>texture{Grnt17}translate<23.5,4,-0.25>} 
box{<0,0,0><12,8,0.5>texture{Grnt17}translate<10,2,-0.25>}}

#declare p_inner_wall=union{
object{p_inner}
object {s_w_sash scale<3,2,2> translate<2,4,-0.1>} 
object {s_w_sash scale<3,2,2> translate<23.5,4,-0.1>} 
object {s_w_sash scale<1.5,4,2> translate<10,2,-0.1>} 
object {s_w_sash scale<1.5,4,2> translate<13,2,-0.1>} 
object {s_w_sash scale<1.5,4,2> translate<16,2,-0.1>}
object {s_w_sash scale<1.5,4,2> translate<19,2,-0.1>}}

//object{p_inner_wall}          


//--------------FRONT WALL AND COLUMNS FOR POSH APARTMENTS ----------

#declare f_p_wall=union{
object{posh_wall_part scale<1,1,100>} 
object{small_corner_column rotate<0,180,0>translate<0,2,2>}
object{small_corner_column translate<29.75,2,2>}
object{column1 translate<8.5,2,2>}
object{column1 translate<15.5,2,2>}
object{column1 translate<22.5,2,2>} 
object{side_rails translate<1,2.0,3>}
object{side_rails translate<29,2.0,3>} 
object{front_rails translate<1,2,3>}
object{front_rails translate<9,2,3>}
object{front_rails translate<17,2,3>}   
object{front_rails translate<21,2,3>}
object{p_inner_wall translate<0,0,8>} }  
 
//object{f_p_wall} 


//----------------SIDE WALL FOR POSH APARTMENTS--------------

#declare side1=union{
object{wall}
object{wall translate<15,0,0>}}

#declare s_p_wall1=difference{
object{side1}
box{<0,0,0><4,6,0.5> texture{Grnt17} translate<6,3,-0.25>} 
box{<0,0,0><4,6,0.5> texture{Grnt17} translate<12,3,-0.25>} 
box{<0,0,0><4,6,0.5> texture{Grnt17} translate<18,3,-0.25>}
box{<0,0,0><4,6,0.5> texture{Grnt17} translate<24,3,-0.25>}
box{<0,0,0><4,6,0.5> texture{Grnt17} translate<30,3,-0.25>} 
box{<0,0,0><8.5,8,0.5>texture{Grnt17} translate<37,2,-0.25>} }   

//---------------SIDE WALL AND WINDOWS FOR POSH APARTMENT-------

#declare p_s_wall=union{
object{s_p_wall1} 
object{s_w_sash scale<2,3,2> translate<6,3,-0.1>}  
object{s_w_sash scale<2,3,2> translate<12,3,-0.1>} 
object{s_w_sash scale<2,3,2> translate<18,3,-0.1>}
object{s_w_sash scale<2,3,2> translate<24,3,-0.1>}
object{s_w_sash scale<2,3,2> translate<30,3,-0.1>}
 }   

//object{p_s_wall} 

//---------- FIRST APARTMENT FLOOR CONSTRUCTION-----------
#declare apart_floor1=union{ 
object{r_f_wall} 
object{r_f_wall translate<20,0,0>}  
object{r_f_wall translate<40,0,0>}
object{r_f_wall translate<60,0,0>}
object{r_f_wall translate<80,0,0>}
object{r_f_wall translate<100,0,0>} 
object{r_f_wall rotate<0,-180,0>translate<120,0,120>} 
object{r_f_wall rotate<0,-180,0>translate<20,0,120>}
object{r_f_wall rotate<0,-180,0>translate<40,0,120>}
object{r_f_wall rotate<0,-180,0>translate<60,0,120>}
object{r_f_wall rotate<0,-180,0>translate<80,0,120>}
object{r_f_wall rotate<0,-180,0>translate<100,0,120>} 
object{r_s_wall rotate<0,-90,0>}    
object{r_s_wall rotate<0,-90,0>translate<0,0,90>} 
object{r_s_wall rotate<0,-90,0>translate<120,0,0>} 
object{r_s_wall rotate<0,-90,0>translate<120,0,90>}
object{f_p_wall rotate<0,90,0>translate<0,0,60>}    
object{f_p_wall rotate<0,90,0>translate<0,0,90>}
object{f_p_wall rotate<0,-90,0>translate<120,0,30>}
object{f_p_wall rotate<0,-90,0>translate<120,0,60>}

}
//object{apart_floor1}

//-----------SECOND APARTMENT FLOOR CONSTRUCTION---------
#declare  apart_floor2=union{
object{f_p_wall}
object{f_p_wall translate<30,0,0>}
object{f_p_wall translate<60,0,0>}
object{f_p_wall translate<90,0,0>}
object{f_p_wall rotate<0,180,0> translate<30,0,120>}  
object{f_p_wall rotate<0,180,0> translate<60,0,120>}
object{f_p_wall rotate<0,180,0> translate<90,0,120>}
object{f_p_wall rotate<0,180,0> translate<120,0,120>}
object{f_p_wall rotate<0,90,0> translate<0,0,75>} 
object{f_p_wall rotate<0,-90,0> translate<120,0,45>}
object{p_s_wall rotate<0,-90,0>}   
object{p_s_wall rotate<0,-90,0> translate<0,0,75>}
object{p_s_wall rotate<0,-90,0> translate<120,0,0>}
object{p_s_wall rotate<0,-90,0>translate<120,0,75>}
}
//object{apart_floor2}    

//--------------------APARTMENT ROOF------------------
 
#declare top_wall=difference{
object{wall scale<1,1,20>}
box{<0,0,0><31,9,2> texture{Grnt17}translate<-0.5,4,-0.5>} 
box{<0,0,0><1.5,1,2> texture{Grnt17} translate<4.5,3,-0.51>}
box{<0,0,0><1.5,1,2> texture{Grnt17} translate<7.5,3,-0.51>}
box{<0,0,0><1.5,1,2> texture{Grnt17} translate<10.5,3,-0.51>}
box{<0,0,0><1.5,1,2> texture{Grnt17} translate<13.5,3,-0.51>}
box{<0,0,0><1.5,1,2> texture{Grnt17} translate<16.5,3,-0.51>}
box{<0,0,0><1.5,1,2> texture{Grnt17} translate<19.5,3,-0.51>}
box{<0,0,0><1.5,1,2> texture{Grnt17} translate<22.5,3,-0.51>}
box{<0,0,0><1.5,1,2> texture{Grnt17} translate<25.5,3,-0.51>}
box{<0,0,0><1.5,1,2> texture{Grnt17} translate<28.5,3,-0.51>}}

#declare roof_wall=union{
object{top_wall}    
object{top_wall translate<30,0,0>}  
object{top_wall translate<60,0,0>}  
object{top_wall translate<90,0,0>} } 
            
#declare roof=union{
object{roof_wall} 
object{roof_wall translate<0,0,120>} 
object{roof_wall rotate<0,-90,0>}  
object{roof_wall rotate<0,-90,0> translate<120,0,0>}  
box{<0,0,0><120,0.05,120> texture{Black_Dull}}}    

//------------------BOTTOM FLOOR---------------
#declare bottom_wall=union{
object{wall}
object{wall translate<30,0,0>} 
object{wall translate<60,0,0>} 
object{wall translate<90,0,0>} }

#declare bottom_wall1=difference{
object{bottom_wall}
box{<0,0,0><12,9,1>texture{Grnt17} translate<54,1.0,-0.5>}
box{<0,0,0><12,8,0.5>texture{Grnt17} translate<9,2.0,-0.25>}   
box{<0,0,0><12,8,0.5>texture{Grnt17} translate<24,2.0,-0.25>}  
box{<0,0,0><12,8,0.5>texture{Grnt17} translate<39,2.0,-0.25>}
box{<0,0,0><12,8,0.5>texture{Grnt17} translate<99,2.0,-0.25>}
box{<0,0,0><12,8,0.5>texture{Grnt17} translate<84,2.0,-0.25>}    
box{<0,0,0><12,8,0.5>texture{Grnt17} translate<69,2.0,-0.25>}}  

#declare lower_wall=union{
object{bottom_wall1}
object{s_w_sash scale<6,4,1> translate<9,2,-0.25>}   
object{s_w_sash scale<6,4,1> translate<39,2,-0.25>} 
object{s_w_sash scale<6,4,1> translate<24,2,-0.25>} 
object{s_w_sash scale<6,4,1> translate<69,2,-0.25>}
object{s_w_sash scale<6,4,1> translate<84,2,-0.25>}
object{s_w_sash scale<6,4,1> translate<99,2,-0.25>} 
object{s_w_sash scale<2,4.5,1> translate<54,1.0,-0.25>} 
object{s_w_sash scale<2,4.5,1> translate<58,1.0,-0.25>}  
object{s_w_sash scale<2,4.5,1> translate<62,1.0,-0.25>} 
}  
   
#declare lower_floor=union{
object{lower_wall}     
object{lower_wall rotate<0,180,0>translate<120,0,120>}
object{lower_wall rotate<0,-90,0>translate<120,0,0>}  
object{lower_wall rotate<0,90,0>translate<0,0,120>} }

//--------------SIDEWALK CONSTRUCTION-------------------

 #declare   straight=union{
box{<0,0,0><120,0.5,6> texture{AberGrPP}}   
cylinder{ <0,0,0><120,0,0> 0.5  texture{ AberGrPP}}  
}

#declare corncurb=difference{
torus{2, 0.5 texture{AberGrPP}}
box{<0,0,0><3,1.5,5> texture{AberGrPP} translate<0,-0.5,-1>}   
box{<0,0,0><5,1.5,3> texture{AberGrPP} translate<-3,-0.5,-3>} }

  
#declare cornflat=difference{
box{<0,0,0><6,0.5,6> texture{AberGrPP} } 
object{corncurb  translate<1.750,0.25,4.30>}
} 



#declare corner=union{
object{corncurb}
cylinder{<0,0,0><4,0,0> 0.5  texture{AberGrPP}translate<0,0,2>}
cylinder{<0,0,0><0,0,4> 0.5 texture{AberGrPP}translate<-2,0,-4>}
object{cornflat translate<-2,0,-4>}
} 
                                 
#declare straight1=union{  
object{straight}
object{street_light translate<2,0.75,1.25>}      
object{street_light translate<22,0.75,1.25>}
object{street_light translate<42,0.75,1.25>}
object{street_light translate<62,0.75,1.25>}
object{street_light translate<82,0.75,1.25>}
object{street_light translate<102,0.75,1.25>} }
              

#declare sidewalk=union{
object{straight1 }
object{corner rotate<0,-90,0>translate<-4,0,2>}  
object{straight1 rotate<0,90,0>translate<-6.0,0,126>}  
object{corner translate<-4,0,130>}       
object{straight1 rotate<0,180,0> translate<120,0,132>}  
object{corner rotate<0,90,0> translate<124,0,130>}  
object{straight1 rotate<0,-90,0> translate<126,0,6.0>}  
object{corner rotate<0,180,0> translate<124,0,2.0>}
} 
 
#declare lower_floor1=union{
object{lower_floor translate<1.25,0.5,8.25>}
object{sidewalk scale<1.25,1,1.25>}} 


//---------------APARTMENT BUILDING CONSRUCTION-----------

#declare apartment=union{ 
object{apart_floor1 rotate<0,-90,0>translate<120,12,0>}
object{apart_floor1 translate<0,24,0>}  
object{apart_floor1 rotate<0,-90,0>translate<120,36,0>} 
object{apart_floor1 translate<0,48,0>} 
object{apart_floor1 rotate<0,-90,0>translate<120,60,0>}  
object{apart_floor1 translate<0,72,0>}  
object{apart_floor2 rotate<0,-90,0>translate<120,84,0>}
object{apart_floor2 translate<0,96,0>}  
object{roof translate<0,108,0>}  
object{lower_floor1 }

}      

//object{apartment }   
 
 
   






// ----------------------------------------  
/*
camera
{
  location  <34.0, 89.5, 115.0>
  direction 1.5*z
  right     4/3*x
  look_at   <34.0, 89.0,  130.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 8.0  green 7.0  blue 7.0  // light's color
  translate <330, 7000, 330>
}

// ----------------------------------------
plane { y, -1 pigment {color rgb 0.1}}



sphere{<0,0,0>, 50000 hollow texture{Sunny_Cloud_Sky scale 20000} scale<3,0.25,3>} */