#version 3.1;
global_settings { assumed_gamma 2.2 }

#include "textures.inc"
#include "colors.inc"
camera {
  //location <590,530,10>
  location <-10,330,-2090>

  //look_at <0,200,1000>
  look_at <0,200,0>
  

}


/*light_source { <0, 1000, 000> color rgb <0.3,0.3,0.3>}
light_source { <500, 500, 000> color rgb <1,1,1>}
light_source { <-500, 400, -800> color rgb <1,1,1>}
  */
background { color rgb <1, 1, 1>  }
#declare dim=200;


//**************************************
//*********** les flammes *************
//*************************************
#declare dec=dim*1.3;



#declare forme = merge {
sphere {
<0,0,0>,0.6
}
cone {
<0,0,0>,0.6
<0,3,0>,0
}
}         
 
 
#declare fire =
 interior {
 media {
 scattering {2, rgb<1,1,1>
 extinction .5
 }
 intervals 30
 samples 1,1
 density {
 bozo
 scale <.25,.6,.25>
 turbulence .75
 density_map{
 [0 Black]
 [.25 Black]
 [.35 Blue*1.25]
 [.65 Orange*1.75]
 [.75 Yellow*1.75]
 [1 White*2]
 }
 }
 }
 }
 
#declare base = 
object {forme

pigment { rgbt<1,1,1,1> }
 hollow on
 normal { dents 1 scale .75 }
 interior { fire }
} 

#declare flammea =  

 light_source {
 <0,0,0>
  color rgb <.52,.37,0.22> 
  fade_distance dec
 fade_power 1.3
 looks_like { base }
 } 

#declare flamme = union {       
 object {flammea
 scale <10,10,10>} 
 
cylinder {
<0,-50,20>,<0,-4,0>,2
pigment {wood}
}
       
}       



//**************************************


//**************************************
//*********** la grotte *************
//*************************************


//**************************************


#declare nbl=0;
#while (nbl<360)
object {flamme 
translate <0,400,10*dim-30>  
 rotate <0,+60-15,0>
 rotate <0,nbl,0 > }
 
object {flamme
translate <0,400,10*dim-30> 

 rotate <0,+60+15,0>
 rotate <0,nbl,0 > }

object {flamme 
translate <0,120,10*dim-20-200>  

 rotate <0,+60-25,0>
 rotate <0,nbl,0 > }
object {flamme 
translate <0,120,10*dim-20-200>    
 rotate <0,+60+25,0>
 rotate <0,nbl,0 > }

#declare nbl=nbl+120;
#end


//tunnel1
#declare tunnel = union {
cylinder {
<0,120+200,0>,<0,120+200,20*dim>,60
pigment { color rgb <0.7,0.6,0.4>}
}
box {
<-60,200,0>,<60,120+200,20*dim>
pigment { color rgb <0.7,0.6,0.4>}
}
}

//tunnel1bis
#declare joinp = difference {
box {
<-3,58,1>,<3,62,20*dim-1>
pigment { color rgb <0.7,0.6,0.4>}
}
cylinder {
<-3,62,0>,<-3,62,20*dim>,2
pigment { color rgb <0.7,0.6,0.4>}
}  
cylinder {
<3,62,0>,<3,62,20*dim>,2
pigment { color rgb <0.7,0.6,0.4>}
}

}

#declare joinr = difference {
box {
<-3,58,1>,<3,62,20*dim-1>
pigment { color rgb <0.7,0.6,0.4>}
}
cylinder {
<0,62,0>,<0,62,20*dim>,2
rotate <0,0,degrees(asin(3/60))>
pigment { color rgb <0.7,0.6,0.4>}
}  
cylinder {
<0,62,0>,<0,62,20*dim>,2
rotate <0,0,-degrees(asin(3/60))>
pigment { color rgb <0.7,0.6,0.4>}
}

}


#declare tunnelbis = union {
cylinder {
<0,120+200,0>,<0,120+200,20*dim>,60
pigment { color rgb <0.7,0.6,0.4>}
}
box {
<-60,200,0>,<60,120+200,20*dim>
pigment { color rgb <0.7,0.6,0.4>}
}

object { joinp
rotate <0,0,90>
translate <0,120+200-4,0>
}
object { joinp
rotate <0,0,90>
translate <0,120+200-34,0>
}
object { joinp
rotate <0,0,90>
translate <0,120+200-54,0>
}
object { joinp
rotate <0,0,90>
translate <0,120+200-97,0>
}
object { joinp
rotate <0,0,-90>
translate <0,120+200-4,0>
}
object { joinp
rotate <0,0,-90>
translate <0,120+200-34,0>
}
object { joinp
rotate <0,0,-90>
translate <0,120+200-54,0>
}
object { joinp
rotate <0,0,-90>
translate <0,120+200-97,0>
}
object { joinr
rotate <0,0,-10>
translate <0,120+200,0>
}
object { joinr
rotate <0,0,10>
translate <0,120+200,0>
}
object { joinr
rotate <0,0,-40>
translate <0,120+200,0>
}
object { joinr
rotate <0,0,40>
translate <0,120+200,0>
}
object { joinr
rotate <0,0,-65>
translate <0,120+200,0>
}
object { joinr
rotate <0,0,65>
translate <0,120+200,0>
}

}


//tunnel2
#declare tunnel2 = union {
cylinder {
<0,120,0>,<0,120,20*dim>,60
pigment { color rgb <0.7,0.6,0.4>}
scale <2,1,1>
}
box {
<-60,0,0>,<60,120,20*dim>
pigment { color rgb <0.7,0.6,0.4>}
scale <2,1,1>
}
}

#declare Norm = normal {
   wrinkles 1.0
   scale 100
}


difference {
box {
<-20*dim,-1,-20*dim>,<20*dim,20*dim,20*dim>
pigment { color rgb <0.7,0.6,0.4>}
}

union {

difference {
sphere {
<0,200,0>,10*dim
texture {
pigment { color rgb <0.7,0.6,0.4>}
   normal { Norm }
   }
}
box {
<-20*dim,200,-20*dim>,<20*dim,-20*dim,20*dim>
pigment { color rgb <0.7,0.6,0.4>}
}






}
cylinder {
<0,0,0>,<0,300,0>,10*dim-200
texture {
pigment { color rgb <0.7,0.6,0.4>}
   normal { Norm }
   }
}
object {tunnel
rotate <0,60,0>}
object {tunnel
rotate <0,-60,0>}
object {tunnel
translate <-500+100-200,520,0>
rotate <0,-3,0>}

object {tunnelbis
rotate <0,180,0>}
object {tunnel2
rotate <0,60,0>}
object {tunnel2
rotate <0,-60,0>}

}

}


#declare porte = union { 
object {flamme
translate <-150,70,10*dim-420>}
object {flamme
translate <150,70,10*dim-420>}
  

difference { 
union {
#declare zmar=200;
#while (zmar>0)
box {
<-140-1.3*(200-zmar),zmar,10*dim-200>,<140+1.3*(200-zmar),0,10*dim-1000>
pigment { color rgb <0.7,0.6,0.4>}
}
#declare zmar=zmar-20;
#end

}
object {tunnel2}
cylinder {
<0,-100,0>,<0,1000,0>,10*dim-400
pigment { color rgb <0.7,0.6,0.4>}
}
}


}
      


#macro pierrerond(ag,h) 
#declare p1=<0,60,0>;
#declare p2=<0,h+60,0>;
#declare p3=<0,h+60,30>;
#declare p4=<0,60,30>;

#declare p1d = <60*sin(radians (-ag)),60*cos(radians(-ag)),0>;
#declare p2d = <(60+h)*sin(radians (-ag)),(60+h)*cos(radians(-ag)),0>;
#declare p3d = <(60+h)*sin(radians (-ag)),(60+h)*cos(radians(-ag)),30>;
#declare p4d = <60*sin(radians (-ag)),60*cos(radians(-ag)),30>;

#declare p1g = <60*sin(radians (ag)),60*cos(radians(ag)),0>;
#declare p2g = <(60+h)*sin(radians (ag)),(60+h)*cos(radians(ag)),0>;
#declare p3g = <(60+h)*sin(radians (ag)),(60+h)*cos(radians(ag)),30>;
#declare p4g = <60*sin(radians (ag)),60*cos(radians(ag)),30>;

#declare rap=2;
#declare bord=
union {
sphere {
p1d,rap
}
sphere {
p2d,rap
}
sphere {
p3d,rap
}
sphere {
p4d,rap
}
cylinder {
p1d,p2d,rap
}      
cylinder {
p2d,p3d,rap
}      
cylinder {
p3d,p4d,rap
}      
cylinder {
p4d,p1d,rap
}  

sphere {
p1g,rap
}
sphere {
p2g,rap
}
sphere {
p3g,rap
}
sphere {
p4g,rap
}
cylinder {
p1g,p2g,rap
}      
cylinder {
p2g,p3g,rap
}      
cylinder {
p3g,p4g,rap
}      
cylinder {
p4g,p1g,rap
}      

cylinder {
p1g,p1d,rap
}      
cylinder {
p2g,p2d,rap
}      
cylinder {
p3g,p3d,rap
}      
cylinder {
p4g,p4d,rap
}      

    
}


#declare bd= 
box {
p1+<rap,0,0>,p3
rotate <0,0,-ag>
}


#declare bg= 
box {
p1-<rap,0,0>,p3
rotate <0,0,ag>
}

#declare fb= 
box {
p1g+<0,-rap,0>,p4d
}

#declare fh= 
box {
p2g+<0,rap,0>,p3d
}

#declare decal=<0,0,-rap>;

#declare fav= 
polygon {
5,p1g+decal,p2g+decal,p2d+decal,p1d+decal,p1g+decal
}

#declare far= 
polygon {
5,p4g-decal,p3g-decal,p3d-decal,p4d-decal,p4g-decal
}


#declare pie= union {
object {bg
}   
object {bd
}  
object {bord
}
object {fb
}   
object {fh
}  
object {far
}   
object {fav
}  

}




object {pie
pigment {color rgb <0.8,0.5,0.2>}
}

#end      

//***************************pierre carree*******
//***********************************************

#macro pierrecarre(l,h)
#declare p1d = <l,0,0>;
#declare p2d = <l,h,0>;
#declare p3d = <l,h,30>;
#declare p4d = <l,0,30>;

#declare p1g = <-l,0,0>;
#declare p2g = <-l,h,0>;
#declare p3g = <-l,h,30>;
#declare p4g = <-l,0,30>;
#declare rap=2;
#declare bord=
union {
sphere {
p1d,rap
}
sphere {
p2d,rap
}
sphere {
p3d,rap
}
sphere {
p4d,rap
}
cylinder {
p1d,p2d,rap
}      
cylinder {
p2d,p3d,rap
}      
cylinder {
p3d,p4d,rap
}      
cylinder {
p4d,p1d,rap
}  

sphere {
p1g,rap
}
sphere {
p2g,rap
}
sphere {
p3g,rap
}
sphere {
p4g,rap
}
cylinder {
p1g,p2g,rap
}      
cylinder {
p2g,p3g,rap
}      
cylinder {
p3g,p4g,rap
}      
cylinder {
p4g,p1g,rap
}      

cylinder {
p1g,p1d,rap
}      
cylinder {
p2g,p2d,rap
}      
cylinder {
p3g,p3d,rap
}      
cylinder {
p4g,p4d,rap
}      

box {
p1d+<0,0,-rap>,p3g+<0,0,rap>
}

box {
p1d+<rap,0,0>,p3g+<-rap,0,0>
}

box {
p1d+<0,-rap,0>,p3g+<0,rap,0>
}    
    
}

 
object {bord
pigment {color rgb <0.8,0.5,0.2>}
} 


#end


//*****************************************

#declare psc = pierrerond(18,50)
#declare ps1 = pierrerond(13,20)
#declare ps2 = pierrerond(19,30) 

#declare pc1= pierrecarre(10,28)
#declare pc2= pierrecarre(20,28)


#declare entourage = union {
object {psc
}
object {ps1
rotate <0,0,35>
rotate <0,-3,0>
}
object {ps1
rotate <0,0,-35>
rotate <0,3,0>
}
object {ps2
rotate <0,0,35+40>
rotate <0,-5,0>
}
object {ps2
rotate <0,0,-35-40>
rotate <0,5,0>
}

object {
pc1
translate <-60-10,90-120,0>
rotate <0,-6,0>
}
object {
pc2
translate <-60-20,60-120,0>
rotate <0,-6,0>
}
object {
pc1
translate <-60-10,30-120,0>
rotate <0,-6,0>
}
object {
pc2
translate <-60-20,00-120,0>
rotate <0,-6,0>
}


object {
pc1
translate <60+10,90-120,0>
rotate <0,6,0>
}
object {
pc2
translate <60+20,60-120,0>
rotate <0,6,0>
}
object {
pc1
translate <60+10,30-120,0>
rotate <0,6,0>
}
object {
pc2
translate <60+20,00-120,0>
rotate <0,6,0>
}
              
              
}

object {entourage
scale <2,1,1>
translate <0,120,10*dim-400>
rotate <0,60,0>}
object {entourage
scale <2,1,1>
translate <0,120,10*dim-400>
rotate <0,-60,0>}

object {entourage
translate <0,120+200,10*dim-010>
rotate <0,60,0>}
object {entourage
translate <0,120+200,10*dim-010>
rotate <0,-60,0>}
 

object {porte
rotate <0,60,0>}
object {porte
rotate <0,-60,0>}
            

//*******************************

#declare agp=-50;
#declare h2=seed(1);
#declare lp=20;
#declare agpp=2*degrees(asin(25/(10*dim-200)));

#declare caillou = union {
#while (agp<50)
 #declare hp=20+30*rand(h2);
 #declare pir = pierrecarre(lp,hp)
 object {pir
 translate <0,-hp+200+17,10*dim-200-6>
 rotate <0,agp,0>
 }
 #declare agp=agp+agpp;
 #end                     
}

object {caillou}
          

#declare nbmm=200;
#while (nbmm>0)
box {
<-100-(200-nbmm)*1.5,nbmm,-10*dim>,<100+(200-nbmm)*1.5,nbmm-20,-10*dim+220+(200-nbmm)*2.5>
pigment { color rgb <0.7,0.6,0.4>}
}
#declare nbmm=nbmm-20;
#end

//******************* le chargement ********* 

#declare essieu = union {
cylinder {
<-100,0,0>,<100,0,0>,3
pigment {color rgb <0.6,0.6,0.3>}
}
difference {
cylinder {
<-90,0,0>,<-80,0,0>,40 
pigment {color rgb <0.8,0.8,0.5>}
}           
cylinder {
<-90,-50,0>,<-90,50,0>,1
pigment {color rgb <0.8,0.8,0.5>}
}
}
box {
<-95,15,-25>,<-90,25,25>
pigment {color rgb <0.7,0.6,0.5>}
}
box {
<-95,-15,-25>,<-90,-23,27>
pigment {color rgb <0.7,0.6,0.5>} 
rotate <10,0,0>
}

difference {
cylinder {
<90,0,0>,<80,0,0>,40 
pigment {color rgb <0.8,0.8,0.5>}
}           
cylinder {
<90,-50,0>,<90,50,0>,1
pigment {color rgb <0.8,0.8,0.5>}
}
}
box {
<95,15,-25>,<90,25,25>
pigment {color rgb <0.7,0.6,0.5>}
}
box {
<95,-15,-25>,<90,-23,27>
pigment {color rgb <0.7,0.6,0.5>} 
rotate <10,0,0>
}


}

#declare charriota = union {
object {essieu}

object {essieu
rotate <75,0,0>
translate <0,0,-250>}

box {
<-60,-5,60>,<-50,5,-50>
pigment {color rgb <0.7,0.6,0.5>} 
rotate <-30,0,0>
}
box {
<60,-5,60>,<50,5,-50>
pigment {color rgb <0.7,0.6,0.5>} 
rotate <-30,0,0>
} 

box {
<-60,-5,50>,<-50,5,-60>
pigment {color rgb <0.7,0.6,0.5>} 
rotate <30,0,0>
translate <0,0,-250>
}
box {
<60,-5,50>,<50,5,-60>
pigment {color rgb <0.7,0.6,0.5>} 
rotate <30,0,0> 
translate <0,0,-250>
}

box {
<-40,-5-25,-35>,<-50,5-25,-215>
pigment {color rgb <0.7,0.6,0.5>} 
}
box {
<40,-5-25,-35>,<50,5-25,-215>
pigment {color rgb <0.7,0.6,0.5>} 
}                        

#declare nbcy=0;
#while (nbcy<220)
cylinder {
<-80,-25,-30>,<80,-25,-30>,2
pigment {color rgb <0.7,0.6,0.5>} 
translate <0,0,-nbcy>
}                    
#declare nbcy=nbcy+30;
#end
cylinder {
<-80,0,-50>,<80,0,-50>,2
pigment {color rgb <0.7,0.6,0.5>}
rotate <30,0,0> 
translate <0,0,-250>
}

box {
<-50,30-4,-290>,<-45,30+4,-500>
pigment {color rgb <0.7,0.6,0.5>}
} 
box {
<50,30-4,-290>,<45,30+4,-500>
pigment {color rgb <0.7,0.6,0.5>}
}                    

}

#declare charriot =
object {charriota 
translate <0,40,0>}                   
 


#declare touche = difference {
box {
<0,0,0>,<1,1,-2>
}
cylinder {
<0.5,2,-5.5>,<0.5,-1,-5.5>,5
}
box {
<-1,0,1>,<2,-2,-2>
rotate <10,0,0>
} 
box {
<-1,0,1>,<2,2,-2>
rotate <-5,0,0>
translate <0,1,0>
}
box {
<-1,-1,1>,<0,2,-2>
rotate <0,-10,0>
} 
box {
<1,-1,1>,<0,2,-2>
rotate <0,10,0> 
translate <1,0,0>
} 

}                    

#declare chargement = union {
object {charriot 
}                   


object {
touche
pigment {
image_map {
tga "fotouche.tga"
}
} 
translate <-0.5,-0.5,0> 
rotate <0,0,-15>              
rotate <90,0,0>
scale <100,100,100>
translate <0,20,-125>
}

}

 
object {chargement
translate <0,0,700>
rotate <0,-60,0>
}

   
//********************************trone******
#declare db=500;



#declare nbm=0;
#while (nbm<201)
box {
<-500,nbm,db+1.5*nbm>,<500,nbm+20,10*dim>
pigment { color rgb <0.7,0.6,0.4>}
}  
#declare nbm=nbm+20;
#end 

#while (nbm<401)
box {
<-300,nbm,db+1.5*nbm>,<300,nbm+20,10*dim>
pigment { color rgb <0.7,0.6,0.4>}
}  
#declare nbm=nbm+20;
#end  

#declare nbm=0;
#while (nbm<401)
box {
<-100,nbm,db+1.5*nbm-0.5>,<100,nbm+20+0.5,10*dim>
pigment { color rgb <1,0.5,0.5>}
}  
#declare nbm=nbm+20;
#end  

box {
<-100,0.1,0>,<100,0,10*dim>
pigment { color rgb <1,0.5,0.5>}
}
cylinder {
<0,0,0>,<0,0.1,0>,200      
pigment { color rgb <1,0.5,0.5>}
}


difference {
box {
<-500,0,db+1.5*420>,<500,420,10*dim>
pigment { color rgb <0.7,0.6,0.4>}
}
object {tunnel
translate <-400,20,0>
}
object {tunnel
translate <400,20,0>
}

}

object {entourage
translate <400,120+220,db+1.5*420-10>
}
object {entourage
translate <-400,120+220,db+1.5*420-10>
}


box {
<-410,420,db+1.5*420+20>,<-390,700,10*dim>
pigment { color rgb <0.7,0.6,0.4>}
}

object {flamme
rotate <0,-90,0>
translate <-390+20,520,db+1.5*420+30>}

box {
<410,420,db+1.5*420+20>,<390,700,10*dim>
pigment { color rgb <0.7,0.6,0.4>}
}
object {flamme
rotate <0,90,0>
translate <390-20,520,db+1.5*420+30>}

object {flamme
translate <-180,550,db+1.5*420+280>}
object {flamme
translate <180,550,db+1.5*420+280>}



difference {
box {
<-390,420,db+1.5*420+300>,<390,700,10*dim>
pigment { color rgb <0.7,0.6,0.4>}
}
object {tunnel
translate <-300,220,0>
}
object {tunnel
translate <300,220,0>
}

}

object {entourage
translate <300,120+420,db+1.5*420+300-10>
}
object {entourage
translate <-300,120+420,db+1.5*420+300-10>
}  

box {
<-200,420,db+1.5*420+50>,<200,440,10*dim>
pigment { color rgb <1,0.5,0.5>}

}

box {
<0,0,0>,<1,1,0.01>
pigment {
image_map {
tga "fotex.tga"
}
}              
translate <-0.5,-0.5,0>
scale <200,200,1>
translate <0,560,db+1.5*420+290>
}


//*********************************************
//*********************************************



//*********************************************
//************ les fourmis ********************
//*********************************************



//*********************************************
//*********************************************


//************************fourmi**************

#macro fourmi(atete,abrasd,abrasg,plid,plig,pid,pig,rqu,aant,coul)  
#declare fo = union {

#declare tete = union {

difference {
union {
sphere {
<0,0,0>,10           
texture {
pigment {color rgb <0.8,0.7,0.83>}
finish {metallic}
}
}     
cone {
<0,0,-10*sqrt(2)/2>,10*sqrt(2)/2
<0,0,-10*sqrt(2)>,0  
texture {
pigment {color rgb <0.8,0.7,0.83>}
finish {metallic}
}
}
cone {
<0,0,-10*sqrt(2)+4>,4
<0,0,-10*sqrt(2)>,0  
pigment {color rgb <0.7,0.7,0.2>} 
translate <0,0,-0.1>
}

}
box {
<-50,-50,-50>,<50,0,50>   
pigment {color rgb <0.5,0.4,0.53>}
}
}
sphere {
<5,5,-5>,3
pigment {color rgb <0.9,0.9,0.95>}
}  
sphere {
<-5,5,-5>,3
pigment {color rgb <0.9,0.9,0.95>}
}
sphere {
<5.4,5.6,-6>,2
pigment {color rgb <0.5,0.2,0.35>}
}  
sphere {
<-5.4,5.6,-6>,2
pigment {color rgb <0.5,0.2,0.35>}
}
cone {
<0,5,2>,1
<0,-10,2>,2
texture {
pigment {color rgb <0.8,0.7,0.83>}
finish {metallic}
}
}
}
object {
tete
translate <0,107,2>
rotate <0,atete,0>
}

#declare antenne=
union {
sphere {
<0,0.2,0>,0.2
pigment {color rgb <0.7,0.6,0.73>}
scale <3,50,1>
}
sphere {
<0,0,-0.2>,0.2
pigment {color rgb <0.7,0.6,0.73>}
scale <3,1,70>
rotate <aant,0,0>
translate <0,20,0>
}                                                
}
object {antenne
rotate <30,0,0>
translate <0,10,0>
rotate <-15,0,0>
rotate <0,0,10>   
rotate <0,atete,0>
translate <0,109,-2>} 

object {antenne
rotate <30,0,0>
translate <0,10,0>
rotate <-15,0,0>
rotate <0,0,-10> 
rotate <0,atete,0>
translate <0,109,-2>}

 

#declare corps =
union {
sphere {
<0,0,0>,10
texture {
pigment {color rgb <0.8,0.7,0.83>}
finish {metallic}
}  
scale <1.2,1.6,1>
}
difference {
sphere {
<0,0,0>,10.1
texture {
pigment {color rgb <coul,0.5,1-coul>}
finish {metallic}
}  
scale <1.2,1.6,1>
}
box {
<-30,-30,-30>,<30,4,30>  
pigment {color rgb <coul,0.5,1-coul>}
}  
box {
<-30,30,-30>,<30,0,30>  
pigment {color rgb <coul,0.5,1-coul>} 
rotate <0,0,30>
translate <0,14,0>
}
}
sphere {
<0,-16,0>,10
texture {
pigment {color rgb <0.8,0.7,0.83>}
finish {metallic}
}  
}
#declare queue = union {
cone {
<0,-7,0>,0
<0,-12,0>,10
texture {
pigment {color rgb <0.8,0.7,0.83>}
finish {metallic}
}  
}
difference {
sphere {
<0,0,0>,10        
texture {
pigment {color rgb <0.6,0.5,0.63>}
finish {metallic}
}  
scale <1.5,2,1.5>
translate <0,-29,0>
} 
box {
<-20,20,-20>,<20,-12,20>  
pigment {color rgb <0.5,0.5,0.5>}
}
}
}
object {queue
rotate <-55-rqu,0,0>
translate <0,-16,0>}
}

object {corps
translate <0,89,0>}

//**********bras gauche
#declare bg = union {
sphere {
<0,0,0>,1.5
}
sphere {
<0,0,-0.4>,0.4
scale <1,2,15>
rotate <0,-plig,0>
}
sphere {
<0,0,-0.4>,0.4
scale <1,2,20>
rotate <0,30+plig,0>
translate <0,0,-30*0.4>
rotate <0,-plig,0>
}
sphere {
<0,0,-0.4>,0.4
scale <1,2,10>
rotate <0,-plig,0>

translate <0,0,-40*0.4>
rotate <0,30+plig,0>


translate <0,0,-30*0.4>
rotate <0,-plig,0>
}

sphere {
<0,0,-0.4>,0.4
scale <1,2,5>
rotate <0,60+plig,0>

translate <0,0,-20*0.4>
rotate <0,-plig,0>


translate <0,0,-40*0.4>
rotate <0,30+plig,0>


translate <0,0,-30*0.4>
rotate <0,-plig,0>
}


}

object {bg
pigment {color rgb <0.7,0.6,0.73>}
rotate <abrasg,0,0>
rotate <0,15,0>
translate <0,78,-8>
rotate <0,-45,0>
}


//**********bras droit
#declare bd = union {
sphere {
<0,0,0>,1.5
}
sphere {
<0,0,-0.4>,0.4
scale <1,2,15>
rotate <0,plid,0>
}
sphere {
<0,0,-0.4>,0.4
scale <1,2,20>
rotate <0,-30-plid,0>
translate <0,0,-30*0.4>
rotate <0,plid,0>
}
sphere {
<0,0,-0.4>,0.4
scale <1,2,10>
rotate <0,plid,0>

translate <0,0,-40*0.4>
rotate <0,-30-plid,0>


translate <0,0,-30*0.4>
rotate <0,plid,0>
}

sphere {
<0,0,-0.4>,0.4
scale <1,2,5>
rotate <0,-60-plid,0>

translate <0,0,-20*0.4>
rotate <0,plid,0>


translate <0,0,-40*0.4>
rotate <0,-30-plid,0>


translate <0,0,-30*0.4>
rotate <0,plid,0>
}


}

object {bd
pigment {color rgb <0.7,0.6,0.73>}
rotate <abrasd,0,0>
rotate <0,-15,0>
translate <0,78,-8>
rotate <0,45,0>
}

//**********pied gauche
#declare pg = union {
sphere {
<0,0,0>,2
}
sphere {
<0,0,-0.4>,0.4
scale <3,2,30>
rotate <-50+pig,0,0>
}
sphere {
<0,0,0.4>,0.4
scale <3,2,30>
rotate <50-pig,0,0> 
rotate <50-pig,0,0>
translate <0,0,-60*0.4>
rotate <-50+pig,0,0>
}
sphere {
<0,0,-0.4>,0.4
scale <5,2,10>
translate <0,-120*0.4*sin(radians(50-pig)),0>
} 


}

object {pg
pigment {color rgb <0.7,0.6,0.73>}
//rotate <pig,0,0>
rotate <0,15,0>
translate <0,68,-8>
rotate <0,-45,0>
}


//**********pied droit
#declare pd = union {
sphere {
<0,0,0>,2
}
sphere {
<0,0,-0.4>,0.4
scale <3,2,30>
rotate <-50+pid,0,0>
}
sphere {
<0,0,0.4>,0.4
scale <3,2,30>
rotate <50-pid,0,0> 
rotate <50-pid,0,0>
translate <0,0,-60*0.4>
rotate <-50+pid,0,0>
}
sphere {
<0,0,-0.4>,0.4
scale <5,2,10>
translate <0,-120*0.4*sin(radians(50-pid)),0>
} 


}

object {pd
pigment {color rgb <0.7,0.6,0.73>}
//rotate <pid,0,0>
rotate <0,-15,0>
translate <0,68,-8>
rotate <0,45,0>
}


} 



object {fo
translate <0,-68-60*0.4*sin( radians(-50+min(pid,pig)) )-60*0.4*sin(radians(-100-min(pid,pig))),0>
}                                     
#end


//************* fourmie arme
#macro fourmiarme (atete,abrasd,abrasg,plid,plig,pid,pig,rqu,aant,coul,rhal,rhab)   

#declare foa = union {
fourmi(atete,abrasd,abrasg,plid,plig,pid,pig,rqu,aant,coul)  

#declare halleb = union {
cylinder {
<0,0,0>,<0,135,0>,1
pigment {color rgb <0.7,0.5,0.3>}
}
difference {
union {
cone {
<0,110,0>,20
<0,110,-1>,16
texture {Chrome_Texture}
}
cone {
<0,110,0>,20
<0,110,1>,16
texture {Chrome_Texture}
}

}
cylinder {
<0,0,-5>,<0,0,5>,3
texture {Chrome_Texture}
scale <2,8,1>
translate <0,27+110,0>
}
cylinder {
<0,0,-5>,<0,0,5>,3
texture {Chrome_Texture}
scale <2,8,1>
translate <0,-27+110,0>
}                  
box {
<5,-30+110,-5>,<30,30+110,5>
texture {Chrome_Texture}
}

}
cylinder {
<0,106.5,0>,<0,113.5,0>,1.5 
texture {Chrome_Texture}

}
}


object {halleb   
rotate <0,rhal,0>
rotate <0,0,22-rhab>
rotate <-4,0,0>
translate <0,0,-20>}

}
object {foa
}
#end



//**************************utilisation des fourmis


#declare h1=seed(1);
//l'armee

#declare nbc=0;

#while (nbc<5) 
#declare nbl=0;
 #while (nbl<8)  
 #declare pl=15*rand(h1);
  #declare fo2 = fourmiarme (-50+100*rand(h1),10+10*rand(h1),40+20*rand(h1),50+20*rand(h1),40+20*rand(h1),-12-pl,-12-pl,10*rand(h1),-30+60*rand(h1),0.15+rand(h1)/10,-12+24*rand(h1),8*rand(h1))
  object { fo2
  translate <nbc*80-160,0,nbl*100>
  rotate <0,90,0>
  translate <600,0,-000>}
  #declare nbl=nbl+1;
 #end
 #declare nbc=nbc+1;
#end


  #declare fo3 = fourmiarme (-20+40*rand(h1),10+10*rand(h1),40+20*rand(h1),50+20*rand(h1),40+20*rand(h1),-20,-20,10*rand(h1),-30*rand(h1),0.85+rand(h1)/10,0,8*rand(h1))
  object { fo3
  rotate <0,180,0>
  translate <2*80+5*rand(h1)-160,0,-2*100-5*rand(h1)>
    rotate <0,90,0>
  translate <600,0,-00>
  }

  
  
  
    #declare pl=15*rand(h1);
    #declare fo2 = fourmiarme (-50+100*rand(h1),10+10*rand(h1),40+20*rand(h1),50+20*rand(h1),40+20*rand(h1),-12-pl,-12-pl,10*rand(h1),-30+60*rand(h1),0.15+rand(h1)/10,-5+10*rand(h1),8*rand(h1))
#declare sentinelle = union {
  object { fo2
  translate <0,200,10*dim-100>
  rotate <0,4,0>
 }
  object { fo2
  translate <0,200,10*dim-100>
  rotate <0,-4,0>
 }
 
  object { fo2 
  rotate <0,45,0>
  translate <0,00,10*dim-300>
  rotate <0,19,0>
 }
  object { fo2
  rotate <0,-45,0>
  translate <0,00,10*dim-300>
  rotate <0,-19,0>
 }
  object { fo2 
  rotate <0,90,0>
  translate <0,00,10*dim-500>
  rotate <0,4,0>
 }
  object { fo2
  rotate <0,-90,0>
  translate <0,00,10*dim-500>
  rotate <0,-4,0>
 }
                             
                             
}
#declare sentinelleb = union {  
    #declare pl=15*rand(h1);
    #declare fo2 = fourmiarme (-50+100*rand(h1),10+10*rand(h1),40+20*rand(h1),50+20*rand(h1),40+20*rand(h1),-12-pl,-12-pl,10*rand(h1),-30+60*rand(h1),0.15+rand(h1)/10,-5+10*rand(h1),0)

  object { fo2 
  rotate <0,90,0>
  translate <0,200,10*dim-100>
  rotate <0,3,0>
 } 
     #declare pl=15*rand(h1);
    #declare fo2 = fourmiarme (-50+100*rand(h1),10+10*rand(h1),40+20*rand(h1),50+20*rand(h1),40+20*rand(h1),-12-pl,-12-pl,10*rand(h1),-30+60*rand(h1),0.15+rand(h1)/10,-5+10*rand(h1),0)

  object { fo2 
  rotate <0,-90,0>
  translate <0,200,10*dim-100>
  rotate <0,-3,0>
 }
                             
                             
}

object {sentinelle
rotate <0,60,0>}                             
object {sentinelle
rotate <0,-60,0>}                             
object {sentinelleb
rotate <0,180,0>}                             
 
 
#declare reine = 
fourmi(-20,10,45,20,20,0,0,0,0,0.5) 

object {
reine
scale <2,2,2> 
rotate <0,-20,0>
translate <0,440,db+1.5*420+100>
}

#declare sousreine = 
fourmi(0,0,45,20,20,0,0,0,0,0.85) 

object {
sousreine
rotate <0,-45,0>
translate <-300,420,db+1.5*420+250>
}
object {
sousreine
rotate <0,45,0>
translate <300,420,db+1.5*420+250>
}
 

#declare foescgs =  fourmi(0,50,00,40,40,0,-10,0,0,0.15) 


#declare foescg = union {
object {foescgs}
object {flamme
translate <-10,120,-40>
}
}

#declare foescds =  fourmi(0,00,50,40,40,-10,0,0,0,0.15) 


#declare foescd = union {
object {foescds}
object {flamme
translate <10,120,-40>
}
}


#declare nbfoesc=20;
#while (nbfoesc<380)
object {
foescg 
rotate <0,-90,0>
translate <-250,nbfoesc,db+1.5*nbfoesc>
} 
object {
foescd 
rotate <0,90,0>
translate <250,nbfoesc,db+1.5*nbfoesc>
}                                      
                                     
#declare nbfoesc=nbfoesc+80;
#end    

 
 #declare fogs =  fourmi(0,50,00,40,40,0,0,0,0,0.15) 


#declare foug = union {
object {fogs}
object {flamme
translate <-10,120,-40>
}
}

#declare fods =  fourmi(0,0,50,40,40,0,0,0,0,0.15) 


#declare foud = union {
object {fods}
object {flamme
translate <10,120,-40>
}
}

//autour de l'escalier secondaire 

object {foug

rotate <0,-90,0>
translate <-300,0,-1300>} 

object {foud

rotate <0,90,0>
translate <300,0,-1300>} 

//autour de l'armee 

object {foug
translate <-160-80,0,0>
rotate <0,90,0>
translate <600,0,-00>} 

object {foud
translate <160+80,0,0>
rotate <0,90,0>
translate <600,0,-00>} 
 


//autour du chargement

object {foug
translate <-200,0,600>
rotate <0,-60,0>
} 

object {foud
translate <200,0,600>
rotate <0,-60,0>
} 
object {foug
translate <-250,0,300>
rotate <0,-60,0>
} 

object {foud
translate <250,0,300>
rotate <0,-60,0>
} 
 
#declare nbc=0;

#while (nbc<4) 
 #declare pl=15*rand(h1);
  #declare fo2 = fourmi (-50+100*rand(h1),10+10*rand(h1),40+20*rand(h1),50+20*rand(h1),40+20*rand(h1),-12-pl,-12-pl,10*rand(h1),-30+60*rand(h1),0.15+rand(h1)/10)
  object { fo2
  translate <-100,0,700-350-50*nbc>
  rotate <0,-60,0>
  } 
 #declare pl=15*rand(h1);
  #declare fo2 = fourmi (-50+100*rand(h1),10+10*rand(h1),40+20*rand(h1),50+20*rand(h1),40+20*rand(h1),-12-pl,-12-pl,10*rand(h1),-30+60*rand(h1),0.15+rand(h1)/10)
  object { fo2
  translate <100,0,700-350-50*nbc>
  rotate <0,-60,0>
  } 
  

 #declare nbc=nbc+1;
#end


//l'armee2

#declare nbc=0;

#while (nbc<5) 
#declare nbl=0;
 #while (nbl<8)  
 #declare pl=15*rand(h1);
  #declare fo2 = fourmiarme (-50+100*rand(h1),10+10*rand(h1),40+20*rand(h1),50+20*rand(h1),40+20*rand(h1),-12-pl,-12-pl,10*rand(h1),-30+60*rand(h1),0.15+rand(h1)/10,-12+24*rand(h1),8*rand(h1))
  object { fo2
  translate <nbc*80-160,0,nbl*100>
  rotate <0,180,0>
  translate <00,0,-600>}
  #declare nbl=nbl+1;
 #end
 #declare nbc=nbc+1;
#end


  #declare fo3 = fourmiarme (-20+40*rand(h1),10+10*rand(h1),40+20*rand(h1),50+20*rand(h1),40+20*rand(h1),-20,-20,10*rand(h1),-30*rand(h1),0.85+rand(h1)/10,0,8*rand(h1))
  object { fo3
  rotate <0,180,0>
  translate <2*80+5*rand(h1)-160,0,-2*100-5*rand(h1)>
    rotate <0,180,0>
  translate <00,0,-600>
  }

 //autour de l'armee2 

object {foug
translate <-160-80,0,0>
rotate <0,180,0>
translate <00,0,-600>} 

object {foud
translate <160+80,0,0>
rotate <0,180,0>
translate <00,0,-600>} 
 

 
 //********************lescalier
 
 #declare h3=seed(1);

#declare arb = union {
cone {
<0,0,0>,20
<0,10*dim+200,0>,10
pigment {color rgb <0.6,0.5,0.3>}
}
#declare nbma=15; 
#while (nbma<720*1)
cylinder {
<0,nbma,0>,<115+5*rand(h3),nbma,0>,2+2*rand(h3)
pigment {color rgb <0.6+0.2*rand(h3),0.4+0.2*rand(h3),0.15+0.2*rand(h3)>}
rotate <0,-nbma/2+180,0>
}
#declare nbma=nbma+20;
#end 
difference {
union {

#declare nbtr=0;
#while (nbtr<400)
box {
<-200,720,-200+nbtr>,<200,710,-200+nbtr+23+rand(h1)*1.4>
pigment {color rgb <0.7-rand(h1)/10,0.6-rand(h1)/10,0.5>}
}      
#declare nbtr=nbtr+25;
#end


}
box {
<-300,600,0>,<0,800,130>
pigment {color rgb <0.7,0.6,0.5>}
}            
}            

box {
<160,703,-180>,<175,710,180>
pigment {color rgb <0.6,0.6,0.3>}
rotate <0,-5,0>
}
box {
<-60,703,-180>,<-75,710,-10>
pigment {color rgb <0.6,0.6,0.3>}
rotate <0,6,0>
}
box {
<-195,703,-180>,<-180,710,180>
pigment {color rgb <0.6,0.6,0.3>}
}
box {
<10,703,-60>,<35,710,50>
pigment {color rgb <0.6,0.6,0.3>}
rotate <0,-5,0>
}

            
}

object {arb
translate <-500-200,0,-600> 
rotate <0,-3,0>
}

//***tremplin

#declare tremplin = union {
box {
<-60,0,0>,<60,-10,-400>
pigment {color rgb <0.6,0.6,0.3>}
}
box {
<-50,-3,0>,<-40,-13,500>
pigment {color rgb <0.6,0.6,0.3>}
rotate <45,0,0>
translate <0,0,-170>
}
box {
<50,-3,0>,<40,-13,500>
pigment {color rgb <0.6,0.6,0.3>}
rotate <45,0,0>
translate <0,0,-170>
}
}

object {tremplin
translate <-400-200,720,10*dim-180>
rotate <0,-3,0>
}


#declare lim=(10*dim-180)/2;



#declare rapo=2*lim*1.5; 
#declare alp=asin(lim/rapo);
#declare h=lim/tan(alp);

#declare arcs =
difference {
union {
torus {
rapo,5
rotate <0,0,90>  
translate <50,h,0>
pigment {color rgb <0.8,0.6,0.4>}
}
torus {
rapo,5
rotate <0,0,90>  
translate <-50,h,0>
pigment {color rgb <0.8,0.6,0.4>}
}

}           
box {
<-200,0,-10000>,<200,100000,10000>
pigment {color rgb <0.8,0.6,0.4>}
}

}


#declare rondins = union {
#declare nbr=-degrees(alp);
#while (nbr<degrees(alp))
cylinder {
<-70,-rapo+3,0>,<70,-rapo+3,0>,3
rotate <nbr,0,0>
pigment {color rgb <0.7,0.5,0.3>}
}                                
#declare nbr=nbr+0.5;
#end

}                


#declare parap = union {
box {
<-55,0,-5>,<-45,100,5>
pigment {color rgb <0.6,0.4,0.2>}
}
box {
<55,0,-5>,<45,100,5>
pigment {color rgb <0.6,0.4,0.2>}
}
}

#declare pont = union { 
object {arcs}
object {arcs 
translate <0,70,0>}


object {rondins
translate <0,h,0>}

object {
parap
translate <0,0,-lim>
}                  
object {
parap
translate <0,0,lim>
}                  

}

object {pont
translate <-400-200,720,lim-400>
rotate <0,-3,0>
}
// fourmis sur l'escalier et passerelle

object {foug
translate <-400-200,720,10*dim-300>
rotate <0,-3,0>
} 

object {foud
rotate <0,-90,0>
translate <-370-200,720+h-rapo,lim-400>
rotate <0,-3,0>
} 
object {foug
rotate <0,-90,0>
translate <-350-200,720,-600>
rotate <0,-3,0>} 

object {foug
translate <-60,10+300,000>
rotate <0,-300/2,0>
translate <-500-200,0,-600> 
rotate <0,-3,0>
} 
