#version unofficial megapov 0.4;

global_settings { hf_gray_16 }

#declare T_1 = texture {
	pigment { wrinkles scale .5 color_map { [0 rgb .2] [1 rgb 1] } }
	finish { ambient 0 diffuse 1 }
}

#declare T_2 = texture {
	pigment { wrinkles scale .5 color_map { [0 rgb .2] [1 rgb 1] } }
	finish { ambient .4 diffuse .6 }
}

plane { -z, 0
	texture {	
		gradient y
		triangle_wave
		translate -.5*y
		scale 6
		texture_map {
			[0 T_1]
			[.5 T_2]
		}
	}
}

light_source {
	<-12, -2, -10>, rgb 1
	spotlight
	radius 1
	falloff 10
	tightness 5
	point_at <-3, .8, 0>
}

light_source {
	<8, 0, -10>, rgb .9
	spotlight
	radius 1
	falloff 12
	tightness 10
	point_at <3, .8, 0>
}


light_source {
	<5, -10, -5>, rgb 1
	spotlight
	radius 0
	falloff 5
	tightness 4
	point_at <.2, .8, 0>
}


camera {
	orthographic
	location <0,0,-10>
	right 8*x
	up 6*y
	look_at <0,0,0>
}

