#version unofficial megapov 0.5;


#include "mgrass.pov"

#macro PlaceObjSurObj(loc, Obj1, Obj2, roty)

#local Start = loc + 50*y;
#local Norm = <0,0,0>;
#local Intersec = trace(Obj2, Start, -y, Norm);

	#if ((Norm.x != 0) | (Norm.y != 0) | (Norm.z != 0))

		object { Obj1
			rotate roty*y
			translate Intersec
		}
	#end
#end


/*
#declare Blanc1=rgb<0.90,0.81,0.81>;
#declare Green1=rgb<230,190,50>/255;
#declare Green2=rgb<110,230,8>/255;

#declare pigSpotted =pigment {
	spotted
    color_map {
        [0.0, 1.01   color Green1 color Green2 ]
    }
}

#declare pigEarth =pigment {
    spotted
    color_map {
        [0 color Tan*0.3]
        [0.4 color Tan*0.3]
        [0.4 color Green1*0.4]
        [1   color Green1*0.4]
    }
}
#declare pigGreen=pigment{Green2*1.3}

#declare txtGrass=texture {
	pigment { pigSpotted }
	finish{ ambient 0.4 diffuse 0.6}
	scale <0.01,1,0.01>
}

*/

#macro PutGrassOn(sol, grass, lPatch, scdev, coin1, nbPatchx, nbPatchz, addPatch, addDir, ymin, nmin, rnd, test)

#local st = seed(rnd);

union{
	
	#local zCountPatch=0;
	#local xDep=coin1.x;
	#local zloc=coin1.z;
	
	#while (zCountPatch<nbPatchz)

		#local xloc=xDep;
		#local xFin=xDep+nbPatchx*lPatch;

		#while (xloc<xFin)

			#if (test=true)
				#local patch = sphere{
					0,lPatch*0.5
					pigment{Red}
					scale <1,0.2,1>
				}
			#else
				#local patch = object{
					grass
					translate <-lPatch, 0, -lPatch>*.5
				}
			#end
			
			#local Start = <xloc,50,zloc>;
			#local Norm = <0,0,0>;
			#local Intersec = trace(sol, Start, -y, Norm);
			#local Norm = vnormalize(Norm);

			#if ((Norm.x != 0) | (Norm.y != 0) | (Norm.z != 0))

				#if ((Intersec.y > ymin) & (vdot(Norm,y) > nmin) )

					object { patch
						rotate y*360*rand(st)
						#if (vdot(Norm,y) < 1.0 )
						Reorient(y, Norm)
						#end
						scale (1+scdev*rand(st))
						translate Intersec
					}
				#end
			#end

			#local xloc=xloc+lPatch;
		#end
		#local zloc=zloc+lPatch;
		#local zCountPatch=zCountPatch+1;
		#if (addDir < 0)
			#local xDep=xDep-addPatch*lPatch;
		#end
		#local nbPatchx=nbPatchx+addPatch;
	#end
	texture{ txtGrass }
}


#end



#macro Rock(rnd)

#local st = seed(rnd*687452);

sphere {
	0, 1
	translate .4*y
	scale <.05 + .1*rand(st), .01 + .05*rand(st), .03 + .07*rand(st)>
	texture {
		pigment {
			bozo
			scale .04
			warp { turbulence .7 octaves 3 }
			color_map
			{
				[.6 color rgb<.8,.6,.3>*.7]
				[.6 color rgb<.8,.6,.3>]
			}
		}
		normal { bozo 10 translate 10*rand(st)*x scale <.02,.1,.02>}
		finish { ambient .4 diffuse .6 }
	}
}

#end



#macro LittleRocks(obj, loc1, loc2, nbx, nbz, rnd)

#local st =seed(rnd);

#local ymin = loc1.y;
#local ymax = loc2.y;

#local x0 = loc1.x;
#local x1 = loc2.x;
#local z0 = loc1.z;
#local z1 = loc2.z;
#local incx = (x1-x0)/nbx;
#local incz = (z1-z0)/nbz;

	#local i = x0;
	#while (i < x1)

		#local j = z0;
		#while (j < z1)

			#local Start = <i + incx*rand(st), ymax+50, j + incz*rand(st)>;
			#local Norm = <0,0,0>;
			#local Intersec = trace(obj, Start, -y, Norm);

			#if ((Norm.x != 0) | (Norm.y != 0) | (Norm.z != 0))

				#if ( (Intersec.y > ymin) & (Intersec.y < ymax) )
				object {
					Rock(rand(st))
					#if (vdot(Norm,y) < 1.0 )
					Reorient(y, Norm)
					#end
					scale .15
					translate Intersec
				}
				#end
			#end
		
			#local j = j+incz;
		#end

		#local i = i+incx;
	#end

#end



#declare doSmooth = true;
#declare segBlade = 12;
#declare xBladeStart = .003;
#declare xBladeEnd = .001;
#declare zBladeStart = xBladeStart*0.3;
#declare startBend = <0,1,0>;
#declare dofold = false;
#declare maxrotBlade = 250;


#macro TouffeHerbe(centre, rayon, nbre, lBlade, lBladedev, vBend, pwBend, rnd)

#local st = seed(rnd);

#local Pturb = pigment {
	bozo
	turbulence .3
	scale rayon*.3
	color_map { [0 rgb 0] [1 rgb <1,0,0>]}
}

	mesh {
	#local i = 0;
	#local inc = 360/nbre;
	#while (i<360)

		#local temp = sqrt(rand(st))*vaxis_rotate(x, y, i);
		#local posBlade = centre + <temp.x*rayon.x, 0, temp.z*rayon.z>;
		#local rotBlade = maxrotBlade*(-.5+vlength(eval_pigment(Pturb, posBlade)));
		#local temp = .3*vlength(vBend)*<-1+2*rand(st),-1+2*rand(st),-1+2*rand(st)>;

		MakeBlade(doSmooth, posBlade, rotBlade, segBlade, (lBlade + lBladedev*rand(st)),
					xBladeStart, xBladeEnd, zBladeStart,
					startBend, vBend+temp, pwBend*(.5+rand(st)), dofold, false
					)

		#local i=i+inc;
	#end

		texture { txtGrass scale<rayon.x, lBlade*.2, rayon.z> }
	}

#end


#declare T_Pierre = texture {
	pigment {
		marble
		scale .05
		color_map {
			[.1 rgb <.95, .8, .8>]
			[.3 rgb <.4, .3, .3>]
			[.5 rgb <.5, .6, .7>]
			[.7 rgb <.4, .3, .3>]
			[.9 rgb <.8, .85, .95>]
		}
		warp { turbulence .7 octaves 3 }
	}
	normal {
		average
		normal_map {
			[1 bozo 5 turbulence .3 scale .2 ]
			[1 granite 5 scale .05 ]
		}
	}
	finish { ambient .4 diffuse .6 }
}


#macro Pierre(taille, rnd)

#local st = seed(rnd*38321);

object {
	blob {
		sphere { <-.4 + rand(st)*.1, 0, 0>, 1, 1 }
		sphere { <.3 - rand(st)*.1, 0, 0>, .8, 1 }
		sphere { <.1 - rand(st)*.2, .4*rand(st), 0>, .7, 1 }
		sphere { <.1 - rand(st)*.2, 0, .4*rand(st)>, .6, 1 }
		threshold .1
	}
	scale taille
/*	texture {
		pigment {
			slope y
			pigment_map {
				[.8 granite scale .05
					color_map {
						[.2 rgb <.9, .9, .95>]
						[.3 rgb <.4, .3, .3>]
						[.5 rgb <.6, .6, .6>]
						[.7 rgb <.4, .3, .3>]
						[.9 rgb <.9, .95, .9>]
					} ]
				[.8 pigSpotted scale <.001, .1, .001> ]
			}
			warp { turbulence .02 octaves 3 }
		}
		normal {
			average
			normal_map {
				[1 bozo 5 turbulence .3 scale .2 ]
				[1 granite 1 scale .1 ]
			}
			translate 321*rand(st)
		}
		finish { ambient .4 diffuse .6 }
	}*/
	texture {
		slope y,y
		texture_map {
			[.5 T_Pierre ]
			[.5 T_Sol1   ]
		}
		warp { turbulence 1.5 octaves 3 lambda 9}
	}
}

#end

#macro GrossesPierres(obj, sc, loc1, loc2, nbx, nbz, rnd)

#local st =seed(rnd);

#local ymin = loc1.y;
#local ymax = loc2.y;

#local x0 = loc1.x;
#local x1 = loc2.x;
#local z0 = loc1.z;
#local z1 = loc2.z;
#local incx = (x1-x0)/nbx;
#local incz = (z1-z0)/nbz;

	#local i = x0;
	#while (i < x1)

		#local j = z0;
		#while (j < z1)

			#local Start = <i + .8*incx*(-.2 + rand(st)), ymax+50, j + .8*incz*(-.2 + rand(st))>;
			#local Norm = <0,0,0>;
			#local Intersec = trace(obj, Start, -y, Norm);

			#if ((Norm.x != 0) | (Norm.y != 0) | (Norm.z != 0))

				#if (Intersec.y > ymin)
				object {
					Pierre(<.1+.3*rand(st), .05+.2*rand(st), .1+.3*rand(st)>, rand(st))
					translate .02*y
					#if (vdot(Norm,y) < 1.0 )
					Reorient(y, Norm)
					#end
					scale sc
					translate Intersec
				}
				#end
			#end
		
			#local j = j+incz;
		#end

		#local i = i+incx;
	#end

#end

