//=========================================================================
//      INCLUDE FILES, SETTINGS
//=========================================================================
#version unofficial MegaPov 0.5;
#include "colors.inc"
#include "metals.inc"
#declare r1=seed(0);
//=========================================================================
//      CAMERA, LUMIERE, ENVIRONNEMENT
//=========================================================================

//camera {location <20,20,25> direction z*2 look_at <0,0,0>}
//plane {y,0 pigment {White}}
sphere {0,15000 pigment {rgb <0.196078,.6,.8>+Gray20} finish {diffuse 0 ambient 1}}                                    
light_source {<40,50,-30>*100 rgb <1,1,.95>*2.5} 
light_source {<40,50,-30>*100 rgb <.95,.95,1>*.7 shadowless rotate y*180} 

//=========================================================================
//      DEFINITION DE TEXTURES
//=========================================================================
#include "wild-tex.inc"
#declare H2O=material
{
texture {
         pigment {rgbft <.89,.97,1,.1,.7>}
         finish {blinn 5 facets .3 
                 phong .3
                 reflection_type 1 reflection_min .1 reflection_max 1 conserve_energy
                 }                 
}                 
interior {ior 1.33}
}
    
#declare H2OB=material
{
texture {
         pigment {rgbft <.85,.95,1,.1,.8>}
         finish {blinn 5 facets .3 
                 phong .3
                 reflection_type 1 reflection_min .1 reflection_max 1 conserve_energy
                 }
}  
interior {ior 1.33}
}    

#declare MoussePierre = 
 texture {
 slope y
 texture_map { 
 [0 Pierre02]
 [.98 Pierre02]
 [1 Mousse]
 }}

#declare RayPlante = 
   pigment
   {
      radial
      color_map
      {
         [ 0.0     rgbft <0.041667, 0.458333, 0.229848, 0.0, 0.0> ]
         [ 0.125   rgbft <0.337991, 0.539701, 0.236332, 0.0, 0.0> ]
         [ 0.25    rgbft <0.37965, 0.59189, 0.222556, 0.0, 0.3229> ]
         [ 0.375   rgbft <0.424026, 0.528587, 0.324271, 0.0, 0.0> ]
         [ 0.587189  rgbft <0.444382, 0.574795, 0.29727, 0.0, 0.0> ]
         [ 0.625   rgbft <0.852092, 0.832787, 0.543708, 0.0, 0.291667> ]
         [ 0.640569  rgbft <0.485862, 0.634552, 0.275925, 0.0, 0.0> ]
         [ 0.875   rgbft <0.506987, 0.648102, 0.281581, 0.0, 0.364567> ]
         [ 1.0     rgbft <0.0, 0.437467, 0.197576, 0.0, 0.0> ]
      }
      turbulence .2
      lambda 3
      frequency 80
      ramp_wave
   }
//=========================================================================
//      DEFINITION DES ISOSURFACES
//=========================================================================
//H, lacunary, octaves, offset, gain
#declare Fun1=function {"ridgedmf", <.8, 2, 5, 1, 1.2>}
#declare FunP=function {x*0+y*1+z*0}
#declare FunS=function {x^2+y^2+z^2} 

#declare Rocher=isosurface { 
  function {FunP + Fun1/6}
                           
  threshold 0
  contained_by { box {-4,4} }
  accuracy .01
  method 2
  eval
  scale 10  
  rotate x*5
}

#declare SurfEau=isosurface { 
  function {FunP - Fun1/20}
                           
  threshold 0
  contained_by { box {-3,3} }
  accuracy .01
  method 2
  eval
  scale 10  
  translate y*-2.5 
} 
/*
#declare Pepite=isosurface { 
  function {FunS - Fun1/2
            }
                           
  threshold 1
  contained_by { box {-4,4} }
  accuracy .1
  method 2
  eval
  scale 2.5 
} */
//=========================================================================
//      PLANTES
//=========================================================================
#declare Brin1demi=
difference {
sphere {<0,0,0>,10}
sphere {<0,0,0>,10.1 scale <1,1,1.2> translate x*.2}
pigment {RayPlante}   
normal {radial .5  turbulence .2 lambda 3 frequency 80}
finish {phong .8 specular .4}
translate x*10   

rotate y*20  
clipped_by {plane {z,0}}
}

#declare Brin1=union {
object {Brin1demi}
object {Brin1demi scale <1,1,-1>}
} 

#declare Brin2demi=
difference {
sphere {<0,-10,0>,10}
sphere {<0,-10,0>,10 rotate x*1 rotate z*2}
translate y*10

pigment {RayPlante}
//pigment {Gray50}      
normal {radial .3  turbulence .2 lambda 3 frequency 80}
finish {phong 1 phong_size 10 specular .5}

translate x*10   
rotate y*20  
clipped_by {plane {z,0}}    
scale <1,1,.5>
}  

#declare Brin2=union {
object {Brin2demi}
object {Brin2demi scale <1,1,-1>}
} 

#declare EPig=pigment {wrinkles color_map {[0 Black][1 White]}}

#declare GroupePlantes1 = union {
#declare I=0;
#while (I < 50)
 #declare J=0;
 #while (J < 50)
    #declare Ev1=eval_pigment (EPig,<I,0,J>);
    #if (Ev1.x > .6)
     object {Brin2 scale <.3+Ev1.x,Ev1.x*5,.2> rotate y*1600*Ev1.x translate <I,0,J>}
    #else
    #end
 #declare J=J+4;
 #end
#declare I=I+4;
#end
}                 
//=========================================================================
//      PEPITES
//=========================================================================
#macro PepiteMac (RayPep,NbFacesPep)
 #debug "macropepite"
 intersection
 {
 #local I=0;
 #while (I < NbFacesPep)
  plane {y,0
       translate y*RayPep*(.7+rand(r1)*.3) rotate <rand(r1)*360,rand(r1)*360,rand(r1)*360>}

 #local I=I+1;
 #end
 bounded_by {sphere {0,RayPep*2}}
 }
#end

#declare EPig=pigment {agate color_map {[0 Black][1 White]} scale 100}

#macro VerticFall (Obj1,Position)
 trace (Obj1, Position, -y)
 //#declare OutNorm=OutNorm;
#end

#declare Pepite2=sphere {0,10}

#declare GroupePepites=union {
#declare I=0;
#while (I < 125)
  #declare A=-20+rand(r1)*60;
  #declare B=-20+rand(r1)*60;
    #declare Ev1=eval_pigment (EPig,<A,0,B>);
    #declare Ev2=eval_pigment (EPig,<B,0,A>);
    #if (Ev1.x > .1)
     //sphere {0,Ev1.x*2 translate <A,Ev1.x*2,B>} 
     #declare PosVertic =  VerticFall (Rocher,<A,10,B>);   
     #declare Pepite2=PepiteMac (5,25)
     object {Pepite2 scale .05+Ev2.x*.05 translate <A,
     PosVertic.y
     ,B>}
    #else
    #end
#declare I=I+1;
#end                
texture {T_Gold_4B finish {reflection .15 reflect_metallic metallic off phong 1.5}}
//pigment {Red}
}                                

#include "brindherbe.inc"

#declare CompteHerbes = 0;

#declare Herbes=union {
#declare I=0;
#while (I < 2625)
  #declare A=-20+rand(r1)*60;
  #declare B=-20+rand(r1)*60;
    #declare Ev1=eval_pigment (EPig,<A,0,B>);
    #declare Ev2=eval_pigment (EPig,<B,0,A>);
    //#if (Ev1.x > .1)
     //sphere {0,Ev1.x*2 translate <A,Ev1.x*2,B>} 
     #declare PosVertic =  VerticFall (Rocher,<A,10,B>);   
     
     #if (PosVertic.y > -2)
     //sphere {<0,0,0>,.5 translate <A,PosVertic.y,B>}
     object {BrinHerbe scale .3+Ev2.x*.2 rotate y*Ev2.x*360 translate <A,PosVertic.y,B> 
     #declare CompteHerbes = CompteHerbes+1;
     //pigment {rgb <0.349+(Ev2.x*.3),0.541+(Ev2.x*.12),0.212+(rand(r1)*.16)>}    
     }
     #else #end
     
    //#else #end
#declare I=I+1;
#end                
pigment {wrinkles color_map {[0 rgb <0.349,0.541,0.212>][1 rgb <0.349+.3,0.541+.12,0.212+.16>]} scale 10}
}                                
#debug "nombre de brins :   "
#debug str(CompteHerbes,3,0)
#debug "\n"                 

object {Herbes}

//=========================================================================
//      PLACEMENTS
//=========================================================================
object {Rocher texture {MoussePierre}}
object {SurfEau material {H2O}}
object {GroupePlantes1 scale .3 translate <-15,-5,0>}
object {GroupePepites}

//#include "grille.inc"

camera {location <20,20,25> direction z*2 look_at <0,0,0>}

global_settings 
{
ini_option "+q9"
}