/*
 *	"Sunrise over Lake Solitude"
 *
 *	Created for the IRTC topic "Wilderness"
 *	Copyright Mark Wagner 2000
 *
 */

//	rocks.inc
//  Contains all textures and models relating to rocks.

#ifndef(included)
    #declare cm = 1/(30.48 * 100);
    #include "units.inc"
#end

/* Rock texture based on that from "Alexander Bay" */
#declare Rocktext = pigment {
  granite
  color_map {
    [0.00 rgb <0.2,0.25,0>]
    [0.30 rgb <1,0.85,0.8>]
    [0.7 rgb <1,0.85,0.8>]
    [1.00 rgb <1,1,1>]
    }
  scale 1
  }

#declare Rocktext2 = pigment {
  bozo
  color_map {
    [0.25 rgbt <1,1,1,1>]
    [0.375 rgbt <1,1,1,0.3>]
    [0.5 rgbt <1,1,1,1>]
    [0.625 rgbt <0,0,0,1>]
    [0.75 rgbt <0,0,0,0.7>]
    [1 rgbt <0,0,0,1>]
    }
  scale 50
  }

#declare Rocknorm = normal {
  wrinkles 1 scale 20 turbulence 0.4 }

#declare Rock1 =
  texture { pigment {Rocktext}
    normal {Rocknorm}
    finish { diffuse 0.3 phong 0.3 phong_size 200 }
    }
  texture { pigment {Rocktext2}
    normal {Rocknorm}
    finish { diffuse 0.3 phong 0.3 phong_size 200 }
    }

#declare Rock2 =
  texture { pigment {Rocktext}
    normal {Rocknorm}
    finish { diffuse 0.7 ambient 0.2 }
    }
  texture { pigment {Rocktext2}
    normal {Rocknorm}
    finish { diffuse 0.7 ambient 0.2 }
    }
    
#declare Rock = 
  texture {
    gradient y
    texture_map {
      [ 0.08 Rock1 scale 0.01]
      [ 0.15 Rock2 scale 0.01]
      }
    turbulence 0.1
    scale 100
    translate <0,-55,0>
    }

#declare BigRock1 = blob {
  threshold 0.56
  sphere { <0,0,0>,1,1
    scale <144,60,84>
    }
  sphere { <0,0,0>,1,1
    scale < 36, 20, 60>
    rotate < 20, -50, 0>
    translate < 0, 15, 20>
    }
  sphere { <0,0,0>,1,1
    scale < 50, 10, 30>
    rotate < 20, 0, -10>
    translate < 10, 20, 20>
    }
  sphere { <0,0,0>,1,1
    scale < 150, 20, 40>
    rotate < 0, 0, 0>
    translate < -50, -10, 10>
    }
  sphere { <0,0,0>,1,-0.5
    scale < 40, 30, 90>
    rotate < 0, 0, 0>
    translate < 80, -25, 0>
    }
  sphere { <0,0,0>,1,-0.5
    scale < 60, 20, 30>
    rotate < 0, 0, 0>
    translate < 20, -25, 50>
    }
  sphere { <0,0,0>,1,-0.5
    scale < 60, 20, 80>
    rotate < 0, 10, 10>
    translate < 20, 30, 10>
    }
  rotate <0,-20,0>
  scale 1/4
  texture { Rock }
  scale feet
  }


#ifndef(included)
    object{BigRock1}
    plane{y, -50*feet pigment{checker rgb <0,.9,0>, rgb <0,.7,0> scale 50*feet}}
    camera{location 150*feet look_at 0}
    light_source{10000*feet, 1}
#end