 cave.inc      
o 8"
oD  PYx^Cx   
oTEXTMPS           :K  6uеk                      =  // Persistence Of Vision INCLUDE file
// File:        cave.inc
// Vers:        3.1g.r1 Mac PPC
// Desc:        Cave and cave people.
// Auth:        Peter Murray
// Date:        19th June 2000.

#debug "\r  cave.inc - Cave and cave people.\r"

// Measurements might already be defined.
#ifndef(in)
	#declare in = 1;
	#declare ft = 12;
	#declare yd = 36*in;
	#declare mi = 5280*ft;
#end

sky_sphere {
  pigment {
    gradient y
    colour_map {
      [0.500 colour rgb <0.75, 0.40, 0.20>*0.75]
      [0.800 colour rgb <0.50, 0.50, 1.00>*1.0]
      [1.000 colour rgb <0.00, 0.00, 0.60>*0.5]
    }
    scale 2
    translate -1
  }
}

// Textures come from furs.inc

// Objects

#declare RockStrength=5;
#declare WallStrength=250;
#declare HillStrength=200;

#declare FlameWd=5*in;
#declare FlameShape=
merge{
	sphere{<0,0,0>,FlameWd/3}
	cone{<0,0,0>,FlameWd/3,<0,FlameWd*2/3,0>,0}
	cone{<0,FlameWd*2/3,0>,FlameWd/4,<FlameWd/4,FlameWd*4/3,0>,0}
	cylinder{<0*FlameWd/4,FlameWd*4/3,0>,<FlameWd/4,FlameWd*2,0>,.2}
	hollow
	interior{
		media{
			emission 1 //scattering{1,0.5}
			density{spherical
				colour_map{
					[ 0 colour rgbt <4, 0, 0, 1> ]
					[ 1 colour rgbt <4, 4, 0,-1> ]
				}
			}
		}
	}
	scale <1,1.5,1>
	texture{
		pigment{colour rgbt<1,1,1,1>}
	}
}

#declare Flame=
light_source{
	<0,2,0>*in
	colour rgb <0.95,0.70,0.35> looks_like{FlameShape}
	fade_distance 5*ft
	fade_power 1
}

#macro Flame2(FPos,FSiz)
merge{
  sphere {
    <0,0,0>,FSiz.x/3
  }
  cone {
    <0,0,0>,FSiz.x/3,<0,FSiz.y*2/3,0>,FSiz.x/4
  }
  cone {
    <0,FSiz.y*2/3,0>,FSiz.x/4,<FSiz.x/4,FSiz.y*4/3,0>,0
  }
  interior{
    media{
      emission 1
      density{
        spherical
        color_map {
          [ 0 color rgb <3, 0, 0> ]
          [ 1 color rgb <4, 4, 0>]
        }
      }
    }
  }
  texture{
    pigment{colour rgbt<1,1,1,1>}
  }
  hollow
  scale <1,1.5,1>
  translate FPos
}
#end

#macro UpTo(Vector1,Vector2,Seed)
	<Vector1.x+(Vector2.x-Vector1.x)*rand(Seed),
	 Vector1.y+(Vector2.y-Vector1.y)*rand(Seed),
	 Vector1.z+(Vector2.z-Vector1.z)*rand(Seed)>
#end

#macro Place(baseLocation,minoffsetXYZ,maxoffsetXYZ,objectList)
object{
	#local objectNo=floor(dimension_size(objectList,1)*rand(TreeNo));
  objectList[objectNo]
	rotate UpTo(<0,0,0>,<5,360,5>,TreeRot)
	translate baseLocation
	#write(DebugFile,"Tree at ",baseLocation," is ",objectNo,"; ")
	#local TempXYZ=UpTo(minoffsetXYZ,maxoffsetXYZ,TreePos);
	#local baseLocation=baseLocation+TempXYZ;
	#write(DebugFile,TempXYZ,"\n")
}
#end

#declare CaveInterior=
blob{
	threshold 0.6
	cylinder{<0,0,-8>*ft,<0,8,-4>*ft,5*ft,RockStrength}//entrance
	cylinder{<0,-1,-4>*ft,<0,6,-4>*ft,5*ft,RockStrength}//entrance
	cylinder{<0,4,0>*ft,<0,6,0>*ft,8*ft,3*RockStrength}//centre
	cylinder{<0,2,0>*ft,<2,4,0>*ft,4*ft,2*RockStrength}//centre
	cylinder{<0,3,8>*ft,<0.5,7.5,8>*ft,7*ft,RockStrength}//back
	cylinder{<0,0,14>*ft,<0.5,7.5,14>*ft,7*ft,RockStrength}//back
	cylinder{<0,0,20>*ft,<0.5,7,20>*ft,7*ft,RockStrength}//back
	cylinder{<0,0,26>*ft,<0.5,6.5,26>*ft,7*ft,RockStrength}//back
	cylinder{<-7,0,0>*ft,<-5,6,0>*ft,4*ft,RockStrength}//left
	cylinder{<8,0,0>*ft,<6,5,0>*ft,4*ft,1.5*RockStrength}//right
	cylinder{<7,0,4>*ft,<7,6,5>*ft,4*ft,RockStrength}//right
	cylinder{<0,3,3>*ft,<0,8,5>*ft,10*ft,RockStrength}//mid
	cylinder{//floor
		<0,-2,-8>*ft,<0,-2,28>*ft,4*ft,-RockStrength
		scale <7,1,1> //texture{pigment{Red}}
	}
}

#declare RockWall=
blob{
	threshold 0.25
	//left
	cylinder{<-20,-8,-5>*ft,<-19,17,-4>*ft,6*ft,WallStrength}
	cylinder{<-17,-8,-4>*ft,<-16,17,-3>*ft,6*ft,WallStrength}
	cylinder{<-15,-7,-6>*ft,<-13,16,-4>*ft,3*ft,WallStrength}
	cylinder{<-12,-6,-5>*ft,<-12,15,-2>*ft,4.5*ft,WallStrength}
	cylinder{<-9,-5,-5>*ft,<-8,17,-2.5>*ft,3*ft,WallStrength}
	cylinder{<-8.5,-3,-3>*ft,<-6,15,-2>*ft,3.5*ft,WallStrength}
	//right
	cylinder{<7.5,-2,-3.5>*ft,<4,17,-1.5>*ft,4.5*ft,WallStrength}
	cylinder{<9,-6,-4>*ft,<7,17,-2.5>*ft,4*ft,WallStrength}
	cylinder{<12,-6,-3>*ft,<11.5,15,-2>*ft,4.5*ft,WallStrength}
	cylinder{<16,-7,-4>*ft,<14,16,0>*ft,3*ft,WallStrength}
	cylinder{<19,-6,-2>*ft,<18,13,-1>*ft,3*ft,WallStrength}
	cylinder{<21,-5,-5.5>*ft,<19,13,-2>*ft,2.5*ft,WallStrength}
	cylinder{<22,-5,-4>*ft,<21,15,-3>*ft,3*ft,WallStrength}
	//floor/ledge/path
	cylinder{<-7,-5,-2>*ft,<8,-3,-2>*ft,3.5*ft,WallStrength}
	cylinder{<-7,-7,-4.5>*ft,<8,-4,-3.5>*ft,4.5*ft,WallStrength}
	cylinder{<-25,-8,-5>*ft,<25,-7,-4>*ft,3*ft,WallStrength}
	cylinder{<-25,-7,-6.5>*ft,<25,-6,-5.5>*ft,3*ft,WallStrength}
	cylinder{<-25,-8,-8>*ft,<25,-7,-7>*ft,4.5*ft,WallStrength}
	cylinder{<-25,-8,-9.5>*ft,<25,-7,-8.5>*ft,3*ft,WallStrength}
	cylinder{<-25,-9,-11>*ft,<25,-8,-10>*ft,4.5*ft,WallStrength}
	cylinder{<-25,-7.5,-12>*ft,<25,-8,-11.5>*ft,3*ft,WallStrength}
	cylinder{<-25,-8,-13>*ft,<25,-9,-13>*ft,4.5*ft,WallStrength}
	//upper rock wall
	cylinder{<-9,13,-1>*ft,<8,12,-1>*ft,3.5*ft,WallStrength}
	cylinder{<-7,15,-2>*ft,<6,14,-1.5>*ft,3*ft,WallStrength}
	cylinder{<-20,17,-3>*ft,<20,15,-2>*ft,3*ft,WallStrength}
	texture{CaveRock}
}

#declare Hill1=
blob{
	threshold 0.25
	sphere{<-200,0,0>*ft,300*ft,HillStrength scale <1,0.75,1>}
	sphere{<0,0,0>*ft,400*ft,HillStrength scale <1,0.5,1>}
	sphere{<200,0,0>*ft,300*ft,HillStrength scale <1,0.75,1>}
	sphere{<-150,0,150>*ft,200*ft,HillStrength}
	sphere{<-100,0,100>*ft,100*ft,HillStrength}
	sphere{<100,0,100>*ft,100*ft,HillStrength}
	sphere{<-75,0,100>*ft,300*ft,HillStrength}
	sphere{<75,0,150>*ft,300*ft,HillStrength}
	sphere{<-50,125,200>*ft,200*ft,HillStrength}
	sphere{<50,125,200>*ft,200*ft,HillStrength}
	sphere{<-50,0,250>*ft,200*ft,HillStrength}
	sphere{<25,0,200>*ft,150*ft,HillStrength}
	sphere{<200,0,25>*ft,150*ft,HillStrength}
	sphere{<100,0,50>*ft,150*ft,HillStrength}
	sphere{<-50,150,25>*ft,300*ft,HillStrength}
	scale <1,0.25,1>
	texture{Hills}
}

#declare Fire=
union{
  cylinder{<0,0,0>*in,<0,3,0>*in,6*in}
  cylinder{<-7,3,0>*in,<3,3,0>*in,2*in}
  cylinder{<-2,3,7>*in,<1,3,-2>*in,2*in}
	texture{
	  pigment{
			agate
			colour_map{
				[0.0 colour rgb <0.2,0.2,0.0>]
				[0.5 colour rgb <0.2,0.2,0.0>]
				[1.0 colour rgb <0.1,0.1,0.1>]
			}
		}
	}
	rotate z*40 rotate x*30
}

#declare CaveScene=
union{
	difference{
		union{
			object{RockWall}
			box{<-12,-10,-5>*ft,<12,17,30>*ft}
			translate <0,0,-1>*ft
		}
		object{CaveInterior}
		#if (Silly=1)
			box{<-25,3,-20>*ft,<25,17,31>*ft}//picture window
		#end
		//box{<-25,3,-20>*ft,<25,40,31>*ft}//cut-away to position characters
	}
	object{Fire translate <6.5,-1,1.5>*ft}
	object{Flame rotate y*90 translate <6.6,-0.5,1.5>*ft}//<4.5,1,9>*ft
	object{Flame2(<6.75,-0.25,1.5>*ft,<2,7,2>*in)}
	object{Flame translate <6.4,-0.5,1.25>*ft}//<3.75,0.25,8.5>*ft
	#if (Silly=1)
		#local HFlesh=texture{pigment{colour rgb <0.79,0.45,0.31>}}
		#local HHair =texture{pigment{colour rgb <0.70,0.30,0.15>}}
		#local Furskin=texture{Woven}
		#include "cavepizza.cst"
		object{// cave pizza delivery guy
			RTDH2(<0,1.16,-8>*ft,<0,195,0>,
				array[7]{<1.05,1.1,1>,<1.05,1.2,1>,<1.05,1.1,1>,<1.05,1.1,1>,
					<1.05,1.1,1>,<1.05,0.8,1>,<1.05,0.8,1>},
				array[11]{<-10,5,0>,<25,0,0>,<120,-20,0>,<-10,0,5>,<100,-10,0>,<15,0,0>,<-10,0,0>,<0,10,0>,<0,0,0>,<0,0,90>,<0,0,-90>},
				array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
		}
	#end
	// Include the family
	#local HFlesh=texture{pigment{colour rgb <0.79,0.45,0.31>}}
	#local HHair =texture{pigment{colour rgb <0.55,0.33,0.15>}}
	#local Furskin=texture{Leather}
	#include "cavemom.cst"
	object{//cave mom
		RTDH2(<8.5,-3,0.75>*ft,<0,125,0>,
			array[7]{<1,1,1>,<1,1,1>,<1.2,1.3,1.2>,<1.2,1.3,1.2>,
				<1.2,1.2,1.2>,<1.2,1,1.1>,<1.2,1,1.1>},
			array[11]{<0,15,-15>,
				<15,0,-25>,<15,0,50>,<20,0,0>,<40,0,0>,
				<80,0,0>,<-90,0,-6>,<75,0,-5>,<-90,0,-10>,
				<0,0,30>,<0,0,0>
			},
			array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
	}
	#local HFlesh=texture{pigment{colour rgb <0.82,0.48,0.34>}}
	#local HHair =texture{pigment{colour rgb <0.63,0.56,0.59>}}
	#local Furskin=texture{Panther}
	#include "cavegran.cst"
	object{//cave gran
		RTDH2(<7.0,-1,-1.0>*ft,<0,180,0>,
			array[7]{<1,1,1>,<1,1,1.2>,<1.2,1.3,1.2>,<1.2,1.3,1.2>,
				<1.2,1.2,1.5>,<1.2,1,1.1>,<1.2,1,1.1>},
			array[9]{<-20,15,0>,<5,0,-10>,<5,0,0>,<0,0,10>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
			array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
	}
	#local HFlesh=texture{pigment{colour rgb <0.79,0.45,0.31>}}
	#local HHair =texture{pigment{colour rgb <0.29,0.19,0.00>}}
	#local Furskin=texture{Eland scale 0.5}
	#include "cavedad.cst"
	object{//cave dad
		RTDH2(<-5.65,-1.5,5.1>*ft,<0,255,-20>,
			array[7]{<1.3,1.1,1.3>,<1.5,1.43,2>,<1.6,1.48,1.6>,<1.6,1.48,1.6>,
				<1.4,0.62,2>,<1.25,1.067,1.09>,<1.25,1.067,1.09>},
			array[13]{<0,-10,0>,
				<-10,0,-15>,<10,0,-20>,<0,0,0>,<40,0,20>,
				<60,0,3>,<-95,0,8>,<55,0,6>,<-95,0,8>,
				<0,-40,-80>,<40,70,30>,<0,0,0>,<-60,0,0>
			},
			array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
	}
	object{
		Spear1 rotate z*85 rotate y*80 rotate x*-12
		translate <-3.0,-1.1,1.75>*ft
	}
	#local HFlesh=texture{pigment{colour rgb <0.79,0.45,0.31>}}
	#local HHair =texture{pigment{colour rgb <0.35,0.25,0.12>}}
	#local Furskin=texture{Eland scale 0.5}
	#include "cavekid1.cst"
	object{// cave kid 1
		RTDH2(<6.0,-2.5,4.0>*ft,<15,-10,2>,
			array[7]{<0.83,0.94,0.875>,<0.875,1.21,1>,<1,0.89,1>,<1,0.89,1>,
				<0.8,0.46,1>,<0.78,0.87,0.78>,<0.78,0.87,0.78>},
			array[11]{<0,-30,0>,
				<20,-10,-10>,<40,0,5>,<30,0,10>,<60,0,0>,
				<45,0,0>,<-90,0,0>,<50,0,0>,<-90,0,0>,
				<0,0,0>,<0,0,0>
			},
			array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
	}
	#if (Silly=0)
		#local HFlesh=texture{pigment{colour rgb <0.85,0.55,0.42>}}
		#local HHair =texture{pigment{colour rgb <0.31,0.25,0.15>}}
		#local Furskin=texture{Panther}
		#include "cavekid2.cst"
		object{//cave kid 2
			RTDH2(<-2.7,-1.85,-5.9>*ft,<0,-90,0>,
				array[7]{<0.83,0.89,0.625>,<0.75,0.78,1>,<0.8,0.89,0.8>,<0.8,0.89,0.8>,
					<0.7,0.54,1>,<0.625,0.8,0.625>,<0.625,0.8,0.625>},
				array[13]{<0,0,0>,
					<90,0,-10>,<210,0,0>,<-10,0,0>,<12,0,0>,
					<100,0,0>,<-30,0,0>,<50,0,5>,<25,0,0>,
					<0,0,-60>,<0,0,0>,<-30,0,0>,<0,0,0>
				},
				array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
		}
	#end
	#local HFlesh=texture{pigment{colour rgb <0.79,0.45,0.31>}}
	#local HHair =texture{pigment{colour rgb <0.70,0.30,0.15>}}
	#local Furskin=texture{Eland scale 0.5}
	#include "cavekid3.cst"
	object{//cave kid 3
		RTDH2(<0,0,0>,<-10,0,0>,
			array[7]{<0.75,0.89,0.75>,<0.68,0.71,0.875>,<0.8,0.63,0.8>,<0.8,0.63,0.8>,
				<0.6,0.46,0.8>,<0.47,0.43,0.47>,<0.47,0.43,0.47>},
			array[9]{<15,20,0>,
				<50,0,-10>,<110,-20,5>,<20,0,10>,<75,30,0>,
			  <-5,0,0>,<-14,0,0>,<-17,0,0>,<-47,0,0>
			},
			array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
		rotate <0,290,0>
		translate <0,-1.4,5>*ft
	}
	texture{CaveRock}
	translate <0,2,0>*ft
}

object{CaveScene}

// Ground/landscape

union{
	difference{
		plane{y,0.0*ft hollow on texture{Ground2}}//basic ground level
		difference{
			torus{2050*ft,60*ft translate <0.05,0,-1>*mi}
			box{<0.55*mi,-20*ft,-1.5*mi>,<0.05*mi,20*ft,-0.5*mi> rotate y*3}
		}
		difference{
			torus{2050*ft,60*ft translate <-0.15,0,-1.75>*mi}
			box{<-0.65*mi,-20*ft,-2.25*mi>,<-0.1*mi,20*ft,-1.5*mi>}
			box{
				<-0.65*mi,-20*ft,-2*mi>,<-0.1*mi,20*ft,-1.2*mi>
				translate <0.65,0,1.75>*mi rotate y*8 translate <-0.65,0,-1.75>*mi 
			}
		}
		sphere{
			<0,0,0>,100*ft scale <9,0.01,4>
			translate <0.05,0,-.6>*mi
		}
		cone{
			<0,0,0>,60*ft,<3000,0,1800>*ft,80*ft scale <1,0.1,1>
			translate <0.05,0,-.6>*mi
		}
		sphere{
			<0,0,0>,100*ft scale <4,0.01,2> rotate y*-40
			translate <0.16,0,-.55>*mi
		}
		sphere{
			<0,0,0>,100*ft scale <4,0.01,2> rotate y*-40
			translate <-0.12,0,-.64>*mi
		}
	}
	plane{y,-0.25*ft texture{River}}//water table under ground
	object{Hill1 scale <1,2,1> rotate y*-45 translate <0.05,0,-1>*mi}
	object{Hill1 scale <1,1.5,1> rotate y*60 translate <-0.15,0,-1.75>*mi}
	object{Hill1 rotate y*-40 translate <0.25,0,-4>*mi}
	object{Hill1 scale <1,2,1> rotate y*30 translate <-0.1,0,-7>*mi}
	// Birds
	object{Rook(0,<0,-80,0>,
		array[7]{<0,0,0>,<0,0,0>,<0,-10,-20>,<0,15,15>,<0,15,-20>,<0,-20,-10>,<20,0,0>}
		)
		rotate x*30 translate <-9,155,-55>*ft
	}
	object{Rook(<2,155,-80>*ft,<0,-90,-40>,
		array[7]{<0,35,0>,<-20,0,0>,<0,-10,-20>,<0,20,15>,<0,10,25>,<0,-25,-30>,<0,0,0>}
	)}
	object{Rook(<-2,157,-80>*ft,<0,-90,-40>,
		array[7]{<0,-5,0>,<-10,0,0>,<0,-30,20>,<0,20,30>,<0,20,15>,<0,-20,-30>,<10,30,0>}
	)}
	object{Rook(<-6,151,-60>*ft,<0,-80,-50>,
		array[7]{<0,1,0>,<-20,0,0>,<0,0,-45>,<0,0,20>,<0,0,45>,<0,0,-20>,<-20,0,0>}
	)}
	object{Rook(<-8,160,-55>*ft,<0,-80,-10>,
		array[7]{<0,1,0>,<-20,0,0>,<0,0,-45>,<0,0,5>,<0,0,45>,<0,0,-5>,<0,0,0>}
	)}
	// Trees
	#declare Position=<-500,0.1,-300>*ft;
	// Trees this side of the river
	#while (Position.z>-3150*ft)
		#while (Position.x<400*ft)
			Place(
				Position,<50,0,-25>*ft,<125,0,25>*ft,
				array[7]{TreeF1a,TreeF1b,TreeF2a,TreeF3a,TreeF3b,TreeF4a,TreeF5}
			)
		#end
		#local NPosition=<(UpTo(<-575,0,0>*ft,<-525,0,0>*ft,TreePos)).x,
			Position.y,
			Position.z-(UpTo(<0,0,40>*ft,<0,0,100>*ft,TreePos)).z>;
			#local Position=NPosition;
	#end
	#local Position=<Position.x,Position.y,-3350*ft>;
	// Trees the other side of the river
	#while (Position.z>-7500*ft)
		#while (Position.x<400*ft)
			Place(
				Position,<50,0,-25>*ft,<125,0,25>*ft,
				array[7]{TreeF1a,TreeF1b,TreeF2a,TreeF3a,TreeF3b,TreeF4a,TreeF5}
			)
		#end
		#local NPosition=<(UpTo(<-975,0,0>*ft,<-925,0,0>*ft,TreePos)).x,
			Position.y,
			Position.z-(UpTo(<0,0,40>*ft,<0,0,100>*ft,TreePos)).z>;
			#local Position=NPosition;
	#end
	translate <0,-140*ft,0>
	rotate x*7 //tilt it slightly because I want to see the water!
}

// Sky

plane{
  <0,1,-0.002>,5*mi hollow
  pigment{
    bozo
    turbulence 0.65
    octaves 6
    omega 0.8
    lambda 2
    colour_map{
      [0.00 colour rgb  <0.95, 0.95, 0.95>*1.3]
      [0.40 colour rgb  <0.90, 0.90, 0.90>*1.3]
      [0.41 colour rgb  <0.90, 0.70, 0.70>*1.3]
      [0.60 colour rgbt <1.00, 1.00, 1.00, 1.00>]
      [1.00 colour rgbt <1.00, 1.00, 1.00, 1.00>]
    }
    scale 500000
		rotate z*-30
  }
}

plane{
  <0,1,-0.002>,6*mi hollow
  pigment{
    bozo
    turbulence 0.65
    octaves 6
    omega 0.8
    lambda 2
    colour_map{
      [0.00 colour rgb  <0.95, 0.95, 0.95>*1.5]
      [0.35 colour rgb  <0.90, 0.90, 0.90>*1.5]
      [0.40 colour rgbt <1.00, 1.00, 1.00, 1.00>]
      [1.00 colour rgbt <1.00, 1.00, 1.00, 1.00>]
    }
    scale 600000
		rotate z*-30
  }
}

light_source{//rising sun
  <8000,1000,-500>*ft
  colour rgb <1.0,0.8,0.4>*2.5
}


// credits object
union{
	text{
		ttf "PALATINO.TTF","pdmcave.jpg",2,0
		scale <3,3,0.15>
		translate <0,0,0>*in
	}
	text{
		ttf "PALATINO.TTF","Peter Murray  29Jun2000",2,0
		scale <3,3,0.15>
		translate <0,-3,0>*in
	}
	text{
		ttf "PALATINO.TTF","\"Wilderness\"",2,0
		scale <3,3,0.15>
		translate <0,-6,0>*in
	}
	text{
		ttf "PALATINO.TTF","Internet Raytracing Competition",2,0
		scale <2,2,0.15>
		translate <0,-9,0>*in
	}
	rotate y*180 rotate x*-70
	translate <1.5,1.75,10>*ft
	texture{Gold_Metal}
}


                                                                zALTHALTH                       cave.incave0(EX) Apr 20009elerm TEXTMPS                       u  :K  6             )%JVWRBMPp                              +%JVWRJFIF                              ,%JVWRPNTG                          %  %         
 
    
         $  6                             H 	Monaco 
  
      3* b Bk  :K  :K  7      3* b B  7                     z
VO    z SELc   "MPSR  .styl   FNwPo   R           N       
U           &                                                                              