 	rtdhc.inc      
o 8"
oD  PYx^Lp   
oTEXTMPS         l>  lq                       U  // Persistence Of Vision INCLUDE file
// File:        rtdhc.inc
// Vers:        3.1g.r1 Mac PPC
// Desc:        Simplified humans that can wear clothes
// Uses:				.cst costume files
// Auth:        Peter Murray

#debug "\r  rtdhc.inc - define Render Test Dummy - Human, costumable\r"

/*
Macros:
	(all figures share the basic textures)
	("HFlesh" = skin)
   RTDH2 Costumable
*/

// Measurements might already be defined.
#ifndef(in)
	#declare in = 1;
	#declare ft = 12;
#end

#declare HFlesh=
texture{
	pigment{
		colour rgb <.97,.82,.75>//<.76,.58,.45>
	}
}

/*
// Assumpta Fitzgerald
#local HFlesh=texture{pigment{colour rgb <0.89,0.51,0.46>}}
#local HHair =texture{pigment{colour rgb <0.29,0.19,0.00>}}
// Beth (Newsradio)
#local HFlesh=texture{pigment{colour rgb <0.86,0.69,0.68>}}
#local HHair =texture{pigment{colour rgb <0.72,0.41,0.24>}}
// Beverly Crusher
#local HFlesh=texture{pigment{colour rgb <0.81,0.59,0.62>}}
#local HHair =texture{pigment{colour rgb <0.64,0.43,0.25>}}
#local HHair2=texture{pigment{colour rgb <0.36,0.22,0.12>}}
// Data
#local HFlesh=texture{pigment{colour rgb <0.86,0.73,0.64>}}
#local HHair =texture{pigment{colour rgb <0.36,0.32,0.24>}}
// Deanna Troi
#local HFlesh=texture{pigment{colour rgb <0.84,0.66,0.59>}}
#local HHair =texture{pigment{colour rgb <0.52,0.39,0.23>}}
// Geordi LaForge
#local HFlesh=texture{pigment{colour rgb <0.33,0.22,0.10>}}
#local HHair =texture{pigment{colour rgb <0.07,0.08,0.08>}}
// Gloria (Newsradio)
#local HFlesh=texture{pigment{colour rgb <0.45,0.34,0.25>}}
#local HHair =texture{pigment{colour rgb <0.29,0.19,0.15>}}
// Happy Merryweather
#local HFlesh=texture{pigment{colour rgb <0.85,0.55,0.42>}}
#local HHair =texture{pigment{colour rgb <0.31,0.25,0.15>}}
// Jean-Luc Picard
#local HFlesh=texture{pigment{colour rgb <0.77,0.59,0.49>}}
#local HHair =texture{pigment{colour rgb <0.63,0.56,0.59>}}
// Joy Merryweather
#local HFlesh=texture{pigment{colour rgb <0.79,0.45,0.31>}}
#local HHair =texture{pigment{colour rgb <0.40,0.33,0.15>}}
// Liz (Newsradio)
#local HFlesh=texture{pigment{colour rgb <0.88,0.65,0.55>}}
#local HHair =texture{pigment{colour rgb <0.64,0.50,0.42>}}
// Worf
#local HFlesh=texture{pigment{colour rgb <0.51,0.35,0.32>}}
#local HHair =texture{pigment{colour rgb <0.23,0.17,0.12>}}
*/

#declare HEyes=
texture{
	pigment{colour rgb<.9,.9,.9>}
}

// To be replaced later by a macro
#declare RHand=
union{
	sphere{
		<0,-0.5,0>*in,0.5*in
		scale <1.5,4,3.0>
	}
	sphere{
		<-0.75,-0.75,1>*in,0.5*in
		scale <0.75,2,0.75>
	}
	cylinder{//thumb
		<0.5,-1.5,-1>*in,<0.5,-4,-1>*in,0.375*in
	}//fingers:
	cylinder{//first
		<0,-2.5,-0.75>*in,<0,-5.5,-0.75>*in,0.375*in
	}
	cylinder{//index
		<0,-3,-0.375>*in,<0,-6,-0.375>*in,0.375*in
	}
	cylinder{//middle
		<0,-3,0.375>*in,<0,-5.75,0.375>*in,0.375*in
	}
	cylinder{//little
		<0,-2.5,0.75>*in,<0,-4.75,0.75>*in,0.375*in
	}
}

#declare LHand=
union{
	sphere{
		<0,-0.5,0>*in,0.5*in
		scale <1.5,4,3.0>
	}
	sphere{
		<-0.75,-0.75,-1>*in,0.5*in
		scale <0.75,2,0.75>
	}
	cylinder{//thumb
		<-0.5,-1.5,-1>*in,<-0.5,-4,-1>*in,0.375*in
	}//fingers:
	cylinder{//first
		<0,-2.5,-0.75>*in,<0,-5.5,-0.75>*in,0.375*in
	}
	cylinder{//index
		<0,-3,-0.375>*in,<0,-6,-0.375>*in,0.375*in
	}
	cylinder{//middle
		<0,-3,0.375>*in,<0,-5.75,0.375>*in,0.375*in
	}
	cylinder{//little
		<0,-2.5,0.75>*in,<0,-4.75,0.75>*in,0.375*in
	}
}
/*
sphere{
	<0,-1,0>*in,1*in
	scale <1.25,2.5,1.75>
}
*/
//box{<-1.25*in,0,-1.75*in>,<1.25*in,-5*in,1.75*in>}

/*
	Parameters for all macros:
		plocn:	Origin of dummy in scene (groundlevel, between feet)
		prtn:	 	Rotation of whole figure
		psize:	Array[7] of size data
						0 Head, 1 Torso, 2 RArm, 3 LArm, 4 Hips, 5 RLeg, 6 LLeg
		prtns:	Array[9] of rotation data
						0 Head 1 right u arm 2 right l arm 3 left u arm 4 left l arm
						5 right u leg 6 right l leg 7 left u leg 8 left l leg
		pclths: placeholder variable
		prhead: Rotation of head relative to torso
		prtorso:Rotation of torso about waist
		prhips: Rotation of hips about waist
*/

#macro RTDH2 (plocn,prtn,psize,prtns,pclths,prhead,prtorso,prhips)
object{
	#if (dimension_size(psize,1)<7)
		#debug "\nError in RTDH2; sizes must be array[7].\n"
	#end
	#local Waist=<0,2*ft+9*in,0>*(psize[5]+psize[6])/2+<0,8*in,0>*psize[4];
	#local DraperyPoints=array[64]
	union{
		// Head
		union{
			// Neck
			cylinder{
				<0,0,0>,<0,3,0>,2*in
				scale <1,1,.5>
			}
			// Outline
			sphere{
				<0,0,0>,.5*in
				scale <6,8,6>
				translate <0,5*in,-1*in>
			}
			sphere{
				<0,0,0>,.5*in
				scale <6,7,8>
				translate <0,5.5*in,0>
			}
			// Eyes
			sphere{
				<0,0,0>,.5*in
				scale <1.5,1,1>
				translate <-2*in,5*in,-3.5*in>
				texture{HEyes}
			}
			sphere{
				<0,0,0>,.5*in
				scale <1.5,1,1>
				translate <2*in,5*in,-3.5*in>
				texture{HEyes}
			}
			// Nose
			cone{
				<0,0,0>*in,0,<0,-1.5,-0.3>*in,0.5*in
				scale <1.5,1,1>
				translate <0,5,-4>*in
			}
			#ifdef (HeadClothing)
				object{HeadClothing}
			#end
			scale psize[0]
			rotate prtns[0]
			rotate prhead+prtorso
			translate Waist+(vrotate(<0,1*ft+2*in,0>*psize[1],prtorso))
		}
		// Torso
		union{
			cone{
				<0,11*in,0>,5*in,<0,14*in,0>,2*in
			}
			cone{
				<0,7*in,0>,5.5*in,<0,11*in,0>,5*in
			}
			cone{
				<0,0,0>,5*in,<0,7*in,0>,5.5*in
			}
			#ifdef (TorsoClothing)
				object{TorsoClothing}
			#end
			// Upper shoulders
			/*
			cone{
				<0,10*in,0>,8*in,<0,11*in,0>,5*in
				scale <1,1,.5>
			}
			*/
			#local Rshld=vrotate(<-6*in,10*in,0>*psize[1],prtorso);
			#local Lshld=vrotate(<6*in,10*in,0>*psize[1],prtorso);
			#ifdef (ShoulderClothing)
				object{ShoulderClothing}
			#end
			scale <1,1,.5>*psize[1]
			rotate prtorso
			translate Waist
		}
		#local RInt=radians(22.5);
		// Store drapery values for top,shoulder: 0-7
		#local DraperyPoints[ 3]=<2.1,14,-2.2>*<sin(3*RInt),1,cos(3*RInt)>*<1,1,.5>*psize[1];
		#local DraperyPoints[ 2]=<2.1,14,-2.2>*<sin(RInt),1,cos(RInt)>*<1,1,.5>*psize[1];
		#local DraperyPoints[ 1]=DraperyPoints[ 2]*<-1,1,1>;
		#local DraperyPoints[ 0]=DraperyPoints[ 3]*<-1,1,1>;
		#local DraperyPoints[ 4]=DraperyPoints[ 0]*<1,1,-1>;
		#local DraperyPoints[ 5]=DraperyPoints[ 1]*<1,1,-1>;
		#local DraperyPoints[ 6]=DraperyPoints[ 2]*<1,1,-1>;
		#local DraperyPoints[ 7]=DraperyPoints[ 3]*<1,1,-1>;
		//adjust drapery
		#local DraperyPoints[ 0]=Waist+vrotate(DraperyPoints[ 0],prtorso);
		#local DraperyPoints[ 1]=Waist+vrotate(DraperyPoints[ 1],prtorso);
		#local DraperyPoints[ 2]=Waist+vrotate(DraperyPoints[ 2],prtorso);
		#local DraperyPoints[ 3]=Waist+vrotate(DraperyPoints[ 3],prtorso);
		#local DraperyPoints[ 4]=Waist+vrotate(DraperyPoints[ 4],prtorso);
		#local DraperyPoints[ 5]=Waist+vrotate(DraperyPoints[ 5],prtorso);
		#local DraperyPoints[ 6]=Waist+vrotate(DraperyPoints[ 6],prtorso);
		#local DraperyPoints[ 7]=Waist+vrotate(DraperyPoints[ 7],prtorso);
		// Store drapery values for top,collar: 0-7
		#local DraperyPoints[11]=<8.1,11,-6.1>*<sin(3*RInt),1,cos(3*RInt)>*<1,1,.5>*psize[1];
		#local DraperyPoints[10]=<8.1,11,-6.1>*<sin(RInt),1,cos(RInt)>*<1,1,.5>*psize[1];
		#local DraperyPoints[ 9]=DraperyPoints[10]*<-1,1,1>;
		#local DraperyPoints[ 8]=DraperyPoints[11]*<-1,1,1>;
		#local DraperyPoints[12]=DraperyPoints[ 8]*<1,1,-1>;
		#local DraperyPoints[13]=DraperyPoints[ 9]*<1,1,-1>;
		#local DraperyPoints[14]=DraperyPoints[10]*<1,1,-1>;
		#local DraperyPoints[15]=DraperyPoints[11]*<1,1,-1>;
		//adjust drapery
		#local DraperyPoints[ 8]=Waist+vrotate(DraperyPoints[ 8],prtorso);
		#local DraperyPoints[ 9]=Waist+vrotate(DraperyPoints[ 9],prtorso);
		#local DraperyPoints[10]=Waist+vrotate(DraperyPoints[10],prtorso);
		#local DraperyPoints[11]=Waist+vrotate(DraperyPoints[11],prtorso);
		#local DraperyPoints[12]=Waist+vrotate(DraperyPoints[12],prtorso);
		#local DraperyPoints[13]=Waist+vrotate(DraperyPoints[13],prtorso);
		#local DraperyPoints[14]=Waist+vrotate(DraperyPoints[14],prtorso);
		#local DraperyPoints[15]=Waist+vrotate(DraperyPoints[15],prtorso);
		// Right arm
		union{
			sphere{
				<0,0,0>,1*in scale <3,1.5,1.5>*psize[2] translate <3.5,0,0>*in
				rotate prtorso
				translate Rshld+Waist
			}
			sphere{
				<0,0,0>,1*in scale psize[2]
				rotate prtns[1]+prtorso
				translate Rshld+Waist
			}
			cone{
				<0,0,0>,1*in,<0,-9.5*in,0>,1*in
				scale psize[2]
				rotate prtns[1]+prtorso
				translate Rshld+Waist
				#local Relbw=Rshld+vrotate(<0,-9.5*in,0>*psize[2],prtns[1]+prtorso);
			}
			#ifdef (RuSleeveClothing)
				object{
					RuSleeveClothing
					scale psize[2]
					rotate prtns[1]+prtorso
					translate Rshld+Waist
				}
			#end
			sphere{
				<0,0,0>,1*in scale psize[2]
				rotate prtns[2]+prtorso
				translate Relbw+Waist
			}
			cone{
				<0,0,0>,1*in,<0,-9.5*in,0>,1.25*in
				scale psize[2]
				rotate prtns[2]+prtorso
				translate Relbw+Waist
				#local Rwrst=Relbw+vrotate(<0,-9.5*in,0>*psize[2],prtns[2]+prtorso);
			}
			sphere{
				<0,-9.5*in,0>,1.25*in
				scale psize[2]
				rotate prtns[2]+prtorso
				translate Relbw+Waist
			}
			#ifdef (RlSleeveClothing)
				object{
					RlSleeveClothing
					scale psize[2]
					rotate prtns[2]+prtorso
					translate Relbw+Waist
				}
			#end
			object{
				RHand
				scale psize[2]
				rotate prtns[2]
				#if (dimension_size(prtns,1)>9) rotate prtns[9] #end
				translate Rwrst+Waist
			}
			#ifdef (RHandClothing)
				object{
					RHandClothing
					scale psize[2]
					rotate prtns[2]
					#if (dimension_size(prtns,1)>9) rotate prtns[9] #end
					translate Rwrst+Waist
				}
			#end
		}
		// Left arm
		union{
			sphere{
				<0,0,0>,1*in scale <3,1.5,1.5>*psize[3] translate <-3.5,0,0>*in
				rotate prtorso
				translate Lshld+Waist
			}
			sphere{
				<0,0,0>,1*in scale psize[3]
				rotate prtns[3]+prtorso
				translate Lshld+Waist
			}
			cone{
				<0,0,0>,1*in,<0,-9.5*in,0>,1*in
				scale psize[3]
				rotate prtns[3]+prtorso
				translate Lshld+Waist
				#local Lelbw=Lshld+vrotate(<0,-9.5*in,0>*psize[3],prtns[3]+prtorso);
			}
			#ifdef (LuSleeveClothing)
				object{
					LuSleeveClothing
					scale psize[3]
					rotate prtns[3]+prtorso
					translate Lshld+Waist
				}
			#end
			sphere{
				<0,0,0>,1*in scale psize[3]
				rotate prtns[4]+prtorso
				translate Lelbw+Waist
			}
			cone{
				<0,0,0>,1*in,<0,-9.5*in,0>,1.25*in
				scale psize[3]
				rotate prtns[4]+prtorso
				translate Lelbw+Waist
				#local Lwrst=Lelbw+vrotate(<0,-9.5*in,0>*psize[3],prtns[4]+prtorso);
			}
			sphere{
				<0,-9.5*in,0>,1.25*in
				scale psize[3]
				rotate prtns[4]+prtorso
				translate Lelbw+Waist
			}
			#ifdef (LlSleeveClothing)
				object{
					LlSleeveClothing
					scale psize[3]
					rotate prtns[4]+prtorso
					translate Lelbw+Waist
				}
			#end
			object{
				LHand
				scale psize[3]
				rotate prtns[4]
				#if (dimension_size(prtns,1)>10) rotate prtns[10] #end
				translate Lwrst+Waist
			}
			#ifdef (LHandClothing)
				object{
					LHandClothing
					scale psize[3]
					rotate prtns[4]
					#if (dimension_size(prtns,1)>10) rotate prtns[10] #end
					translate Lwrst+Waist
				}
			#end
		}
		// Hips
		union{
			sphere{
				<0,0,0>,5*in
				scale <1,1,.5>*psize[4]
				translate Waist
				// Store drapery values for skirt,waist: 32-39
				#local DraperyPoints[35]=<5.1,0,-5.1>*<sin(3*RInt),1,cos(3*RInt)>*<1,1,.5>*psize[4];
				#local DraperyPoints[34]=<5.1,0,-5.1>*<sin(RInt),1,cos(RInt)>*<1,1,.5>*psize[4];
				#local DraperyPoints[33]=DraperyPoints[34]*<-1,1,1>;
				#local DraperyPoints[32]=DraperyPoints[35]*<-1,1,1>;
				#local DraperyPoints[36]=DraperyPoints[32]*<1,1,-1>;
				#local DraperyPoints[37]=DraperyPoints[33]*<1,1,-1>;
				#local DraperyPoints[38]=DraperyPoints[34]*<1,1,-1>;
				#local DraperyPoints[39]=DraperyPoints[35]*<1,1,-1>;
				//adjust drapery
				#local DraperyPoints[32]=Waist+vrotate(DraperyPoints[32],prhips);
				#local DraperyPoints[33]=Waist+vrotate(DraperyPoints[33],prhips);
				#local DraperyPoints[34]=Waist+vrotate(DraperyPoints[34],prhips);
				#local DraperyPoints[35]=Waist+vrotate(DraperyPoints[35],prhips);
				#local DraperyPoints[36]=Waist+vrotate(DraperyPoints[36],prhips);
				#local DraperyPoints[37]=Waist+vrotate(DraperyPoints[37],prhips);
				#local DraperyPoints[38]=Waist+vrotate(DraperyPoints[38],prhips);
				#local DraperyPoints[39]=Waist+vrotate(DraperyPoints[39],prhips);
			}
			cone{
				<0,0,0>,5*in,<0,-8*in,-3>,1*in
				//<0,0,0>,5*in,<0,-8*in,0>,6*in
				scale <1,1,.5>*psize[4]
				rotate prhips
				translate Waist
				#local Rhip=vrotate(<-3*in,-8*in,0>*psize[4],prhips);
				#local Lhip=vrotate(<3*in,-8*in,0>*psize[4],prhips);
			}
			#ifdef (HipsClothing)
				object{
					HipsClothing
					scale psize[4]
					rotate prhips
					translate Waist
				}
			#end
		}
		// Right leg
		union{
			sphere{
				<0.3,1.6,0.35>*in,3.2*in
				scale <1,1,1>*psize[5]
				translate Rhip+Waist
			}
			#ifdef (RHipsClothing)
				object{
					RHipsClothing
					scale psize[5]
					translate Rhip+Waist
				}
			#end
			cone{
				<0,0,0>,3*in,<0,8*in,0>,2*in
				scale psize[5]
				rotate prhips
				translate Rhip+Waist
			}
			cone{
				<0,0,0>,3*in,<0,-14*in,0>,1.5*in
				scale psize[5]
				rotate prtns[5]
				translate Rhip+Waist
				#local Rknee=Rhip+vrotate(<0,-14*in,0>*psize[5],prtns[5]);
				#local RkneeD=Rhip+vrotate(<0,-14*in,0>*psize[5],
					<min(0.5*prtns[5].x,prtns[5].x),prtns[5].y,min(0,0.5*prtns[5].z)>);
			}
			// Store drapery values for skirt,thigh: 40-41,44-45
			#local DraperyPoints[40]=<-2.6,-14,-2.6>*<sin(2*RInt),1/3,cos(2*RInt)>*psize[5];
			#local DraperyPoints[41]=<2.6,-14,-2.6>*<sin(RInt),1/3,cos(RInt)>*psize[5];
			#local DraperyPoints[44]=DraperyPoints[40]*<1,1,-1>;
			#local DraperyPoints[45]=DraperyPoints[41]*<1,1,-1>;
			//adjust drapery
			#local DraperyPoints[40]=Rhip+Waist+vrotate(DraperyPoints[40],
				<max(0,prtns[5].x),prtns[5].y,min(0,prtns[5].z)>);
			#local DraperyPoints[41]=Rhip+Waist+vrotate(DraperyPoints[41],
				<max(0.5*prtns[5].x,prtns[5].x),prtns[5].y,min(0,0.5*prtns[5].z)>);
			#local DraperyPoints[44]=Rhip+Waist+vrotate(DraperyPoints[44],
				<min(0,prtns[5].x),prtns[5].y,min(0,prtns[5].z)>);
			#local DraperyPoints[45]=Rhip+Waist+vrotate(DraperyPoints[45],
				<min(0.5*prtns[5].x,prtns[5].x),prtns[5].y,min(0,0.5*prtns[5].z)>);
			#ifdef (RThighClothing)
				object{
					RThighClothing
					scale psize[5]
					rotate prtns[5]
					translate Rhip+Waist
				}
			#end
			sphere{
				<0,0,0>,1.5*in
				scale psize[5]
				translate Rknee+Waist
			}
			cone{
				<0,0,0>,1.5*in,<0,-16*in,0>,1.5*in
				scale psize[5]
				rotate prtns[6]
				translate Rknee+Waist
				#local Rankl=Rknee+vrotate(<0,-16*in,0>*psize[5],prtns[6]);
			}
			// Store drapery values for skirt,knee: 48-49,52-53
			#local DraperyPoints[48]=<-2.6,-14,-2.6>*<sin(2*RInt),1,cos(2*RInt)>*psize[5];
			#local DraperyPoints[49]=<2.6,-14,-2.6>*<sin(RInt),1,cos(RInt)>*psize[5];
			#local DraperyPoints[52]=DraperyPoints[48]*<1,1,-1>;
			#local DraperyPoints[53]=DraperyPoints[49]*<1,1,-1>;
			//adjust drapery
			#local DraperyPoints[48]=Rhip+Waist+vrotate(DraperyPoints[48],
				<max(0,prtns[5].x),prtns[5].y,min(0,prtns[5].z)>);
			#local DraperyPoints[49]=Rhip+Waist+vrotate(DraperyPoints[49],
				<max(0.5*prtns[5].x,prtns[5].x),prtns[5].y,min(0,0.5*prtns[5].z)>);
			#local DraperyPoints[52]=Rhip+Waist+vrotate(DraperyPoints[52],
				<min(0,prtns[5].x),prtns[5].y,min(0,prtns[5].z)>);
			#local DraperyPoints[53]=Rhip+Waist+vrotate(DraperyPoints[53],
				<min(0.5*prtns[5].x,prtns[5].x),prtns[5].y,min(0,0.5*prtns[5].z)>);
			#ifdef (RCalfClothing)
				object{
					RCalfClothing
					scale psize[5]
					rotate prtns[6]
					translate Rknee+Waist
				}
			#end
			union{
				cylinder{
				<0,0,0>*in,<0,-3,0>*in,1*in
				scale <1.5,1,0.75>
			}
			intersection{
				box{
					<-2,0,0>*in,<2,-3,-6.1>*in
				}
				union{
					sphere{
						<0,0,0>*in,1*in scale <2,2.5,6> translate <0,-3,0>*in
					}
					cylinder{
						<1.25,-2.5,-4>*in,<1.25,-2.5,-6>*in,0.5*in
					}
				}
			}
			scale psize[5]
			#if (dimension_size(prtns,1)>11) rotate prtns[11] #end
			translate Rankl+Waist
		}
		// Store drapery values for skirt,ankle: 56-57,60-61
		#local DraperyPoints[56]=<-2.6,-16,-2.6>*<sin(2*RInt),1,cos(2*RInt)>*psize[5];
		#local DraperyPoints[57]=<2.6,-16,-2.6>*<sin(RInt),1,cos(RInt)>*psize[5];
		#local DraperyPoints[60]=DraperyPoints[56]*<1,1,-1>;
		#local DraperyPoints[61]=DraperyPoints[57]*<1,1,-1>;
		//adjust drapery
		#local DraperyPoints[56]=<min(Rknee.x,RkneeD.x),Rknee.y,max(Rknee.z,RkneeD.z)>+Waist+vrotate(DraperyPoints[56],
			<max(0,prtns[6].x),prtns[6].y,min(0,prtns[6].z)>);
		#local DraperyPoints[57]=<RkneeD.x,Rknee.y,max(Rknee.z,RkneeD.z)>+Waist+vrotate(DraperyPoints[57],
			<max(0.5*prtns[6].x,prtns[6].x),prtns[6].y,min(0,0.5*prtns[6].z)>);
		#local DraperyPoints[60]=<min(Rknee.x,RkneeD.x),Rknee.y,min(Rknee.z,RkneeD.z)>+Waist+vrotate(DraperyPoints[60],
			<min(0,prtns[6].x),prtns[6].y,min(0,prtns[6].z)>);
		#local DraperyPoints[61]=<RkneeD.x,Rknee.y,min(Rknee.z,RkneeD.z)>+Waist+vrotate(DraperyPoints[61],
			<min(0.5*prtns[6].x,prtns[6].x),prtns[6].y,min(0,0.5*prtns[6].z)>);
		#ifdef (RFootClothing)
			object{
				RFootClothing
				scale psize[5]
				#if (dimension_size(prtns,1)>11) rotate prtns[11] #end
				translate Rankl+Waist
			}
		#end
		}
		// Left leg
		union{
			sphere{
				<-0.3,1.6,0.35>*in,3.2*in
				scale <1,1,1>*psize[6]
				translate Lhip+Waist
			}
			#ifdef (LHipsClothing)
				object{
					LHipsClothing
					scale psize[6]
					translate Lhip+Waist
				}
			#end
			cone{
				<0,0,0>,3*in,<0,8*in,0>,2*in
				scale psize[6]
				rotate prhips
				translate Lhip+Waist
			}
			cone{
				<0,0,0>,3*in,<0,-14*in,0>,1.5*in
				scale psize[6]
				rotate prtns[7]
				translate Lhip+Waist
				#local Lknee=Lhip+vrotate(<0,-14*in,0>*psize[6],prtns[7]);
				#local LkneeD=Lhip+vrotate(<0,-14*in,0>*psize[6],
					<max(0.5*prtns[7].x,prtns[7].x),prtns[7].y,max(0,0.5*prtns[7].z)>);
			}
			// Store drapery values for skirt,thigh: 42-43,46-47
			#local DraperyPoints[42]=<-2.6,-14,-2.6>*<sin(RInt),1/3,cos(RInt)>*psize[6];
			#local DraperyPoints[43]=<2.6,-14,-2.6>*<sin(2*RInt),1/3,cos(2*RInt)>*psize[6];
			#local DraperyPoints[46]=DraperyPoints[42]*<1,1,-1>;
			#local DraperyPoints[47]=DraperyPoints[43]*<1,1,-1>;
			//adjust drapery
			#local DraperyPoints[42]=Lhip+Waist+vrotate(DraperyPoints[42],
				<max(0.5*prtns[7].x,prtns[7].x),prtns[7].y,max(0,0.5*prtns[7].z)>);
			#local DraperyPoints[43]=Lhip+Waist+vrotate(DraperyPoints[43],
				<max(0,prtns[7].x),prtns[7].y,max(0,prtns[7].z)>);
			#local DraperyPoints[46]=Lhip+Waist+vrotate(DraperyPoints[46],
				<min(0.5*prtns[7].x,prtns[7].x),prtns[7].y,max(0,0.5*prtns[7].z)>);
			#local DraperyPoints[47]=Lhip+Waist+vrotate(DraperyPoints[47],
				<min(0,prtns[7].x),prtns[7].y,max(0,prtns[7].z)>);
			#ifdef (LThighClothing)
				object{
					LThighClothing
					scale psize[6]
					rotate prtns[7]
					translate Lhip+Waist
				}
			#end
			sphere{
				<0,0,0>,1.5*in
				scale psize[6]
				translate Lknee+Waist
			}
			cone{
				<0,0,0>,1.5*in,<0,-16*in,0>,1.5*in
				scale psize[6]
				rotate prtns[8]
				translate Lknee+Waist
				#local Lankl=Lknee+vrotate(<0,-16*in,0>*psize[6],prtns[8]);
			}
			// Store drapery values for skirt,knee: 50-51,54-55
			#local DraperyPoints[50]=<-2.6,-14,-2.6>*<sin(RInt),1,cos(RInt)>*psize[6];
			#local DraperyPoints[51]=<2.6,-14,-2.6>*<sin(2*RInt),1,cos(2*RInt)>*psize[6];
			#local DraperyPoints[54]=DraperyPoints[50]*<1,1,-1>;
			#local DraperyPoints[55]=DraperyPoints[51]*<1,1,-1>;
			//adjust drapery
			#local DraperyPoints[50]=Lhip+Waist+vrotate(DraperyPoints[50],
				<max(0.5*prtns[7].x,prtns[7].x),prtns[7].y,max(0,0.5*prtns[7].z)>);
			#local DraperyPoints[51]=Lhip+Waist+vrotate(DraperyPoints[51],
				<max(0,prtns[7].x),prtns[7].y,max(0,prtns[7].z)>);
			#local DraperyPoints[54]=Lhip+Waist+vrotate(DraperyPoints[54],
				<min(0.5*prtns[7].x,prtns[7].x),prtns[7].y,max(0,0.5*prtns[7].z)>);
			#local DraperyPoints[55]=Lhip+Waist+vrotate(DraperyPoints[55],
				<min(0,prtns[7].x),prtns[7].y,max(0,prtns[7].z)>);
			#ifdef (LCalfClothing)
				object{
					LCalfClothing
					scale psize[6]
					rotate prtns[8]
					translate Lknee+Waist
				}
			#end
			union{
				cylinder{
					<0,0,0>*in,<0,-3,0>*in,1*in
					scale <1.5,1,0.75>
				}
				intersection{
					box{
						<-2,0,0>*in,<2,-3,-6.1>*in
					}
					union{
						sphere{
							<0,0,0>*in,1*in scale <2,2.5,6> translate <0,-3,0>*in
						}
						cylinder{
							<-1.25,-2.5,-4>*in,<-1.25,-2.5,-6>*in,0.5*in
						}
					}
				}
				scale psize[6]
				#if (dimension_size(prtns,1)>12) rotate prtns[12] #end
				translate Lankl+Waist
			}
			// Store drapery values for skirt,ankle: 58-59,62-63
			#local DraperyPoints[58]=<-2.6,-16,-2.6>*<sin(RInt),1,cos(RInt)>*psize[6];
			#local DraperyPoints[59]=<2.6,-16,-2.6>*<sin(2*RInt),1,cos(2*RInt)>*psize[6];
			#local DraperyPoints[62]=DraperyPoints[58]*<1,1,-1>;
			#local DraperyPoints[63]=DraperyPoints[59]*<1,1,-1>;
			//adjust drapery
			#local DraperyPoints[58]=<LkneeD.x,Lknee.y,max(Lknee.z,LkneeD.z)>+Waist+vrotate(DraperyPoints[58],
				<max(0.5*prtns[8].x,prtns[8].x),prtns[8].y,max(0,0.5*prtns[8].z)>);
			#local DraperyPoints[59]=<max(Lknee.x,LkneeD.x),Lknee.y,max(Lknee.z,LkneeD.z)>+Waist+vrotate(DraperyPoints[59],
				<max(0,prtns[8].x),prtns[8].y,max(0,prtns[8].z)>);
			#local DraperyPoints[62]=<LkneeD.x,Lknee.y,min(Lknee.z,LkneeD.z)>+Waist+vrotate(DraperyPoints[62],
				<min(0.5*prtns[8].x,prtns[8].x),prtns[8].y,max(0,0.5*prtns[8].z)>);
			#local DraperyPoints[63]=<max(Lknee.x,LkneeD.x),Lknee.y,min(Lknee.z,LkneeD.z)>+Waist+vrotate(DraperyPoints[63],
				<min(0,prtns[8].x),prtns[8].y,max(0,prtns[8].z)>);
			#ifdef (LFootClothing)
				object{
					LFootClothing
					scale psize[6]
					#if (dimension_size(prtns,1)>12) rotate prtns[12] #end
					translate Lankl+Waist
				}
			#end
		}
		#ifdef (Bodycostume)
			Bodycostume(DraperyPoints)
		#end
		texture{HFlesh}
	}//-union
	rotate prtn
	translate plocn
}//-object RTDH2
#end

#declare SamplerName=object{
	RTDH2(<0,0,0>,<0,0,0>,
		array[7]{<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>,
			<1,1,1>,<1,1,1>,<1,1,1>},
		array[9]{<15,5,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
#declare SamplerBBox=array[2]
	{<-12*in,0,-8*in>,<12*in,5*ft+8*in,8*in>}

/*
#declare KoDT_BA=object{
	RTDH2(<0,0,0>,<0,0,0>,
		array[7]{<1.5,1.33,1.5>,<1.07,1.5,1.07>,<2,1,2>,<2,1,2>,
			<1,0.83,1>,<1.33,0.61,1.33>,<1.33,0.61,1.33>},
		array[9]{<10,10,0>,<0,0,-40>,<120,0,0>,<0,0,15>,<0,0,-5>,<5,0,-20>,<-3,0,-18>,<0,0,20>,<-2,0,18>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
	scale 1.2
}
#declare KoDT_Bob=object{
	RTDH2(<0,0,0>,<0,0,0>,
		array[7]{<1.29,1.67,1.29>,<1.1,1.5,1.1>,<2,1.23,2>,<2,1.23,2>,
			<1.1,0.87,1.1>,<1.2,0.6,1.2>,<1.2,0.6,1.2>},
		array[9]{<10,5,0>,<0,0,-70>,<0,0,-120>,<0,0,110>,<0,0,115>,<5,0,-15>,<-3,0,-13>,<0,0,13>,<-2,0,11>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
	psize:	Array[7] of size data
					0 Head, 1 Torso, 2 RArm, 3 LArm, 4 Hips, 5 RLeg, 6 LLeg
	prtns:	Array[9] of rotation data
					0 Head 1 right u arm 2 right l arm 3 left u arm 4 left l arm
			5 right u leg 6 right l leg 7 left u leg 8 left l leg
#declare KoDT_Brian=object{
	RTDH2(<0,0,0>,<0,0,0>,
		array[7]{<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>,
			<1,1,1>,<1,1,1>,<1,1,1>},
		array[9]{<15,5,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
#declare KoDT_Dave=object{
	RTDH2(<0,0,0>,<0,0,0>,
		array[7]{<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>,
			<1,1,1>,<1,1,1>,<1,1,1>},
		array[9]{<15,5,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
#declare KoDT_Johnny=object{
	RTDH2(<0,0,0>,<0,0,0>,
		array[7]{<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>,
			<1,1,1>,<1,1,1>,<1,1,1>},
		array[9]{<15,5,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
#declare KoDT_Sara=object{
	RTDH2(<0,0,0>,<0,0,0>,
		array[7]{<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>,
			<1,1,1>,<1,1,1>,<1,1,1>},
		array[9]{<15,5,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
#local HFlesh=texture{pigment{colour rgb <0.79,0.45,0.31>}}
#local HHair =texture{pigment{colour rgb <0.55,0.33,0.15>}}
#declare Cave_mother=object{
	RTDH2(<0,0,0>,<0,0,0>,
		array[7]{<1,1,1>,<1,1,1>,<1.2,1.3,1.2>,<1.2,1.3,1.2>,
			<1.2,1.2,1.2>,<1.2,1,1.1>,<1.2,1,1.1>},
		array[9]{<15,5,0>,<15,0,-25>,<15,0,65>,<0,0,10>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
#local HFlesh=texture{pigment{colour rgb <0.77,0.59,0.49>}}
#local HHair =texture{pigment{colour rgb <0.63,0.56,0.59>}}
#declare Cave_grandma=object{
	RTDH2(<0,0,0>,<0,0,0>,
		array[7]{<1,1,1>,<1,1,1.2>,<1.2,1.3,1.2>,<1.2,1.3,1.2>,
			<1.2,1.2,1.5>,<1.2,1,1.1>,<1.2,1,1.1>},
		array[9]{<15,5,0>,<15,0,-25>,<15,0,65>,<0,0,10>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
#local HFlesh=texture{pigment{colour rgb <0.79,0.45,0.31>}}
#local HHair =texture{pigment{colour rgb <0.29,0.19,0.00>}}
#declare Cave_dad=object{
	RTDH2(<0,0,0>,<0,0,0>,
		array[7]{<1.3,1.1,1.3>,<1.5,1.43,2>,<1.6,1.48,1.6>,<1.6,1.48,1.6>,
			<1.4,0.62,2>,<1.25,1.067,1.09>,<1.25,1.067,1.09>},
		array[9]{<0,-15,0>,<0,0,-10>,<0,0,0>,<-30,0,10>,<30,10,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
#local HFlesh=texture{pigment{colour rgb <0.79,0.45,0.31>}}
#local HHair =texture{pigment{colour rgb <0.70,0.30,0.15>}}
#local Furskin=texture{Woven}
#declare CavePizza=object{// cave pizza delivery guy
	RTDH2(<0,0,0>,<0,0,0>,
		array[7]{<1.05,1.1,1>,<1.05,1.2,1>,<1.05,1.1,1>,<1.05,1.1,1>,
			<1.05,1.1,1>,<1.05,0.8,1>,<1.05,0.8,1>},
		array[11]{<-10,-25,0>,<25,0,0>,<120,-20,0>,<-10,0,5>,<100,-10,0>,<15,0,0>,<-10,0,0>,<0,10,0>,<0,0,0>,<0,0,90>,<0,0,-90>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
	psize:	Array[7] of size data
					0 Head <6,8,6>, 1 Torso <16,20,8>, 2 RArm <2.5,19,2.5>, 3 LArm <2.5,19,2.5>,
					4 Hips <10,8,5>, 5 RLeg <6.4,30,6.4>, 6 LLeg <6.4,30,6.4>
	prtns:	Array[9] of rotation data
					0 Head 1 right u arm 2 right l arm 3 left u arm 4 left l arm
					5 right u leg 6 right l leg 7 left u leg 8 left l leg
					9 right hand 10 left hand
*/
#local HFlesh=texture{pigment{colour rgb <0.79,0.45,0.31>}}
#local HHair =texture{pigment{colour rgb <0.35,0.25,0.12>}}
#declare Cave_kid1=object{
	RTDH2(<0,0,0>,<0,0,0>,
		array[7]{<0.83,0.94,0.875>,<0.875,1.21,1>,<1,0.89,1>,<1,0.89,1>,
			<0.8,0.46,1>,<0.78,0.87,0.78>,<0.78,0.87,0.78>},
		array[9]{<0,-15,0>,<0,0,-10>,<0,0,5>,<-10,0,10>,<10,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
#declare Cave_kid2=object{
	RTDH2(<0,0,0>,<0,0,0>,
		array[7]{<0.83,0.89,0.625>,<0.75,0.78,1>,<0.8,0.89,0.8>,<0.8,0.89,0.8>,
			<0.7,0.54,1>,<0.625,0.8,0.625>,<0.625,0.8,0.625>},
		array[9]{<0,15,0>,<-5,0,-10>,<0,0,5>,<0,0,10>,<5,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
#local HFlesh=texture{pigment{colour rgb <0.79,0.45,0.31>}}
#local HHair =texture{pigment{colour rgb <0.70,0.30,0.15>}}
#declare Cave_kid3=object{
	RTDH2(<0,0,0>,<0,0,0>,
		array[7]{<0.75,0.89,0.75>,<0.68,0.71,0.875>,<0.8,0.63,0.8>,<0.8,0.63,0.8>,
			<0.6,0.46,0.8>,<0.47,0.43,0.47>,<0.47,0.43,0.47>},
		array[9]{<20,-5,0>,<-5,0,-10>,<0,0,5>,<0,0,10>,<5,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}

#declare UnitRTD=object{
	RTDH2(<0,0,0>,<0,0,0>,
		array[7]{<1/6,1/9,1/8>,<1/8,1/14,1/4>,<1/2.5,1/19,1/2.5>,<1/2.5,1/19,1/2.5>,
			<1/10,1/13,1/5>,<1/6.4,1/30,1/6.4>,<1/6.4,1/30,1/6.4>},
		array[9]{<15,5,0>,<15,0,-25>,<15,0,65>,<0,0,10>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
                                                                       ^  ^     Icon
           @         	rtdhc.inc-148EX) Apr 20009 Atm TEXTMPS                     l  l>    
   Include    C  [
fl     '   h @         [                       poser rib read.pl   TEXTMPS   h         <    (         x       x ttxt8BIM   	                           >                               ?  f$` 9  FhR                  
 
    
         $  6 U `                         H 	Monaco 
 !
$p             
   \g \gq  >6  >6  =(     \g \g  =(               ^  ^   
RT     MPSR  *FPRF   BSELc   Nstyl   ZNwPo   f         <
Qx,                                POV-Ray File Prefs 