/* Persistence of Vision Ray Tracer Scene Description File
File: aphrodite.pov
Vers: MegaPOV 0.5
Date:27. August 2000 
Auth:Anto Matkovic, Zagreb, Croatia
e-mail:  matkovic.geo@yahoo.com
site: www.geocities.com/SoHo/Studios/7415
This is eye, some things can be easily changed.
' broj_traka' is number of scaled and randomly rotated spheres.
' sirina_trake ' is xy scale
' otvor_zjenice ' is hole diameter in cm
*/
//#include "hue_colours.inc"
//background { colour rgb 0.3 }
//light_source{0*x color rgb 1 translate <40, 24, 4>}
//camera {  sky z*1 up z*1 right <1.33, 0.0, 0.0> location  <15, 2, 2> look_at   <0, 0, 0> angle 12}
#version unofficial MegaPov 0.5;

#declare otvor_zjenice = 0.18;
#declare obrub_zjenice = 0.2-otvor_zjenice*0.5;

#declare sirina_trake = 0.02;
#declare broj_traka = 2; 
#declare turbulencija_radiala = 1.2;
#declare frekvencija_radiala = 14;

#declare oci_bjeloo = colour rgb c05*0.09+0.9;
#declare oci_b1 = colour rgb c28*0.1+0.3;// spheres 1
#declare oci_b2 = colour rgb c28*0.5+0.2; // spheres 2 
#declare oci_b3 = colour rgb c28*0.5+0.2; // behind 1
#declare oci_b4 = colour rgb c28*0.1+0.17; //behind 2 
#declare oci_b5 = colour rgb c28*0.15+0.15; //ring 

#declare oci_boja1 = texture { pigment { oci_b1}
finish { ambient 0.3 diffuse 0.6 }}
#declare oci_boja2 = texture { pigment { oci_b2}
finish { ambient 0.3 diffuse 0.6 }}
#declare oci_boja3 = texture { pigment { oci_b3}
finish { ambient 0.3 diffuse 0.6 }}
#declare oci_boja4 = texture { pigment { oci_b4}
finish { ambient 0.3 diffuse 0.6 }}

#declare oci_boja4vani = texture { pigment { oci_b5}
finish { ambient 0.19 diffuse 0.59   phong 0.99 phong_size 112
reflection 0.1
irid { 0.2   thickness 0.7 turbulence 0.7}
}
normal{ agate 0.003 scale 0.001}}

#declare oci_iza = texture {pigment {radial frequency frekvencija_radiala turbulence turbulencija_radiala
colour_map{  [0 oci_b3]
             [1 oci_b4]}scale 0.05}
finish { ambient 0.4 diffuse 0.5 } rotate z*90}

texture {pigment {wood rotate y*90
 colour_map{  [0 colour rgb <0.15, 0.15, 0.15>] //crno u sredini
              [otvor_zjenice *1.5 colour rgb <0.15, 0.15, 0.15>]  //crno u sredini
              [otvor_zjenice *1.5+0.1 colour rgbf <0.1, 0.1, 0.1, 1>]
              [0.74 colour rgbf <0.1, 0.1, 0.1, 1>]
              [0.86 oci_b5]//okolo
              [1 oci_b5]}//oko
              scale 1.4}
finish { ambient 0.9 diffuse 0.1 }}

#declare bjeloo = texture {pigment { oci_bjeloo}
finish { ambient 0.19 diffuse 0.59   phong 0.99 phong_size 112
reflection 0.1
//irid { 0.15   thickness 0.7 turbulence 0.7}
}}

//ovo je 'stakleni dio ispred mreznjace
#declare bjeloo_st =  texture { pigment { colour rgbf <0.99, 0.99, 0.99, 0.99>}
finish { ambient 0.4 diffuse 0.5  phong 0.99 phong_size 56 specular 0.99 roughness 0.0001 reflection 0.1
}}

#declare bjeloo_sve =material {texture {wood rotate y*90
texture_map{ [0  bjeloo_st]
              [0.089 bjeloo_st]
              [0.093 oci_boja4vani]
              [0.097 oci_boja4vani]
              [0.099 bjeloo] // okolo
              [1 bjeloo]}//okolo
              scale 14}
interior { ior 1.33}}

#declare oko = union {
blob { threshold 0.5
sphere {<0, 0, 0>, 3.1, 1}
sphere {<0, 0, 0>, 1.9, 1 scale <0.9, 0.5, 0.5> translate x*0.3}
material {bjeloo_sve}}

cylinder {<1.4, 0, 0><1.3, 0, 0>, 0.7  texture {oci_iza} no_shadow}
    #declare broj_oko = 0 ;
    #declare R1 = seed(11);
    #declare R2 = seed(17);
	#while (broj_oko <broj_traka)

sphere {<0, 0, 1>, 1 scale < sirina_trake, sirina_trake,(rand(R1)*obrub_zjenice+0.07)>
translate <1.4, 0, otvor_zjenice>  rotate <(rand(R1)*360), 0, 0>
texture {oci_boja1} no_shadow}

sphere {<0, 0, 1>, 1 scale < sirina_trake, sirina_trake,(rand(R2)*obrub_zjenice+0.07)>
translate <1.4, 0, otvor_zjenice>  rotate <(rand(R2)*360), 0, 0>
texture {oci_boja2} no_shadow}

#declare broj_oko = (broj_oko + 1);
#end
}

//object {oko rotate <0, 0, 25>}










