/* Persistence of Vision Ray Tracer Scene Description File
File: aphrodite.pov
Vers: MegaPOV 0.5
Date:27. August 2000 
Auth:Anto Matkovic, Zagreb, Croatia
e-mail:  matkovic.geo@yahoo.com
site: www.geocities.com/SoHo/Studios/7415
All things needed for rendering are there.
Image was rendered on 1068x801 (see aph1068_801.ini)
Heightfields are POV files, included in the source: aph_heightfield.pov and aph_heightfield_pijesak.tga.
First was rendered on 768x768, second on 600x600, both as hf_gray_16 tga.
hue_colours.inc is necessary for probably all textures, that is for starting work with fully saturated colours.
*/

#version unofficial MegaPov 0.5;
#include "hue_colours.inc"

global_settings {
ambient_light c36*0.09+0.9
assumed_gamma 2.3
max_trace_level 6}
  
#switch (1)

#case (1)//ovo je za 4/3, main...
#declare mjesto_kamere = <2, 121, 75>;
#declare mjesto_gdje_gleda_kamera = <0, 0, -25.5>;
#declare kut_kamere = 45;
camera {  sky z*1 up z*1 right <4/3, 0, 0> 
location  mjesto_kamere look_at mjesto_gdje_gleda_kamera angle kut_kamere}
#break 

#case (2)//eye test
#declare mjesto_kamere = <0.1, 128, 80>;
#declare mjesto_gdje_gleda_kamera = <7, 0, 1>;
#declare kut_kamere = 5;
camera {  sky z*1 up z*1 right <4/3, 0, 0> 
location  mjesto_kamere look_at mjesto_gdje_gleda_kamera angle kut_kamere}
#end

#declare visina_mora = 5;
#declare spust_mora = -55;
#declare daljina_mora_od_kamere =-73;
#declare skala_mora = 0.02;
#declare aph_rot = <90, 0, 27>;
#declare aph_tr  = <-1, 0, 0>;

light_source {0*x colour rgb c36*0.1+0.7 area_light <50, 0, 0> <0, 0, -50> 
3, 3 adaptive 0 jitter  translate <600, -1111, 1111>}

light_source {0*x colour rgb c06*0.1+0.7 translate mjesto_kamere }

//box{<-300, -0.5, -300><300, 0.5, 400> rotate <17, 7, 30> 
//translate <0, 220, 0> 
//texture {pigment { colour rgb c04*0.99}finish {ambient 1 diffuse 0}}}


//light_source {0*x color rgb c35*0.1+0.2 translate <200, 200, 700> }

//light_source {0*x color rgb c06*0.3+0.1 spotlight translate <0, 250, 0> point_at <0, 0, 0> 
//radius 12 tightness 50 falloff 17 shadowless}

//light_source {0*x color rgb c36*0.2+0.2 spotlight translate <300, 300, 700> point_at <0, 0, -33> 
//radius 2 tightness 3 falloff 17 shadowless}

background {colour rgb c37*0.6+0.3} 

fog {up z*1 fog_type 2 distance 30 colour rgb c31*0.6+0.15 fog_offset -100 fog_alt 16 rotate x*-11}

#include "aph_tex.inc"

//more (sea)
height_field {tga "aph_heightfield.tga" smooth  translate <-0.5, 0, -0.5> rotate <90, 0, 0>
scale <270, 300, visina_mora> translate <0, daljina_mora_od_kamere, spust_mora> no_shadow material {more_b}}

#include "aph_pijesak.inc"//sand, ground, stones
#include "aph_oko.inc"//eyes
object { oko scale 0.98 rotate <0, -12, 90> translate < 3.1, -4.73, 3.15> rotate <0, 0, 27> translate aph_tr}
object { oko scale 0.98 rotate <0, -12, 90> translate < -3.1, -4.73, 3.15> rotate <0, 0, 27> translate aph_tr}
#include "aph_kosa.inc" object {aph_kosa  rotate <90, 0, 180> rotate aph_rot translate aph_tr}//hair
#include "aph_body.inc" object {aph_body rotate aph_rot translate aph_tr  material {skin_suncano}}//body
#include "aph_obrve.inc" object {aph_obrve rotate aph_rot translate aph_tr  texture {obrve070800} no_shadow}//eyebrows
#include "aph_unoci.inc" object {aph_unoci rotate aph_rot translate aph_tr translate y*-0.1 texture 
{unoci070800} no_shadow}
#include "aph_usta.inc"  object {aph_usta  rotate aph_rot translate aph_tr  texture {usta_260700}}//lips

#include "aph_trep.inc"//eyelashes 
object {trep rotate aph_rot translate aph_tr texture {trep_tex scale <1, 1, 1 > 
translate < 3.1, -4.8, 3.15> rotate <0, 0, 27> translate aph_tr}  no_shadow}
object {trep scale <-1, 1, 1>rotate aph_rot translate aph_tr texture {trep_tex scale <-1, 1, 1 > 
translate < -3.1, -4.8, 3.15> rotate <0, 0, 27> translate aph_tr}  no_shadow}









   
   
   