// ============================================================================
//
// Atlantic Still Life
//
// Entry for July/August IRTC - Topic 'Sea'
//
// All code and images copyright (c) Ian Shumsky / Outerarm 2000
//
// ============================================================================

#version unofficial Megapov 0.5;

// ============================================================================
//
// This file contains the majority of textured used in the image.
//
// ============================================================================

//
// The general wood we will use for everything. This is based on the woods.inc
// file.
//

#declare T_Wood35 = texture
{
	pigment
	{
		wood
		turbulence 0.03725
		omega 0.65725
		lambda 2.425
		color_map
		{
			[0.250 color rgbf <1.00000, 0.53373, 0.11665, 0.000>]
			[0.350 color rgbf <0.66275, 0.28607, 0.00000, 0.000>]
			[0.525 color rgbf <1.00000, 0.53363, 0.11715, 0.000>]
			[0.600 color rgbf <0.66475, 0.28647, 0.00000, 0.000>]
			[0.750 color rgbf <1.00000, 0.53353, 0.11565, 0.000>]
			[0.850 color rgbf <0.66275, 0.28667, 0.00000, 0.000>]
			[1.000 color rgbf <1.00000, 0.53143, 0.11795, 0.000>]
		}
		scale <0.25, 0.225, 1.0>
	}
}
texture
{
	pigment
	{
		wood
		scale 1.01275
		turbulence 0.0435
		omega 0.65
		lambda 3.15
		color_map
		{
			[0.200 color rgbf <0.56695, 0.17347, 0.00000, 0.8250>]
			[0.350 color rgbf <0.96471, 0.54510, 0.22753, 0.7710>]
			[0.400 color rgbf <0.56341, 0.17547, 0.00000, 0.9150>]
			[0.615 color rgbf <0.96472, 0.54510, 0.22553, 0.7590>]
			[0.700 color rgbf <0.56671, 0.17687, 0.00000, 0.7920>]
			[0.850 color rgbf <0.96485, 0.54510, 0.22453, 0.8975>]
			[1.000 color rgbf <0.56478, 0.17247, 0.00000, 0.9750>]
		}
		scale <0.225, 0.2725, 1.0>
		translate <-0.35, 0.095, 1.25>
	}
}

#declare wood_texture2 = texture
{
	T_Wood35
	finish
	{
		specular 0.15
		roughness 0.025
		ambient 0.25
		reflection 0.1
	}
	rotate <0, 90, 0>
	rotate <3, 0, 0>
	scale <2, 1, 1>
	translate <-6, 0, -5>
	scale 0.025
}

//
// The stone texture for the fossil rocks. This is based on textures found in
// stone.inc
//

#declare colint = 1.5;

#declare T_Grnt0a = texture
{
	pigment
	{
		granite
		turbulence 0.6
		color_map
		{
			[0.000, 0.153 color rgbt <0.729 / colint, 0.502 / colint, 0.451 / colint, 0.306> color rgbt <0.769 / colint, 0.686 / colint, 0.592 / colint, 0.792>]
			[0.153, 0.398 color rgbt <0.769 / colint, 0.686 / colint, 0.592 / colint, 0.792> color rgbt <0.843 / colint, 0.753 / colint, 0.718 / colint, 0.396>]
			[0.398, 0.559 color rgbt <0.843 / colint, 0.753 / colint, 0.718 / colint, 0.396> color rgbt <0.780 / colint, 0.667 / colint, 0.561 / colint, 0.976>]
			[0.559, 0.729 color rgbt <0.780 / colint, 0.667 / colint, 0.561 / colint, 0.976> color rgbt <0.741 / colint, 0.659 / colint, 0.576 / colint, 0.820>]
			[0.729, 1.001 color rgbt <0.741 / colint, 0.659 / colint, 0.576 / colint, 0.820> color rgbt <0.729 / colint, 0.502 / colint, 0.451 / colint, 0.306>]
		}
	}
}

#declare T_Grnt9a = texture
{
	pigment
	{
		granite
		turbulence 0.6
		color_map
		{
			[0.000, 0.216 color rgbt <0.812 / colint, 0.812 / colint, 0.812 / colint, 0.835> color rgbt <0.745 / colint, 0.843 / colint, 0.835 / colint, 0.847>]
			[0.216, 0.241 color rgbt <0.745 / colint, 0.843 / colint, 0.835 / colint, 0.847> color rgbt <0.404 / colint, 0.337 / colint, 0.337 / colint, 0.463>]
			[0.241, 0.267 color rgbt <0.404 / colint, 0.337 / colint, 0.337 / colint, 0.463> color rgbt <0.773 / colint, 0.729 / colint, 0.745 / colint, 0.622>]
			[0.267, 0.759 color rgbt <0.773 / colint, 0.729 / colint, 0.745 / colint, 0.622> color rgbt <0.914 / colint, 0.843 / colint, 0.725 / colint, 0.651>]
			[0.759, 0.784 color rgbt <0.914 / colint, 0.843 / colint, 0.725 / colint, 0.651> color rgbt <0.153 / colint, 0.133 / colint, 0.208 / colint, 0.437>]
			[0.784, 0.810 color rgbt <0.153 / colint, 0.133 / colint, 0.208 / colint, 0.437> color rgbt <0.812 / colint, 0.812 / colint, 0.812 / colint, 0.835>]
			[0.810, 1.001 color rgbt <0.812 / colint, 0.812 / colint, 0.812 / colint, 0.835> color rgbt <0.812 / colint, 0.812 / colint, 0.812 / colint, 0.835>]
		}
	}
}

#declare rock_texture = texture
{
	pigment
	{
		color rgb <1, 1, 1> / colint
	}
	finish
	{
		ambient 0.6
		crand 0.06
		diffuse 0.7
	}
}
texture
{
	T_Grnt0a
	scale <0.02, 0.02, 0.02>
	rotate <0, 0, -30>
}
texture
{
	T_Grnt9a
	scale <0.02, 0.02, 0.02>
	rotate <0, 0, 40>
	finish
	{
		phong 1.0
		ambient 0.2
		diffuse 0.5
		phong_size 90
	}
}

//
// Set the texture for the fossils. Both textures are image_maps.
//

#declare calymene_texture = texture
{
	pigment
	{
		image_map
		{
			png "trilobite_skin.png"
			map_type 0
			interpolate 2
			once
		}
	}
	finish
	{
		specular 1 roughness 0.001
	}
	translate <-0.5,-0.5, 0>
	rotate x*90
	rotate y*-90
	scale <8, 1, 4>
}

#declare dalmanites_texture = texture
{
	pigment
	{
		image_map
		{
			png "trilobite_skin.png"
			map_type 0
			interpolate 2
			once
		}
	}
	finish
	{
		specular 1 roughness 0.001
	}
	translate <-0.5,-0.5, 0>
	rotate x*90
	rotate y*-90
	scale <9.5, 1, 7>
}

//
// Set the glass texture for the fossil stands.
//

#declare Glass = material
{
	texture
	{
		pigment
		{
			color rgbf <1.0, 1.0, 1.0, 0.7>
		}
		finish
		{
			ambient 0.0
			diffuse 0.0
			specular 1.0
			roughness 0.001
			reflection 0.5
		}
	}
	interior
	{
		ior 1.2
	}
}

//
// Define the metal textures used on the globe. These are all based on textures
// found in metals.inc
//

#declare GoldBase = <1.00, 0.875, 0.575>;
#declare CVect2 = GoldBase - <0.00, 0.15, 0.30>;
#declare P_Gold2 = rgb CVect2;

#declare globe_gold_t = texture
{
	pigment
	{
		P_Gold2
	}
	finish
	{
		ambient 0.25
		brilliance 4
		diffuse 0.5
		blinn 2
		metallic
		specular 0.80
		roughness 1/80
		reflection 0.25
	}
}

#declare P_Silver2 = color rgb <0.94, 0.93, 0.85>;

#declare globe_silver_t = texture
{
	pigment
	{
		P_Silver2
	}
	finish
	{
		ambient 0.25
		brilliance 4
		diffuse 0.5
		blinn 2
		metallic
		specular 0.80
		roughness 1/80
		reflection 0.2
	}
}

#declare P_Brass3 = color rgb <0.58, 0.42, 0.20>;

#declare globe_bronze_t = texture
{
	pigment
	{
		P_Brass3
	}
	finish
	{
		ambient 0.25
		brilliance 4
		diffuse 0.5
		blinn 2
		metallic
		specular 0.80
		roughness 1/80
		reflection 0.25
	}
}

