// ============================================================================
//
// Atlantic Still Life
//
// Entry for July/August IRTC - Topic 'Sea'
//
// All code and images copyright (c) Ian Shumsky / Outerarm 2000
//
// ============================================================================

#version unofficial Megapov 0.5;

// ============================================================================
//
// This file is used to generate a height field which is used as the rock
// holding the Dalmanites fossil. The do_gen_hf flag controls whether the
// height field is generated or a test of the height field is constructed.
//
// Once the height field has been rendered, it should be imported into a paint
// program and squared off. A 1 pixel BLACK border should then be added to the
// image to correctly close the height field when it is renders.
//
// ============================================================================

#declare do_gen_hf = false;

#if (do_gen_hf = true)
	global_settings
	{
		assumed_gamma 2.2
		hf_gray_16
	}

	camera
	{
		location <0, 0, -10>
		look_at 0
	}

	plane
	{
		z, 10
		pigment
		{
			granite
			color_map
			{
				[0 rgb <0.3, 0.3, 0.3>]
				[1 rgb <1, 1, 1>]
			}
			scale 10
		}
	}

	light_source
	{
		<0, 20, -100>
		color rgb <1, 1, 1>
	}
	light_source
	{
		<20, 1, -20>
		color rgb <1, 1, 1>
	}
#else
	#include "asl_textures.inc"

	camera
	{
		location <0, 1, -1>
		look_at 0
		angle 20
	}

	light_source
	{
		<1000,1000,-1000>
		color rgb <1, 1, 1>
	}

	light_source
	{
		<0, 1, 1>
		color rgb <1, 1, 1> / 3
	}

	#include "dalmanites.inc"

	#declare dalmanites_rand = seed (270);

	#declare rock_hf_2 = height_field
	{
		png "dalmanites_rock_hf.png"
		smooth
		translate <-.5, 0, -.5>
		rotate y*180
	}

	#declare _dalmanites_rock = union
	{
		object
		{
			dalmanites
			translate <0, 0.002, 0>
			rotate z*0.7
			rotate y*180
			rotate y * -135
			scale 3
		}
		union
		{
			object
			{
				rock_hf_2
			}
			box
			{
				<-0.5, -.1, -0.5>, <0.5, 0, 0.5>
			}
    			scale <0.25, 0.02, 0.25>
			texture
			{
				rock_texture
				scale 2
				translate <10 * rand (dalmanites_rand),10 * rand (dalmanites_rand),10 * rand (dalmanites_rand)>
			}
		}
		// rest on y = 0
		translate <0, .1*.02, 0>
		scale 1.15
	}

	#declare dalmanite_label = union
	{
		//
		// Mount
		//

		box
		{
			<0, 0, 0>, <1, 1, 1>
			translate <-0.5, -0.5, -0.5>
			scale <3.8 + 0.1, .78 + 0.1, 1>
			texture
			{
				rock_texture
				scale 2
				translate <10 * rand (dalmanites_rand),10 * rand (dalmanites_rand),10 * rand (dalmanites_rand)>
			}
		}

		//
		// Label
		//

		box
		{
			<0, 0, 0>, <1, 1, 1>
			texture
			{
				pigment
				{
					image_map
					{
						png "dalmanites_label.png"
						map_type 0
						interpolate 2
					}
				}
			}
			translate <-0.5, -0.5, -0.5>
			scale <3.8, .78, 1>
			translate <0, 0, -00.02>
		}
		rotate x*90
		scale <0.03, 0.02, 0.03>
	}

	#declare dalmanites_rock = union
	{
		object
		{
			_dalmanites_rock
		}
		object
		{
			dalmanite_label
			translate <-0.078, 0.015, -0.12>
		}
	}

	object
	{
		dalmanites_rock
	}

#end
