//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 1 lights, 14 materials and 92 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 07/20/2000    (20.07.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <   -703.768,     712.150,     -52.630>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35836,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      30.000
  look_at   <   -836.502,     229.753,     -51.671>
}

//
// *******  L I G H T S *******
//

light_source {   // Light1
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  translate  <-615.200688, 622.927547, 75.731003>
}


//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//
// ********  MATERIALS  *******
//

#include "camel.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

cylinder { // Cylndr003
  <0,0,1>, <0,0,0>, 1 
  material {
    MyFlesh
  }
  scale <1.5, 1.5, 5.0>
  rotate <-36.817352, -210.312485, -21.630676>
  translate  <-753.061804, 439.443214, -74.070553>
}


union { // BezPtch001
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.000000, -6.000000, 0.000000>, <-5.000000, -6.000000, 0.000000>, <-4.000000, -6.000000, 0.000000>, <-3.000000, -6.000000, 0.000000>, 
      <-6.000000, -5.000000, 0.000000>, <-5.000000, -5.000000, 0.000000>, <-4.000000, -5.000000, 0.000000>, <-3.000000, -5.000000, 0.000000>, 
      <-6.000000, -4.000000, 0.000000>, <-5.000000, -4.000000, 0.000000>, <-4.000000, -4.000000, 0.000000>, <-3.000000, -4.000000, 0.000000>, 
      <-6.000000, -3.000000, 0.000000>, <-5.000000, -3.000000, 0.000000>, <-4.000000, -3.000000, 0.000000>, <-2.984351, -3.000000, 0.093897>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.000000, -3.000000, 0.000000>, <-5.000000, -3.000000, 0.000000>, <-4.000000, -3.000000, 0.000000>, <-2.984351, -3.000000, 0.093897>, 
      <-6.000000, -2.000000, 0.000000>, <-5.000000, -2.000000, 0.000000>, <-4.000000, -2.000000, 0.000000>, <-2.968701, -2.000000, 0.156495>, 
      <-6.000000, -1.000000, 0.000000>, <-5.000000, -1.000000, 0.000000>, <-4.000000, -1.000000, 0.000000>, <-3.438185, -1.000000, 0.751174>, 
      <-6.000000, 0.000000, 0.000000>, <-5.000000, 0.000000, 0.000000>, <-4.000000, 0.000000, 0.000000>, <-3.641628, 0.000000, 0.704225>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.000000, 0.000000, 0.000000>, <-5.000000, 0.000000, 0.000000>, <-4.000000, 0.000000, 0.000000>, <-3.641628, 0.000000, 0.704225>, 
      <-6.000000, 1.000000, 0.000000>, <-5.000000, 1.000000, 0.000000>, <-4.000000, 1.000000, 0.000000>, <-3.845070, 1.000000, 0.657277>, 
      <-6.000000, 2.000000, 0.000000>, <-5.000000, 2.000000, 0.000000>, <-4.000000, 2.000000, 0.000000>, <-3.438185, 2.000000, 0.344288>, 
      <-6.000000, 3.000000, 0.000000>, <-5.000000, 3.000000, 0.000000>, <-4.000000, 3.000000, 0.000000>, <-3.219092, 3.000000, 0.172144>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.000000, 3.000000, 0.000000>, <-5.000000, 3.000000, 0.000000>, <-4.000000, 3.000000, 0.000000>, <-3.219092, 3.000000, 0.172144>, 
      <-6.000000, 4.000000, 0.000000>, <-5.000000, 4.000000, 0.000000>, <-4.000000, 4.000000, 0.000000>, <-3.000000, 4.000000, 0.000000>, 
      <-6.000000, 5.000000, 0.000000>, <-5.000000, 5.000000, 0.000000>, <-4.000000, 5.000000, 0.000000>, <-3.000000, 5.000000, 0.000000>, 
      <-6.000000, 6.000000, 0.000000>, <-5.000000, 6.000000, 0.000000>, <-4.000000, 6.000000, 0.000000>, <-3.000000, 6.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, -6.000000, 0.000000>, <-2.000000, -6.000000, 0.000000>, <-1.000000, -6.000000, 0.000000>, <0.000000, -6.000000, 0.000000>, 
      <-3.000000, -5.000000, 0.000000>, <-2.000000, -5.000000, 0.000000>, <-1.000000, -5.000000, 0.000000>, <0.000000, -5.000000, 0.000000>, 
      <-3.000000, -4.000000, 0.000000>, <-2.000000, -4.000000, 0.000000>, <-1.000000, -4.000000, 0.000000>, <0.000000, -4.000000, 0.000000>, 
      <-2.984351, -3.000000, 0.093897>, <-1.968701, -3.000000, 0.156495>, <-1.062598, -3.000000, 0.312989>, <0.328638, -3.000000, 0.438185>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.984351, -3.000000, 0.093897>, <-1.968701, -3.000000, 0.156495>, <-1.062598, -3.000000, 0.312989>, <0.328638, -3.000000, 0.438185>, 
      <-2.968701, -2.000000, 0.156495>, <-1.937402, -2.000000, 0.312989>, <-1.125196, -2.000000, 0.625978>, <0.657277, -2.000000, 0.813772>, 
      <-3.438185, -1.000000, 0.751174>, <-2.876369, -1.000000, 1.502347>, <-2.064163, -1.000000, 1.815336>, <-0.281690, -1.000000, 2.003130>, 
      <-3.641628, 0.000000, 0.704225>, <-3.283255, 0.000000, 1.408451>, <-2.408451, 0.000000, 1.564945>, <-0.751174, 0.000000, 1.862285>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.641628, 0.000000, 0.704225>, <-3.283255, 0.000000, 1.408451>, <-2.408451, 0.000000, 1.564945>, <-0.751174, 0.000000, 1.862285>, 
      <-3.845070, 1.000000, 0.657277>, <-3.690141, 1.000000, 1.314554>, <-2.752739, 1.000000, 1.314554>, <-1.220657, 1.000000, 1.721440>, 
      <-3.438185, 2.000000, 0.344288>, <-2.876369, 2.000000, 0.688576>, <-1.938967, 2.000000, 0.688576>, <-0.406886, 2.000000, 1.095462>, 
      <-3.219092, 3.000000, 0.172144>, <-2.438185, 3.000000, 0.344288>, <-1.469484, 3.000000, 0.344288>, <-0.203443, 3.000000, 0.547731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.219092, 3.000000, 0.172144>, <-2.438185, 3.000000, 0.344288>, <-1.469484, 3.000000, 0.344288>, <-0.203443, 3.000000, 0.547731>, 
      <-3.000000, 4.000000, 0.000000>, <-2.000000, 4.000000, 0.000000>, <-1.000000, 4.000000, 0.000000>, <0.000000, 4.000000, 0.000000>, 
      <-3.000000, 5.000000, 0.000000>, <-2.000000, 5.000000, 0.000000>, <-1.000000, 5.000000, 0.000000>, <0.000000, 5.000000, 0.000000>, 
      <-3.000000, 6.000000, 0.000000>, <-2.000000, 6.000000, 0.000000>, <-1.000000, 6.000000, 0.000000>, <0.000000, 6.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -6.000000, 0.000000>, <1.000000, -6.000000, 0.000000>, <2.000000, -6.000000, 0.000000>, <3.000000, -6.000000, 0.000000>, 
      <0.000000, -5.000000, 0.000000>, <1.000000, -5.000000, 0.000000>, <2.000000, -5.000000, 0.000000>, <3.000000, -5.000000, 0.000000>, 
      <0.000000, -4.000000, 0.000000>, <1.000000, -4.000000, 0.000000>, <2.000000, -4.000000, 0.000000>, <3.000000, -4.000000, 0.000000>, 
      <0.328638, -3.000000, 0.438185>, <1.719875, -3.000000, 0.500782>, <2.719875, -3.000000, 0.500782>, <3.328638, -3.000000, 0.438185>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.328638, -3.000000, 0.438185>, <1.719875, -3.000000, 0.500782>, <2.719875, -3.000000, 0.500782>, <3.328638, -3.000000, 0.438185>, 
      <0.657277, -2.000000, 0.813772>, <2.439750, -2.000000, 1.001565>, <3.439750, -2.000000, 1.001565>, <3.657277, -2.000000, 0.813772>, 
      <-0.281690, -1.000000, 2.003130>, <1.500782, -1.000000, 2.190923>, <2.500782, -1.000000, 2.190923>, <2.718310, -1.000000, 2.003130>, 
      <-0.751174, 0.000000, 1.862285>, <0.906103, 0.000000, 2.159624>, <3.126761, 0.000000, 1.471049>, <3.031299, 0.000000, 1.658842>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.751174, 0.000000, 1.862285>, <0.906103, 0.000000, 2.159624>, <3.126761, 0.000000, 1.471049>, <3.031299, 0.000000, 1.658842>, 
      <-1.220657, 1.000000, 1.721440>, <0.311424, 1.000000, 2.128326>, <3.752739, 1.000000, 0.751174>, <3.344288, 1.000000, 1.283255>, 
      <-0.406886, 2.000000, 1.095462>, <1.125196, 2.000000, 1.502347>, <2.500782, 2.000000, 2.190923>, <2.718310, 2.000000, 2.003130>, 
      <-0.203443, 3.000000, 0.547731>, <1.062598, 3.000000, 0.751174>, <2.250391, 3.000000, 1.095462>, <2.859155, 3.000000, 1.001565>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.203443, 3.000000, 0.547731>, <1.062598, 3.000000, 0.751174>, <2.250391, 3.000000, 1.095462>, <2.859155, 3.000000, 1.001565>, 
      <0.000000, 4.000000, 0.000000>, <1.000000, 4.000000, 0.000000>, <2.000000, 4.000000, 0.000000>, <3.000000, 4.000000, 0.000000>, 
      <0.000000, 5.000000, 0.000000>, <1.000000, 5.000000, 0.000000>, <2.000000, 5.000000, 0.000000>, <3.000000, 5.000000, 0.000000>, 
      <0.000000, 6.000000, 0.000000>, <1.000000, 6.000000, 0.000000>, <2.000000, 6.000000, 0.000000>, <3.000000, 6.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.000000, -6.000000, 0.000000>, <4.000000, -6.000000, 0.000000>, <5.000000, -6.000000, 0.000000>, <6.000000, -6.000000, 0.000000>, 
      <3.000000, -5.000000, 0.000000>, <4.000000, -5.000000, 0.000000>, <5.000000, -5.000000, 0.000000>, <6.000000, -5.000000, 0.000000>, 
      <3.000000, -4.000000, 0.000000>, <4.000000, -4.000000, 0.000000>, <5.000000, -4.000000, 0.000000>, <6.000000, -4.000000, 0.000000>, 
      <3.328638, -3.000000, 0.438185>, <3.937402, -3.000000, 0.312989>, <5.000000, -3.000000, 0.000000>, <6.000000, -3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.328638, -3.000000, 0.438185>, <3.937402, -3.000000, 0.312989>, <5.000000, -3.000000, 0.000000>, <6.000000, -3.000000, 0.000000>, 
      <3.657277, -2.000000, 0.813772>, <3.874804, -2.000000, 0.625978>, <5.000000, -2.000000, 0.000000>, <6.000000, -2.000000, 0.000000>, 
      <2.718310, -1.000000, 2.003130>, <2.935837, -1.000000, 1.815336>, <5.000000, -1.000000, 0.000000>, <6.000000, -1.000000, 0.000000>, 
      <3.031299, 0.000000, 1.658842>, <2.935837, 0.000000, 1.815336>, <5.000000, 0.000000, 0.000000>, <6.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.031299, 0.000000, 1.658842>, <2.935837, 0.000000, 1.815336>, <5.000000, 0.000000, 0.000000>, <6.000000, 0.000000, 0.000000>, 
      <3.344288, 1.000000, 1.283255>, <2.935837, 1.000000, 1.815336>, <5.000000, 1.000000, 0.000000>, <6.000000, 1.000000, 0.000000>, 
      <2.718310, 2.000000, 2.003130>, <2.935837, 2.000000, 1.815336>, <5.000000, 2.000000, 0.000000>, <6.000000, 2.000000, 0.000000>, 
      <2.859155, 3.000000, 1.001565>, <3.467919, 3.000000, 0.907668>, <5.000000, 3.000000, 0.000000>, <6.000000, 3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.859155, 3.000000, 1.001565>, <3.467919, 3.000000, 0.907668>, <5.000000, 3.000000, 0.000000>, <6.000000, 3.000000, 0.000000>, 
      <3.000000, 4.000000, 0.000000>, <4.000000, 4.000000, 0.000000>, <5.000000, 4.000000, 0.000000>, <6.000000, 4.000000, 0.000000>, 
      <3.000000, 5.000000, 0.000000>, <4.000000, 5.000000, 0.000000>, <5.000000, 5.000000, 0.000000>, <6.000000, 5.000000, 0.000000>, 
      <3.000000, 6.000000, 0.000000>, <4.000000, 6.000000, 0.000000>, <5.000000, 6.000000, 0.000000>, <6.000000, 6.000000, 0.000000>
    }
  }
  material {
    Desert
  }
  scale <100.0, 30.0, 30.0>
  rotate 28.405735*z
  translate  <-731.714609, 561.614857, -135.136955>
}


object {   // HgtFld001
  height_field {
//    tga "C:\PROGRAM FILES\MORAY FOR WINDOWS\Maps\hf1.tga"
    tga "hf1.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    Desert
  }
  scale <5000.0, 5000.0, 400.0>
  rotate -126.234459*z
  translate  <-731.754765, -25.42076, -53.953907>
}


sphere { // Sphere001
  <0,0,0>,1
  material {
    Sky
  }
  scale 5000.0
  rotate 0.572703*z
}




#declare Blanket2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.990533, -5.000000, -3.519133>, <-3.677736, -5.000000, -1.880737>, <-2.756354, -5.000000, -5.083816>, <-1.878177, -5.000000, -3.825163>, 
      <-4.053131, -4.000000, -3.706927>, <-3.677736, -4.000000, -1.880737>, <-2.944148, -4.000000, -2.141719>, <-1.972074, -4.000000, -1.853332>, 
      <-3.990533, -3.000000, -4.833687>, <-3.615138, -3.000000, -3.007498>, <-2.881550, -3.000000, -1.703534>, <-1.909476, -3.000000, -1.415147>, 
      <-3.990533, -2.000000, -3.832122>, <-3.646437, -2.000000, -2.444118>, <-2.912849, -2.000000, -1.140154>, <-1.940775, -2.000000, -0.851767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.990533, -2.000000, -3.832122>, <-3.646437, -2.000000, -2.444118>, <-2.912849, -2.000000, -1.140154>, <-1.940775, -2.000000, -0.851767>, 
      <-3.990533, -1.000000, -2.830557>, <-3.677736, -1.000000, -1.880737>, <-2.944148, -1.000000, -0.576774>, <-1.972074, -1.000000, -0.288387>, 
      <-3.990533, 0.000000, -2.830557>, <-3.677736, 0.000000, -1.880737>, <-2.944148, 0.000000, -0.576774>, <-1.972074, 0.000000, -0.288387>, 
      <-4.021832, 1.000000, -3.268742>, <-3.677736, 1.000000, -1.880737>, <-2.944148, 1.000000, -0.576774>, <-1.972074, 1.000000, -0.288387>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.021832, 1.000000, -3.268742>, <-3.677736, 1.000000, -1.880737>, <-2.944148, 1.000000, -0.576774>, <-1.972074, 1.000000, -0.288387>, 
      <-4.053131, 2.000000, -3.706927>, <-3.677736, 2.000000, -1.880737>, <-2.944148, 2.000000, -0.576774>, <-1.972074, 2.000000, -0.288387>, 
      <-4.053131, 3.000000, -3.706927>, <-3.677736, 3.000000, -1.880737>, <-2.944148, 3.000000, -0.576774>, <-1.940775, 3.000000, -0.257088>, 
      <-3.927936, 4.000000, -3.080948>, <-3.615138, 4.000000, -2.131129>, <-2.631158, 4.000000, -3.581469>, <-1.690384, 4.000000, -2.479310>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.878177, -5.000000, -3.825163>, <-1.000000, -5.000000, -2.566510>, <0.000000, -5.000000, -2.566510>, <1.033767, -5.000000, -3.878307>, 
      <-1.972074, -4.000000, -1.853332>, <-1.000000, -4.000000, -1.564945>, <0.000000, -4.000000, -1.564945>, <0.939871, -4.000000, -1.906476>, 
      <-1.909476, -3.000000, -1.415147>, <-0.937402, -3.000000, -1.126761>, <0.062598, -3.000000, -1.126761>, <1.002468, -3.000000, -1.468291>, 
      <-1.940775, -2.000000, -0.851767>, <-0.968701, -2.000000, -0.563380>, <0.031299, -2.000000, -0.563380>, <0.971170, -2.000000, -0.904911>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.940775, -2.000000, -0.851767>, <-0.968701, -2.000000, -0.563380>, <0.031299, -2.000000, -0.563380>, <0.971170, -2.000000, -0.904911>, 
      <-1.972074, -1.000000, -0.288387>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.939871, -1.000000, -0.341531>, 
      <-1.972074, 0.000000, -0.288387>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <0.939871, 0.000000, -0.341531>, 
      <-1.972074, 1.000000, -0.288387>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.955520, 1.000000, -0.310232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.972074, 1.000000, -0.288387>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.955520, 1.000000, -0.310232>, 
      <-1.972074, 2.000000, -0.288387>, <-1.000000, 2.000000, 0.000000>, <0.000000, 2.000000, 0.000000>, <0.971170, 2.000000, -0.278933>, 
      <-1.940775, 3.000000, -0.257088>, <-0.937402, 3.000000, 0.062598>, <0.062598, 3.000000, 0.062598>, <0.971170, 3.000000, -0.310232>, 
      <-1.690384, 4.000000, -2.479310>, <-0.749609, 4.000000, -1.377152>, <0.250391, 4.000000, -1.377152>, <1.221561, 4.000000, -2.532454>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.033767, -5.000000, -3.878307>, <2.067535, -5.000000, -5.190103>, <2.680678, -5.000000, -1.526763>, <3.211542, -5.000000, -3.692740>, 
      <0.939871, -4.000000, -1.906476>, <1.879741, -4.000000, -2.248006>, <2.680678, -4.000000, -1.526763>, <3.274140, -4.000000, -3.379751>, 
      <1.002468, -3.000000, -1.468291>, <1.942339, -3.000000, -1.809822>, <2.743276, -3.000000, -2.653524>, <3.336738, -3.000000, -4.506511>, 
      <0.971170, -2.000000, -0.904911>, <1.911040, -2.000000, -1.246441>, <2.711977, -2.000000, -2.090143>, <3.211542, -2.000000, -3.473647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.971170, -2.000000, -0.904911>, <1.911040, -2.000000, -1.246441>, <2.711977, -2.000000, -2.090143>, <3.211542, -2.000000, -3.473647>, 
      <0.939871, -1.000000, -0.341531>, <1.879741, -1.000000, -0.683061>, <2.680678, -1.000000, -1.526763>, <3.086347, -1.000000, -2.440783>, 
      <0.939871, 0.000000, -0.341531>, <1.879741, 0.000000, -0.683061>, <2.680678, 0.000000, -1.526763>, <3.148944, 0.000000, -2.065197>, 
      <0.955520, 1.000000, -0.310232>, <1.911040, 1.000000, -0.620463>, <2.680678, 1.000000, -1.526763>, <3.180243, 1.000000, -2.753772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.955520, 1.000000, -0.310232>, <1.911040, 1.000000, -0.620463>, <2.680678, 1.000000, -1.526763>, <3.180243, 1.000000, -2.753772>, 
      <0.971170, 2.000000, -0.278933>, <1.942339, 2.000000, -0.557866>, <2.680678, 2.000000, -1.526763>, <3.211542, 2.000000, -3.442348>, 
      <0.971170, 3.000000, -0.310232>, <1.879741, 3.000000, -0.683061>, <2.680678, 3.000000, -1.526763>, <3.211542, 3.000000, -3.442348>, 
      <1.221561, 4.000000, -2.532454>, <2.192730, 4.000000, -3.687756>, <2.743276, 4.000000, -1.777154>, <3.148944, 4.000000, -2.691175>
    }
  }
  material {
    rug2
  }
  scale <5.0, 7.0, 5.0>
  rotate -94.977173*z
  translate  <-120.989204, 36.213167, 4.228249>
}
#declare Mainbody2 = union {
  sphere { // Sphere040
    <0,0,0>,1
    material {
      Camel1
    }
    scale <15.98055, 10.0, 8.131079>
    translate  <-78.380725, 0.0, -23.548414>
  }
  sphere { // Sphere041
    <0,0,0>,1
    material {
      Camel1
    }
    scale <28.493122, 18.206993, 19.605167>
    translate  <-50.687224, 0.0, -20.257506>
  }
  sphere { // Sphere042
    <0,0,0>,1
    material {
      Camel1
    }
    scale <-12.518201, -5.759059, -13.058995>
    rotate -12.944258*z
    translate  <-35.634224, 11.534231, -24.813455>
  }
  sphere { // Sphere043
    <0,0,0>,1
    material {
      Camel1
    }
    scale <-12.518201, -5.759059, -13.058995>
    rotate 12.94426*z
    translate  <-35.634224, -11.53423, -24.813455>
  }
  sphere { // Sphere044
    <0,0,0>,1
    material {
      Camel1
    }
    scale <14.509237, 16.17622, 17.471052>
    rotate 64.290329*y
    translate  <-87.90413, 6.635413, -28.106535>
  }
  rotate -4.97717*z
  translate  <-65.779161, 33.412651, 4.228249>
}
#declare Reins3and4A = union {
  torus { // Torus016
    1.5, 0.02  rotate -x*90
    material {
      MyBlack
    }
    scale <7.025021, 14.575078, 10.409853>
    rotate <115.386894, -72.816971, -53.169388>
    translate  <-45.531916, 17.727675, 8.672845>
  }
  torus { // Torus017
    1.5, 0.02  rotate -x*90
    material {
      MyBlack
    }
    scale <7.025021, 14.575078, 10.409853>
    rotate <112.085167, -73.335625, -57.359283>
    translate  <-44.562925, 19.59959, 8.672845>
  }
}
#declare Reins3and4 = difference {
  object { Reins3and4A }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    material {
      MyBlack
    }
    scale <25.790848, 11.088437, 21.016941>
    rotate <-5.334033, 22.335175, -28.882011>
    translate  <-40.67503, 15.613214, 25.369495>
  }
}
#declare CSG007 = difference {
  torus { // Torus009
    1.25, 0.45  rotate -x*90
    scale <1.369706, 1.0, 0.7>
    rotate -90.0*x
    translate  -0.336096*x
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <3.209946, 2.0, 2.031493>
    translate  2.0*z
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    material {
      Camel1
    }
    scale <1.705802, 1.0, 1.314927>
    rotate <-180.0, -0.0, -180.0>
    translate  <-1.555205, 0.0, -1.071571>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    material {
      Camel1
    }
    scale <0.769088, 1.0, 1.319654>
    rotate <180.0, 43.857609, 180.0>
    translate  <0.320259, 0.0, -1.543962>
  }
  material {
    Camel1
  }
  scale <11.0, 10.0, 11.868921>
  rotate <180.0, 0.0, 180.0>
  translate  <-60.5, 32.347639, -1.438526>
}
#declare CSG008 = difference {
  torus { // Torus010
    1.25, 0.45  rotate -x*90
    scale <1.369706, 1.0, 0.7>
    rotate -90.0*x
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <3.209946, 2.0, 2.031493>
    translate  2.0*z
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <0.899171, 1.0, 0.842537>
    translate  <-1.646871, 0.0, 0.314927>
  }
  material {
    Camel1
  }
  scale <11.121353, 10.0, 11.868921>
  translate  <-94.490589, 32.347639, -0.160741>
}
#declare Neck2 = union {
  object { CSG007 }
  object { CSG008 }
}
#declare Body2 = union {
  object { Neck2 }
}
#declare BezPtch003 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.814301, 0.000000, 0.264880>, <-4.814301, -1.043411, 0.264880>, <-4.406534, -1.897111, -0.021411>, <-3.260489, -1.897111, -0.119253>, 
      <-4.434828, 0.000000, 0.644679>, <-4.434828, -1.043411, 0.644679>, <-4.027061, -1.897111, 0.358388>, <-3.517115, -1.897111, 0.076341>, 
      <-4.055355, 0.000000, 1.024477>, <-4.055355, -1.043411, 1.024477>, <-3.647588, -1.897111, 0.738186>, <-3.149207, -1.897111, 0.388275>, 
      <-3.675882, 0.000000, 1.404276>, <-3.675882, -1.043411, 1.404276>, <-3.268116, -1.897111, 1.117985>, <-2.769734, -1.918793, 0.768073>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.260489, -1.897111, -0.119253>, <-2.114443, -1.897111, -0.217095>, <-2.248909, -1.043411, -0.406866>, <-2.248909, 0.000000, -0.406866>, 
      <-3.517115, -1.897111, 0.076341>, <-3.007168, -1.897111, -0.205706>, <-2.715057, -1.043411, -0.317487>, <-2.715057, 0.000000, -0.317487>, 
      <-3.149207, -1.897111, 0.388275>, <-2.650826, -1.897111, 0.038363>, <-2.243060, -1.043411, -0.247928>, <-2.243060, 0.000000, -0.247928>, 
      <-2.769734, -1.918793, 0.768073>, <-2.271353, -1.897111, 0.418162>, <-1.863587, -1.043411, 0.131871>, <-1.863587, 0.000000, 0.131871>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.248909, 0.000000, -0.406866>, <-2.248909, 1.043411, -0.406866>, <-2.114443, 1.897111, -0.197791>, <-3.260489, 1.897111, -0.109601>, 
      <-2.715057, 0.000000, -0.317487>, <-2.715057, 1.043411, -0.317487>, <-3.007168, 1.897111, -0.205706>, <-3.517115, 1.897111, 0.076341>, 
      <-2.243060, 0.000000, -0.247928>, <-2.243060, 1.043411, -0.247928>, <-2.650826, 1.897111, 0.038363>, <-3.149207, 1.897111, 0.388275>, 
      <-1.863587, 0.000000, 0.131871>, <-1.863587, 1.043411, 0.131871>, <-2.271353, 1.897111, 0.418162>, <-2.769734, 1.918793, 0.768073>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.260489, 1.897111, -0.109601>, <-4.406534, 1.897111, -0.021411>, <-4.814301, 1.043411, 0.264880>, <-4.814301, 0.000000, 0.264880>, 
      <-3.517115, 1.897111, 0.076341>, <-4.027061, 1.897111, 0.358388>, <-4.434828, 1.043411, 0.644679>, <-4.434828, 0.000000, 0.644679>, 
      <-3.149207, 1.897111, 0.388275>, <-3.647588, 1.897111, 0.738186>, <-4.055355, 1.043411, 1.024477>, <-4.055355, 0.000000, 1.024477>, 
      <-2.769734, 1.918793, 0.768073>, <-3.268116, 1.897111, 1.117985>, <-3.675882, 1.043411, 1.404276>, <-3.675882, 0.000000, 1.404276>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.675882, 0.000000, 1.404276>, <-3.675882, -1.043411, 1.404276>, <-3.268116, -1.897111, 1.117985>, <-2.769734, -1.918793, 0.768073>, 
      <-3.296409, 0.000000, 1.784075>, <-3.296409, -1.043411, 1.784075>, <-2.888643, -1.897111, 1.497784>, <-2.390261, -1.897111, 1.147872>, 
      <-1.108001, 0.000000, 2.477072>, <-1.108001, -1.043411, 2.477072>, <-0.576105, -1.897111, 2.477072>, <0.073990, -1.897111, 2.477072>, 
      <-1.108001, 0.000000, 2.972487>, <-1.108001, -1.043411, 2.972487>, <-0.576105, -1.897111, 2.972487>, <0.073990, -1.918793, 2.972487>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.769734, -1.918793, 0.768073>, <-2.271353, -1.897111, 0.418162>, <-1.863587, -1.043411, 0.131871>, <-1.863587, 0.000000, 0.131871>, 
      <-2.390261, -1.897111, 1.147872>, <-1.891880, -1.897111, 0.797961>, <-1.484114, -1.043411, 0.511670>, <-1.484114, 0.000000, 0.511670>, 
      <0.073990, -1.897111, 2.477072>, <0.724085, -1.897111, 2.477072>, <1.255981, -1.043411, 2.477072>, <1.255981, 0.000000, 2.477072>, 
      <0.073990, -1.918793, 2.972487>, <0.724085, -1.897111, 2.972487>, <1.255981, -1.043411, 2.972487>, <1.255981, 0.000000, 2.972487>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.863587, 0.000000, 0.131871>, <-1.863587, 1.043411, 0.131871>, <-2.271353, 1.897111, 0.418162>, <-2.769734, 1.918793, 0.768073>, 
      <-1.484114, 0.000000, 0.511670>, <-1.484114, 1.043411, 0.511670>, <-1.891880, 1.897111, 0.797961>, <-2.390261, 1.897111, 1.147872>, 
      <1.255981, 0.000000, 2.477072>, <1.255981, 1.043411, 2.477072>, <0.724085, 1.897111, 2.477072>, <0.073990, 1.897111, 2.477072>, 
      <1.255981, 0.000000, 2.972487>, <1.255981, 1.043411, 2.972487>, <0.724085, 1.897111, 2.972487>, <0.073990, 1.918793, 2.972487>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.769734, 1.918793, 0.768073>, <-3.268116, 1.897111, 1.117985>, <-3.675882, 1.043411, 1.404276>, <-3.675882, 0.000000, 1.404276>, 
      <-2.390261, 1.897111, 1.147872>, <-2.888643, 1.897111, 1.497784>, <-3.296409, 1.043411, 1.784075>, <-3.296409, 0.000000, 1.784075>, 
      <0.073990, 1.897111, 2.477072>, <-0.576105, 1.897111, 2.477072>, <-1.108001, 1.043411, 2.477072>, <-1.108001, 0.000000, 2.477072>, 
      <0.073990, 1.918793, 2.972487>, <-0.576105, 1.897111, 2.972487>, <-1.108001, 1.043411, 2.972487>, <-1.108001, 0.000000, 2.972487>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.108001, 0.000000, 2.972487>, <-1.108001, -1.043411, 2.972487>, <-0.576105, -1.897111, 2.972487>, <0.073990, -1.918793, 2.972487>, 
      <-1.108001, 0.000000, 3.467901>, <-1.108001, -1.043411, 3.467901>, <-0.576105, -1.897111, 3.467901>, <0.073990, -1.897111, 3.467901>, 
      <-1.108001, 0.000000, 3.963315>, <-1.108001, -1.043411, 3.963315>, <-0.576105, -1.897111, 3.963315>, <0.073990, -1.897111, 3.963315>, 
      <-1.108001, 0.000000, 4.458730>, <-1.108001, -1.043411, 4.458730>, <-0.576105, -1.897111, 4.458730>, <0.073990, -1.897111, 4.458730>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.073990, -1.918793, 2.972487>, <0.724085, -1.897111, 2.972487>, <1.255981, -1.043411, 2.972487>, <1.255981, 0.000000, 2.972487>, 
      <0.073990, -1.897111, 3.467901>, <0.724085, -1.897111, 3.467901>, <1.255981, -1.043411, 3.467901>, <1.255981, 0.000000, 3.467901>, 
      <0.073990, -1.897111, 3.963315>, <0.724085, -1.897111, 3.963315>, <1.255981, -1.043411, 3.963315>, <1.255981, 0.000000, 3.963315>, 
      <0.073990, -1.897111, 4.458730>, <0.724085, -1.897111, 4.458730>, <1.255981, -1.043411, 4.458730>, <1.255981, 0.000000, 4.458730>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.255981, 0.000000, 2.972487>, <1.255981, 1.043411, 2.972487>, <0.724085, 1.897111, 2.972487>, <0.073990, 1.918793, 2.972487>, 
      <1.255981, 0.000000, 3.467901>, <1.255981, 1.043411, 3.467901>, <0.724085, 1.897111, 3.467901>, <0.073990, 1.897111, 3.467901>, 
      <1.255981, 0.000000, 3.963315>, <1.255981, 1.043411, 3.963315>, <0.724085, 1.897111, 3.963315>, <0.073990, 1.897111, 3.963315>, 
      <1.255981, 0.000000, 4.458730>, <1.255981, 1.043411, 4.458730>, <0.724085, 1.897111, 4.458730>, <0.073990, 1.897111, 4.458730>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.073990, 1.918793, 2.972487>, <-0.576105, 1.897111, 2.972487>, <-1.108001, 1.043411, 2.972487>, <-1.108001, 0.000000, 2.972487>, 
      <0.073990, 1.897111, 3.467901>, <-0.576105, 1.897111, 3.467901>, <-1.108001, 1.043411, 3.467901>, <-1.108001, 0.000000, 3.467901>, 
      <0.073990, 1.897111, 3.963315>, <-0.576105, 1.897111, 3.963315>, <-1.108001, 1.043411, 3.963315>, <-1.108001, 0.000000, 3.963315>, 
      <0.073990, 1.897111, 4.458730>, <-0.576105, 1.897111, 4.458730>, <-1.108001, 1.043411, 4.458730>, <-1.108001, 0.000000, 4.458730>
    }
  }
  material {
    Material3_1
  }
  scale <2.0, 2.0, 5.0>
  rotate <0.0, -76.31337, -0.0>
  translate  <-23.526669, 4.94824, -6.354334>
}
#declare BezPtch002 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.814301, 0.000000, 0.264880>, <-4.814301, -0.999068, 0.264880>, <-4.406534, -1.816488, -0.021411>, <-3.260489, -1.816488, -0.119253>, 
      <-4.434828, 0.000000, 0.644679>, <-4.434828, -0.999068, 0.644679>, <-4.027061, -1.816488, 0.358388>, <-3.517115, -1.816488, 0.076341>, 
      <-4.055355, 0.000000, 1.024477>, <-4.055355, -0.999068, 1.024477>, <-3.647588, -1.816488, 0.738186>, <-3.149207, -1.816488, 0.388275>, 
      <-3.675882, 0.000000, 1.404276>, <-3.675882, -0.999068, 1.404276>, <-3.268116, -1.816488, 1.117985>, <-2.769734, -1.837733, 0.768073>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.260489, -1.816488, -0.119253>, <-2.114443, -1.816488, -0.217095>, <-2.248909, -0.999068, -0.406866>, <-2.248909, 0.000000, -0.406866>, 
      <-3.517115, -1.816488, 0.076341>, <-3.007168, -1.816488, -0.205706>, <-2.715057, -0.999068, -0.317487>, <-2.715057, 0.000000, -0.317487>, 
      <-3.149207, -1.816488, 0.388275>, <-2.650826, -1.816488, 0.038363>, <-2.243060, -0.999068, -0.247928>, <-2.243060, 0.000000, -0.247928>, 
      <-2.769734, -1.837733, 0.768073>, <-2.271353, -1.816488, 0.418162>, <-1.863587, -0.999068, 0.131871>, <-1.863587, 0.000000, 0.131871>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.248909, 0.000000, -0.406866>, <-2.248909, 0.999068, -0.406866>, <-2.114443, 1.816488, -0.197791>, <-3.260489, 1.816488, -0.109601>, 
      <-2.715057, 0.000000, -0.317487>, <-2.715057, 0.999068, -0.317487>, <-3.007168, 1.816488, -0.205706>, <-3.517115, 1.816488, 0.076341>, 
      <-2.243060, 0.000000, -0.247928>, <-2.243060, 0.999068, -0.247928>, <-2.650826, 1.816488, 0.038363>, <-3.149207, 1.816488, 0.388275>, 
      <-1.863587, 0.000000, 0.131871>, <-1.863587, 0.999068, 0.131871>, <-2.271353, 1.816488, 0.418162>, <-2.769734, 1.837733, 0.768073>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.260489, 1.816488, -0.109601>, <-4.406534, 1.816488, -0.021411>, <-4.814301, 0.999068, 0.264880>, <-4.814301, 0.000000, 0.264880>, 
      <-3.517115, 1.816488, 0.076341>, <-4.027061, 1.816488, 0.358388>, <-4.434828, 0.999068, 0.644679>, <-4.434828, 0.000000, 0.644679>, 
      <-3.149207, 1.816488, 0.388275>, <-3.647588, 1.816488, 0.738186>, <-4.055355, 0.999068, 1.024477>, <-4.055355, 0.000000, 1.024477>, 
      <-2.769734, 1.837733, 0.768073>, <-3.268116, 1.816488, 1.117985>, <-3.675882, 0.999068, 1.404276>, <-3.675882, 0.000000, 1.404276>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.675882, 0.000000, 1.404276>, <-3.675882, -0.999068, 1.404276>, <-3.268116, -1.816488, 1.117985>, <-2.769734, -1.837733, 0.768073>, 
      <-3.296409, 0.000000, 1.784075>, <-3.296409, -0.999068, 1.784075>, <-2.888643, -1.816488, 1.497784>, <-2.390261, -1.816488, 1.147872>, 
      <-1.108001, 0.000000, 2.477072>, <-1.108001, -0.999068, 2.477072>, <-0.576105, -1.816488, 2.477072>, <0.073990, -1.816488, 2.477072>, 
      <-1.108001, 0.000000, 2.972487>, <-1.108001, -0.999068, 2.972487>, <-0.576105, -1.816488, 2.972487>, <0.073990, -1.837733, 2.972487>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.769734, -1.837733, 0.768073>, <-2.271353, -1.816488, 0.418162>, <-1.863587, -0.999068, 0.131871>, <-1.863587, 0.000000, 0.131871>, 
      <-2.390261, -1.816488, 1.147872>, <-1.891880, -1.816488, 0.797961>, <-1.484114, -0.999068, 0.511670>, <-1.484114, 0.000000, 0.511670>, 
      <0.073990, -1.816488, 2.477072>, <0.724085, -1.816488, 2.477072>, <1.255981, -0.999068, 2.477072>, <1.255981, 0.000000, 2.477072>, 
      <0.073990, -1.837733, 2.972487>, <0.724085, -1.816488, 2.972487>, <1.255981, -0.999068, 2.972487>, <1.255981, 0.000000, 2.972487>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.863587, 0.000000, 0.131871>, <-1.863587, 0.999068, 0.131871>, <-2.271353, 1.816488, 0.418162>, <-2.769734, 1.837733, 0.768073>, 
      <-1.484114, 0.000000, 0.511670>, <-1.484114, 0.999068, 0.511670>, <-1.891880, 1.816488, 0.797961>, <-2.390261, 1.816488, 1.147872>, 
      <1.255981, 0.000000, 2.477072>, <1.255981, 0.999068, 2.477072>, <0.724085, 1.816488, 2.477072>, <0.073990, 1.816488, 2.477072>, 
      <1.255981, 0.000000, 2.972487>, <1.255981, 0.999068, 2.972487>, <0.724085, 1.816488, 2.972487>, <0.073990, 1.837733, 2.972487>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.769734, 1.837733, 0.768073>, <-3.268116, 1.816488, 1.117985>, <-3.675882, 0.999068, 1.404276>, <-3.675882, 0.000000, 1.404276>, 
      <-2.390261, 1.816488, 1.147872>, <-2.888643, 1.816488, 1.497784>, <-3.296409, 0.999068, 1.784075>, <-3.296409, 0.000000, 1.784075>, 
      <0.073990, 1.816488, 2.477072>, <-0.576105, 1.816488, 2.477072>, <-1.108001, 0.999068, 2.477072>, <-1.108001, 0.000000, 2.477072>, 
      <0.073990, 1.837733, 2.972487>, <-0.576105, 1.816488, 2.972487>, <-1.108001, 0.999068, 2.972487>, <-1.108001, 0.000000, 2.972487>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.108001, 0.000000, 2.972487>, <-1.108001, -0.999068, 2.972487>, <-0.576105, -1.816488, 2.972487>, <0.073990, -1.837733, 2.972487>, 
      <-1.108001, 0.000000, 3.467901>, <-1.108001, -0.999068, 3.467901>, <-0.576105, -1.816488, 3.467901>, <0.073990, -1.816488, 3.467901>, 
      <-1.108001, 0.000000, 3.963315>, <-1.108001, -0.999068, 3.963315>, <-0.576105, -1.816488, 3.963315>, <0.073990, -1.816488, 3.963315>, 
      <-1.108001, 0.000000, 4.458730>, <-1.108001, -0.999068, 4.458730>, <-0.576105, -1.816488, 4.458730>, <0.073990, -1.816488, 4.458730>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.073990, -1.837733, 2.972487>, <0.724085, -1.816488, 2.972487>, <1.255981, -0.999068, 2.972487>, <1.255981, 0.000000, 2.972487>, 
      <0.073990, -1.816488, 3.467901>, <0.724085, -1.816488, 3.467901>, <1.255981, -0.999068, 3.467901>, <1.255981, 0.000000, 3.467901>, 
      <0.073990, -1.816488, 3.963315>, <0.724085, -1.816488, 3.963315>, <1.255981, -0.999068, 3.963315>, <1.255981, 0.000000, 3.963315>, 
      <0.073990, -1.816488, 4.458730>, <0.724085, -1.816488, 4.458730>, <1.255981, -0.999068, 4.458730>, <1.255981, 0.000000, 4.458730>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.255981, 0.000000, 2.972487>, <1.255981, 0.999068, 2.972487>, <0.724085, 1.816488, 2.972487>, <0.073990, 1.837733, 2.972487>, 
      <1.255981, 0.000000, 3.467901>, <1.255981, 0.999068, 3.467901>, <0.724085, 1.816488, 3.467901>, <0.073990, 1.816488, 3.467901>, 
      <1.255981, 0.000000, 3.963315>, <1.255981, 0.999068, 3.963315>, <0.724085, 1.816488, 3.963315>, <0.073990, 1.816488, 3.963315>, 
      <1.255981, 0.000000, 4.458730>, <1.255981, 0.999068, 4.458730>, <0.724085, 1.816488, 4.458730>, <0.073990, 1.816488, 4.458730>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.073990, 1.837733, 2.972487>, <-0.576105, 1.816488, 2.972487>, <-1.108001, 0.999068, 2.972487>, <-1.108001, 0.000000, 2.972487>, 
      <0.073990, 1.816488, 3.467901>, <-0.576105, 1.816488, 3.467901>, <-1.108001, 0.999068, 3.467901>, <-1.108001, 0.000000, 3.467901>, 
      <0.073990, 1.816488, 3.963315>, <-0.576105, 1.816488, 3.963315>, <-1.108001, 0.999068, 3.963315>, <-1.108001, 0.000000, 3.963315>, 
      <0.073990, 1.816488, 4.458730>, <-0.576105, 1.816488, 4.458730>, <-1.108001, 0.999068, 4.458730>, <-1.108001, 0.000000, 4.458730>
    }
  }
  material {
    Material3_1
  }
  scale <2.0, 2.0, 5.0>
  rotate <0.0, -76.31337, -0.0>
  translate  <-23.526669, -4.948236, -6.354334>
}
#declare Group003 = union {
  object { BezPtch003 }
  object { BezPtch002 }
  material {
    Material3_1
  }
  translate  <0.747569, 0.0, 3.737843>
}
#declare BezPtch005 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.687011, -6.189358, -5.758998>, <-4.688576, -7.316119, 1.439750>, <-3.000000, -5.000000, 0.000000>, <-2.000000, -5.000000, 0.000000>, 
      <-4.186228, -4.000000, -5.758998>, <-4.000000, -4.000000, 0.000000>, <-3.000000, -4.000000, 0.000000>, <-2.000000, -4.000000, 0.000000>, 
      <-4.186228, -3.000000, -5.758998>, <-4.000000, -3.000000, 0.000000>, <-3.000000, -3.000000, 0.000000>, <-1.718310, -3.281690, 0.000000>, 
      <-4.186228, -2.000000, -5.758998>, <-4.000000, -2.000000, 0.000000>, <-2.906103, -2.000000, 0.438185>, <-1.812207, -2.140845, 0.219092>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.186228, -2.000000, -5.758998>, <-4.000000, -2.000000, 0.000000>, <-2.906103, -2.000000, 0.438185>, <-1.812207, -2.140845, 0.219092>, 
      <-4.186228, -1.000000, -5.758998>, <-4.000000, -1.000000, 0.000000>, <-2.812207, -1.000000, 0.876369>, <-1.906103, -1.000000, 0.438185>, 
      <-4.186228, 0.000000, -5.758998>, <-4.000000, 0.000000, 0.000000>, <-3.000000, 0.000000, 0.000000>, <-2.187793, 0.250391, 0.219092>, 
      <-4.186228, 1.000000, -5.758998>, <-4.000000, 2.283255, 0.031299>, <-3.000000, 2.283255, 0.031299>, <-2.093897, 2.408451, 0.140845>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.186228, 1.000000, -5.758998>, <-4.000000, 2.283255, 0.031299>, <-3.000000, 2.283255, 0.031299>, <-2.093897, 2.408451, 0.140845>, 
      <-4.186228, 2.000000, -5.758998>, <-4.000000, 4.566510, 0.062598>, <-3.000000, 4.566510, 0.062598>, <-2.000000, 4.566510, 0.062598>, 
      <-3.622848, 5.629108, -5.758998>, <-3.123631, 4.752739, -2.942097>, <-1.935837, 5.629108, -3.630673>, <-1.530516, 5.441315, -2.128326>, 
      <-2.934272, 6.754304, -5.696401>, <-2.810642, 6.816901, -3.881064>, <-2.749609, 6.065728, -3.004695>, <-1.843505, 6.316119, -3.442879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -5.000000, 0.000000>, <-1.000000, -5.000000, 0.000000>, <-0.250391, -6.126761, 0.000000>, <0.749609, -6.126761, 0.000000>, 
      <-2.000000, -4.000000, 0.000000>, <-1.000000, -4.000000, 0.000000>, <0.000000, -4.000000, 0.000000>, <1.000000, -4.000000, 0.000000>, 
      <-1.718310, -3.281690, 0.000000>, <-0.436620, -3.563380, 0.000000>, <0.000000, -3.000000, 0.000000>, <1.000000, -3.000000, 0.000000>, 
      <-1.812207, -2.140845, 0.219092>, <-0.718310, -2.281690, 0.000000>, <0.000000, -2.000000, 0.000000>, <0.624413, -2.000000, -0.735524>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.812207, -2.140845, 0.219092>, <-0.718310, -2.281690, 0.000000>, <0.000000, -2.000000, 0.000000>, <0.624413, -2.000000, -0.735524>, 
      <-1.906103, -1.000000, 0.438185>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.248826, -1.000000, -1.471049>, 
      <-2.187793, 0.250391, 0.219092>, <-1.375587, 0.500782, 0.438185>, <0.000000, 0.000000, 0.000000>, <0.248826, 0.000000, -1.471049>, 
      <-2.093897, 2.408451, 0.140845>, <-1.187793, 2.533646, 0.250391>, <-0.438185, 2.251956, 0.031299>, <-0.189358, 1.610329, -1.455399>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.093897, 2.408451, 0.140845>, <-1.187793, 2.533646, 0.250391>, <-0.438185, 2.251956, 0.031299>, <-0.189358, 1.610329, -1.455399>, 
      <-2.000000, 4.566510, 0.062598>, <-1.000000, 4.566510, 0.062598>, <-0.876369, 4.503912, 0.062598>, <-0.627543, 3.220657, -1.439750>, 
      <-1.530516, 5.441315, -2.128326>, <-1.125196, 5.253521, -0.625978>, <-0.813772, 5.316119, -0.625978>, <-1.034429, 5.754304, -0.970266>, 
      <-1.843505, 6.316119, -3.442879>, <-0.937402, 6.566510, -3.881064>, <-0.813772, 5.752739, -2.378717>, <-1.097027, 6.159624, -2.660407>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.749609, -6.126761, 0.000000>, <1.749609, -6.126761, 0.000000>, <2.874804, -7.316119, 0.500782>, <3.812207, -7.316119, 0.500782>, 
      <1.000000, -4.000000, 0.000000>, <2.000000, -4.000000, 0.000000>, <3.000000, -4.000000, 0.000000>, <4.000000, -4.000000, 0.000000>, 
      <1.000000, -3.000000, 0.000000>, <2.000000, -3.000000, 0.000000>, <3.000000, -3.000000, 0.000000>, <4.000000, -3.000000, 0.000000>, 
      <0.624413, -2.000000, -0.735524>, <1.248826, -2.000000, -1.471049>, <2.248826, -2.000000, -1.471049>, <3.530516, -2.000000, -1.439750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.624413, -2.000000, -0.735524>, <1.248826, -2.000000, -1.471049>, <2.248826, -2.000000, -1.471049>, <3.530516, -2.000000, -1.439750>, 
      <0.248826, -1.000000, -1.471049>, <0.497653, -1.000000, -2.942097>, <1.497653, -1.000000, -2.942097>, <3.061033, -1.000000, -2.879499>, 
      <0.248826, 0.000000, -1.471049>, <0.497653, 0.000000, -2.942097>, <1.497653, 0.000000, -2.942097>, <1.308294, 0.000000, -5.571205>, 
      <-0.189358, 1.610329, -1.455399>, <0.059468, 0.968701, -2.942097>, <1.059468, 0.968701, -2.942097>, <0.870110, 0.968701, -5.571205>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.189358, 1.610329, -1.455399>, <0.059468, 0.968701, -2.942097>, <1.059468, 0.968701, -2.942097>, <0.870110, 0.968701, -5.571205>, 
      <-0.627543, 3.220657, -1.439750>, <-0.378717, 1.937402, -2.942097>, <0.621283, 1.937402, -2.942097>, <0.431925, 1.937402, -5.571205>, 
      <-1.034429, 5.754304, -0.970266>, <-1.255086, 6.192488, -1.314554>, <-0.943662, 5.629108, -2.065728>, <-0.381847, 5.566510, -5.508607>, 
      <-1.097027, 6.159624, -2.660407>, <-1.380282, 6.566510, -2.942097>, <-1.068858, 6.629108, -2.942097>, <-0.381847, 6.566510, -5.508607>
    }
  }
  material {
    Material3_1
  }
  scale 2.0
  rotate 90.0*x
  translate  <-43.139475, -10.996081, 3.737843>
}
#declare BezPtch006 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.749609, -6.189358, -5.508607>, <7.004695, -6.001565, 4.820031>, <3.000000, -5.000000, 0.000000>, <2.000000, -5.000000, 0.000000>, 
      <4.248826, -4.000000, -5.508607>, <4.000000, -4.000000, 0.000000>, <3.000000, -4.000000, 0.000000>, <2.000000, -4.000000, 0.000000>, 
      <4.248826, -3.000000, -5.508607>, <4.000000, -3.000000, 0.000000>, <3.000000, -3.000000, 0.000000>, <1.718310, -3.281690, 0.000000>, 
      <4.248826, -2.000000, -5.508607>, <4.000000, -2.000000, 0.000000>, <2.906103, -2.000000, 0.438185>, <1.812207, -2.140845, 0.219092>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.248826, -2.000000, -5.508607>, <4.000000, -2.000000, 0.000000>, <2.906103, -2.000000, 0.438185>, <1.812207, -2.140845, 0.219092>, 
      <4.248826, -1.000000, -5.508607>, <4.000000, -1.000000, 0.000000>, <2.812207, -1.000000, 0.876369>, <1.906103, -1.000000, 0.438185>, 
      <4.248826, 0.000000, -5.508607>, <4.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>, <2.187793, 0.250391, 0.219092>, 
      <4.248826, 1.000000, -5.508607>, <3.687011, 2.971831, 0.125196>, <2.687011, 2.971831, 0.125196>, <1.780908, 3.097027, 0.203443>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.248826, 1.000000, -5.508607>, <3.687011, 2.971831, 0.125196>, <2.687011, 2.971831, 0.125196>, <1.780908, 3.097027, 0.203443>, 
      <4.248826, 2.000000, -5.508607>, <3.374022, 5.943662, 0.250391>, <2.374022, 5.943662, 0.250391>, <1.374022, 5.943662, 0.250391>, 
      <3.685446, 5.629108, -5.508607>, <3.186228, 5.503912, -3.505477>, <2.374022, 5.441315, -2.065728>, <1.374022, 5.441315, -2.065728>, 
      <2.996870, 6.754304, -5.508607>, <2.372457, 6.629108, -3.129890>, <2.624413, 6.441315, -3.129890>, <1.624413, 6.441315, -3.129890>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.000000, -5.000000, 0.000000>, <1.000000, -5.000000, 0.000000>, <0.000000, -5.000000, 0.000000>, <-1.000000, -5.000000, 0.000000>, 
      <2.000000, -4.000000, 0.000000>, <1.000000, -4.000000, 0.000000>, <0.000000, -4.000000, 0.000000>, <-1.000000, -4.000000, 0.000000>, 
      <1.718310, -3.281690, 0.000000>, <0.436620, -3.563380, 0.000000>, <0.000000, -3.000000, 0.000000>, <-1.000000, -3.000000, 0.000000>, 
      <1.812207, -2.140845, 0.219092>, <0.718310, -2.281690, 0.000000>, <0.000000, -2.000000, 0.000000>, <-0.624413, -2.000000, -0.735524>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.812207, -2.140845, 0.219092>, <0.718310, -2.281690, 0.000000>, <0.000000, -2.000000, 0.000000>, <-0.624413, -2.000000, -0.735524>, 
      <1.906103, -1.000000, 0.438185>, <1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <-0.248826, -1.000000, -1.471049>, 
      <2.187793, 0.250391, 0.219092>, <1.375587, 0.500782, 0.438185>, <0.000000, 0.000000, 0.000000>, <-0.248826, 0.000000, -1.471049>, 
      <1.780908, 3.097027, 0.203443>, <0.874804, 3.222222, 0.344288>, <0.125196, 2.940532, 0.125196>, <0.032864, 1.954617, -1.424100>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.780908, 3.097027, 0.203443>, <0.874804, 3.222222, 0.344288>, <0.125196, 2.940532, 0.125196>, <0.032864, 1.954617, -1.424100>, 
      <1.374022, 5.943662, 0.250391>, <0.374022, 5.943662, 0.250391>, <0.250391, 5.881064, 0.250391>, <0.314554, 3.909233, -1.345853>, 
      <1.374022, 5.441315, -2.065728>, <0.374022, 5.441315, -2.065728>, <0.563380, 5.503912, -3.505477>, <0.533646, 5.503912, -3.223787>, 
      <1.624413, 6.441315, -3.129890>, <0.624413, 6.441315, -3.129890>, <0.563380, 6.503912, -3.505477>, <0.658842, 6.347418, -3.317684>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -5.000000, 0.000000>, <-2.000000, -5.000000, 0.000000>, <-4.627543, -7.691706, 1.126761>, <-5.564945, -7.691706, 1.126761>, 
      <-1.000000, -4.000000, 0.000000>, <-2.000000, -4.000000, 0.000000>, <-3.000000, -4.000000, 0.000000>, <-4.000000, -4.000000, 0.000000>, 
      <-1.000000, -3.000000, 0.000000>, <-2.000000, -3.000000, 0.000000>, <-3.000000, -3.000000, 0.000000>, <-4.000000, -3.000000, 0.000000>, 
      <-0.624413, -2.000000, -0.735524>, <-1.248826, -2.000000, -1.471049>, <-2.248826, -2.000000, -1.471049>, <-3.530516, -2.000000, -1.439750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.624413, -2.000000, -0.735524>, <-1.248826, -2.000000, -1.471049>, <-2.248826, -2.000000, -1.471049>, <-3.530516, -2.000000, -1.439750>, 
      <-0.248826, -1.000000, -1.471049>, <-0.497653, -1.000000, -2.942097>, <-1.497653, -1.000000, -2.942097>, <-3.061033, -1.000000, -2.879499>, 
      <-0.248826, 0.000000, -1.471049>, <-0.497653, 0.000000, -2.942097>, <-1.497653, 0.000000, -2.942097>, <-1.308294, 0.000000, -5.571205>, 
      <0.032864, 1.954617, -1.424100>, <-0.059468, 0.968701, -2.942097>, <-1.059468, 0.968701, -2.942097>, <-0.870110, 0.968701, -5.571205>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.032864, 1.954617, -1.424100>, <-0.059468, 0.968701, -2.942097>, <-1.059468, 0.968701, -2.942097>, <-0.870110, 0.968701, -5.571205>, 
      <0.314554, 3.909233, -1.345853>, <0.378717, 1.937402, -2.942097>, <-0.621283, 1.937402, -2.942097>, <-0.431925, 1.937402, -5.571205>, 
      <0.533646, 5.503912, -3.223787>, <0.503912, 5.503912, -2.942097>, <0.192488, 5.566510, -2.942097>, <0.381847, 5.566510, -5.571205>, 
      <0.658842, 6.347418, -3.317684>, <0.754304, 6.190923, -3.129890>, <0.442879, 6.253521, -3.129890>, <0.381847, 6.566510, -5.571205>
    }
  }
  material {
    Material3_1
  }
  scale 2.0
  rotate <90.0, 0.0, 180.0>
  translate  <-43.139475, 10.99608, 3.737843>
}
#declare Group002 = union {
  object { BezPtch005 }
  object { BezPtch006 }
  translate  <0.373784, 0.0, 4.859196>
}
#declare BezPtch004 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.111520, -1.073272, 0.000000>, <0.660851, -1.100280, 0.002450>, <1.132402, -0.672920, 0.004454>, <1.159410, -0.123584, 0.004454>, 
      <0.109296, -1.073162, 0.499995>, <0.658627, -1.100170, 0.502445>, <1.130178, -0.672811, 0.504449>, <1.157186, -0.123474, 0.504449>, 
      <0.107072, -1.073053, 0.999990>, <0.656403, -1.100061, 1.002440>, <1.127953, -0.672702, 1.004444>, <1.154962, -0.123365, 1.004444>, 
      <0.104847, -1.072944, 1.499985>, <0.654178, -1.099952, 1.502435>, <1.125729, -0.672592, 1.504439>, <1.152737, -0.123256, 1.504439>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.159410, -0.123584, 0.004454>, <1.186419, 0.425753, 0.004454>, <0.759064, 0.897307, 0.002450>, <0.209733, 0.924315, 0.000000>, 
      <1.157186, -0.123474, 0.504449>, <1.184194, 0.425862, 0.504449>, <0.756839, 0.897417, 0.502445>, <0.207508, 0.924425, 0.499995>, 
      <1.154962, -0.123365, 1.004444>, <1.181970, 0.425971, 1.004444>, <0.754615, 0.897526, 1.002440>, <0.205284, 0.924534, 0.999990>, 
      <1.152737, -0.123256, 1.504439>, <1.179746, 0.426081, 1.504439>, <0.752391, 0.897635, 1.502435>, <0.203060, 0.924644, 1.499985>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.209733, 0.924315, 0.000000>, <-0.339598, 0.951324, -0.002450>, <-0.811149, 0.523964, -0.004454>, <-0.838157, -0.025372, -0.004454>, 
      <0.207508, 0.924425, 0.499995>, <-0.341823, 0.951433, 0.497545>, <-0.813373, 0.524073, 0.495541>, <-0.840381, -0.025263, 0.495541>, 
      <0.205284, 0.924534, 0.999990>, <-0.344047, 0.951542, 0.997540>, <-0.815597, 0.524183, 0.995536>, <-0.842606, -0.025154, 0.995536>, 
      <0.203060, 0.924644, 1.499985>, <-0.346271, 0.951652, 1.497535>, <-0.817822, 0.524292, 1.495531>, <-0.844830, -0.025044, 1.495531>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.838157, -0.025372, -0.004454>, <-0.865165, -0.574709, -0.004454>, <-0.437811, -1.046264, -0.002450>, <0.111520, -1.073272, 0.000000>, 
      <-0.840381, -0.025263, 0.495541>, <-0.867390, -0.574600, 0.495541>, <-0.440035, -1.046154, 0.497545>, <0.109296, -1.073162, 0.499995>, 
      <-0.842606, -0.025154, 0.995536>, <-0.869614, -0.574490, 0.995536>, <-0.442259, -1.046045, 0.997540>, <0.107072, -1.073053, 0.999990>, 
      <-0.844830, -0.025044, 1.495531>, <-0.871838, -0.574381, 1.495531>, <-0.444484, -1.045936, 1.497535>, <0.104847, -1.072944, 1.499985>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.104847, -1.072944, 1.499985>, <0.654178, -1.099952, 1.502435>, <1.125729, -0.672592, 1.504439>, <1.152737, -0.123256, 1.504439>, 
      <0.102623, -1.072834, 1.999980>, <0.651954, -1.099842, 2.002430>, <1.123505, -0.672483, 2.004434>, <1.150513, -0.123146, 2.004434>, 
      <0.100399, -1.072725, 2.499975>, <0.649730, -1.099733, 2.502425>, <1.121280, -0.672373, 2.504429>, <1.148289, -0.123037, 2.504429>, 
      <0.098174, -1.072616, 2.999970>, <0.647505, -1.099624, 3.002420>, <1.119056, -0.672264, 3.004424>, <1.146064, -0.122928, 3.004424>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.152737, -0.123256, 1.504439>, <1.179746, 0.426081, 1.504439>, <0.752391, 0.897635, 1.502435>, <0.203060, 0.924644, 1.499985>, 
      <1.150513, -0.123146, 2.004434>, <1.177521, 0.426190, 2.004434>, <0.750166, 0.897745, 2.002430>, <0.200835, 0.924753, 1.999980>, 
      <1.148289, -0.123037, 2.504429>, <1.175297, 0.426299, 2.504429>, <0.747942, 0.897854, 2.502425>, <0.198611, 0.924862, 2.499975>, 
      <1.146064, -0.122928, 3.004424>, <1.173073, 0.426409, 3.004424>, <0.745718, 0.897963, 3.002420>, <0.196387, 0.924972, 2.999970>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.203060, 0.924644, 1.499985>, <-0.346271, 0.951652, 1.497535>, <-0.817822, 0.524292, 1.495531>, <-0.844830, -0.025044, 1.495531>, 
      <0.200835, 0.924753, 1.999980>, <-0.348496, 0.951761, 1.997530>, <-0.820046, 0.524401, 1.995526>, <-0.847054, -0.024935, 1.995526>, 
      <0.198611, 0.924862, 2.499975>, <-0.350720, 0.951870, 2.497525>, <-0.822270, 0.524511, 2.495521>, <-0.849279, -0.024826, 2.495521>, 
      <0.196387, 0.924972, 2.999970>, <-0.352944, 0.951980, 2.997521>, <-0.824495, 0.524620, 2.995516>, <-0.851503, -0.024716, 2.995516>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.844830, -0.025044, 1.495531>, <-0.871838, -0.574381, 1.495531>, <-0.444484, -1.045936, 1.497535>, <0.104847, -1.072944, 1.499985>, 
      <-0.847054, -0.024935, 1.995526>, <-0.874063, -0.574271, 1.995526>, <-0.446708, -1.045826, 1.997530>, <0.102623, -1.072834, 1.999980>, 
      <-0.849279, -0.024826, 2.495521>, <-0.876287, -0.574162, 2.495521>, <-0.448932, -1.045717, 2.497525>, <0.100399, -1.072725, 2.499975>, 
      <-0.851503, -0.024716, 2.995516>, <-0.878511, -0.574053, 2.995516>, <-0.451157, -1.045607, 2.997521>, <0.098174, -1.072616, 2.999970>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.098174, -1.072616, 2.999970>, <0.647505, -1.099624, 3.002420>, <1.119056, -0.672264, 3.004424>, <1.146064, -0.122928, 3.004424>, 
      <0.095950, -1.072506, 3.499965>, <0.645281, -1.099514, 3.502415>, <1.116832, -0.672155, 3.504419>, <1.143840, -0.122818, 3.504419>, 
      <0.093726, -1.072397, 3.999960>, <0.643057, -1.099405, 4.002410>, <1.114607, -0.672045, 4.004414>, <1.141616, -0.122709, 4.004414>, 
      <0.091502, -1.072287, 4.499955>, <0.640833, -1.099296, 4.502405>, <2.177035, -0.777962, 6.932667>, <2.204044, -0.228625, 6.932667>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.146064, -0.122928, 3.004424>, <1.173073, 0.426409, 3.004424>, <0.745718, 0.897963, 3.002420>, <0.196387, 0.924972, 2.999970>, 
      <1.143840, -0.122818, 3.504419>, <1.170848, 0.426518, 3.504419>, <0.743493, 0.898073, 3.502415>, <0.194162, 0.925081, 3.499965>, 
      <1.141616, -0.122709, 4.004414>, <1.168624, 0.426628, 4.004414>, <0.741269, 0.898182, 4.002410>, <0.191938, 0.925190, 3.999960>, 
      <2.204044, -0.228625, 6.932667>, <2.231052, 0.320711, 6.932667>, <0.739045, 0.898292, 4.502405>, <0.189714, 0.925300, 4.499955>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.196387, 0.924972, 2.999970>, <-0.352944, 0.951980, 2.997521>, <-0.824495, 0.524620, 2.995516>, <-0.851503, -0.024716, 2.995516>, 
      <0.194162, 0.925081, 3.499965>, <-0.355169, 0.952089, 3.497516>, <-0.826719, 0.524730, 3.495511>, <-0.853727, -0.024607, 3.495511>, 
      <0.191938, 0.925190, 3.999960>, <-0.357393, 0.952198, 3.997511>, <-0.828943, 0.524839, 3.995506>, <-0.855952, -0.024498, 3.995506>, 
      <0.189714, 0.925300, 4.499955>, <-0.359617, 0.952308, 4.497506>, <-0.831168, 0.524948, 4.495501>, <-0.858176, -0.024388, 4.495501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.851503, -0.024716, 2.995516>, <-0.878511, -0.574053, 2.995516>, <-0.451157, -1.045607, 2.997521>, <0.098174, -1.072616, 2.999970>, 
      <-0.853727, -0.024607, 3.495511>, <-0.880736, -0.573943, 3.495511>, <-0.453381, -1.045498, 3.497516>, <0.095950, -1.072506, 3.499965>, 
      <-0.855952, -0.024498, 3.995506>, <-0.882960, -0.573834, 3.995506>, <-0.455605, -1.045389, 3.997511>, <0.093726, -1.072397, 3.999960>, 
      <-0.858176, -0.024388, 4.495501>, <-0.885184, -0.573725, 4.495501>, <-0.457829, -1.045279, 4.497506>, <0.091502, -1.072287, 4.499955>
    }
  }
  material {
    Material3_1
  }
  scale <1.950725, 2.165195, 3.464868>
  rotate <6.712265, -44.624222, -3.391708>
  translate  <-32.972127, 10.485976, -0.316837>
}
#declare BezPtch007 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.111520, -1.073272, 0.000000>, <0.660851, -1.100280, 0.002450>, <1.132402, -0.672920, 0.004454>, <1.159410, -0.123584, 0.004454>, 
      <0.109296, -1.073162, 0.499995>, <0.658627, -1.100170, 0.502445>, <1.130178, -0.672811, 0.504449>, <1.157186, -0.123474, 0.504449>, 
      <0.107072, -1.073053, 0.999990>, <0.656403, -1.100061, 1.002440>, <1.127953, -0.672702, 1.004444>, <1.154962, -0.123365, 1.004444>, 
      <0.104847, -1.072944, 1.499985>, <0.654178, -1.099952, 1.502435>, <1.125729, -0.672592, 1.504439>, <1.152737, -0.123256, 1.504439>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.159410, -0.123584, 0.004454>, <1.186419, 0.425753, 0.004454>, <0.759064, 0.897307, 0.002450>, <0.209733, 0.924315, 0.000000>, 
      <1.157186, -0.123474, 0.504449>, <1.184194, 0.425862, 0.504449>, <0.756839, 0.897417, 0.502445>, <0.207508, 0.924425, 0.499995>, 
      <1.154962, -0.123365, 1.004444>, <1.181970, 0.425971, 1.004444>, <0.754615, 0.897526, 1.002440>, <0.205284, 0.924534, 0.999990>, 
      <1.152737, -0.123256, 1.504439>, <1.179746, 0.426081, 1.504439>, <0.752391, 0.897635, 1.502435>, <0.203060, 0.924644, 1.499985>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.209733, 0.924315, 0.000000>, <-0.339598, 0.951324, -0.002450>, <-0.811149, 0.523964, -0.004454>, <-0.838157, -0.025372, -0.004454>, 
      <0.207508, 0.924425, 0.499995>, <-0.341823, 0.951433, 0.497545>, <-0.813373, 0.524073, 0.495541>, <-0.840381, -0.025263, 0.495541>, 
      <0.205284, 0.924534, 0.999990>, <-0.344047, 0.951542, 0.997540>, <-0.815597, 0.524183, 0.995536>, <-0.842606, -0.025154, 0.995536>, 
      <0.203060, 0.924644, 1.499985>, <-0.346271, 0.951652, 1.497535>, <-0.817822, 0.524292, 1.495531>, <-0.844830, -0.025044, 1.495531>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.838157, -0.025372, -0.004454>, <-0.865165, -0.574709, -0.004454>, <-0.437811, -1.046264, -0.002450>, <0.111520, -1.073272, 0.000000>, 
      <-0.840381, -0.025263, 0.495541>, <-0.867390, -0.574600, 0.495541>, <-0.440035, -1.046154, 0.497545>, <0.109296, -1.073162, 0.499995>, 
      <-0.842606, -0.025154, 0.995536>, <-0.869614, -0.574490, 0.995536>, <-0.442259, -1.046045, 0.997540>, <0.107072, -1.073053, 0.999990>, 
      <-0.844830, -0.025044, 1.495531>, <-0.871838, -0.574381, 1.495531>, <-0.444484, -1.045936, 1.497535>, <0.104847, -1.072944, 1.499985>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.104847, -1.072944, 1.499985>, <0.654178, -1.099952, 1.502435>, <1.125729, -0.672592, 1.504439>, <1.152737, -0.123256, 1.504439>, 
      <0.102623, -1.072834, 1.999980>, <0.651954, -1.099842, 2.002430>, <1.123505, -0.672483, 2.004434>, <1.150513, -0.123146, 2.004434>, 
      <0.100399, -1.072725, 2.499975>, <0.649730, -1.099733, 2.502425>, <1.121280, -0.672373, 2.504429>, <1.148289, -0.123037, 2.504429>, 
      <0.098174, -1.072616, 2.999970>, <0.647505, -1.099624, 3.002420>, <1.119056, -0.672264, 3.004424>, <1.146064, -0.122928, 3.004424>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.152737, -0.123256, 1.504439>, <1.179746, 0.426081, 1.504439>, <0.752391, 0.897635, 1.502435>, <0.203060, 0.924644, 1.499985>, 
      <1.150513, -0.123146, 2.004434>, <1.177521, 0.426190, 2.004434>, <0.750166, 0.897745, 2.002430>, <0.200835, 0.924753, 1.999980>, 
      <1.148289, -0.123037, 2.504429>, <1.175297, 0.426299, 2.504429>, <0.747942, 0.897854, 2.502425>, <0.198611, 0.924862, 2.499975>, 
      <1.146064, -0.122928, 3.004424>, <1.173073, 0.426409, 3.004424>, <0.745718, 0.897963, 3.002420>, <0.196387, 0.924972, 2.999970>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.203060, 0.924644, 1.499985>, <-0.346271, 0.951652, 1.497535>, <-0.817822, 0.524292, 1.495531>, <-0.844830, -0.025044, 1.495531>, 
      <0.200835, 0.924753, 1.999980>, <-0.348496, 0.951761, 1.997530>, <-0.820046, 0.524401, 1.995526>, <-0.847054, -0.024935, 1.995526>, 
      <0.198611, 0.924862, 2.499975>, <-0.350720, 0.951870, 2.497525>, <-0.822270, 0.524511, 2.495521>, <-0.849279, -0.024826, 2.495521>, 
      <0.196387, 0.924972, 2.999970>, <-0.352944, 0.951980, 2.997521>, <-0.824495, 0.524620, 2.995516>, <-0.851503, -0.024716, 2.995516>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.844830, -0.025044, 1.495531>, <-0.871838, -0.574381, 1.495531>, <-0.444484, -1.045936, 1.497535>, <0.104847, -1.072944, 1.499985>, 
      <-0.847054, -0.024935, 1.995526>, <-0.874063, -0.574271, 1.995526>, <-0.446708, -1.045826, 1.997530>, <0.102623, -1.072834, 1.999980>, 
      <-0.849279, -0.024826, 2.495521>, <-0.876287, -0.574162, 2.495521>, <-0.448932, -1.045717, 2.497525>, <0.100399, -1.072725, 2.499975>, 
      <-0.851503, -0.024716, 2.995516>, <-0.878511, -0.574053, 2.995516>, <-0.451157, -1.045607, 2.997521>, <0.098174, -1.072616, 2.999970>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.098174, -1.072616, 2.999970>, <0.647505, -1.099624, 3.002420>, <1.119056, -0.672264, 3.004424>, <1.146064, -0.122928, 3.004424>, 
      <0.095950, -1.072506, 3.499965>, <0.645281, -1.099514, 3.502415>, <1.116832, -0.672155, 3.504419>, <1.143840, -0.122818, 3.504419>, 
      <0.093726, -1.072397, 3.999960>, <0.643057, -1.099405, 4.002410>, <1.114607, -0.672045, 4.004414>, <1.141616, -0.122709, 4.004414>, 
      <0.091502, -1.072287, 4.499955>, <0.640833, -1.099296, 4.502405>, <3.503521, -0.777962, 5.375479>, <3.530529, -0.228625, 5.375479>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.146064, -0.122928, 3.004424>, <1.173073, 0.426409, 3.004424>, <0.745718, 0.897963, 3.002420>, <0.196387, 0.924972, 2.999970>, 
      <1.143840, -0.122818, 3.504419>, <1.170848, 0.426518, 3.504419>, <0.743493, 0.898073, 3.502415>, <0.194162, 0.925081, 3.499965>, 
      <1.141616, -0.122709, 4.004414>, <1.168624, 0.426628, 4.004414>, <0.741269, 0.898182, 4.002410>, <0.191938, 0.925190, 3.999960>, 
      <3.530529, -0.228625, 5.375479>, <3.557538, 0.320711, 5.375479>, <0.739045, 0.898292, 4.502405>, <0.189714, 0.925300, 4.499955>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.196387, 0.924972, 2.999970>, <-0.352944, 0.951980, 2.997521>, <-0.824495, 0.524620, 2.995516>, <-0.851503, -0.024716, 2.995516>, 
      <0.194162, 0.925081, 3.499965>, <-0.355169, 0.952089, 3.497516>, <-0.826719, 0.524730, 3.495511>, <-0.853727, -0.024607, 3.495511>, 
      <0.191938, 0.925190, 3.999960>, <-0.357393, 0.952198, 3.997511>, <-0.828943, 0.524839, 3.995506>, <-0.855952, -0.024498, 3.995506>, 
      <0.189714, 0.925300, 4.499955>, <-0.359617, 0.952308, 4.497506>, <-0.831168, 0.524948, 4.495501>, <-0.858176, -0.024388, 4.495501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.851503, -0.024716, 2.995516>, <-0.878511, -0.574053, 2.995516>, <-0.451157, -1.045607, 2.997521>, <0.098174, -1.072616, 2.999970>, 
      <-0.853727, -0.024607, 3.495511>, <-0.880736, -0.573943, 3.495511>, <-0.453381, -1.045498, 3.497516>, <0.095950, -1.072506, 3.499965>, 
      <-0.855952, -0.024498, 3.995506>, <-0.882960, -0.573834, 3.995506>, <-0.455605, -1.045389, 3.997511>, <0.093726, -1.072397, 3.999960>, 
      <-0.858176, -0.024388, 4.495501>, <-0.885184, -0.573725, 4.495501>, <-0.457829, -1.045279, 4.497506>, <0.091502, -1.072287, 4.499955>
    }
  }
  material {
    Material3_1
  }
  scale <1.950725, 2.165195, 3.464868>
  rotate <-0.0, -75.511101, -0.0>
  translate  <-29.079035, -9.29712, 5.785846>
}
#declare Clothes = union {
  object { Group002 }
  object { BezPtch004 }
  object { BezPtch007 }
}
#declare Group005 = union {
  sphere { // Sphere019
    <0,0,0>,1
    material {
      Material5
    }
    scale <0.686453, 1.0, 0.522504>
    translate  <-42.677368, -1.113382, 28.19922>
  }
  sphere { // Sphere020
    <0,0,0>,1
    material {
      Material5
    }
    scale <0.686453, 1.0, 0.522504>
    translate  <-42.677368, 1.11338, 28.19922>
  }
  sphere { // Sphere022
    <0,0,0>,1
    material {
      MyFlesh
    }
    scale <0.686453, 1.62458, 0.522504>
    rotate <-90.0, -26.562119, 0.0>
    translate  <-42.370251, 0.0, 27.163273>
  }
  sphere { // Sphere021
    <0,0,0>,1
    material {
      Material5
    }
    scale <0.686453, 1.62458, 0.522504>
    translate  <-42.766953, 0.0, 25.601259>
  }
  translate  <0.126337, 0.0, -1.073862>
}
#declare Group004 = union {
  torus { // Torus004
    1.5, 0.5  rotate -x*90
    material {
      Turban
    }
    scale <3.006141, 2.26868, 1.961>
    rotate <6.579032, 0.0, -0.0>
    translate  <-47.179464, -0.0, 29.727931>
  }
  torus { // Torus008
    1.5, 0.5  rotate -x*90
    material {
      Turban
    }
    scale <-4.764174, -3.006334, -1.295969>
    rotate <-45.0, 45.0, 0.0>
    translate  <-46.908318, 0.494851, 24.803139>
  }
  torus { // Torus005
    1.5, 0.5  rotate -x*90
    material {
      Turban
    }
    scale <3.232423, 2.638094, 2.374946>
    rotate <-3.561671, 0.0, 0.0>
    translate  <-47.45061, 0.494851, 28.385702>
  }
  torus { // Torus006
    1.5, 0.5  rotate -x*90
    material {
      Turban
    }
    scale <-4.764174, -3.006334, -1.295969>
    rotate <-5.0, 45.0, 0.0>
    translate  <-46.908318, 0.494851, 24.803139>
  }
  torus { // Torus007
    1.5, 0.5  rotate -x*90
    material {
      Turban
    }
    scale <-4.599351, -2.791401, -1.926199>
    rotate <0.0, 30.0, -0.0>
    translate  <-46.908318, 0.391872, 25.3>
  }
}
#declare Character = union {
  object { Group003 }
  object { Clothes }
  sphere { // Sphere038
    <0,0,0>,1
    material {
      MyFlesh
    }
    scale <2.767189, 1.542814, 1.412564>
    rotate 36.24638*y
    translate  <-32.145752, 10.458063, -0.739845>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    material {
      Material3_1
    }
    scale <-2.700381, -7.359829, -6.195938>
    rotate <-180.0, 17.81979, -180.0>
    translate  <-44.444886, 0.0, 4.01657>
  }
  object { Group005 }
  object { Group004 }
  sphere { // Sphere013
    <0,0,0>,1
    material {
      Material4
    }
    scale <5.101031, 2.454927, 1.699053>
    rotate <-0.0, -27.779438, 0.0>
    translate  <-20.912699, 5.381937, -9.718393>
  }
  sphere { // Sphere014
    <0,0,0>,1
    material {
      Material4
    }
    scale <5.101031, 2.454927, 1.699053>
    rotate <-0.0, -27.779438, 0.0>
    translate  <-20.912699, -5.38194, -9.718393>
  }
  sphere { // Sphere012
    <0,0,0>,1
    material {
      MyFlesh
    }
    scale 3.990274
    translate  <-46.349259, 0.0, 26.912473>
  }
  sphere { // Sphere039
    <0,0,0>,1
    material {
      MyFlesh
    }
    scale <2.767189, 1.542814, 1.412564>
    rotate 13.18735*y
    translate  <-28.706976, -9.646758, 5.958956>
  }
}
#declare CSG003 = difference {
  torus { // Torus002
    1.25, 0.45  rotate -x*90
    scale <1.369706, 1.0, 0.7>
    rotate -90.0*x
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <3.209946, 2.0, 2.031493>
    translate  2.0*z
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <0.899171, 1.0, 0.842537>
    translate  <-1.646871, 0.0, 0.314927>
  }
  material {
    Camel1
  }
  scale <11.121353, 10.0, 11.868921>
  translate  <-27.286257, 0.0, -2.242706>
}
#declare CSG004 = difference {
  torus { // Torus003
    1.25, 0.45  rotate -x*90
    scale <1.369706, 1.0, 0.7>
    rotate -90.0*x
    translate  -0.336096*x
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <3.209946, 2.0, 2.031493>
    translate  2.0*z
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    material {
      Camel1
    }
    scale <1.705802, 1.0, 1.314927>
    rotate <-180.0, -0.0, -180.0>
    translate  <-1.555205, 0.0, -1.071571>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    material {
      Camel1
    }
    scale <0.769088, 1.0, 1.319654>
    rotate <180.0, 43.857609, 180.0>
    translate  <0.320259, 0.0, -1.543962>
  }
  material {
    Camel1
  }
  scale <11.0, 10.0, 11.868921>
  rotate <180.0, 0.0, 180.0>
  translate  <7.0, 0.0, -3.0>
}
#declare Neck1 = union {
  object { CSG003 }
  object { CSG004 }
}
#declare CSG001 = union {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <3.3, 3.3, 9.0>
    rotate -90.0*y
    translate  <-1.587066, 0.0, 5.61689>
  }
  sphere { // Sphere002
    <0,0,0>,1
    scale 3.714829
    translate  <0.093615, 0.0, 5.523273>
  }
  material {
    Camel1
  }
}
#declare CSG002 = difference {
  object { CSG001 }
  sphere { // Sphere003
    <0,0,0>,1
    material {
      Camel1
    }
    scale <1.0, 1.0, 0.5>
    translate  <1.821482, -2.319065, 7.20834>
  }
  sphere { // Sphere005
    <0,0,0>,1
    scale <1.0, 1.0, 0.5>
    translate  <1.82148, 2.319, 7.20834>
  }
  material {
    Camel1
  }
}
#declare CSG005 = difference {
  sphere { // Sphere008
    <0,0,0>,1
    material {
      Camel1
    }
    scale <1.90639, 2.0, 2.6553>
    rotate -21.736*y
    translate  <-3.71645, 3.9447, 12.68432>
  }
  sphere { // Sphere015
    <0,0,0>,1
    material {
      Material4
    }
    scale <0.953195, 1.0, 1.32765>
    rotate -21.736*y
    translate  <-2.5, 4.77269, 13.058104>
  }
  translate  <-10.98055, 0.0, -3.5>
}
#declare CSG006 = difference {
  sphere { // Sphere007
    <0,0,0>,1
    material {
      Camel1
    }
    scale <1.906385, 2.0, 2.655303>
    rotate -21.736036*y
    translate  <-3.716974, -3.944715, 12.684324>
  }
  sphere { // Sphere016
    <0,0,0>,1
    material {
      Material4
    }
    scale <0.953195, 1.0, 1.32765>
    rotate -21.736*y
    translate  <-2.5, -4.77269, 13.058104>
  }
  translate  <-10.98055, 0.0, -3.5>
}
#declare CSG013 = difference {
  torus { // Torus001
    1.5, 0.5  rotate -x*90
    material {
      Camel1
    }
    scale <2.909818, 2.22774, 1.248791>
    translate  <10.462113, 0.334815, 7.712666>
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    material {
      Camel1
    }
    scale 12.911169
    translate  <-4.743648, 0.0, 1.82448>
  }
  rotate 0.0*y
  translate  <-12.208741, -0.334815, -3.5>
}
#declare Head1 = union {
  sphere { // Sphere004
    <0,0,0>,1
    material {
      Camel1
    }
    scale <6.897732, 5.212666, 5.68074>
    translate  <-11.421005, 0.0, 5.804118>
  }
  object { CSG002 }
  object { CSG005 }
  object { CSG006 }
  sphere { // Sphere006
    <0,0,0>,1
    material {
      Material2
    }
    scale <2.072945, 1.5, 1.5>
    translate  <-8.518947, -3.448304, 8.331717>
  }
  sphere { // Sphere009
    <0,0,0>,1
    material {
      MyBlack
    }
    scale <2.072948, 1.5, 1.5>
    translate  <-8.5189, 3.4483, 8.33172>
  }
  sphere { // Sphere017
    <0,0,0>,1
    material {
      Material5
    }
    scale <1.381965, 1.0, 1.0>
    translate  <-7.72447, 3.902261, 8.33172>
  }
  sphere { // Sphere018
    <0,0,0>,1
    material {
      Material5
    }
    scale <1.381965, 1.0, 1.0>
    translate  <-7.724468, -3.90226, 8.33172>
  }
  object { CSG013 }
  torus { // Torus012
    1.5, 0.5  rotate -x*90
    material {
      MyBlack
    }
    scale <2.0, 2.0, 0.869565>
    rotate -90.0*y
    translate  <-5.208741, -0.334815, 5.608599>
  }
  translate  <12.208741, 0.334815, 3.5>
}
#declare Rein1 = difference {
  torus { // Torus014
    1.5, 0.02  rotate -x*90
    material {
      MyBlack
    }
    scale <15.294438, 8.921784, 7.713849>
    rotate <49.76981, -0.514574, -1.134705>
    translate  <-13.710077, -1.881302, 5.362346>
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    material {
      MyBlack
    }
    scale <-27.468462, -12.206279, -19.974455>
    rotate <-180.0, 0.0, 10.039993>
    translate  <-12.639654, 6.249831, 0.0>
  }
  rotate 6.356087*y
  translate  <-3.253766, 0.0, 5.774834>
}
#declare Rein2 = difference {
  torus { // Torus015
    1.5, 0.02  rotate -x*90
    material {
      MyBlack
    }
    scale <12.505229, 9.679523, 8.973696>
    rotate <-48.194485, -7.614057, 23.047977>
    translate  <-6.701498, -6.261323, 4.253733>
  }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    material {
      MyBlack
    }
    scale <-27.468462, -12.206279, -19.974455>
    rotate <7.895124, -11.269235, 15.759539>
    translate  <1.039592, -16.723075, 19.288146>
  }
  rotate <-10.414558, 6.25221, -1.146705>
  translate  <-3.253766, 0.0, 5.774834>
}
#declare Blanket1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.990533, -5.000000, -3.519133>, <-3.677736, -5.000000, -1.880737>, <-2.756354, -5.000000, -5.083816>, <-1.878177, -5.000000, -3.825163>, 
      <-4.053131, -4.000000, -3.706927>, <-3.677736, -4.000000, -1.880737>, <-2.944148, -4.000000, -2.141719>, <-1.972074, -4.000000, -1.853332>, 
      <-3.990533, -3.000000, -4.833687>, <-3.615138, -3.000000, -3.007498>, <-2.881550, -3.000000, -1.703534>, <-1.909476, -3.000000, -1.415147>, 
      <-3.990533, -2.000000, -3.832122>, <-3.646437, -2.000000, -2.444118>, <-2.912849, -2.000000, -1.140154>, <-1.940775, -2.000000, -0.851767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.990533, -2.000000, -3.832122>, <-3.646437, -2.000000, -2.444118>, <-2.912849, -2.000000, -1.140154>, <-1.940775, -2.000000, -0.851767>, 
      <-3.990533, -1.000000, -2.830557>, <-3.677736, -1.000000, -1.880737>, <-2.944148, -1.000000, -0.576774>, <-1.972074, -1.000000, -0.288387>, 
      <-3.990533, 0.000000, -2.830557>, <-3.677736, 0.000000, -1.880737>, <-2.944148, 0.000000, -0.576774>, <-1.972074, 0.000000, -0.288387>, 
      <-4.021832, 1.000000, -3.268742>, <-3.677736, 1.000000, -1.880737>, <-2.944148, 1.000000, -0.576774>, <-1.972074, 1.000000, -0.288387>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.021832, 1.000000, -3.268742>, <-3.677736, 1.000000, -1.880737>, <-2.944148, 1.000000, -0.576774>, <-1.972074, 1.000000, -0.288387>, 
      <-4.053131, 2.000000, -3.706927>, <-3.677736, 2.000000, -1.880737>, <-2.944148, 2.000000, -0.576774>, <-1.972074, 2.000000, -0.288387>, 
      <-4.053131, 3.000000, -3.706927>, <-3.677736, 3.000000, -1.880737>, <-2.944148, 3.000000, -0.576774>, <-1.940775, 3.000000, -0.257088>, 
      <-3.927936, 4.000000, -3.080948>, <-3.615138, 4.000000, -2.131129>, <-2.631158, 4.000000, -3.581469>, <-1.690384, 4.000000, -2.479310>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.878177, -5.000000, -3.825163>, <-1.000000, -5.000000, -2.566510>, <0.000000, -5.000000, -2.566510>, <1.033767, -5.000000, -3.878307>, 
      <-1.972074, -4.000000, -1.853332>, <-1.000000, -4.000000, -1.564945>, <0.000000, -4.000000, -1.564945>, <0.939871, -4.000000, -1.906476>, 
      <-1.909476, -3.000000, -1.415147>, <-0.937402, -3.000000, -1.126761>, <0.062598, -3.000000, -1.126761>, <1.002468, -3.000000, -1.468291>, 
      <-1.940775, -2.000000, -0.851767>, <-0.968701, -2.000000, -0.563380>, <0.031299, -2.000000, -0.563380>, <0.971170, -2.000000, -0.904911>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.940775, -2.000000, -0.851767>, <-0.968701, -2.000000, -0.563380>, <0.031299, -2.000000, -0.563380>, <0.971170, -2.000000, -0.904911>, 
      <-1.972074, -1.000000, -0.288387>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <0.939871, -1.000000, -0.341531>, 
      <-1.972074, 0.000000, -0.288387>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <0.939871, 0.000000, -0.341531>, 
      <-1.972074, 1.000000, -0.288387>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.955520, 1.000000, -0.310232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.972074, 1.000000, -0.288387>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.955520, 1.000000, -0.310232>, 
      <-1.972074, 2.000000, -0.288387>, <-1.000000, 2.000000, 0.000000>, <0.000000, 2.000000, 0.000000>, <0.971170, 2.000000, -0.278933>, 
      <-1.940775, 3.000000, -0.257088>, <-0.937402, 3.000000, 0.062598>, <0.062598, 3.000000, 0.062598>, <0.971170, 3.000000, -0.310232>, 
      <-1.690384, 4.000000, -2.479310>, <-0.749609, 4.000000, -1.377152>, <0.250391, 4.000000, -1.377152>, <1.221561, 4.000000, -2.532454>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.033767, -5.000000, -3.878307>, <2.067535, -5.000000, -5.190103>, <2.680678, -5.000000, -1.526763>, <3.211542, -5.000000, -3.692740>, 
      <0.939871, -4.000000, -1.906476>, <1.879741, -4.000000, -2.248006>, <2.680678, -4.000000, -1.526763>, <3.274140, -4.000000, -3.379751>, 
      <1.002468, -3.000000, -1.468291>, <1.942339, -3.000000, -1.809822>, <2.743276, -3.000000, -2.653524>, <3.336738, -3.000000, -4.506511>, 
      <0.971170, -2.000000, -0.904911>, <1.911040, -2.000000, -1.246441>, <2.711977, -2.000000, -2.090143>, <3.211542, -2.000000, -3.473647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.971170, -2.000000, -0.904911>, <1.911040, -2.000000, -1.246441>, <2.711977, -2.000000, -2.090143>, <3.211542, -2.000000, -3.473647>, 
      <0.939871, -1.000000, -0.341531>, <1.879741, -1.000000, -0.683061>, <2.680678, -1.000000, -1.526763>, <3.086347, -1.000000, -2.440783>, 
      <0.939871, 0.000000, -0.341531>, <1.879741, 0.000000, -0.683061>, <2.680678, 0.000000, -1.526763>, <3.148944, 0.000000, -2.065197>, 
      <0.955520, 1.000000, -0.310232>, <1.911040, 1.000000, -0.620463>, <2.680678, 1.000000, -1.526763>, <3.180243, 1.000000, -2.753772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.955520, 1.000000, -0.310232>, <1.911040, 1.000000, -0.620463>, <2.680678, 1.000000, -1.526763>, <3.180243, 1.000000, -2.753772>, 
      <0.971170, 2.000000, -0.278933>, <1.942339, 2.000000, -0.557866>, <2.680678, 2.000000, -1.526763>, <3.211542, 2.000000, -3.442348>, 
      <0.971170, 3.000000, -0.310232>, <1.879741, 3.000000, -0.683061>, <2.680678, 3.000000, -1.526763>, <3.211542, 3.000000, -3.442348>, 
      <1.221561, 4.000000, -2.532454>, <2.192730, 4.000000, -3.687756>, <2.743276, 4.000000, -1.777154>, <3.148944, 4.000000, -2.691175>
    }
  }
  material {
    rug
  }
  scale <5.0, 7.0, 5.0>
  rotate -90.0*z
  translate  <-55.244834, -2.0, 0.0>
}
#declare Mainbody1 = union {
  sphere { // Sphere010
    <0,0,0>,1
    material {
      Camel1
    }
    scale <15.98055, 10.0, 8.131079>
    translate  <-78.380725, 0.0, -23.548414>
  }
  sphere { // Sphere011
    <0,0,0>,1
    material {
      Camel1
    }
    scale <28.493122, 18.206993, 19.605167>
    translate  <-50.687224, 0.0, -20.257506>
  }
  sphere { // Sphere023
    <0,0,0>,1
    material {
      Camel1
    }
    scale <-12.518201, -5.759059, -13.058995>
    rotate -12.944258*z
    translate  <-35.634224, 11.534231, -24.813455>
  }
  sphere { // Sphere024
    <0,0,0>,1
    material {
      Camel1
    }
    scale <-12.518201, -5.759059, -13.058995>
    rotate 12.94426*z
    translate  <-35.634224, -11.53423, -24.813455>
  }
  sphere { // Sphere025
    <0,0,0>,1
    material {
      Camel1
    }
    scale <14.509237, 16.17622, 17.471052>
    rotate 64.290329*y
    translate  <-87.90413, 6.635413, -28.106535>
  }
  object { Blanket1 }
}
#declare Body1 = union {
  object { Neck1 }
  object { Head1 }
  object { Rein1 }
  object { Rein2 }
  object { Mainbody1 }
}
#declare CSG009 = union {
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <3.3, 3.3, 9.0>
    rotate -90.0*y
    translate  <-1.587066, 0.0, 5.61689>
  }
  sphere { // Sphere027
    <0,0,0>,1
    scale 3.714829
    translate  <0.093615, 0.0, 5.523273>
  }
  material {
    Camel1
  }
}
#declare CSG010 = difference {
  object { CSG009 }
  sphere { // Sphere028
    <0,0,0>,1
    material {
      Camel1
    }
    scale <1.0, 1.0, 0.5>
    translate  <1.821482, -2.319065, 7.20834>
  }
  sphere { // Sphere029
    <0,0,0>,1
    scale <1.0, 1.0, 0.5>
    translate  <1.82148, 2.319, 7.20834>
  }
  material {
    Camel1
  }
}
#declare CSG011 = difference {
  sphere { // Sphere030
    <0,0,0>,1
    material {
      Camel1
    }
    scale <1.90639, 2.0, 2.6553>
    rotate -21.736*y
    translate  <-3.71645, 3.9447, 12.68432>
  }
  sphere { // Sphere031
    <0,0,0>,1
    material {
      Material4
    }
    scale <0.953195, 1.0, 1.32765>
    rotate -21.736*y
    translate  <-2.5, 4.77269, 13.058104>
  }
  translate  <-10.98055, 0.0, -3.5>
}
#declare CSG012 = difference {
  sphere { // Sphere032
    <0,0,0>,1
    material {
      Camel1
    }
    scale <1.906385, 2.0, 2.655303>
    rotate -21.736036*y
    translate  <-3.716974, -3.944715, 12.684324>
  }
  sphere { // Sphere033
    <0,0,0>,1
    material {
      Material4
    }
    scale <0.953195, 1.0, 1.32765>
    rotate -21.736*y
    translate  <-2.5, -4.77269, 13.058104>
  }
  translate  <-10.98055, 0.0, -3.5>
}
#declare CSG014 = difference {
  torus { // Torus011
    1.5, 0.5  rotate -x*90
    material {
      Camel1
    }
    scale <2.909818, 2.22774, 1.248791>
    translate  <10.462113, 0.334815, 7.712666>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    material {
      Camel1
    }
    scale 12.911169
    translate  <-4.743648, 0.0, 1.82448>
  }
  rotate 0.0*y
  translate  <-12.208741, -0.334815, -3.5>
}
#declare Head2 = union {
  sphere { // Sphere026
    <0,0,0>,1
    material {
      Camel1
    }
    scale <6.897732, 5.212666, 5.68074>
    translate  <-11.421005, 0.0, 5.804118>
  }
  object { CSG010 }
  object { CSG011 }
  object { CSG012 }
  sphere { // Sphere034
    <0,0,0>,1
    material {
      Material2
    }
    scale <2.072945, 1.5, 1.5>
    translate  <-8.518947, -3.448304, 8.331717>
  }
  sphere { // Sphere035
    <0,0,0>,1
    material {
      MyBlack
    }
    scale <2.072948, 1.5, 1.5>
    translate  <-8.5189, 3.4483, 8.33172>
  }
  sphere { // Sphere036
    <0,0,0>,1
    material {
      Material5
    }
    scale <1.381965, 1.0, 1.0>
    translate  <-7.72447, 3.902261, 8.33172>
  }
  sphere { // Sphere037
    <0,0,0>,1
    material {
      Material5
    }
    scale <1.381965, 1.0, 1.0>
    translate  <-7.724468, -3.90226, 8.33172>
  }
  object { CSG014 }
  torus { // Torus013
    1.5, 0.5  rotate -x*90
    material {
      MyBlack
    }
    scale <2.0, 2.0, 0.869565>
    rotate -90.0*y
    translate  <-5.208741, -0.334815, 5.608599>
  }
  rotate -30.0*z
  translate  <-57.18662, 26.04704, 5.06147>
}
union { // My_Camels
  superellipsoid { // SuperQ001
    <0.1, 1.0>
    material {
      Tx_6
    }
    scale 17.633154
    rotate -4.314198*z
    translate  <-115.696903, 38.475174, 1.707881>
  }
  object { Blanket2 }
  object { Mainbody2 }
  object { Reins3and4 }
  object { Body2 }
  object { Character }
  object { Body1 }
  object { Head2 }
  rotate <-0.777676, -1.072393, 35.95211>
  translate  <-729.137825, 450.583502, -65.681605>
}


