#version unofficial megapov 0.5;

#declare test_part = off;

#global_settings { max_trace_level 50 }

#if (test_part)


#declare Place_Part1 = on;
#declare Place_Part2 = on;
#declare Place_Part3 = off;

#declare Part_Samples = 10;
#declare Part_Variance = 1/256;
#declare Part_Confidence = 0.99;


sky_sphere {
	pigment {
		bozo
		warp { turbulence .2 }
		scale <.2, .05, .2>
		warp { turbulence .02 }
		color_map {
			[0 color rgb <.7, .7, .6>*.7]
			[1 color rgb <.7, .7, .7>*.7]
		}
	}
}


light_source { <10000, 10000, -10000> color rgb 1 }


plane { y, 4
	pigment { color rgb <.6, .6, .7> }
	normal { bozo turbulence .3 scale 10 }
	finish { ambient .4 diffuse .6 }
}

#end


#if (Place_Part1)

particle_system {
	threshold	.42
	rand_seed	3652
	//environment object { O_obstacle }
	//temperature {Pigment}
	jitter <.2,.5,.1>	// velocity jitter
	wind <.5,0,-.9>*.5
	//gravity -9.8*y*.01
	time 10
	iterations 100
	drag 1
	particle_emitter { //dfinition d'un metteur de particules
		location <5,4,-20>
		//object { box {<-30, -28+70*sin(5*pi/180), 50>, <30, -25+70*sin(5*pi/180), 70>} }, 5  //l'objet  partir duquel sont mises les particules
		direction <2,4,.5>
		particle_stretch 0,0
		start_time 0
		stop_time 9
		rate 200  //particules emises par unites de temps
		angle 10, 20 //angle d'mission
		type 1    //0=atmos 1=fluide
		radius .11
		mass 1
		temperature .5
		elasticity 1
		lifespan 11   //dure de vie des particules
	}
	particle_emitter { //dfinition d'un metteur de particules
		location <5,4,-20>
		//object { box {<-30, -28+70*sin(5*pi/180), 50>, <30, -25+70*sin(5*pi/180), 70>} }, 5  //l'objet  partir duquel sont mises les particules
		direction <2,4,.5>*.8
		particle_stretch 0,0
		start_time 0
		stop_time 9
		rate 100  //particules emises par unites de temps
		angle 5, 15 //angle d'mission
		type 1    //0=atmos 1=fluide
		radius .11
		mass 1
		temperature .5
		elasticity 1
		lifespan 11   //dure de vie des particules
	}
	particle_emitter { //dfinition d'un metteur de particules
		location <5,5,-20>
		//object { box {<-30, -28+70*sin(5*pi/180), 50>, <30, -25+70*sin(5*pi/180), 70>} }, 5  //l'objet  partir duquel sont mises les particules
		direction <2,4,.5>*.3
		particle_stretch 0,0
		start_time 0
		stop_time 9
		rate 50  //particules emises par unites de temps
		angle 5, 15 //angle d'mission
		type 1    //0=atmos 1=fluide
		radius .15
		mass 1
		temperature .5
		elasticity 1
		lifespan 11   //dure de vie des particules
	}
	//custom_particle { sphere {0, .4 pigment { color rgbf <1,.5,.5,.2> } finish { ambient .8 diffuse .2 } } }
	texture { pigment { color rgbt<0,0,0,1> } }
	no_shadow
	hollow
	interior {
		media {
			intervals 5
			scattering { 1, color rgb 2 extinction 1 }
			samples Part_Samples,Part_Samples
			method 2
			variance Part_Variance
			confidence Part_Confidence
		}
	}
}

#end

#if (Place_Part2)

particle_system {
	threshold	.45
	rand_seed	3652
	//environment object { O_obstacle }
	//temperature {Pigment}
	jitter <.2,.3,.1>	// velocity jitter
	wind <.5,0,-.9>*.9
	//gravity -9.8*y*.01
	time 10
	iterations 400
	drag 1
	particle_emitter { //dfinition d'un metteur de particules
		location <-7,4,18>
		//object { box {<-30, -28+70*sin(5*pi/180), 50>, <30, -25+70*sin(5*pi/180), 70>} }, 5  //l'objet  partir duquel sont mises les particules
		direction <-.7,18,.5>
		particle_stretch 0,0
		start_time 0
		stop_time 10
		rate 300  //particules emises par unites de temps
		angle 10, 15 //angle d'mission
		type 1    //0=atmos 1=fluide
		radius .12
		mass 1
		temperature .5
		elasticity 1
		lifespan 11   //dure de vie des particules
	}
	particle_emitter { //dfinition d'un metteur de particules
		location <-7,4,18>
		//object { box {<-30, -28+70*sin(5*pi/180), 50>, <30, -25+70*sin(5*pi/180), 70>} }, 5  //l'objet  partir duquel sont mises les particules
		direction <-.7,15,.5>
		particle_stretch 0,0
		start_time 0
		stop_time 10
		rate 300  //particules emises par unites de temps
		angle 5, 15 //angle d'mission
		type 1    //0=atmos 1=fluide
		radius .2
		mass 1
		temperature .5
		elasticity 1
		lifespan 11   //dure de vie des particules
	}
	//custom_particle { sphere {0, .4 pigment { color rgbf <1,.5,.5,.2> } finish { ambient .8 diffuse .2 } } }
	texture { pigment { color rgbt<0,0,0,1> } }
	no_shadow
	hollow
	interior {
		media {
			intervals 5
			scattering { 1, color rgb 1 extinction 1 }
			samples Part_Samples,Part_Samples
			method 2
			variance Part_Variance
			confidence Part_Confidence
		}
	}
}

#end

#if (Place_Part3)

particle_system {
	threshold	.45
	rand_seed	3652
	//environment object { O_obstacle }
	//temperature {Pigment}
	jitter <.2,.5,.1>	// velocity jitter
	wind <.5,0,-.9>*.5
	//gravity -9.8*y*.01
	time 10
	iterations 100
	drag 1
	particle_emitter { //dfinition d'un metteur de particules
		location <5,4,18>
		//object { box {<-30, -28+70*sin(5*pi/180), 50>, <30, -25+70*sin(5*pi/180), 70>} }, 5  //l'objet  partir duquel sont mises les particules
		direction <4,7,.5>
		particle_stretch 0,0
		start_time 0
		stop_time 9
		rate 600  //particules emises par unites de temps
		angle 10, 20 //angle d'mission
		type 1    //0=atmos 1=fluide
		radius .15
		mass 1
		temperature .5
		elasticity 1
		lifespan 11   //dure de vie des particules
	}
	//custom_particle { sphere {0, .4 pigment { color rgbf <1,.5,.5,.2> } finish { ambient .8 diffuse .2 } } }
	texture { pigment { color rgbt<0,0,0,1> } }
	no_shadow
	hollow
	interior {
		media {
			intervals 5
			scattering { 1, color rgb .8 extinction 1 }
			samples Part_Samples,Part_Samples
			method 2
			variance Part_Variance
			confidence Part_Confidence
		}
	}
}

#end

#if (test_part)

camera {
	location <0, 8, -70>
	right x
	up y*4/3
	angle 30
	look_at <0,15,0>
}

#end
