#version unofficial MegaPov 0.5;

//=====================================
//       TEXTURE ROCHER
//=====================================
#declare T_Pierre01 = texture {
	pigment {
		granite
		scale 2
		color_map {
			[ 0.0   rgb <0.80, 0.40, 0.30>*.3 ]
			[ 0.14  rgb <0.73, 0.45, 0.45>*.3 ]
			[ 0.35  rgb <0.98, 0.75, 0.71>*.3 ]
			[ 0.43  rgb <0.67, 0.56, 0.49>*.3 ]
			[ 0.52  rgb <0.85, 0.63, 0.55>*.2 ]
			[ 0.79  rgb <0.91, 0.75, 0.74>*.2 ]
			[ 0.86  rgb <0.77, 0.55, 0.60>*.2 ]
			[ 1.0   rgb <0.92, 0.60, 0.60>*.2 ]
		}
	}
	normal {
		granite 2
		scale .2
	}
	finish { ambient .2 diffuse .8
		phong .1 phong_size 20
		specular .9 roughness .07
	}
}

#declare T_Pierre02 = texture {
	pigment {
		granite
		scale 2
		color_map {
			[ 0.0   rgb <0.40, 0.80, 0.30>*.3 ]
			[ 0.14  rgb <0.45, 0.73, 0.45>*.3 ]
			[ 0.35  rgb <0.75, 0.98, 0.71>*.3 ]
			[ 0.43  rgb <0.56, 0.67, 0.49>*.3 ]
			[ 0.52  rgb <0.63, 0.85, 0.55>*.2 ]
			[ 0.79  rgb <0.75, 0.91, 0.74>*.2 ]
			[ 0.86  rgb <0.55, 0.77, 0.60>*.2 ]
			[ 1.0   rgb <0.60, 0.92, 0.60>*.2 ]
		}
	}
	normal {
		granite 2
		scale .2
	}
	finish { ambient .2 diffuse .8
		phong .1 phong_size 20
		specular .9 roughness .1
	}
}

#declare T_Pierre = texture {
	planar
	scale 4
	translate 2*y
	warp { reset_children }
	texture_map {
		[0 T_Pierre01]
		[1 T_Pierre02]
	}
}

//=====================================
//       TEXTURES MER
//=====================================

#switch (Fake_Texture)

	#case (1)
		#declare T_Water1 = texture {
			pigment {
/*				agate
				agate_turb 2.0
				color_map {
					[.2 color rgb<0,.8,.4>*.2]
					[.8 color rgb<0,.8,.4>*.4]
				}*/
				color rgb<0,.8,.4>*.4
			}
			normal {
				wrinkles , 4.0
				scale  <0.01, 0.005, 1.0>
			}
			finish {
				ambient 0.0 diffuse 0.8
				//reflection .2
				//reflection_min 0.0
				//reflection_max 0.2
				specular .6 roughness .0001
				phong .2 phong_size 60
			}
		}
		#break

	#case (2)
		#declare T_Water1 = texture {
			pigment {
				agate
				agate_turb 1.0
				color_map {
					[ 0.0     rgbft <0.212681, 0.212681, 0.620653, 0.0, 0.0> ]
					[ 0.333333  rgbft <0.1326, 0.291667, 0.409067, 0.0, 0.0> ]
					[ 0.666667  rgbft <0.199225, 0.287112, 0.550775, 0.0, 0.0> ]
					[ 1.0     rgbft <0.146701, 0.3125, 0.394965, 0.0, 0.0> ]
				}
				warp { turbulence <0.2, 0.2, 0.2> }
				scale  <0.4, 0.02, 1.0>
			}
			normal {
				wrinkles , 4.0
				scale  <0.1, 0.1, .01>
				warp { turbulence <0.2, 0.1, 0.1> }
			}
			finish {
				ambient 0.0
				diffuse 0.661867
				brilliance 3.157667
				phong 0.1
				phong_size 60
				reflection 0.330933
			}
		}
		#break

	#else

		#declare T_Water1 = texture {
			pigment { color rgbf<.8,1,.98,.9> }
		//	pigment { color rgbt<.4,1,.7,.8/.2>*.2 }
			normal {
				wrinkles , 2.0
				scale  <0.3, 0.3, .03>
			}
			finish {
				ambient 0 diffuse 0
		//		ambient 0.5 diffuse 0.2
			#if (Use_Fresnel)
				reflection_type 1
			#end
				reflection_min 0.0
				reflection_max 0.1
				//conserve_energy
				specular .6 roughness .001
			//	phong .2 phong_size 60
			}
		}
#end

#declare T_Ecume = texture {
	pigment { color rgb<1,1.05,1.02> }
//	pigment { color rgb<2,0,0> }
	normal {
		granite 3
		warp { turbulence <.5,0,.5> octaves 3 }
		scale  <0.01, 0.01, 0.01>
	}
	finish {
		ambient 0.7 diffuse 0.3
		specular .4 roughness .001
		phong .2 phong_size 60
	}
}

#declare T_Water2 = texture {
	crackle metric 2
//	warp { turbulence .2 octaves 3 }
	scale .1
	texture_map {
		[.35 T_Ecume  ]
		[.35 T_Water1 ]
	}
}

#declare T_Water1_To_Water2_0 = texture {
	crackle metric 3
	warp { turbulence .05 octaves 3 lambda 6 }
	scale 2.2
	warp { turbulence .2 octaves 3 lambda 6 }
	warp { reset_children }
	texture_map {
		[0.95 T_Water2]
		[0.95 T_Water1]
	}
}

#declare T_Water1_To_Water2_1 = texture {
	crackle metric 3
	warp { turbulence .05 octaves 3 lambda 6 }
	scale 1.1
	warp { turbulence .1 octaves 3 lambda 6 }
	warp { reset_children }
	texture_map {
		[0.85 T_Water2]
		[0.85 T_Water1]
	}
}

#declare T_Water1_To_Water2_2 = texture {
	crackle metric 3
	warp { turbulence .05 octaves 3 lambda 6 }
	scale 2.2
	warp { turbulence .2 octaves 3 lambda 6 }
	warp { reset_children }
	texture_map {
		[0.75 T_Water2]
		[0.75 T_Water1]
	}
}

#if (Use_Prox)
#declare T_Water_Prox = texture {
	proximity {
		Rocher, 10
		samples 10
		sample_bailout 20
		max_density 1
		type 1
		method 1
		sides 1
	}
	texture_map {
		[0.5 T_Water1_To_Water2_1 ]
		[0.8 T_Water1_To_Water2_2 ]
		//[1.0 T_Water1             ]
	}
}

#else

#declare T_Water_Prox = texture {
	cylindrical
	warp { turbulence .07 octaves 2 lambda 7 omega .3 }
	scale Scale_Rocher*<.6,1,1>
	warp { turbulence .5 octaves 3 lambda 5 omega .3 }
	scale 4*5
//	warp { turbulence 1 octaves 3 lambda 5 omega .3 }
	warp { reset_children }
	texture_map {
	//	[0.20 T_Water1             ]
	//	[0.30 T_Water1_To_Water2_2 ]
		[0.35 T_Water1_To_Water2_2 ]
		[0.58 T_Water1_To_Water2_1 ]
		[0.60 T_Water1_To_Water2_0 ]
		[0.65 T_Water2 ]
	}
}

#end


#declare M_My_Water = material {
	texture {
#if (Use_Prox)
		object {
			Rocher
			texture { T_Water_Prox }, texture { T_Water1_To_Water2_1 }
		}
		//warp { turbulence .4 octaves 3 }
#else
		T_Water_Prox
//		T_Water1
#end
	}
	interior {
		//ior 1.05
		fade_color rgb<.3,.90,.8>*.8
		fade_power 1001
		fade_distance 1
	}
}



//=====================================
//    TEXTURES CORPS PHARE
//=====================================

#declare T_Tres_Tres_Cracra = texture {
	pigment {
		wrinkles
		color_map {
			[0.0 color rgb (<.36, .25, .20>*.4 + <.8,1,.6>*.7*<.36, .25, .20>*.5*.6)]
			[0.6 color rgb (<.25, .36, .20>*.3 + <.8,1,.6>*.7*<.25, .36, .20>*.4*.3)]
		}
	}
	normal {
		average
		normal_map {
			[ 1 bozo 2 turbulence .4 scale 1.3 ]
			[ 1 wrinkles 4 scale .2 ]
		}
	}			
	finish {
		ambient .3 diffuse .7
		phong .6 phong_size 80
		specular .8 roughness 0.1
	}
}

#declare T_Tres_Cracra = texture {
	pigment {
		wrinkles
		color_map {
			[0.0 color rgb (<.36, .25, .20>*.5 + <1,.8,.6>*.7*<.36, .25, .20>*.5*.6)]
			[0.6 color rgb (<.36, .25, .20>*.4 + <1,.8,.6>*.7*<.36, .25, .20>*.4*.3)]
		}
	}
	normal {
		average
		normal_map {
			[ 1 bozo 2 turbulence .4 scale 1.3 ]
			[ 1 granite 2 scale .25 ]
		}
	}			
	finish { ambient .2 diffuse .8
		specular .6 roughness .05
		phong .3 phong_size 20
	}
}

#declare T_Assez_Cracra = texture {
	pigment {
		wrinkles
		color_map {
			[0.0 color rgb (<1,.8,.6>*.7)]
			[1.0 color rgb (<.36, .25, .20>*.5 + <1,.8,.6>*.7*<.36, .25, .20>*.5*.5)]
		}
	}
	normal {
		average
		normal_map {
			[ 1 bozo 2 turbulence .4 scale 1.3 ]
			[ 1 granite 2 scale .25 ]
		}
	}			
	finish { ambient .2 diffuse .8
		specular .3 roughness .01
		phong .1 phong_size 20
	}
}

#declare T_Peu_Cracra = texture {
	pigment {
		wrinkles
		color_map {
			[0.3 color rgb (<1,.8,.6>*.7)]
			[1.0 color rgb (<.36, .25, .20>*.6 + <1,.8,.6>*.7*<.36, .25, .20>*.6*.7)]
		}
	}
	normal {
		average
		normal_map {
			[ 1 bozo 2 turbulence .4 scale 1.3 ]
			[ 1 granite 2 scale .25 ]
		}
	}			
	finish { ambient .2 diffuse .8
		specular .05 roughness .005
		phong .05 phong_size 20
	}
}



#declare P_Mortar = pigment { color rgb <.60, .55, .55> }
#declare P_Brick = pigment {
	bozo
	warp { turbulence .4 octaves 3 }
	scale .02
	color_map {
		[0.2 color rgb<.72,.55,.35>*.9]
		[0.6 color rgb<.65,.50,.35>*.8]
		[0.8 color rgb<.54,.45,.40>*.7]
	}
}

#switch (Detail_Phare)

	#case (0)
		#declare T_Corps_Phare = texture {
			pigment { color rgb<1, .8, .6>*.7 }
			normal { granite scale .25 }
			finish { ambient .2 diffuse .8
				specular .05 roughness .0001
				phong .05 phong_size 20
			}
		}
		#break

	#range (1, 3)
		#declare T_Corps_Phare = texture {
			gradient y
			turbulence .05
			scale <5, 32, 5>
			warp { reset_children }
			texture_map {
				[0.0 T_Tres_Cracra ]
				[0.4 T_Assez_Cracra ]
				[0.8 T_Peu_Cracra ]
			}
		}
		#break

	#range (4, 10)
		#declare T_Corps_Phare_1 = texture {
			gradient y
			turbulence .05
			scale <5, 32, 5>
			warp { reset_children }
			texture_map {
				[0.0 T_Tres_Cracra ]
				[0.4 T_Assez_Cracra ]
				[0.8 T_Peu_Cracra ]
			}
		}
		#declare T_Corps_Phare_2 = texture {
			pigment {
				brick pigment { P_Brick }, pigment { P_Mortar }
				mortar .15 brick_size <.01, .15, 3>
				translate 1*z
				scale <1/pi, 1, 1>
				warp { cylindrical orientation y dist_exp .0001 }
			}
			normal { wrinkles scale .2 }
			finish { ambient .3 diffuse .7
				specular .1 roughness .001
				phong .05 phong_size 20
			}
		}
		#declare T_Corps_Phare_3 = texture {
			bozo
			warp { turbulence .4 octaves 3 lambda 5 }
			scale 1.5
			warp { turbulence .4 octaves 3 lambda 5 }
			scale 1.5
			translate 352
			//warp { turbulence .5 octaves 5 lambda 3 }
			warp { reset_children }
			texture_map {
				[0.65 T_Corps_Phare_1]
				[0.65 T_Corps_Phare_2]
			}
		}
		#declare T_Corps_Phare = texture {
			gradient y
			scale <1,32,1>
			warp { reset_children }
			texture_map {
				[0.1 T_Corps_Phare_1]
				[0.2 T_Corps_Phare_3]
			}
		}
		
		#break
		

	#else
		#declare T_Corps_Phare = texture {
			pigment { color rgb<1, .8, .6>*.7 }
			normal { granite scale .25 }
			finish { ambient .3 diffuse .7
				specular .05 roughness .001
				phong .05 phong_size 20
			}
		}
#end


#declare T_Ardoise = texture {
	pigment { color rgb<.5,.6,1>*.07 }
	normal { granite 2 scale .3 }
	finish { ambient .2 diffuse .8
		specular .7 roughness .1
		phong .3 phong_size 20
	}
}
           


#declare T_Brique = texture {
	pigment {
		bozo
		warp { turbulence .4 octaves 3 }
		scale .02
		color_map {
			[0.2 color rgb<.72,.60,.35>*.9]
			[0.6 color rgb<.65,.60,.35>*.8]
			[0.8 color rgb<.54,.50,.40>*.7]
		}
	}
	normal { wrinkles scale .2 }
	finish { ambient .2 diffuse .8
		specular .1 roughness .001
		phong .05 phong_size 20
	}
}




#declare T_Fenetre_Tour = texture {
	pigment {
		bozo
		turbulence .5
		scale .05
		color_map {
			[.4 color rgb <.98,.97,.97>]
			[.6 color rgb <.98,.97,.97>*.8]
		}
	}
	finish { ambient .2 diffuse .8 }
}

#declare M_Vitre = material {
	texture {
		pigment { color rgbf 1 }
		normal { bumps .3 scale .5 }
		finish {
			ambient 0 diffuse 0
			reflection .1
			specular .8 roughness .001
			conserve_energy
		}
	}
	interior {
		ior 1.5
	}
}


#local St1 = pigment {
	wrinkles scale .25
	color_map { [0.3 color rgb <166, 111, 81>/255] [0.7 color rgb <137, 114, 69>/255] }
}

#local St2 = pigment {
	wrinkles scale .25
	color_map { [0.3 color rgb <137, 99, 99>/255] [0.7 color rgb <141, 113, 95>/255] }
}

#local St3 = pigment {
	wrinkles scale .25
	color_map { [0.3 color rgb <105, 101, 80>/255] [0.7 color rgb <114, 85, 71>/255] }
}

#macro T_Crack(sc)
	texture {
		pigment {
			crackle
			turbulence .2
			pigment_map {
				[ sc color rgb <.4, .3, .2>*.5 ]
				[ sc crackle solid pigment_map {
					 [0.3 St1] [0.4 St2] [0.6 St2] [0.7 St3] } ]
			}
		}
		normal {
			average
			normal_map {
				#if (Iso_Base=off)
				[2 crackle slope_map { [0, <0, 0>] [sc, <0, 3>] [sc+.01, <1, 0>] } ]
				#end
				[1 granite scale .1 ]
			}
		}
		finish {
			ambient .3 diffuse .6
			phong .6 phong_size 60
			specular .6 roughness 0.001
		}
		scale .1
	}
#end

#local T_Crack1 = T_Crack(.1)
#local T_Crack2 = T_Crack(.2)
#local T_Crack3 = T_Crack(.3)
#local T_Crack4 = T_Crack(.4)
#local T_Crack5 = T_Crack(.5)

#declare T_Base = texture {
	gradient y
	texture_map {
		[0.60 T_Crack1 ]
		[0.80 T_Crack2 ]
		[0.90 T_Crack3 ]
		[0.95 T_Crack4 ]
		[0.98 T_Crack5 ]
	}
}


//=====================================
//    TEXTURES HAUT PHARE
//=====================================

#declare M_Vitre2 = material {
	texture {
		pigment { color rgbf <.95,1,.98,1> }
		normal { bumps .3 scale .5 }
		finish {
			ambient 0 diffuse 0
			reflection_min 0
			reflection_max .2
			specular .8 roughness .001
			conserve_energy
		}
	}
	interior {
		ior 1.5
	}
}

#declare M_Lens = material {
	texture {
		pigment { color rgbf<1, 1, .87, .98> }
		finish {
			ambient 0 diffuse 0
			reflection_type 1
			conserve_energy
			specular .7 roughness .0001
			phong .3 phong_size 70
			irid { .3 thickness 2 turbulence 1 }
		}
	}
	interior {
		ior 2
	}
}

#declare T_Tole = texture {
	pigment {
		bozo
		warp { turbulence .4 octaves 3 }
		scale .4
		warp { turbulence .1 octaves 3 }
		color_map {
			[.5 color rgb<.4, .30, .25>]
			[.5 color rgb<.4, .25, .20>]
		}
	}
	normal {
		bozo
		warp { turbulence .4 octaves 3 }
		scale .4
		warp { turbulence .1 octaves 3 }
		normal_map {
			[.5 wrinkles scale .3 ]
			[.5 granite scale .2 ]
		}
	}
	finish {
		ambient .2 diffuse .2
		reflection .2 reflect_metallic
		specular .2 roughness .001 metallic 
		phong .2 phong_size 20
	}
}

#declare T_Interieur_Guitoune = texture {
	pigment {
		color rgb <.7, .6, .6>*.8
	}
	normal { crackle .5 scale .1 }
	finish { ambient .3 diffuse .7 }
}
