  #include "colors.inc"  
  #include "woods.inc"
  #include "golds.inc"
                       
#declare poignee =                     
  union{  
    intersection {
      box {<-1,0,-1>,<1,1,1,>}
      sphere {<0,0,0>, sqrt(2)}
      }
    union {  
      sphere {<0,0,0>, 1 }
      difference {
        sphere {<0,0,0>, 1}
        plane {-y,0}
        scale <1,5,1> 
        }
      translate <0,5,0>
      }  
    pigment {Red}    
    rotate -90*z
    }     
           
#declare vis =    
  difference {    
    sphere { 0,1}
    box {<-1,0,-1>,<1,1,1>
      scale <1/4,1,1>
      translate <0,sin(pi/4),0>
      }   
    texture {T_Gold_3A}      
    //pigment {Yellow}                           
    }    
  
  #declare T_Wood1 =
    texture { 
      pigment { 
        P_WoodGrain1A  
        color_map { M_Wood1A }
        warp {
          black_hole <0, 0, 0>, 1.8   
          falloff 0.9
          inverse
          }
        }
      }
    texture { pigment { P_WoodGrain1B  color_map { M_Wood1B }}}
  
#macro barre(inclinaison)     
  union {    
    #local R=14;
    #local r=2; 
    #local aa=pi/4;  
    difference { 
      torus {R,r}
      plane {-y,-r*cos(aa)}
      plane {y, -r*cos(aa)}  
      difference {
        cylinder { <0,0,0>, <0,r,0>, R + r*sin(aa)/2}
        cylinder { <0,-1,0>, <0,r+1,0>, R - r*sin(aa)/2}  
        }
      texture {T_Wood1 
        scale 10 
        rotate 90*y }
      //pigment {Red} 
      }
    difference {
      cylinder { <0,0,0>, <0,r*cos(aa),0>, R + r*sin(aa)/2}
      cylinder { <0,-1,0>, <0,r+1,0>, R - r*sin(aa)/2}    
      texture {T_Gold_3A}
      //pigment {Yellow}
      }   
    #local i=0;
    #while (i<6)  
      object { vis   
        #local Rvis =  r*sin(aa)/4/cos(pi/4);
        scale Rvis
        translate <R,  r*cos(aa)- Rvis*cos(pi/4),0>  
        rotate i*60*y
        } 
      object { poignee
        scale r*cos(aa)
        texture {T_Wood1 
          scale 10      
          rotate 90*y 
          rotate 60*i*x 
          translate 10*y
          }
        translate < R+r*sin(aa), 0, 0>  
        rotate i*60*y   
        }  
      #local i=i+1;
    #end             
    cylinder {<0,0,0>,<0,-r,0>,R
      pigment {Black}
      finish {reflection 1}
      }
    rotate -90*x 
    #local taille_poignee = 5*r*cos(aa); 
    // on "pose" le miroir sur le plan y=0
    translate <0, (R+r*sin(aa)+taille_poignee)*cos(pi/6),0>
    // on l'incline
    rotate -inclinaison*x
    // on le recentre pour faciliter son positionnement
    translate < 0,
                ((R+r*sin(aa)+taille_poignee)*cos(pi/6))* (-cos(radians(inclinaison))), 
                -r*cos(aa)>
    }
#end
    
/*         
object {barre
  rotate -90*x}          
    */