#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "glass.inc"

   
#declare Maillon =
union {
  difference {  
    torus {1,1/2}
    plane {-z,0}
    }
  difference {  
    torus {1,1/2}
    plane {z,0}
    translate 2*z
    }            
  cylinder {<1,0,0>,<1,0,2>,0.5}  
  cylinder {<-1,0,0>,<-1,0,2>,0.5}
  }  
        
#declare Ancre =  
union { 
  union {
    prism {
      cubic_spline
      linear_sweep
      0,
      1.0,
      22,  
      < 1, 0>, < -1,  0>, < -4, 1>, < -4.5, 1.5>, < -6, 1>, 
      < -6,  0>, < -5,  -1>, < -3, -2>, < -1,  -2.2>,
      < 0, -3>, < 0, -3>, < 0, -3>, 
      < 1, -2.2>, < 3, -2>, < 5, -1>, < 6, 0>, < 6, 1>,   
      < 4.5, 1.5>, < 4,  1>, < 1, 0>, < -1,  0>, < -4, 1>
      }        
    prism {
      linear_spline
      linear_sweep
      0,
      1.0,
      9, 
      < 1, -1>, < 1, 8>, < 3, 8>, < 3, 10>, 
      < -3,  10>, < -3,  8>, < -1, 8>, < -1,  -1>,
      < 1, -1>
      }
    prism {
      linear_spline
      linear_sweep
      0,
      1.0,
      4, 
      < 7, -1>, < 7, 2.5>, < 3.5, 2.5>, < 7, -1>
      }
    prism {
      linear_spline
      linear_sweep
      0,
      1.0,
      4, 
      < -7, -1>, < -7, 2.5>, < -3.5, 2.5>, < -7, -1>
      }  
    scale <1,2,1>
    }
  torus {1,1/2
    translate <0,1,11>
    }   
                   
  #local i=1;
  #while (i<7)                 
  object {Maillon   
    #if (mod(i,2)=1)
      rotate 90*z 
    #end
    translate <0,1,9+3*i>
    } 
  #local i= i+1;                     
  #end
    
  texture { T_Chrome_4D } 
  }
       
       
#declare T_Verre =
texture {
    pigment { color rgbf <1, 1, 1, 0.98> }
    finish { F_Glass1 }
}

#declare aiguille_minutes =     
union {
  union {
    prism {
      cubic_spline
      linear_sweep
      0,
      1.0,
      13,  
      < 1.5, -0.8>, < 1,  0>, < 1.5, 0.8>, < 2,  1>, < 12, 2>, 
      < 22,  0>, < 22, 0>, < 22, 0>,
      <12, 1>, < 2, -1>, < 1.5, -0.8>, < 1, 0>, < 1.5, 0.8>  
      }
    cylinder {0,y,2}  
     texture { T_Chrome_4D }
    }
  cylinder {0,1.1*y,1
    texture {T_Gold_3A}
    }        
  scale <1,1/4,1>  
  }   
  
#declare aiguille_heures =    
union {
  prism {
    cubic_spline
    linear_sweep
    0,
    1.0,
    13,
  
    < 0, -2>, < 0, -1>, < 1, 0>, < 2,  0>, < 8, 2>, 
    < 14,  0>, < 14, 0>, < 14, 0>,
    <8, 1>, < 2, -2>, < 0, -2>, < 0, -1>, < 1, 0>

    }
  prism {
    cubic_spline
    linear_sweep
    0,
    1.0,
    13,
  
    < 1, 0>, < 0, 1>, < 0, 2>, < 2,  2>, < 7.5, -0.8>, 
    < 11,  0>, < 11, 0>, < 11, 0>,
    <7.5, -1.4>, < 2, 0>, < 1, 0>, < 0, 1>, < 0, 2>

     scale < 1, 3/4, 1>        
    }    
  cylinder {0,y,2}  
  texture { T_Chrome_4D }  
  scale <1,1/4,1>
  }
       
#declare boite_de_thon = 
union {  
   #local r=24;
   difference {
     union {  
       //aroudi du bas
       torus {r-1,1
         translate y} 
       //corps de la boite  
       difference {    
         cylinder {<0,1,0>,<0,18,0>,r}
         cylinder {<0,1,0>,<0,19,0>,r-0.5}
         }                
       //fond de la boite  
       cylinder {<0,0.5,0>,<0,1,0>,r-1}   
       // les 3 "rayures" sur le ccot de la boite
       torus {r-0.5,1
         translate (1+6)*y}
       torus {r-0.5,1
         translate (1+8)*y}
       torus {r-0.5,1
         translate (1+10)*y}   
       } 
     //ouverture pour le balancier  
     box {<12,6,0>,<-12,12,-25>}    
     texture { T_Chrome_4D } 
    }                            
  //bordure de la boite  
  union {   
    difference {
      cylinder {<0,18,0>,<0,20,0>,r+0.5}
      cylinder {<0,17,0>,<0,23,0>,r}  
      }
    torus {r+0.25,0.25
      translate 20*y
      }  
    texture {T_Gold_3A}
    } 
  //cadran de l'horloge     
  cylinder {<0,18,0>,<0,18.5,0>,r
    pigment{
      image_map{ sys "sirene.bmp"} 
      scale 2*r
      rotate 90*x
      translate <-r,0,-r>
      } 
    finish { ambient 0.9 diffuse 0.1}  
    }    
  // verre de l'horloge 
  #local a= 70;
  #local c= sqrt(pow(a,2)+pow(r,2)); 
  intersection {
    cylinder {<0,-a,0>,<0,a,0>,r}
    difference {
      sphere { <0,-a,0>, c }
      sphere { <0,-a,0>, c-0.5 } 
      }
    translate <0,20,0>  
    texture {T_Verre}
    interior {I_Glass}
    } 
  object{
    aiguille_minutes   
    //scale 0.8
    rotate -10*y
    translate   19*y
    }          
  object{                
    aiguille_heures      
    //scale 0.8
    rotate 190*y
    translate   18.75*y
    }          
  }
    
#declare pendule = 
union{              
  #local coef = 1.8;
  object { boite_de_thon }
  object { Ancre 
    scale <coef, coef, coef>   
    translate<0,0,-24*coef> 
    rotate 10*y
    translate<0,7,-18> 
    }
  }
      