// TSUNAMI (c) 2000 Claudius Klein
// Entry for IRTC stills competition August 2000 - topic 'Sea'
 
#include "colors.inc"
#version unofficial MegaPov 0.5;

global_settings { 
  assumed_gamma 1.0 max_trace_level 10 
  motion_blur 4,0.1 // for the birds
  radiosity { count 35 brightness 0.15 gray_threshold 0.9 normal on } 
}

#declare MainCam =
camera {
  right x*image_width/image_height up y
  location <0.5,1,-4>
  look_at <0,0.8,0>
  rotate <0,0,3>
}

// === some preparatory things...

#declare earthrad = 6378000;

// === textures...

#declare CMSand =  // sampled from nice beach pictures :)
color_map {
  [0.0 rgb <255,246,219>/255 ]
  [0.2 rgb <252,247,220>/255 ]
  [0.4 rgb <254,244,218>/255 ]
  [0.6 rgb <253,245,222>/255 ]
  [0.8 rgb <251,248,217>/255 ]
  [1.0 rgb <255,245,223>/255 ]
}

#declare TGraniteStone =
texture {
  pigment { White } 
  finish { ambient 0 diffuse 0.6 }
  normal { granite 0.8 scale 0.3 } 
}

#declare TMossy =
texture {
  pigment { 
    bozo scale 0.1
    color_map { [0   rgb <135,210,5>/255]
                [0.5 color DarkGreen]
                [1   rgb <60,110,50>/255 ] }
  } 
  finish { ambient 0 diffuse 0.7 specular 1 roughness 0.01 reflection 0.02 }
  normal { bumps -0.9 scale 0.005 }
}
          
#declare TMossyStone =
texture { 
  spotted turbulence 0.6
  texture_map { [0.49 TGraniteStone ]
                [0.51 TMossy       ] 
              }
  scale 0.5
}

#declare TOldIron =
texture {
  pigment { 
    crackle solid scale 0.5 
    color_map {[0   color IndianRed*0.6]
               [0.5 color IndianRed*0.8]
               [1   color IndianRed*1.0]} 
  } 
  finish { ambient 0 diffuse 1 specular 0.3 roughness 0.05 metallic } 
  normal { crackle -0.1 solid scale 0.5 }
}

#declare TRustyCrust =
texture {
  pigment { 
    granite scale 0.4 
    color_map {[0 color IndianRed] [0.6 color Coral*0.6 ] [1 color Coral*0.9]} 
  } 
  finish { ambient 0 diffuse 1 } 
  normal { granite -0.5 scale 0.2 }
}

#declare TRustyIron =
texture { 
  spotted turbulence 0.6
  texture_map { [0.49 TOldIron ] [0.51 TRustyCrust ] }
  scale 0.5
}
                                 
#declare TRustyCan =
texture { 
  spotted turbulence 0.6
  texture_map { 
    [0.49 pigment { Red } 
          finish { ambient 0 diffuse 0.8 specular 0.7 roughness 0.01 brilliance 2 } ] 
    [0.51 TRustyCrust ] }
  scale 0.5
}
                                 
// === Water ===

#declare WaterClear = rgbt <0.01,0.01,0.01,0.95>;

#declare ISaltWater =
interior { 
  ior 1.42 fade_power 1000 fade_distance 5 caustics 0.2
  media { absorption <0.1,0.02,0.05> intervals 1 samples 2,2 }
}

#declare FWater =
finish { 
  ambient 0 diffuse 0 
  reflection_type 1 reflection_min 0 reflection_max 1 reflection_falloff 2
  conserve_energy blinn 1 facets 0.1        
}

#declare NGran  = normal { granite 0.5 scale 10 }
#declare NWav   = normal { waves 0.05 frequency 5000 scale 1000 }

#declare NOcean1 = 
normal { average normal_map { [0.3 granite 1 scale 10] [0.7 NWav] } }
    
#declare FPGranit =
function { pigment { granite scale 25 color_map {[0 rgb 1][1 rgb 0]} } }

#declare IsoWater =
isosurface {               
  function { y + 0.5 - FPGranit(x,y,z)*0.8 }   
  contained_by { sphere { <0,-earthrad,0> earthrad+1 } } 
  method 2 max_gradient 1.2 //eval
  accuracy 0.01
}

#declare IsoOcean =
union {
  object { 
    IsoWater 
    material {
      interior { ISaltWater }
      texture { pigment { WaterClear } finish { FWater } }
    }
    hollow 
  }
  sphere { <0,-earthrad,0>, earthrad-500
    texture { pigment { Green } finish { ambient 0 diffuse 1 } }
  }
}

// === Sun and Sky ===

#declare Sun =
union {
  light_source { <0,0,0>
    color rgb <255,235,180>/255*1-exp(-20*radians(35)) //completely wrong :(
    media_interaction on media_attenuation off 
    translate z*1000000
  }
  disc { <0,0,0>, z, 50000  
    pigment { 
      spherical scale 50000 poly_wave 2
      color_map { [0 rgbt 1] [0.9 rgb 1] [1.0 rgb 3] }
    }
    finish { ambient 1 diffuse 0 }
    no_shadow
    translate z*100000
  }
  rotate <-35,-25,0>
}

sky_sphere {
  pigment { gradient y 
    color_map { 
      [0.3 rgb 1]
      [0.6 rgb <140,179,252>/255]
      [0.9 color Blue+(0.4*SteelBlue)]
    } 
    scale 2 translate -1
  }
}

#declare Flightpath =
cone { <-10000,0,0>,20,<0,0,0>,5
  texture { pigment { rgbt 1 } }
  interior { 
    media { 
      scattering { 1, 0.1 extinction 0.1 }
      intervals 1 samples 1,1 method 3 
      density { 
        crackle turbulence 0.8 scale 100
        color_map { [0 rgb 0] [1 rgb 1] }
      }
    }
  }
  hollow
}

#declare SimpleJet =  // don't take this too serious, please. ;)
union {
  cylinder { <-30,0,0>,<30,0,0>,5 }
  sphere { <-30,0,0>,5 }
  sphere { < 30,0,0>,5 }
  cylinder { <0,-2,-30>,<0,0,0>,4 scale <1,0.1,1> rotate y* 20 }
  cylinder { <0,-2, 30>,<0,0,0>,4 scale <1,0.1,1> rotate y*-20 }
  texture { 
    pigment { White } 
    finish { ambient 0 diffuse 1 specular 1 roughness 0.01 reflection 0.2 }
  }
}

#declare FlyingJet =
union {  
  object { Flightpath translate z*-15 }
  object { Flightpath translate z* 15 }
  object { SimpleJet  translate x*100 }
}

#declare Buoy =
sphere { <0,0,0>, 0.5
  texture { 
    pigment { checker Red, White } 
    finish { ambient 0 diffuse 1 specular 1 roughness 0.001 }
    normal { checker } 
    scale 0.5
  }
}

#declare QuayProtector =   // don't know how to call this...
torus { 1/2, 1/6
  texture {
    pigment { rgb <50,50,70>/255 }
    finish { ambient 0 diffuse 1 specular 0.5 roughness 0.01 }
  }
}

#declare Bollard =
union {
  difference {
    box { <-1.1,0,-1.1>,<1.1,0.1,1.1> }
    cylinder {<-0.9,-0.1,-0.9>,<-0.9,0.2,-0.9>,0.1 }  // :)
  }
  sphere { <-0.9,0.1, 0.9>,0.13 scale <1,0.8,1> }      
  sphere { < 0.9,0.1,-0.9>,0.13 scale <1,0.8,1> }
  sphere { < 0.9,0.1, 0.9>,0.13 scale <1,0.8,1> }
  
  cylinder { <0,0,0>, <0,1.5,0>, 0.9 }
  sphere { <0,0,0>,1 scale <1,0.5,1> translate <0,1.5,0> }
  texture { TRustyIron scale 0.5 }
  scale 0.2
}

#declare Sailboat =      // no time constructing a real boat...
union {
  difference {
    sphere {<0,0,0>, 3 scale <1,1,0.1> }
    sphere {<0,6,0>, 8 }
    texture { 
      pigment { IndianRed } 
      finish { ambient 0 diffuse 1 specular 0.8 roughness 0.01 }
    }
  }
  cylinder {<0,-3,0>, <0,1.5,0>, 0.05 }
  cone { <0,-1.3,0>,0.01 ,<0,1.3,0>,2.9
    rotate <0,0,45> 
    scale <1,1,0.0001>
  }
  pigment { White*2 }
  finish { ambient 0 diffuse 1 specular 1 }
}

#declare Rowboat =
union {
  difference {
    sphere {<0,0,0>, 3 scale <1,1,0.2> }
    sphere {<0,6,0>, 8 }
    sphere {<0,0.2,0>, 3 scale <1,1,0.17> }
  }
  cylinder {<0,0,0>,<0,0,-1.8>,0.04 rotate <-25,25,0> translate <0,-1.85,-0.15> }
  cylinder {<0,0,0>,<0,0,1.8>,0.04 rotate <15,-25,0> translate <0,-1.9,0.15> }
  texture { 
    pigment { IndianRed } 
    finish { ambient 0 diffuse 0.95 specular 0.3 roughness 0.01 }
  }
}  

#declare Sign =
union {
  cylinder { <0,0,0>,<0,1.8,0>,0.02
    texture { TRustyIron }
  }
  intersection {
    sphere { <0.5,0.5,0>, (sqrt(0.5*0.5+0.5*0.5)-0.02)
      scale <3/10,4/10,1> translate <-0.15,1.35,-0.02> 
    }
    difference {
      box {<0,0,0>,<1,1,0.01> 
        texture { 
          pigment { image_map { png "noswim.png" once interpolate 2 } }
          finish { ambient 0 diffuse 1.5 } 
        }
        scale <3/10,4/10,1> translate <-0.15,1.35,-0.02>
      }
      cylinder { <0,1.38,-0.03>,<0,1.38,0.01>,0.015 }
      cylinder { <0,1.72,-0.03>,<0,1.72,0.01>,0.015 }
    }
  }
}

#declare Can =
union {  
  difference {
    cylinder {<0,0,0>,<0,12,0>,4}
    cylinder {<0,0,0>,<0,13,0>,3.95}
  }
  difference {
    cylinder {<0,11.4,0>,<0,11.6,0>,3.95}
    cylinder {<-2.5,10,0>,<0,14,0>,1.3 }
  }
  texture { TRustyCan scale 5 }
  translate <0,-6,0> rotate <0,0,-90> 
  scale 1/100
  translate <0,4/100,0> rotate <0,35,0>
  
}

#declare Ring = torus { 0.1,0.05 scale 1/3 texture {TRustyIron} rotate <90,0,0> } 

#declare S = seed (30000); 

#macro RandVec(Delta) 
  <-Delta/2+rand(S)*Delta,-Delta/2+rand(S)*Delta,-Delta/2+rand(S)*Delta>
#end

#macro Wall (p0,vdir,Blocks,Size,Fuzz)
  #local l = 0;
  #while ( l*Size < Blocks*Size )
    
      superellipsoid { <0.15,0.15> scale 0.5 
      texture { TMossyStone rotate <l*90,l*180,l*270> }
      scale Size
      rotate RandVec(Size*Fuzz)
      translate p0 + vdir*l*Size
    }
  #local l=l+Size;
  #end
#end

#declare Beach =
box { <-15,0,-5>,<15,0.1,30>
  texture {
    pigment { bozo color_map { CMSand } }
    finish { ambient 0 diffuse 0.5 } 
    normal { agate -0.5 scale 0.5 }
  }
}

// And now for the 'main' part. :)

#declare MTsunami =
material {
  interior { ISaltWater }
  texture {
    slope y
    texture_map {
      [ 0.93 pigment { WaterClear } 
             finish { FWater } 
             normal {
               average 
               normal_map {[0.5 NGran scale 0.5] [0.5 NOcean1 scale 2]} 
             } 
      ]
      [ 1.0  pigment { 
               crackle turbulence 1 scale 20
               color_map { [0 rgb 2] [1 color WaterClear] } 
             }
             finish { ambient 0 diffuse 1 specular 1 roughness 0.01 }
             normal { NOcean1 scale 2 }
      ]
    }
  }    
} 

#declare Tsunami =
isosurface { 
  function { y + 0.5 - 20 - cos(x/20)*20 - noise3d(x*0.03,y*0,z*0.1) }
  contained_by { box { <-pi*20,-pi*20,-pi>, <pi*20,pi*20,pi*2500> } }
  method 2 
  max_gradient 1.4 //eval           
  accuracy 0.01
  material { MTsunami } hollow
}


/**************************/

camera { MainCam }

object { Sun }

object { IsoOcean }

object { Tsunami rotate <0,-45,0> translate <250,-0.15,0> } 

object { Beach rotate x*15 translate <0,-1.5,0> }
  
object { Sailboat rotate <0,-65,0> translate <-70,2.4,150> }

object { Rowboat scale 0.8 rotate <15,140,-5> translate <1.9,1.8,6> }

object { Buoy scale 0.5 rotate <-20,-15,15> translate <  0,-0.15,0> }
object { Buoy scale 0.5 rotate <-35, 10,15> translate <1.2,-0.05,0> }
object { Buoy scale 0.5 rotate <-20,-15,15> translate <2.4,    0,0> }

Wall(< 0  ,-0.92,-2.5>,<0,0,1>, 5,0.5,15)
Wall(<-0.5,-0.46,-2.5>,<0,0,1>, 5,0.5,15)  
Wall(<-1.0,    0,-2.5>,<0,0,1>,16,0.5, 5)  
Wall(<-1.5,    0,-2.5>,<0,0,1>,16,0.5,10)
Wall(<-1.0, -0.5,-2.5>,<0,0,1>,16,0.5, 0)  
Wall(<-0.5,-0.92,-2.5>,<0,0,1>,16,0.5, 0)

object { Bollard scale 0.6 translate <-0.95,0.25,-2.25> }
object { Bollard scale 0.6 rotate y* 90 translate <-0.95,0.25,-1> }
object { Bollard scale 0.6 translate <-0.95,0.25, 1> }
object { QuayProtector scale 0.5 rotate z*-79 translate <-0.6,0,1> }
object { Bollard scale 0.6 translate <-0.95,0.25, 3> }
object { QuayProtector scale 0.5 rotate z*-80 translate <-0.6,0,3> }
object { Bollard scale 0.6 translate <-0.95,0.25, 5> }
object { QuayProtector scale 0.5 rotate z*-78 translate <-0.6,0,5> }

object { Sign rotate <-3,0,-8> translate <-1.3,0,-1.25> }  
object { Can translate <-0.8,0.25,-1.5> }
object { FlyingJet rotate <0,-30,0> translate <1000,2000,6000> }


// Very useful include files. Many thanks to both authors!

// Birds.inc (c) 1998 Neil Alexander
#include "birds.inc"

// make them livin' creatures:
motion_blur{
  object { Bird(0.2+clock) scale <1,0.8,1>/20  //they are too fat :)
  rotate <0,0,8> translate <-0.95,0.55,1>}
}
motion_blur{
  object {Bird(clock/2) scale <1,0.8,1>/20  
  rotate <5,160,-5> translate <-5,1.2,3>}
}
motion_blur{ 
  object {Bird(0.1+clock) scale <1,0.8,1>/20  
  rotate <10,140,-5> translate <-6,2,5>}
}


// Link.inc (c) Chris Colefax.

#declare camera_sky = <0.00001,1,0>; //some bug with versions > 3.0

// linking boat with bollard
#declare link_object = torus {0.5,0.15 texture { TRustyIron } }
#declare link_size = 0.06;

#declare link_point1 = <-0.9,0.35,5.25>;
#declare link_point2 = <0.28, 0.6,5>;
#include "LINK.INC"

// linking buoys
#declare link_size = 0.04;

object { Ring translate <-0.75,0.15,-0.6> }
#declare link_point1 = <-0.75,0.15,-0.6>;
#declare link_point2 = < 0,-0.15,0>;
#include "LINK.INC"

#declare link_point1 = <  0,-0.2,0>;
#declare link_point2 = <1.2,-0.1,0>;
#include "LINK.INC"

#declare link_point1 = <1.2,-0.1,0>;
#declare link_point2 = <2.4,-0.05,0>;
#include "LINK.INC"

// ==== END OF SESSION ====
