//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 1 lights, 10 materials and 32 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 08/30/2000    (30.08.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,0.945098,0.737255>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.5
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

fog {
  fog_type 1    // Constant
  distance     200.0
  color <1.0,0.611765,0.0,0.0,0.0>
}

fog {
  fog_type 2    // Ground Fog
  distance     2000.0
  color <0.898039,0.737255,0.6,0.0,0.0>
  turbulence   <0.2,0.2,0.2>
    omega      0.5
    lambda     2.0
    octaves    6
    turb_depth 0.2
  up           <0,0,1>
  fog_offset   15.0
  fog_alt      4.0
}

fog {
  fog_type 2    // Ground Fog
  distance     2000.0
  color <0.8,0.698039,0.498039,0.0,0.0>
  turbulence   <0.1,0.1,0.1>
    omega      0.5
    lambda     2.0
    octaves    6
    turb_depth 0.2
  up           <0,0,1>
  fog_offset   25.0
  fog_alt      5.0
}

fog {
  fog_type 2    // Ground Fog
  distance     2000.0
  color <0.72549,0.592157,0.529412,0.0,0.0>
  up           <0,0,1>
  fog_offset   10.0
  fog_alt      2.0
}

camera {  //  Camera StdCam
  location  <    -56.000,       0.000,       9.000>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35836,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      30.000
  look_at   <      0.000,       0.000,       9.000>
}

//
// *******  L I G H T S *******
//

#declare Light1 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.800, 0.286>
  translate  <220.0, 0.0, 15.0>
}


//
// ********  MATERIALS  *******
//

#include "fisher.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

#include "G:\moraywin\PovScn\dog.inc"

#declare Figure_2_fur_2_Ref = object {
  Figure_2_fur_2
}
#declare Figure_2_fur_2_0_Ref = object {
  Figure_2_fur_2_0
}
#declare Figure_2_fur_2_1_Ref = object {
  Figure_2_fur_2_1
  material {
    Nose
  }
}
#declare Figure_2_fur_2_2_Ref = object {
  Figure_2_fur_2_2
}
#declare Figure_2_fur_2_3_Ref = object {
  Figure_2_fur_2_3
}
#declare Figure_2_fur_2_4_Ref = object {
  Figure_2_fur_2_4
}
#declare Figure_2_fur_2_5_Ref = object {
  Figure_2_fur_2_5
}
#declare Figure_2_footPads_2_Ref = object {
  Figure_2_footPads_2
}
union { // dog_group
  object { Figure_2_fur_2_Ref }
  object { Figure_2_fur_2_0_Ref }
  object { Figure_2_fur_2_1_Ref }
  object { Figure_2_fur_2_2_Ref }
  object { Figure_2_fur_2_3_Ref }
  object { Figure_2_fur_2_4_Ref }
  object { Figure_2_fur_2_5_Ref }
  object { Figure_2_footPads_2_Ref }
  material {
    Fur
  }
  scale 20.0
  rotate <90.0, -0.0, 52.372761>
  translate  <-33.0, 5.5, 1.95>
}


sphere { // Sphere001
  <0,0,0>,1
  material {
    Evening_Cloud_Sky_1
  }
  hollow
  scale 10000.0
}


plane { // Plane001
  z,0
  material {
    Quiet_Water
  }
}


union { // SOL
  object { Light1 }
  sphere { // Sphere002
    <0,0,0>,1
    material {
      Sun
    }
    hollow
    scale 90.0
    translate  <220.0, 0.0, 15.0>
  }
  material {
    Sun
  }
  translate  <900.0, 0.0, -5.0>
}


union { // sPatchObj1
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <5.500000, -3.500000, 0.000000>, <5.525337, -3.905397, -0.152024>, <5.640000, -4.410000, -0.420000>, <5.700000, -4.800000, -0.600000>, 
      <5.854087, -3.562486, -0.124972>, <5.879424, -3.967883, -0.276996>, <5.880000, -4.410000, -0.420000>, <5.940000, -4.800000, -0.600000>, 
      <6.200000, -3.850000, -0.420000>, <6.200000, -4.090000, -0.420000>, <6.260000, -4.560000, -0.600000>, <6.260000, -4.800000, -0.600000>, 
      <6.500000, -4.000000, -0.600000>, <6.500000, -4.240000, -0.600000>, <6.500000, -4.560000, -0.600000>, <6.500000, -4.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <5.600000, -3.200000, 0.000000>, <5.583029, -3.293338, 0.000000>, <5.494458, -3.411324, 0.033254>, <5.500000, -3.500000, 0.000000>, 
      <5.859600, -3.200000, -0.194700>, <5.842629, -3.293338, -0.194700>, <5.848544, -3.473810, -0.091718>, <5.854087, -3.562486, -0.124972>, 
      <6.230000, -3.200000, -0.420000>, <6.230000, -3.440000, -0.420000>, <6.200000, -3.610000, -0.420000>, <6.200000, -3.850000, -0.420000>, 
      <6.500000, -3.200000, -0.600000>, <6.500000, -3.440000, -0.600000>, <6.500000, -3.760000, -0.600000>, <6.500000, -4.000000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <5.700000, -2.400000, 0.000000>, <5.716088, -2.641332, 0.000000>, <5.643267, -2.962034, 0.000000>, <5.600000, -3.200000, 0.000000>, 
      <5.940000, -2.400000, -0.180000>, <5.956088, -2.641332, -0.180000>, <5.902866, -2.962034, -0.194700>, <5.859600, -3.200000, -0.194700>, 
      <6.260000, -2.400000, -0.420000>, <6.260000, -2.640000, -0.420000>, <6.230000, -2.960000, -0.420000>, <6.230000, -3.200000, -0.420000>, 
      <6.500000, -2.400000, -0.600000>, <6.500000, -2.640000, -0.600000>, <6.500000, -2.960000, -0.600000>, <6.500000, -3.200000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.100000, -3.200000, 0.600000>, <3.860000, -3.200000, 0.600000>, <3.540000, -3.200000, 0.600000>, <3.300000, -3.200000, 0.600000>, 
      <4.112721, -2.971023, 0.714489>, <3.872721, -2.971023, 0.714489>, <3.540000, -2.976598, 0.725664>, <3.300000, -2.976598, 0.725664>, 
      <4.100000, -2.651930, 0.852763>, <3.864110, -2.651930, 0.896992>, <3.537894, -2.683649, 0.852763>, <3.300000, -2.651930, 0.852763>, 
      <4.100000, -2.400000, 0.900000>, <3.864110, -2.400000, 0.944229>, <3.537894, -2.431719, 0.900000>, <3.300000, -2.400000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.000000, -4.200000, 0.000000>, <3.785838, -4.242833, 0.000000>, <3.502782, -4.081113, 0.000000>, <3.300000, -4.000000, 0.000000>, 
      <4.000000, -4.501101, -0.180661>, <3.785838, -4.543933, -0.180661>, <3.502782, -4.321113, -0.180000>, <3.300000, -4.240000, -0.180000>, 
      <4.070000, -4.900000, -0.420000>, <3.806268, -4.949450, -0.420000>, <3.540000, -4.680000, -0.420000>, <3.300000, -4.560000, -0.420000>, 
      <4.100000, -5.200000, -0.600000>, <3.836268, -5.249450, -0.600000>, <3.540000, -4.920000, -0.600000>, <3.300000, -4.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.000000, -4.200000, 0.000000>, <3.785838, -4.242833, 0.000000>, <3.502782, -4.081113, 0.000000>, <3.300000, -4.000000, 0.000000>, 
      <4.000000, -3.898899, 0.180661>, <3.785838, -3.941732, 0.180661>, <3.502782, -3.841113, 0.180000>, <3.300000, -3.760000, 0.180000>, 
      <4.082573, -3.513683, 0.443159>, <3.842573, -3.513683, 0.443159>, <3.540000, -3.461473, 0.452922>, <3.300000, -3.461473, 0.452922>, 
      <4.100000, -3.200000, 0.600000>, <3.860000, -3.200000, 0.600000>, <3.540000, -3.200000, 0.600000>, <3.300000, -3.200000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.800000, -3.700000, 0.000000>, <4.800000, -3.921540, -0.204499>, <4.870000, -4.260000, -0.420000>, <4.900000, -4.500000, -0.600000>, 
      <4.997913, -3.607640, 0.000000>, <4.997913, -3.829181, -0.204499>, <5.110000, -4.350000, -0.420000>, <5.140000, -4.590000, -0.600000>, 
      <5.296842, -3.464148, 0.071703>, <5.322179, -3.869546, -0.080321>, <5.400000, -4.320000, -0.420000>, <5.460000, -4.710000, -0.600000>, 
      <5.500000, -3.500000, 0.000000>, <5.525337, -3.905397, -0.152024>, <5.640000, -4.410000, -0.420000>, <5.700000, -4.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.800000, -3.700000, 0.000000>, <4.543533, -3.819685, 0.000000>, <4.277524, -4.144496, 0.000000>, <4.000000, -4.200000, 0.000000>, 
      <4.800000, -3.921540, -0.204499>, <4.543533, -4.041226, -0.204499>, <4.277524, -4.445596, -0.180661>, <4.000000, -4.501101, -0.180661>, 
      <4.870000, -4.260000, -0.420000>, <4.630000, -4.470000, -0.420000>, <4.383442, -4.841230, -0.420000>, <4.070000, -4.900000, -0.420000>, 
      <4.900000, -4.500000, -0.600000>, <4.660000, -4.710000, -0.600000>, <4.413442, -5.141230, -0.600000>, <4.100000, -5.200000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.900000, -3.200000, 0.600000>, <4.883542, -3.413957, 0.501251>, <4.800000, -3.526425, 0.160223>, <4.800000, -3.700000, 0.000000>, 
      <5.156804, -3.200000, 0.497279>, <5.140346, -3.413957, 0.398529>, <4.997913, -3.434065, 0.160223>, <4.997913, -3.607640, 0.000000>, 
      <5.378731, -3.200000, 0.165952>, <5.361760, -3.293338, 0.165952>, <5.291299, -3.375472, 0.104957>, <5.296842, -3.464148, 0.071703>, 
      <5.600000, -3.200000, 0.000000>, <5.583029, -3.293338, 0.000000>, <5.494458, -3.411324, 0.033254>, <5.500000, -3.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.900000, -3.200000, 0.600000>, <4.677166, -3.200000, 0.689134>, <4.340000, -3.200000, 0.600000>, <4.100000, -3.200000, 0.600000>, 
      <4.883542, -3.413957, 0.501251>, <4.660708, -3.413957, 0.590384>, <4.322573, -3.513683, 0.443159>, <4.082573, -3.513683, 0.443159>, 
      <4.800000, -3.526425, 0.160223>, <4.543533, -3.646110, 0.160223>, <4.277524, -3.843394, 0.180661>, <4.000000, -3.898899, 0.180661>, 
      <4.800000, -3.700000, 0.000000>, <4.543533, -3.819685, 0.000000>, <4.277524, -4.144496, 0.000000>, <4.000000, -4.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.900000, -2.400000, 0.600000>, <4.900000, -2.640000, 0.600000>, <4.916722, -2.982619, 0.700330>, <4.900000, -3.200000, 0.600000>, 
      <5.161472, -2.400000, 0.452922>, <5.161472, -2.640000, 0.452922>, <5.173526, -2.982619, 0.597608>, <5.156804, -3.200000, 0.497279>, 
      <5.460000, -2.400000, 0.180000>, <5.476088, -2.641332, 0.180000>, <5.421998, -2.962034, 0.165952>, <5.378731, -3.200000, 0.165952>, 
      <5.700000, -2.400000, 0.000000>, <5.716088, -2.641332, 0.000000>, <5.643267, -2.962034, 0.000000>, <5.600000, -3.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.900000, -2.400000, 0.600000>, <4.676598, -2.400000, 0.725664>, <4.351930, -2.400000, 0.852763>, <4.100000, -2.400000, 0.900000>, 
      <4.900000, -2.640000, 0.600000>, <4.676598, -2.640000, 0.725664>, <4.351930, -2.651930, 0.805526>, <4.100000, -2.651930, 0.852763>, 
      <4.916722, -2.982619, 0.700330>, <4.693887, -2.982619, 0.789463>, <4.352721, -2.971023, 0.714489>, <4.112721, -2.971023, 0.714489>, 
      <4.900000, -3.200000, 0.600000>, <4.677166, -3.200000, 0.689134>, <4.340000, -3.200000, 0.600000>, <4.100000, -3.200000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <6.500000, -1.600000, -0.600000>, <6.200000, -1.630000, -0.420000>, <5.800000, -1.670000, -0.180000>, <5.500000, -1.700000, 0.000000>, 
      <6.500000, -1.840000, -0.600000>, <6.200000, -1.870000, -0.420000>, <5.814528, -1.887920, -0.180000>, <5.514528, -1.917920, 0.000000>, 
      <6.500000, -2.160000, -0.600000>, <6.260000, -2.160000, -0.420000>, <5.925472, -2.182081, -0.180000>, <5.685472, -2.182081, 0.000000>, 
      <6.500000, -2.400000, -0.600000>, <6.260000, -2.400000, -0.420000>, <5.940000, -2.400000, -0.180000>, <5.700000, -2.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.100000, -1.600000, 0.900000>, <3.860000, -1.600000, 0.900000>, <3.540000, -1.600000, 0.900000>, <3.300000, -1.600000, 0.900000>, 
      <4.100000, -1.835889, 0.944229>, <3.860000, -1.835889, 0.944229>, <3.526868, -1.836380, 0.939397>, <3.286868, -1.836380, 0.939397>, 
      <4.100000, -2.164111, 0.944229>, <3.864110, -2.164111, 0.988459>, <3.537894, -2.195830, 0.944229>, <3.300000, -2.164111, 0.944229>, 
      <4.100000, -2.400000, 0.900000>, <3.864110, -2.400000, 0.944229>, <3.537894, -2.431719, 0.900000>, <3.300000, -2.400000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.900000, -1.600000, 0.600000>, <4.917100, -1.839390, 0.600000>, <4.900000, -2.160000, 0.600000>, <4.900000, -2.400000, 0.600000>, 
      <5.080000, -1.630000, 0.420000>, <5.097099, -1.869390, 0.420000>, <5.161472, -2.160000, 0.452922>, <5.161472, -2.400000, 0.452922>, 
      <5.320000, -1.670000, 0.180000>, <5.334528, -1.887920, 0.180000>, <5.445472, -2.182081, 0.180000>, <5.460000, -2.400000, 0.180000>, 
      <5.500000, -1.700000, 0.000000>, <5.514528, -1.917920, 0.000000>, <5.685472, -2.182081, 0.000000>, <5.700000, -2.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.900000, -1.600000, 0.600000>, <4.660000, -1.600000, 0.690000>, <4.340000, -1.600000, 0.810000>, <4.100000, -1.600000, 0.900000>, 
      <4.917100, -1.839390, 0.600000>, <4.677099, -1.839390, 0.690000>, <4.340000, -1.835889, 0.854229>, <4.100000, -1.835889, 0.944229>, 
      <4.900000, -2.160000, 0.600000>, <4.676598, -2.160000, 0.725664>, <4.351930, -2.164111, 0.896992>, <4.100000, -2.164111, 0.944229>, 
      <4.900000, -2.400000, 0.600000>, <4.676598, -2.400000, 0.725664>, <4.351930, -2.400000, 0.852763>, <4.100000, -2.400000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <5.600000, -0.900000, 0.000000>, <5.618550, -1.141155, 0.000000>, <5.483912, -1.458668, 0.000000>, <5.500000, -1.700000, 0.000000>, 
      <5.865015, -0.868822, -0.187070>, <5.883566, -1.109977, -0.187070>, <5.783912, -1.428668, -0.180000>, <5.800000, -1.670000, -0.180000>, 
      <6.230000, -0.830000, -0.420000>, <6.230000, -1.070000, -0.420000>, <6.200000, -1.390000, -0.420000>, <6.200000, -1.630000, -0.420000>, 
      <6.500000, -0.800000, -0.600000>, <6.500000, -1.040000, -0.600000>, <6.500000, -1.360000, -0.600000>, <6.500000, -1.600000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <5.600000, -0.900000, 0.000000>, <5.865015, -0.868822, -0.187070>, <6.230000, -0.830000, -0.420000>, <6.500000, -0.800000, -0.600000>, 
      <5.587609, -0.738921, 0.000000>, <5.852624, -0.707743, -0.187070>, <6.230000, -0.590000, -0.420000>, <6.500000, -0.560000, -0.600000>, 
      <5.391052, -0.552111, 0.053686>, <5.749610, -0.446653, -0.072864>, <6.170000, -0.360000, -0.420000>, <6.500000, -0.240000, -0.600000>, 
      <5.400000, -0.400000, 0.000000>, <5.758558, -0.294542, -0.126550>, <6.170000, -0.120000, -0.420000>, <6.500000, 0.000000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <5.700000, 0.800000, -0.600000>, <5.610000, 0.440000, -0.420000>, <5.422842, -0.011678, -0.137055>, <5.400000, -0.400000, 0.000000>, 
      <5.933701, 0.737680, -0.600000>, <5.843701, 0.377680, -0.420000>, <5.781400, 0.093780, -0.263605>, <5.758558, -0.294542, -0.126550>, 
      <6.190000, 0.520000, -0.600000>, <6.220000, 0.400000, -0.600000>, <6.140000, 0.000000, -0.420000>, <6.170000, -0.120000, -0.420000>, 
      <6.400000, 0.400000, -0.600000>, <6.430000, 0.280000, -0.600000>, <6.470000, 0.120000, -0.600000>, <6.500000, 0.000000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.000000, -0.100000, 0.000000>, <4.000000, 0.160707, -0.195530>, <4.070000, 0.530000, -0.420000>, <4.100000, 0.800000, -0.600000>, 
      <3.814282, 0.042860, 0.000000>, <3.814282, 0.303567, -0.195530>, <3.886401, 0.586492, -0.420000>, <3.916401, 0.856492, -0.600000>, 
      <3.723946, 0.431094, 0.000000>, <3.749557, 0.661594, -0.153667>, <3.757174, 0.946806, -0.420000>, <3.787174, 1.156806, -0.600000>, 
      <3.500000, 0.500000, 0.000000>, <3.525611, 0.730501, -0.153667>, <3.570000, 0.990000, -0.420000>, <3.600000, 1.200000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.100000, -0.800000, 0.600000>, <3.890000, -0.740000, 0.600000>, <3.613556, -0.645762, 0.600000>, <3.400000, -0.600000, 0.600000>, 
      <4.114629, -1.019435, 0.731661>, <3.904629, -0.959434, 0.731661>, <3.586117, -0.933862, 0.723472>, <3.372562, -0.888100, 0.723472>, 
      <4.100000, -1.348070, 0.852763>, <3.860000, -1.348070, 0.852763>, <3.557216, -1.290103, 0.848351>, <3.317216, -1.290103, 0.848351>, 
      <4.100000, -1.600000, 0.900000>, <3.860000, -1.600000, 0.900000>, <3.540000, -1.600000, 0.900000>, <3.300000, -1.600000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.100000, -0.800000, 0.600000>, <4.084122, -0.561827, 0.457096>, <4.000000, -0.322567, 0.166925>, <4.000000, -0.100000, 0.000000>, 
      <3.890000, -0.740000, 0.600000>, <3.874122, -0.501827, 0.457096>, <3.814282, -0.179707, 0.166925>, <3.814282, 0.042860, 0.000000>, 
      <3.613556, -0.645762, 0.600000>, <3.646440, -0.300478, 0.452021>, <3.689232, 0.118665, 0.208286>, <3.723946, 0.431094, 0.000000>, 
      <3.400000, -0.600000, 0.600000>, <3.432884, -0.254716, 0.452021>, <3.465286, 0.187571, 0.208286>, <3.500000, 0.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.800000, -1.000000, 0.600000>, <4.814518, -1.159693, 0.687105>, <4.886999, -1.417981, 0.600000>, <4.900000, -1.600000, 0.600000>, 
      <5.079398, -1.018627, 0.488241>, <5.093915, -1.178320, 0.575346>, <5.066998, -1.447981, 0.420000>, <5.080000, -1.630000, 0.420000>, 
      <5.354817, -0.928845, 0.173070>, <5.373367, -1.170000, 0.173070>, <5.303912, -1.428668, 0.180000>, <5.320000, -1.670000, 0.180000>, 
      <5.600000, -0.900000, 0.000000>, <5.618550, -1.141155, 0.000000>, <5.483912, -1.458668, 0.000000>, <5.500000, -1.700000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.800000, -1.000000, 0.600000>, <4.597605, -0.986507, 0.680958>, <4.310000, -0.860000, 0.600000>, <4.100000, -0.800000, 0.600000>, 
      <4.814518, -1.159693, 0.687105>, <4.612122, -1.146200, 0.768063>, <4.324629, -1.079435, 0.731661>, <4.114629, -1.019435, 0.731661>, 
      <4.886999, -1.417981, 0.600000>, <4.646998, -1.417981, 0.690000>, <4.340000, -1.348070, 0.762763>, <4.100000, -1.348070, 0.852763>, 
      <4.900000, -1.600000, 0.600000>, <4.660000, -1.600000, 0.690000>, <4.340000, -1.600000, 0.810000>, <4.100000, -1.600000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.800000, -0.500000, 0.000000>, <4.789181, -0.694748, 0.129832>, <4.781360, -0.794954, 0.488157>, <4.800000, -1.000000, 0.600000>, 
      <4.978432, -0.538235, 0.000000>, <4.967613, -0.732983, 0.129832>, <5.060757, -0.813581, 0.376398>, <5.079398, -1.018627, 0.488241>, 
      <5.234180, -0.448771, 0.058525>, <5.225232, -0.600881, 0.112211>, <5.342426, -0.767766, 0.173070>, <5.354817, -0.928845, 0.173070>, 
      <5.400000, -0.400000, 0.000000>, <5.391052, -0.552111, 0.053686>, <5.587609, -0.738921, 0.000000>, <5.600000, -0.900000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.800000, -0.500000, 0.000000>, <4.537628, -0.443777, 0.000000>, <4.212683, -0.263603, 0.000000>, <4.000000, -0.100000, 0.000000>, 
      <4.789181, -0.694748, 0.129832>, <4.526809, -0.638525, 0.129832>, <4.212683, -0.486169, 0.166925>, <4.000000, -0.322567, 0.166925>, 
      <4.781360, -0.794954, 0.488157>, <4.578965, -0.781461, 0.569115>, <4.294122, -0.621827, 0.457096>, <4.084122, -0.561827, 0.457096>, 
      <4.800000, -1.000000, 0.600000>, <4.597605, -0.986507, 0.680958>, <4.310000, -0.860000, 0.600000>, <4.100000, -0.800000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.900000, 0.800000, -0.600000>, <4.870000, 0.410000, -0.420000>, <4.819882, -0.142117, -0.238589>, <4.800000, -0.500000, 0.000000>, 
      <5.140000, 0.800000, -0.600000>, <5.110000, 0.410000, -0.420000>, <4.998314, -0.180353, -0.238589>, <4.978432, -0.538235, 0.000000>, 
      <5.468104, 0.861839, -0.600000>, <5.378103, 0.501839, -0.420000>, <5.257022, -0.060448, -0.078530>, <5.234180, -0.448771, 0.058525>, 
      <5.700000, 0.800000, -0.600000>, <5.610000, 0.440000, -0.420000>, <5.422842, -0.011678, -0.137055>, <5.400000, -0.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.900000, 0.800000, -0.600000>, <4.660000, 0.800000, -0.600000>, <4.329387, 0.729419, -0.600000>, <4.100000, 0.800000, -0.600000>, 
      <4.870000, 0.410000, -0.420000>, <4.630000, 0.410000, -0.420000>, <4.299386, 0.459419, -0.420000>, <4.070000, 0.530000, -0.420000>, 
      <4.819882, -0.142117, -0.238589>, <4.557510, -0.085894, -0.238589>, <4.212683, -0.002896, -0.195530>, <4.000000, 0.160707, -0.195530>, 
      <4.800000, -0.500000, 0.000000>, <4.537628, -0.443777, 0.000000>, <4.212683, -0.263603, 0.000000>, <4.000000, -0.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <2.500000, -3.600000, 0.000000>, <2.740000, -3.720000, 0.000000>, <3.050864, -3.900346, 0.000000>, <3.300000, -4.000000, 0.000000>, 
      <2.500000, -3.921994, -0.241495>, <2.740000, -4.041994, -0.241495>, <3.050864, -4.140346, -0.180000>, <3.300000, -4.240000, -0.180000>, 
      <2.500000, -4.440000, -0.420000>, <2.740000, -4.440000, -0.420000>, <3.060000, -4.560000, -0.420000>, <3.300000, -4.560000, -0.420000>, 
      <2.500000, -4.800000, -0.600000>, <2.740000, -4.800000, -0.600000>, <3.060000, -4.800000, -0.600000>, <3.300000, -4.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <2.500000, -3.200000, 0.600000>, <2.740000, -3.200000, 0.600000>, <3.060000, -3.200000, 0.600000>, <3.300000, -3.200000, 0.600000>, 
      <2.487025, -3.381647, 0.483227>, <2.727025, -3.381647, 0.483227>, <3.060000, -3.461473, 0.452922>, <3.300000, -3.461473, 0.452922>, 
      <2.500000, -3.426934, 0.129800>, <2.740000, -3.546934, 0.129800>, <3.050864, -3.660346, 0.180000>, <3.300000, -3.760000, 0.180000>, 
      <2.500000, -3.600000, 0.000000>, <2.740000, -3.720000, 0.000000>, <3.050864, -3.900346, 0.000000>, <3.300000, -4.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <2.600000, -2.200000, 0.900000>, <2.600000, -1.961423, 0.939763>, <2.486012, -1.637789, 0.941963>, <2.500000, -1.400000, 0.900000>, 
      <2.810000, -2.260000, 0.900000>, <2.810000, -2.021423, 0.939763>, <2.726012, -1.697789, 0.941963>, <2.740000, -1.460000, 0.900000>, 
      <3.083512, -2.371135, 0.900000>, <3.083512, -2.135246, 0.944229>, <3.046868, -1.776380, 0.939397>, <3.060000, -1.540000, 0.900000>, 
      <3.300000, -2.400000, 0.900000>, <3.300000, -2.164111, 0.944229>, <3.286868, -1.836380, 0.939397>, <3.300000, -1.600000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <2.600000, -2.200000, 0.900000>, <2.810000, -2.260000, 0.900000>, <3.083512, -2.371135, 0.900000>, <3.300000, -2.400000, 0.900000>, 
      <2.600000, -2.510362, 0.848273>, <2.810000, -2.570362, 0.848273>, <3.083512, -2.623065, 0.852763>, <3.300000, -2.651930, 0.852763>, 
      <2.518871, -2.935806, 0.769839>, <2.758871, -2.935806, 0.769839>, <3.060000, -2.976598, 0.725664>, <3.300000, -2.976598, 0.725664>, 
      <2.500000, -3.200000, 0.600000>, <2.740000, -3.200000, 0.600000>, <3.060000, -3.200000, 0.600000>, <3.300000, -3.200000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.700000, -4.800000, -0.600000>, <1.760000, -4.410000, -0.420000>, <1.900000, -3.846964, -0.260223>, <1.900000, -3.500000, 0.000000>, 
      <1.940000, -4.800000, -0.600000>, <2.000000, -4.410000, -0.420000>, <2.080000, -3.876964, -0.260223>, <2.080000, -3.530000, 0.000000>, 
      <2.260000, -4.800000, -0.600000>, <2.260000, -4.440000, -0.420000>, <2.320000, -3.891994, -0.241495>, <2.320000, -3.570000, 0.000000>, 
      <2.500000, -4.800000, -0.600000>, <2.500000, -4.440000, -0.420000>, <2.500000, -3.921994, -0.241495>, <2.500000, -3.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.700000, -3.200000, 0.600000>, <1.940000, -3.200000, 0.600000>, <2.260000, -3.200000, 0.600000>, <2.500000, -3.200000, 0.600000>, 
      <1.725849, -3.380944, 0.496603>, <1.965849, -3.380944, 0.496603>, <2.247025, -3.381647, 0.483227>, <2.487025, -3.381647, 0.483227>, 
      <1.900000, -3.332000, 0.126000>, <2.080000, -3.362000, 0.126000>, <2.320000, -3.396934, 0.129800>, <2.500000, -3.426934, 0.129800>, 
      <1.900000, -3.500000, 0.000000>, <2.080000, -3.530000, 0.000000>, <2.320000, -3.570000, 0.000000>, <2.500000, -3.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.700000, -2.100000, 0.800000>, <1.972106, -2.081860, 0.818141>, <2.330000, -2.170000, 0.870000>, <2.600000, -2.200000, 0.900000>, 
      <1.681647, -2.430351, 0.744942>, <1.953754, -2.412211, 0.763082>, <2.330000, -2.480362, 0.818273>, <2.600000, -2.510362, 0.848273>, 
      <1.658714, -2.910997, 0.765145>, <1.898714, -2.910997, 0.765145>, <2.278871, -2.935806, 0.769839>, <2.518871, -2.935806, 0.769839>, 
      <1.700000, -3.200000, 0.600000>, <1.940000, -3.200000, 0.600000>, <2.260000, -3.200000, 0.600000>, <2.500000, -3.200000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.700000, -2.100000, 0.800000>, <1.711723, -1.888989, 0.835169>, <1.785873, -1.611901, 0.928253>, <1.800000, -1.400000, 0.900000>, 
      <1.972106, -2.081860, 0.818141>, <1.983829, -1.870849, 0.853309>, <1.995873, -1.611901, 0.928253>, <2.010000, -1.400000, 0.900000>, 
      <2.330000, -2.170000, 0.870000>, <2.330000, -1.931423, 0.909763>, <2.276012, -1.637789, 0.941963>, <2.290000, -1.400000, 0.900000>, 
      <2.600000, -2.200000, 0.900000>, <2.600000, -1.961423, 0.939763>, <2.486012, -1.637789, 0.941963>, <2.500000, -1.400000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.500000, -3.800000, 0.000000>, <-0.541264, -4.130111, -0.123792>, <-0.640000, -4.500000, -0.420000>, <-0.700000, -4.800000, -0.600000>, 
      <-0.828947, -3.778070, -0.131579>, <-0.870211, -4.108181, -0.255370>, <-0.880000, -4.500000, -0.420000>, <-0.940000, -4.800000, -0.600000>, 
      <-1.200000, -3.940000, -0.420000>, <-1.200000, -4.180000, -0.420000>, <-1.260000, -4.560000, -0.600000>, <-1.260000, -4.800000, -0.600000>, 
      <-1.500000, -4.000000, -0.600000>, <-1.500000, -4.240000, -0.600000>, <-1.500000, -4.560000, -0.600000>, <-1.500000, -4.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.500000, -3.200000, 0.000000>, <-0.439460, -3.369514, 0.000000>, <-0.479075, -3.632604, 0.062774>, <-0.500000, -3.800000, 0.000000>, 
      <-0.771724, -3.163770, -0.217379>, <-0.711183, -3.333284, -0.217379>, <-0.808022, -3.610674, -0.068805>, <-0.828947, -3.778070, -0.131579>, 
      <-1.200000, -3.200000, -0.420000>, <-1.128414, -3.429075, -0.420000>, <-1.200000, -3.700000, -0.420000>, <-1.200000, -3.940000, -0.420000>, 
      <-1.500000, -3.200000, -0.600000>, <-1.428414, -3.429075, -0.600000>, <-1.500000, -3.760000, -0.600000>, <-1.500000, -4.000000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-1.000000, -2.400000, 0.000000>, <-1.291099, -2.400000, -0.194066>, <-1.700000, -2.400000, -0.420000>, <-2.000000, -2.400000, -0.600000>, 
      <-1.035104, -2.680834, 0.000000>, <-1.326203, -2.680834, -0.194066>, <-1.550000, -2.640000, -0.420000>, <-1.850000, -2.640000, -0.600000>, 
      <-0.595190, -2.933469, 0.000000>, <-0.866914, -2.897239, -0.217379>, <-1.284418, -2.929864, -0.420000>, <-1.584418, -2.929864, -0.600000>, 
      <-0.500000, -3.200000, 0.000000>, <-0.771724, -3.163770, -0.217379>, <-1.200000, -3.200000, -0.420000>, <-1.500000, -3.200000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.000000, -3.400000, 0.600000>, <-0.222312, -3.400000, 0.504724>, <-0.312149, -3.225047, 0.150281>, <-0.500000, -3.200000, 0.000000>, 
      <-0.033734, -3.113260, 0.701202>, <-0.256046, -3.113260, 0.605926>, <-0.407338, -2.958516, 0.150281>, <-0.595190, -2.933469, 0.000000>, 
      <-0.232027, -2.704260, 0.600000>, <-0.512096, -2.717597, 0.493307>, <-0.785489, -2.680834, 0.166410>, <-1.035104, -2.680834, 0.000000>, 
      <-0.200000, -2.400000, 0.600000>, <-0.480069, -2.413337, 0.493307>, <-0.750385, -2.400000, 0.166410>, <-1.000000, -2.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.000000, -4.100000, 0.000000>, <0.015066, -4.310922, -0.180790>, <0.070000, -4.590000, -0.420000>, <0.100000, -4.800000, -0.600000>, 
      <-0.174484, -4.112463, 0.000000>, <-0.159418, -4.323385, -0.180790>, <-0.170000, -4.590000, -0.420000>, <-0.140000, -4.800000, -0.600000>, 
      <-0.337893, -3.810807, 0.064843>, <-0.379157, -4.140918, -0.058949>, <-0.400000, -4.500000, -0.420000>, <-0.460000, -4.800000, -0.600000>, 
      <-0.500000, -3.800000, 0.000000>, <-0.541264, -4.130111, -0.123792>, <-0.640000, -4.500000, -0.420000>, <-0.700000, -4.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.000000, -4.100000, 0.000000>, <-0.174484, -4.112463, 0.000000>, <-0.337893, -3.810807, 0.064843>, <-0.500000, -3.800000, 0.000000>, 
      <-0.014978, -3.890308, 0.179736>, <-0.189462, -3.902771, 0.179736>, <-0.316969, -3.643410, 0.127616>, <-0.479075, -3.632604, 0.062774>, 
      <0.030497, -3.659228, 0.508508>, <-0.191814, -3.659228, 0.413231>, <-0.251608, -3.394560, 0.150281>, <-0.439460, -3.369514, 0.000000>, 
      <0.000000, -3.400000, 0.600000>, <-0.222312, -3.400000, 0.504724>, <-0.312149, -3.225047, 0.150281>, <-0.500000, -3.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.900000, -3.700000, 0.000000>, <1.200000, -3.640000, 0.000000>, <1.600000, -3.560000, 0.000000>, <1.900000, -3.500000, 0.000000>, 
      <0.900000, -4.000719, -0.225539>, <1.200000, -3.940719, -0.225539>, <1.600000, -3.906964, -0.260223>, <1.900000, -3.846964, -0.260223>, 
      <0.900000, -4.470000, -0.420000>, <1.140000, -4.470000, -0.420000>, <1.520000, -4.410000, -0.420000>, <1.760000, -4.410000, -0.420000>, 
      <0.900000, -4.800000, -0.600000>, <1.140000, -4.800000, -0.600000>, <1.460000, -4.800000, -0.600000>, <1.700000, -4.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.900000, -3.700000, 0.000000>, <0.900000, -4.000719, -0.225539>, <0.900000, -4.470000, -0.420000>, <0.900000, -4.800000, -0.600000>, 
      <0.630000, -3.820000, 0.000000>, <0.630000, -4.120719, -0.225539>, <0.660000, -4.470000, -0.420000>, <0.660000, -4.800000, -0.600000>, 
      <0.294715, -4.078949, 0.000000>, <0.309781, -4.289871, -0.180790>, <0.310000, -4.590000, -0.420000>, <0.340000, -4.800000, -0.600000>, 
      <0.000000, -4.100000, 0.000000>, <0.015066, -4.310922, -0.180790>, <0.070000, -4.590000, -0.420000>, <0.100000, -4.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.900000, -3.200000, 0.600000>, <1.138356, -3.171958, 0.600000>, <1.460000, -3.200000, 0.600000>, <1.700000, -3.200000, 0.600000>, 
      <0.871159, -3.401889, 0.484635>, <1.109515, -3.373847, 0.484635>, <1.485849, -3.380944, 0.496603>, <1.725849, -3.380944, 0.496603>, 
      <0.900000, -3.512554, 0.140585>, <1.200000, -3.452554, 0.140585>, <1.600000, -3.392000, 0.126000>, <1.900000, -3.332000, 0.126000>, 
      <0.900000, -3.700000, 0.000000>, <1.200000, -3.640000, 0.000000>, <1.600000, -3.560000, 0.000000>, <1.900000, -3.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.900000, -3.200000, 0.600000>, <0.871159, -3.401889, 0.484635>, <0.900000, -3.512554, 0.140585>, <0.900000, -3.700000, 0.000000>, 
      <0.625308, -3.232317, 0.600000>, <0.596467, -3.434206, 0.484635>, <0.630000, -3.632554, 0.140585>, <0.630000, -3.820000, 0.000000>, 
      <0.254223, -3.400000, 0.708953>, <0.284720, -3.659228, 0.617461>, <0.279737, -3.869257, 0.179736>, <0.294715, -4.078949, 0.000000>, 
      <0.000000, -3.400000, 0.600000>, <0.030497, -3.659228, 0.508508>, <-0.014978, -3.890308, 0.179736>, <0.000000, -4.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.100000, -2.300000, 0.800000>, <1.083494, -2.580602, 0.766988>, <0.934837, -2.956139, 0.739349>, <0.900000, -3.200000, 0.600000>, 
      <0.711211, -2.361388, 0.759075>, <0.694705, -2.641990, 0.726063>, <0.660145, -2.988456, 0.739349>, <0.625308, -3.232317, 0.600000>, 
      <0.169437, -2.382408, 0.740738>, <0.137409, -2.686668, 0.740738>, <0.220489, -3.113260, 0.810155>, <0.254223, -3.400000, 0.708953>, 
      <-0.200000, -2.400000, 0.600000>, <-0.232027, -2.704260, 0.600000>, <-0.033734, -3.113260, 0.701202>, <0.000000, -3.400000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.100000, -2.300000, 0.800000>, <1.114106, -2.060198, 0.828212>, <1.031691, -1.737679, 0.831691>, <1.000000, -1.500000, 0.800000>, 
      <1.286410, -2.270567, 0.819622>, <1.300516, -2.030765, 0.847834>, <1.271691, -1.707679, 0.861691>, <1.240000, -1.470000, 0.830000>, 
      <1.511101, -2.112593, 0.787407>, <1.522824, -1.901582, 0.822575>, <1.545873, -1.641901, 0.898254>, <1.560000, -1.430000, 0.870000>, 
      <1.700000, -2.100000, 0.800000>, <1.711723, -1.888989, 0.835169>, <1.785873, -1.611901, 0.928253>, <1.800000, -1.400000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.100000, -2.300000, 0.800000>, <1.286410, -2.270567, 0.819622>, <1.511101, -2.112593, 0.787407>, <1.700000, -2.100000, 0.800000>, 
      <1.083494, -2.580602, 0.766988>, <1.269904, -2.551169, 0.786610>, <1.492748, -2.442944, 0.732348>, <1.681647, -2.430351, 0.744942>, 
      <0.934837, -2.956139, 0.739349>, <1.173194, -2.928097, 0.739349>, <1.418714, -2.910997, 0.765145>, <1.658714, -2.910997, 0.765145>, 
      <0.900000, -3.200000, 0.600000>, <1.138356, -3.171958, 0.600000>, <1.460000, -3.200000, 0.600000>, <1.700000, -3.200000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <2.700000, -0.500000, 0.600000>, <2.669920, -0.755681, 0.735360>, <2.516821, -1.114044, 0.849537>, <2.500000, -1.400000, 0.900000>, 
      <2.910000, -0.530000, 0.600000>, <2.879920, -0.785681, 0.735360>, <2.756821, -1.174044, 0.849537>, <2.740000, -1.460000, 0.900000>, 
      <3.192577, -0.555552, 0.600000>, <3.165139, -0.843653, 0.723472>, <3.077216, -1.230103, 0.848351>, <3.060000, -1.540000, 0.900000>, 
      <3.400000, -0.600000, 0.600000>, <3.372562, -0.888100, 0.723472>, <3.317216, -1.290103, 0.848351>, <3.300000, -1.600000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <2.700000, 0.300000, 0.000000>, <2.685019, 0.060299, 0.179776>, <2.731025, -0.236285, 0.460386>, <2.700000, -0.500000, 0.600000>, 
      <2.940000, 0.360000, 0.000000>, <2.925019, 0.120299, 0.179776>, <2.941025, -0.266285, 0.460386>, <2.910000, -0.530000, 0.600000>, 
      <3.263553, 0.572753, 0.000000>, <3.228839, 0.260324, 0.208286>, <3.225461, -0.210268, 0.452021>, <3.192577, -0.555552, 0.600000>, 
      <3.500000, 0.500000, 0.000000>, <3.465286, 0.187571, 0.208286>, <3.432884, -0.254716, 0.452021>, <3.400000, -0.600000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <2.800000, 1.100000, -0.600000>, <2.770000, 0.860000, -0.420000>, <2.715056, 0.540896, -0.180672>, <2.700000, 0.300000, 0.000000>, 
      <3.040000, 1.130000, -0.600000>, <3.010000, 0.890000, -0.420000>, <2.955056, 0.600896, -0.180672>, <2.940000, 0.360000, 0.000000>, 
      <3.364326, 1.254386, -0.600000>, <3.334326, 1.044386, -0.420000>, <3.289165, 0.803253, -0.153667>, <3.263553, 0.572753, 0.000000>, 
      <3.600000, 1.200000, -0.600000>, <3.570000, 0.990000, -0.420000>, <3.525611, 0.730501, -0.153667>, <3.500000, 0.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.300000, -1.600000, 0.000000>, <-0.630000, -1.600000, -0.180000>, <-1.070000, -1.600000, -0.420000>, <-1.400000, -1.600000, -0.600000>, 
      <-0.427823, -1.892167, 0.000000>, <-0.757823, -1.892167, -0.180000>, <-1.250000, -1.840000, -0.420000>, <-1.580000, -1.840000, -0.600000>, 
      <-0.960445, -2.083558, 0.000000>, <-1.251543, -2.083558, -0.194066>, <-1.520000, -2.160000, -0.420000>, <-1.820000, -2.160000, -0.600000>, 
      <-1.000000, -2.400000, 0.000000>, <-1.291099, -2.400000, -0.194066>, <-1.700000, -2.400000, -0.420000>, <-2.000000, -2.400000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.200000, -1.500000, 0.600000>, <-0.000749, -1.515442, 0.476462>, <-0.150000, -1.570000, 0.180000>, <-0.300000, -1.600000, 0.000000>, 
      <0.111870, -1.782016, 0.600000>, <-0.088879, -1.797458, 0.476462>, <-0.277823, -1.862167, 0.180000>, <-0.427823, -1.892167, 0.000000>, 
      <-0.169069, -2.106158, 0.600000>, <-0.449138, -2.119494, 0.493307>, <-0.710830, -2.083558, 0.166410>, <-0.960445, -2.083558, 0.000000>, 
      <-0.200000, -2.400000, 0.600000>, <-0.480069, -2.413337, 0.493307>, <-0.750385, -2.400000, 0.166410>, <-1.000000, -2.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.200000, -1.500000, 0.600000>, <0.111870, -1.782016, 0.600000>, <-0.169069, -2.106158, 0.600000>, <-0.200000, -2.400000, 0.600000>, 
      <0.410238, -1.483828, 0.729377>, <0.322108, -1.765844, 0.729377>, <0.200367, -2.088566, 0.740738>, <0.169437, -2.382408, 0.740738>, 
      <0.760000, -1.500000, 0.740000>, <0.791691, -1.737679, 0.771691>, <0.725317, -2.121586, 0.787287>, <0.711211, -2.361388, 0.759075>, 
      <1.000000, -1.500000, 0.800000>, <1.031691, -1.737679, 0.831691>, <1.114106, -2.060198, 0.828212>, <1.100000, -2.300000, 0.800000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.800000, -0.600000, 0.600000>, <1.786058, -0.823072, 0.725478>, <1.816901, -1.146481, 0.866197>, <1.800000, -1.400000, 0.900000>, 
      <2.067966, -0.555339, 0.600000>, <2.054024, -0.778411, 0.725478>, <2.026901, -1.146481, 0.866197>, <2.010000, -1.400000, 0.900000>, 
      <2.430000, -0.530000, 0.600000>, <2.399920, -0.785681, 0.735360>, <2.306821, -1.114044, 0.849537>, <2.290000, -1.400000, 0.900000>, 
      <2.700000, -0.500000, 0.600000>, <2.669920, -0.755681, 0.735360>, <2.516821, -1.114044, 0.849537>, <2.500000, -1.400000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.900000, 0.200000, 0.000000>, <1.916327, -0.028577, 0.195923>, <1.816399, -0.337612, 0.452407>, <1.800000, -0.600000, 0.600000>, 
      <2.134646, 0.258662, 0.000000>, <2.150973, 0.030084, 0.195923>, <2.084365, -0.292951, 0.452407>, <2.067966, -0.555339, 0.600000>, 
      <2.460000, 0.270000, 0.000000>, <2.445019, 0.030299, 0.179776>, <2.461025, -0.266285, 0.460386>, <2.430000, -0.530000, 0.600000>, 
      <2.700000, 0.300000, 0.000000>, <2.685019, 0.060299, 0.179776>, <2.731025, -0.236285, 0.460386>, <2.700000, -0.500000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.700000, 0.800000, -0.600000>, <1.760000, 0.620000, -0.420000>, <1.885837, 0.398280, -0.169954>, <1.900000, 0.200000, 0.000000>, 
      <2.037867, 0.853347, -0.600000>, <2.097867, 0.673347, -0.420000>, <2.120483, 0.456942, -0.169954>, <2.134646, 0.258662, 0.000000>, 
      <2.470000, 1.010000, -0.600000>, <2.440000, 0.770000, -0.420000>, <2.475056, 0.510896, -0.180672>, <2.460000, 0.270000, 0.000000>, 
      <2.800000, 1.100000, -0.600000>, <2.770000, 0.860000, -0.420000>, <2.715056, 0.540896, -0.180672>, <2.700000, 0.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.300000, -0.800000, 0.000000>, <-0.607097, -0.800000, -0.216775>, <-1.070000, -0.800000, -0.420000>, <-1.400000, -0.800000, -0.600000>, 
      <-0.336494, -1.037209, 0.000000>, <-0.643591, -1.037209, -0.216775>, <-1.055029, -1.039533, -0.420000>, <-1.385029, -1.039533, -0.600000>, 
      <-0.203804, -1.380122, 0.000000>, <-0.533803, -1.380122, -0.180000>, <-1.070000, -1.360000, -0.420000>, <-1.400000, -1.360000, -0.600000>, 
      <-0.300000, -1.600000, 0.000000>, <-0.630000, -1.600000, -0.180000>, <-1.070000, -1.600000, -0.420000>, <-1.400000, -1.600000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.100000, -0.300000, 0.000000>, <-0.541213, -0.275488, -0.147071>, <-1.080000, -0.090000, -0.420000>, <-1.500000, 0.000000, -0.600000>, 
      <-0.063178, -0.447287, 0.055233>, <-0.504392, -0.422775, -0.091839>, <-1.064913, -0.331397, -0.420000>, <-1.484913, -0.241397, -0.600000>, 
      <-0.275434, -0.640324, 0.000000>, <-0.582532, -0.640324, -0.216775>, <-1.085087, -0.558603, -0.420000>, <-1.415087, -0.558603, -0.600000>, 
      <-0.300000, -0.800000, 0.000000>, <-0.607097, -0.800000, -0.216775>, <-1.070000, -0.800000, -0.420000>, <-1.400000, -0.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.700000, 0.800000, -0.600000>, <-0.940000, 0.800000, -0.600000>, <-1.260000, 0.800000, -0.600000>, <-1.500000, 0.800000, -0.600000>, 
      <-0.520000, 0.470000, -0.420000>, <-0.760000, 0.470000, -0.420000>, <-1.260000, 0.560000, -0.600000>, <-1.500000, 0.560000, -0.600000>, 
      <-0.194991, 0.079966, -0.142487>, <-0.636205, 0.104478, -0.289558>, <-1.094971, 0.149533, -0.420000>, <-1.514971, 0.239533, -0.600000>, 
      <-0.100000, -0.300000, 0.000000>, <-0.541213, -0.275488, -0.147071>, <-1.080000, -0.090000, -0.420000>, <-1.500000, 0.000000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.300000, -0.100000, 0.000000>, <0.267164, 0.162690, -0.197017>, <0.160000, 0.530000, -0.420000>, <0.100000, 0.800000, -0.600000>, 
      <0.167661, -0.122056, 0.000000>, <0.134825, 0.140633, -0.197017>, <-0.080000, 0.530000, -0.420000>, <-0.140000, 0.800000, -0.600000>, 
      <0.027103, -0.307061, 0.042368>, <-0.067889, 0.072905, -0.100120>, <-0.280000, 0.470000, -0.420000>, <-0.460000, 0.800000, -0.600000>, 
      <-0.100000, -0.300000, 0.000000>, <-0.194991, 0.079966, -0.142487>, <-0.520000, 0.470000, -0.420000>, <-0.700000, 0.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.300000, -0.800000, 0.600000>, <0.072316, -0.800000, 0.486158>, <-0.092034, -0.800000, 0.146800>, <-0.300000, -0.800000, 0.000000>, 
      <0.286103, -0.994561, 0.683383>, <0.058419, -0.994561, 0.569541>, <-0.128528, -1.037209, 0.146800>, <-0.336494, -1.037209, 0.000000>, 
      <0.263274, -1.297524, 0.600000>, <0.062525, -1.312966, 0.476462>, <-0.053803, -1.350122, 0.180000>, <-0.203804, -1.380122, 0.000000>, 
      <0.200000, -1.500000, 0.600000>, <-0.000749, -1.515442, 0.476462>, <-0.150000, -1.570000, 0.180000>, <-0.300000, -1.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.300000, -0.800000, 0.600000>, <0.318120, -0.546323, 0.491281>, <0.327521, -0.320171, 0.165128>, <0.300000, -0.100000, 0.000000>, 
      <0.072316, -0.800000, 0.486158>, <0.090436, -0.546323, 0.377439>, <0.195183, -0.342227, 0.165128>, <0.167661, -0.122056, 0.000000>, 
      <-0.092034, -0.800000, 0.146800>, <-0.067468, -0.640324, 0.146800>, <0.063925, -0.454348, 0.097600>, <0.027103, -0.307061, 0.042368>, 
      <-0.300000, -0.800000, 0.000000>, <-0.275434, -0.640324, 0.000000>, <-0.063178, -0.447287, 0.055233>, <-0.100000, -0.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.900000, -0.800000, 0.600000>, <0.886354, -0.991041, 0.709166>, <0.971115, -1.283364, 0.771115>, <1.000000, -1.500000, 0.800000>, 
      <1.174160, -0.763445, 0.600000>, <1.160514, -0.954486, 0.709166>, <1.211115, -1.253364, 0.801115>, <1.240000, -1.470000, 0.830000>, 
      <1.527177, -0.645471, 0.600000>, <1.513235, -0.868542, 0.725478>, <1.576901, -1.176481, 0.836198>, <1.560000, -1.430000, 0.870000>, 
      <1.800000, -0.600000, 0.600000>, <1.786058, -0.823072, 0.725478>, <1.816901, -1.146481, 0.866197>, <1.800000, -1.400000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.900000, -0.800000, 0.600000>, <0.721579, -0.823789, 0.600000>, <0.460997, -0.800000, 0.680499>, <0.300000, -0.800000, 0.600000>, 
      <0.886354, -0.991041, 0.709166>, <0.707933, -1.014830, 0.709166>, <0.447100, -0.994561, 0.763882>, <0.286103, -0.994561, 0.683383>, 
      <0.971115, -1.283364, 0.771115>, <0.731115, -1.283364, 0.711115>, <0.473512, -1.281352, 0.729377>, <0.263274, -1.297524, 0.600000>, 
      <1.000000, -1.500000, 0.800000>, <0.760000, -1.500000, 0.740000>, <0.410238, -1.483828, 0.729377>, <0.200000, -1.500000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.100000, -0.100000, 0.000000>, <1.100000, -0.326416, 0.169812>, <0.917519, -0.554742, 0.459852>, <0.900000, -0.800000, 0.600000>, 
      <1.351930, -0.052763, 0.000000>, <1.351930, -0.279179, 0.169812>, <1.191679, -0.518187, 0.459852>, <1.174160, -0.763445, 0.600000>, 
      <1.651333, 0.137833, 0.000000>, <1.667660, -0.090744, 0.195923>, <1.543576, -0.383083, 0.452407>, <1.527177, -0.645471, 0.600000>, 
      <1.900000, 0.200000, 0.000000>, <1.916327, -0.028577, 0.195923>, <1.816399, -0.337612, 0.452407>, <1.800000, -0.600000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.100000, -0.100000, 0.000000>, <0.864111, -0.144229, 0.000000>, <0.536735, -0.060544, 0.000000>, <0.300000, -0.100000, 0.000000>, 
      <1.100000, -0.326416, 0.169812>, <0.864111, -0.370645, 0.169812>, <0.564256, -0.280715, 0.165128>, <0.327521, -0.320171, 0.165128>, 
      <0.917519, -0.554742, 0.459852>, <0.739097, -0.578531, 0.459852>, <0.479117, -0.546323, 0.571780>, <0.318120, -0.546323, 0.491281>, 
      <0.900000, -0.800000, 0.600000>, <0.721579, -0.823789, 0.600000>, <0.460997, -0.800000, 0.680499>, <0.300000, -0.800000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.900000, 0.800000, -0.600000>, <0.960000, 0.530000, -0.420000>, <1.100000, 0.164000, -0.198000>, <1.100000, -0.100000, 0.000000>, 
      <1.140000, 0.800000, -0.600000>, <1.200000, 0.530000, -0.420000>, <1.351930, 0.211237, -0.198000>, <1.351930, -0.052763, 0.000000>, 
      <1.462937, 0.762569, -0.600000>, <1.522937, 0.582569, -0.420000>, <1.637170, 0.336113, -0.169954>, <1.651333, 0.137833, 0.000000>, 
      <1.700000, 0.800000, -0.600000>, <1.760000, 0.620000, -0.420000>, <1.885837, 0.398280, -0.169954>, <1.900000, 0.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.900000, 0.800000, -0.600000>, <0.660000, 0.800000, -0.600000>, <0.340000, 0.800000, -0.600000>, <0.100000, 0.800000, -0.600000>, 
      <0.960000, 0.530000, -0.420000>, <0.720000, 0.530000, -0.420000>, <0.400000, 0.530000, -0.420000>, <0.160000, 0.530000, -0.420000>, 
      <1.100000, 0.164000, -0.198000>, <0.864111, 0.119771, -0.198000>, <0.503898, 0.202146, -0.197017>, <0.267164, 0.162690, -0.197017>, 
      <1.100000, -0.100000, 0.000000>, <0.864111, -0.144229, 0.000000>, <0.536735, -0.060544, 0.000000>, <0.300000, -0.100000, 0.000000>
    }
  }
  material {
    RoughStone
  }
  scale 8.0
  rotate -97.441826*z
  translate  <156.887462, -43.2793, 0.0>
}


union { // sPatchObj2
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <5.500000, -3.500000, 0.000000>, <5.525337, -3.905397, -0.152024>, <5.640000, -4.410000, -0.420000>, <5.700000, -4.800000, -0.600000>, 
      <5.854087, -3.562486, -0.124972>, <5.879424, -3.967883, -0.276996>, <5.880000, -4.410000, -0.420000>, <5.940000, -4.800000, -0.600000>, 
      <6.200000, -3.850000, -0.420000>, <6.200000, -4.090000, -0.420000>, <6.260000, -4.560000, -0.600000>, <6.260000, -4.800000, -0.600000>, 
      <6.500000, -4.000000, -0.600000>, <6.500000, -4.240000, -0.600000>, <6.500000, -4.560000, -0.600000>, <6.500000, -4.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <5.600000, -3.200000, 0.000000>, <5.583029, -3.293338, 0.000000>, <5.494458, -3.411324, 0.033254>, <5.500000, -3.500000, 0.000000>, 
      <5.859600, -3.200000, -0.194700>, <5.842629, -3.293338, -0.194700>, <5.848544, -3.473810, -0.091718>, <5.854087, -3.562486, -0.124972>, 
      <6.230000, -3.200000, -0.420000>, <6.230000, -3.440000, -0.420000>, <6.200000, -3.610000, -0.420000>, <6.200000, -3.850000, -0.420000>, 
      <6.500000, -3.200000, -0.600000>, <6.500000, -3.440000, -0.600000>, <6.500000, -3.760000, -0.600000>, <6.500000, -4.000000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <5.700000, -2.400000, 0.000000>, <5.716088, -2.641332, 0.000000>, <5.643267, -2.962034, 0.000000>, <5.600000, -3.200000, 0.000000>, 
      <5.940000, -2.400000, -0.180000>, <5.956088, -2.641332, -0.180000>, <5.902866, -2.962034, -0.194700>, <5.859600, -3.200000, -0.194700>, 
      <6.260000, -2.400000, -0.420000>, <6.260000, -2.640000, -0.420000>, <6.230000, -2.960000, -0.420000>, <6.230000, -3.200000, -0.420000>, 
      <6.500000, -2.400000, -0.600000>, <6.500000, -2.640000, -0.600000>, <6.500000, -2.960000, -0.600000>, <6.500000, -3.200000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.100000, -3.200000, 0.600000>, <3.860000, -3.200000, 0.600000>, <3.540000, -3.200000, 0.600000>, <3.300000, -3.200000, 0.600000>, 
      <4.112721, -2.971023, 0.714489>, <3.872721, -2.971023, 0.714489>, <3.540000, -2.976598, 0.725664>, <3.300000, -2.976598, 0.725664>, 
      <4.100000, -2.651930, 0.852763>, <3.864110, -2.651930, 0.896992>, <3.537894, -2.683649, 0.852763>, <3.300000, -2.651930, 0.852763>, 
      <4.100000, -2.400000, 0.900000>, <3.864110, -2.400000, 0.944229>, <3.537894, -2.431719, 0.900000>, <3.300000, -2.400000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.000000, -4.200000, 0.000000>, <3.785838, -4.242833, 0.000000>, <3.502782, -4.081113, 0.000000>, <3.300000, -4.000000, 0.000000>, 
      <4.000000, -4.501101, -0.180661>, <3.785838, -4.543933, -0.180661>, <3.502782, -4.321113, -0.180000>, <3.300000, -4.240000, -0.180000>, 
      <4.070000, -4.900000, -0.420000>, <3.806268, -4.949450, -0.420000>, <3.540000, -4.680000, -0.420000>, <3.300000, -4.560000, -0.420000>, 
      <4.100000, -5.200000, -0.600000>, <3.836268, -5.249450, -0.600000>, <3.540000, -4.920000, -0.600000>, <3.300000, -4.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.000000, -4.200000, 0.000000>, <3.785838, -4.242833, 0.000000>, <3.502782, -4.081113, 0.000000>, <3.300000, -4.000000, 0.000000>, 
      <4.000000, -3.898899, 0.180661>, <3.785838, -3.941732, 0.180661>, <3.502782, -3.841113, 0.180000>, <3.300000, -3.760000, 0.180000>, 
      <4.082573, -3.513683, 0.443159>, <3.842573, -3.513683, 0.443159>, <3.540000, -3.461473, 0.452922>, <3.300000, -3.461473, 0.452922>, 
      <4.100000, -3.200000, 0.600000>, <3.860000, -3.200000, 0.600000>, <3.540000, -3.200000, 0.600000>, <3.300000, -3.200000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.800000, -3.700000, 0.000000>, <4.800000, -3.921540, -0.204499>, <4.870000, -4.260000, -0.420000>, <4.900000, -4.500000, -0.600000>, 
      <4.997913, -3.607640, 0.000000>, <4.997913, -3.829181, -0.204499>, <5.110000, -4.350000, -0.420000>, <5.140000, -4.590000, -0.600000>, 
      <5.296842, -3.464148, 0.071703>, <5.322179, -3.869546, -0.080321>, <5.400000, -4.320000, -0.420000>, <5.460000, -4.710000, -0.600000>, 
      <5.500000, -3.500000, 0.000000>, <5.525337, -3.905397, -0.152024>, <5.640000, -4.410000, -0.420000>, <5.700000, -4.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.800000, -3.700000, 0.000000>, <4.543533, -3.819685, 0.000000>, <4.277524, -4.144496, 0.000000>, <4.000000, -4.200000, 0.000000>, 
      <4.800000, -3.921540, -0.204499>, <4.543533, -4.041226, -0.204499>, <4.277524, -4.445596, -0.180661>, <4.000000, -4.501101, -0.180661>, 
      <4.870000, -4.260000, -0.420000>, <4.630000, -4.470000, -0.420000>, <4.383442, -4.841230, -0.420000>, <4.070000, -4.900000, -0.420000>, 
      <4.900000, -4.500000, -0.600000>, <4.660000, -4.710000, -0.600000>, <4.413442, -5.141230, -0.600000>, <4.100000, -5.200000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.900000, -3.200000, 0.600000>, <4.883542, -3.413957, 0.501251>, <4.800000, -3.526425, 0.160223>, <4.800000, -3.700000, 0.000000>, 
      <5.156804, -3.200000, 0.497279>, <5.140346, -3.413957, 0.398529>, <4.997913, -3.434065, 0.160223>, <4.997913, -3.607640, 0.000000>, 
      <5.378731, -3.200000, 0.165952>, <5.361760, -3.293338, 0.165952>, <5.291299, -3.375472, 0.104957>, <5.296842, -3.464148, 0.071703>, 
      <5.600000, -3.200000, 0.000000>, <5.583029, -3.293338, 0.000000>, <5.494458, -3.411324, 0.033254>, <5.500000, -3.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.900000, -3.200000, 0.600000>, <4.677166, -3.200000, 0.689134>, <4.340000, -3.200000, 0.600000>, <4.100000, -3.200000, 0.600000>, 
      <4.883542, -3.413957, 0.501251>, <4.660708, -3.413957, 0.590384>, <4.322573, -3.513683, 0.443159>, <4.082573, -3.513683, 0.443159>, 
      <4.800000, -3.526425, 0.160223>, <4.543533, -3.646110, 0.160223>, <4.277524, -3.843394, 0.180661>, <4.000000, -3.898899, 0.180661>, 
      <4.800000, -3.700000, 0.000000>, <4.543533, -3.819685, 0.000000>, <4.277524, -4.144496, 0.000000>, <4.000000, -4.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.900000, -2.400000, 0.600000>, <4.900000, -2.640000, 0.600000>, <4.916722, -2.982619, 0.700330>, <4.900000, -3.200000, 0.600000>, 
      <5.161472, -2.400000, 0.452922>, <5.161472, -2.640000, 0.452922>, <5.173526, -2.982619, 0.597608>, <5.156804, -3.200000, 0.497279>, 
      <5.460000, -2.400000, 0.180000>, <5.476088, -2.641332, 0.180000>, <5.421998, -2.962034, 0.165952>, <5.378731, -3.200000, 0.165952>, 
      <5.700000, -2.400000, 0.000000>, <5.716088, -2.641332, 0.000000>, <5.643267, -2.962034, 0.000000>, <5.600000, -3.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.900000, -2.400000, 0.600000>, <4.676598, -2.400000, 0.725664>, <4.351930, -2.400000, 0.852763>, <4.100000, -2.400000, 0.900000>, 
      <4.900000, -2.640000, 0.600000>, <4.676598, -2.640000, 0.725664>, <4.351930, -2.651930, 0.805526>, <4.100000, -2.651930, 0.852763>, 
      <4.916722, -2.982619, 0.700330>, <4.693887, -2.982619, 0.789463>, <4.352721, -2.971023, 0.714489>, <4.112721, -2.971023, 0.714489>, 
      <4.900000, -3.200000, 0.600000>, <4.677166, -3.200000, 0.689134>, <4.340000, -3.200000, 0.600000>, <4.100000, -3.200000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <6.500000, -1.600000, -0.600000>, <6.200000, -1.630000, -0.420000>, <5.800000, -1.670000, -0.180000>, <5.500000, -1.700000, 0.000000>, 
      <6.500000, -1.840000, -0.600000>, <6.200000, -1.870000, -0.420000>, <5.814528, -1.887920, -0.180000>, <5.514528, -1.917920, 0.000000>, 
      <6.500000, -2.160000, -0.600000>, <6.260000, -2.160000, -0.420000>, <5.925472, -2.182081, -0.180000>, <5.685472, -2.182081, 0.000000>, 
      <6.500000, -2.400000, -0.600000>, <6.260000, -2.400000, -0.420000>, <5.940000, -2.400000, -0.180000>, <5.700000, -2.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.100000, -1.600000, 0.900000>, <3.860000, -1.600000, 0.900000>, <3.540000, -1.600000, 0.900000>, <3.300000, -1.600000, 0.900000>, 
      <4.100000, -1.835889, 0.944229>, <3.860000, -1.835889, 0.944229>, <3.526868, -1.836380, 0.939397>, <3.286868, -1.836380, 0.939397>, 
      <4.100000, -2.164111, 0.944229>, <3.864110, -2.164111, 0.988459>, <3.537894, -2.195830, 0.944229>, <3.300000, -2.164111, 0.944229>, 
      <4.100000, -2.400000, 0.900000>, <3.864110, -2.400000, 0.944229>, <3.537894, -2.431719, 0.900000>, <3.300000, -2.400000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.900000, -1.600000, 0.600000>, <4.917100, -1.839390, 0.600000>, <4.900000, -2.160000, 0.600000>, <4.900000, -2.400000, 0.600000>, 
      <5.080000, -1.630000, 0.420000>, <5.097099, -1.869390, 0.420000>, <5.161472, -2.160000, 0.452922>, <5.161472, -2.400000, 0.452922>, 
      <5.320000, -1.670000, 0.180000>, <5.334528, -1.887920, 0.180000>, <5.445472, -2.182081, 0.180000>, <5.460000, -2.400000, 0.180000>, 
      <5.500000, -1.700000, 0.000000>, <5.514528, -1.917920, 0.000000>, <5.685472, -2.182081, 0.000000>, <5.700000, -2.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.900000, -1.600000, 0.600000>, <4.660000, -1.600000, 0.690000>, <4.340000, -1.600000, 0.810000>, <4.100000, -1.600000, 0.900000>, 
      <4.917100, -1.839390, 0.600000>, <4.677099, -1.839390, 0.690000>, <4.340000, -1.835889, 0.854229>, <4.100000, -1.835889, 0.944229>, 
      <4.900000, -2.160000, 0.600000>, <4.676598, -2.160000, 0.725664>, <4.351930, -2.164111, 0.896992>, <4.100000, -2.164111, 0.944229>, 
      <4.900000, -2.400000, 0.600000>, <4.676598, -2.400000, 0.725664>, <4.351930, -2.400000, 0.852763>, <4.100000, -2.400000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <5.600000, -0.900000, 0.000000>, <5.618550, -1.141155, 0.000000>, <5.483912, -1.458668, 0.000000>, <5.500000, -1.700000, 0.000000>, 
      <5.865015, -0.868822, -0.187070>, <5.883566, -1.109977, -0.187070>, <5.783912, -1.428668, -0.180000>, <5.800000, -1.670000, -0.180000>, 
      <6.230000, -0.830000, -0.420000>, <6.230000, -1.070000, -0.420000>, <6.200000, -1.390000, -0.420000>, <6.200000, -1.630000, -0.420000>, 
      <6.500000, -0.800000, -0.600000>, <6.500000, -1.040000, -0.600000>, <6.500000, -1.360000, -0.600000>, <6.500000, -1.600000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <5.600000, -0.900000, 0.000000>, <5.865015, -0.868822, -0.187070>, <6.230000, -0.830000, -0.420000>, <6.500000, -0.800000, -0.600000>, 
      <5.587609, -0.738921, 0.000000>, <5.852624, -0.707743, -0.187070>, <6.230000, -0.590000, -0.420000>, <6.500000, -0.560000, -0.600000>, 
      <5.391052, -0.552111, 0.053686>, <5.749610, -0.446653, -0.072864>, <6.170000, -0.360000, -0.420000>, <6.500000, -0.240000, -0.600000>, 
      <5.400000, -0.400000, 0.000000>, <5.758558, -0.294542, -0.126550>, <6.170000, -0.120000, -0.420000>, <6.500000, 0.000000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <5.700000, 0.800000, -0.600000>, <5.610000, 0.440000, -0.420000>, <5.422842, -0.011678, -0.137055>, <5.400000, -0.400000, 0.000000>, 
      <5.933701, 0.737680, -0.600000>, <5.843701, 0.377680, -0.420000>, <5.781400, 0.093780, -0.263605>, <5.758558, -0.294542, -0.126550>, 
      <6.190000, 0.520000, -0.600000>, <6.220000, 0.400000, -0.600000>, <6.140000, 0.000000, -0.420000>, <6.170000, -0.120000, -0.420000>, 
      <6.400000, 0.400000, -0.600000>, <6.430000, 0.280000, -0.600000>, <6.470000, 0.120000, -0.600000>, <6.500000, 0.000000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.000000, -0.100000, 0.000000>, <4.000000, 0.160707, -0.195530>, <4.070000, 0.530000, -0.420000>, <4.100000, 0.800000, -0.600000>, 
      <3.814282, 0.042860, 0.000000>, <3.814282, 0.303567, -0.195530>, <3.886401, 0.586492, -0.420000>, <3.916401, 0.856492, -0.600000>, 
      <3.723946, 0.431094, 0.000000>, <3.749557, 0.661594, -0.153667>, <3.757174, 0.946806, -0.420000>, <3.787174, 1.156806, -0.600000>, 
      <3.500000, 0.500000, 0.000000>, <3.525611, 0.730501, -0.153667>, <3.570000, 0.990000, -0.420000>, <3.600000, 1.200000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.100000, -0.800000, 0.600000>, <3.890000, -0.740000, 0.600000>, <3.613556, -0.645762, 0.600000>, <3.400000, -0.600000, 0.600000>, 
      <4.114629, -1.019435, 0.731661>, <3.904629, -0.959434, 0.731661>, <3.586117, -0.933862, 0.723472>, <3.372562, -0.888100, 0.723472>, 
      <4.100000, -1.348070, 0.852763>, <3.860000, -1.348070, 0.852763>, <3.557216, -1.290103, 0.848351>, <3.317216, -1.290103, 0.848351>, 
      <4.100000, -1.600000, 0.900000>, <3.860000, -1.600000, 0.900000>, <3.540000, -1.600000, 0.900000>, <3.300000, -1.600000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.100000, -0.800000, 0.600000>, <4.084122, -0.561827, 0.457096>, <4.000000, -0.322567, 0.166925>, <4.000000, -0.100000, 0.000000>, 
      <3.890000, -0.740000, 0.600000>, <3.874122, -0.501827, 0.457096>, <3.814282, -0.179707, 0.166925>, <3.814282, 0.042860, 0.000000>, 
      <3.613556, -0.645762, 0.600000>, <3.646440, -0.300478, 0.452021>, <3.689232, 0.118665, 0.208286>, <3.723946, 0.431094, 0.000000>, 
      <3.400000, -0.600000, 0.600000>, <3.432884, -0.254716, 0.452021>, <3.465286, 0.187571, 0.208286>, <3.500000, 0.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.800000, -1.000000, 0.600000>, <4.814518, -1.159693, 0.687105>, <4.886999, -1.417981, 0.600000>, <4.900000, -1.600000, 0.600000>, 
      <5.079398, -1.018627, 0.488241>, <5.093915, -1.178320, 0.575346>, <5.066998, -1.447981, 0.420000>, <5.080000, -1.630000, 0.420000>, 
      <5.354817, -0.928845, 0.173070>, <5.373367, -1.170000, 0.173070>, <5.303912, -1.428668, 0.180000>, <5.320000, -1.670000, 0.180000>, 
      <5.600000, -0.900000, 0.000000>, <5.618550, -1.141155, 0.000000>, <5.483912, -1.458668, 0.000000>, <5.500000, -1.700000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.800000, -1.000000, 0.600000>, <4.597605, -0.986507, 0.680958>, <4.310000, -0.860000, 0.600000>, <4.100000, -0.800000, 0.600000>, 
      <4.814518, -1.159693, 0.687105>, <4.612122, -1.146200, 0.768063>, <4.324629, -1.079435, 0.731661>, <4.114629, -1.019435, 0.731661>, 
      <4.886999, -1.417981, 0.600000>, <4.646998, -1.417981, 0.690000>, <4.340000, -1.348070, 0.762763>, <4.100000, -1.348070, 0.852763>, 
      <4.900000, -1.600000, 0.600000>, <4.660000, -1.600000, 0.690000>, <4.340000, -1.600000, 0.810000>, <4.100000, -1.600000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.800000, -0.500000, 0.000000>, <4.789181, -0.694748, 0.129832>, <4.781360, -0.794954, 0.488157>, <4.800000, -1.000000, 0.600000>, 
      <4.978432, -0.538235, 0.000000>, <4.967613, -0.732983, 0.129832>, <5.060757, -0.813581, 0.376398>, <5.079398, -1.018627, 0.488241>, 
      <5.234180, -0.448771, 0.058525>, <5.225232, -0.600881, 0.112211>, <5.342426, -0.767766, 0.173070>, <5.354817, -0.928845, 0.173070>, 
      <5.400000, -0.400000, 0.000000>, <5.391052, -0.552111, 0.053686>, <5.587609, -0.738921, 0.000000>, <5.600000, -0.900000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.800000, -0.500000, 0.000000>, <4.537628, -0.443777, 0.000000>, <4.212683, -0.263603, 0.000000>, <4.000000, -0.100000, 0.000000>, 
      <4.789181, -0.694748, 0.129832>, <4.526809, -0.638525, 0.129832>, <4.212683, -0.486169, 0.166925>, <4.000000, -0.322567, 0.166925>, 
      <4.781360, -0.794954, 0.488157>, <4.578965, -0.781461, 0.569115>, <4.294122, -0.621827, 0.457096>, <4.084122, -0.561827, 0.457096>, 
      <4.800000, -1.000000, 0.600000>, <4.597605, -0.986507, 0.680958>, <4.310000, -0.860000, 0.600000>, <4.100000, -0.800000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.900000, 0.800000, -0.600000>, <4.870000, 0.410000, -0.420000>, <4.819882, -0.142117, -0.238589>, <4.800000, -0.500000, 0.000000>, 
      <5.140000, 0.800000, -0.600000>, <5.110000, 0.410000, -0.420000>, <4.998314, -0.180353, -0.238589>, <4.978432, -0.538235, 0.000000>, 
      <5.468104, 0.861839, -0.600000>, <5.378103, 0.501839, -0.420000>, <5.257022, -0.060448, -0.078530>, <5.234180, -0.448771, 0.058525>, 
      <5.700000, 0.800000, -0.600000>, <5.610000, 0.440000, -0.420000>, <5.422842, -0.011678, -0.137055>, <5.400000, -0.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.900000, 0.800000, -0.600000>, <4.660000, 0.800000, -0.600000>, <4.329387, 0.729419, -0.600000>, <4.100000, 0.800000, -0.600000>, 
      <4.870000, 0.410000, -0.420000>, <4.630000, 0.410000, -0.420000>, <4.299386, 0.459419, -0.420000>, <4.070000, 0.530000, -0.420000>, 
      <4.819882, -0.142117, -0.238589>, <4.557510, -0.085894, -0.238589>, <4.212683, -0.002896, -0.195530>, <4.000000, 0.160707, -0.195530>, 
      <4.800000, -0.500000, 0.000000>, <4.537628, -0.443777, 0.000000>, <4.212683, -0.263603, 0.000000>, <4.000000, -0.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <2.500000, -3.600000, 0.000000>, <2.740000, -3.720000, 0.000000>, <3.050864, -3.900346, 0.000000>, <3.300000, -4.000000, 0.000000>, 
      <2.500000, -3.921994, -0.241495>, <2.740000, -4.041994, -0.241495>, <3.050864, -4.140346, -0.180000>, <3.300000, -4.240000, -0.180000>, 
      <2.500000, -4.440000, -0.420000>, <2.740000, -4.440000, -0.420000>, <3.060000, -4.560000, -0.420000>, <3.300000, -4.560000, -0.420000>, 
      <2.500000, -4.800000, -0.600000>, <2.740000, -4.800000, -0.600000>, <3.060000, -4.800000, -0.600000>, <3.300000, -4.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <2.500000, -3.200000, 0.600000>, <2.740000, -3.200000, 0.600000>, <3.060000, -3.200000, 0.600000>, <3.300000, -3.200000, 0.600000>, 
      <2.487025, -3.381647, 0.483227>, <2.727025, -3.381647, 0.483227>, <3.060000, -3.461473, 0.452922>, <3.300000, -3.461473, 0.452922>, 
      <2.500000, -3.426934, 0.129800>, <2.740000, -3.546934, 0.129800>, <3.050864, -3.660346, 0.180000>, <3.300000, -3.760000, 0.180000>, 
      <2.500000, -3.600000, 0.000000>, <2.740000, -3.720000, 0.000000>, <3.050864, -3.900346, 0.000000>, <3.300000, -4.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <2.600000, -2.200000, 0.900000>, <2.600000, -1.961423, 0.939763>, <2.486012, -1.637789, 0.941963>, <2.500000, -1.400000, 0.900000>, 
      <2.810000, -2.260000, 0.900000>, <2.810000, -2.021423, 0.939763>, <2.726012, -1.697789, 0.941963>, <2.740000, -1.460000, 0.900000>, 
      <3.083512, -2.371135, 0.900000>, <3.083512, -2.135246, 0.944229>, <3.046868, -1.776380, 0.939397>, <3.060000, -1.540000, 0.900000>, 
      <3.300000, -2.400000, 0.900000>, <3.300000, -2.164111, 0.944229>, <3.286868, -1.836380, 0.939397>, <3.300000, -1.600000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <2.600000, -2.200000, 0.900000>, <2.810000, -2.260000, 0.900000>, <3.083512, -2.371135, 0.900000>, <3.300000, -2.400000, 0.900000>, 
      <2.600000, -2.510362, 0.848273>, <2.810000, -2.570362, 0.848273>, <3.083512, -2.623065, 0.852763>, <3.300000, -2.651930, 0.852763>, 
      <2.518871, -2.935806, 0.769839>, <2.758871, -2.935806, 0.769839>, <3.060000, -2.976598, 0.725664>, <3.300000, -2.976598, 0.725664>, 
      <2.500000, -3.200000, 0.600000>, <2.740000, -3.200000, 0.600000>, <3.060000, -3.200000, 0.600000>, <3.300000, -3.200000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.700000, -4.800000, -0.600000>, <1.760000, -4.410000, -0.420000>, <1.900000, -3.846964, -0.260223>, <1.900000, -3.500000, 0.000000>, 
      <1.940000, -4.800000, -0.600000>, <2.000000, -4.410000, -0.420000>, <2.080000, -3.876964, -0.260223>, <2.080000, -3.530000, 0.000000>, 
      <2.260000, -4.800000, -0.600000>, <2.260000, -4.440000, -0.420000>, <2.320000, -3.891994, -0.241495>, <2.320000, -3.570000, 0.000000>, 
      <2.500000, -4.800000, -0.600000>, <2.500000, -4.440000, -0.420000>, <2.500000, -3.921994, -0.241495>, <2.500000, -3.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.700000, -3.200000, 0.600000>, <1.940000, -3.200000, 0.600000>, <2.260000, -3.200000, 0.600000>, <2.500000, -3.200000, 0.600000>, 
      <1.725849, -3.380944, 0.496603>, <1.965849, -3.380944, 0.496603>, <2.247025, -3.381647, 0.483227>, <2.487025, -3.381647, 0.483227>, 
      <1.900000, -3.332000, 0.126000>, <2.080000, -3.362000, 0.126000>, <2.320000, -3.396934, 0.129800>, <2.500000, -3.426934, 0.129800>, 
      <1.900000, -3.500000, 0.000000>, <2.080000, -3.530000, 0.000000>, <2.320000, -3.570000, 0.000000>, <2.500000, -3.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.700000, -2.100000, 0.800000>, <1.972106, -2.081860, 0.818141>, <2.330000, -2.170000, 0.870000>, <2.600000, -2.200000, 0.900000>, 
      <1.681647, -2.430351, 0.744942>, <1.953754, -2.412211, 0.763082>, <2.330000, -2.480362, 0.818273>, <2.600000, -2.510362, 0.848273>, 
      <1.658714, -2.910997, 0.765145>, <1.898714, -2.910997, 0.765145>, <2.278871, -2.935806, 0.769839>, <2.518871, -2.935806, 0.769839>, 
      <1.700000, -3.200000, 0.600000>, <1.940000, -3.200000, 0.600000>, <2.260000, -3.200000, 0.600000>, <2.500000, -3.200000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.700000, -2.100000, 0.800000>, <1.711723, -1.888989, 0.835169>, <1.785873, -1.611901, 0.928253>, <1.800000, -1.400000, 0.900000>, 
      <1.972106, -2.081860, 0.818141>, <1.983829, -1.870849, 0.853309>, <1.995873, -1.611901, 0.928253>, <2.010000, -1.400000, 0.900000>, 
      <2.330000, -2.170000, 0.870000>, <2.330000, -1.931423, 0.909763>, <2.276012, -1.637789, 0.941963>, <2.290000, -1.400000, 0.900000>, 
      <2.600000, -2.200000, 0.900000>, <2.600000, -1.961423, 0.939763>, <2.486012, -1.637789, 0.941963>, <2.500000, -1.400000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.500000, -3.800000, 0.000000>, <-0.541264, -4.130111, -0.123792>, <-0.640000, -4.500000, -0.420000>, <-0.700000, -4.800000, -0.600000>, 
      <-0.828947, -3.778070, -0.131579>, <-0.870211, -4.108181, -0.255370>, <-0.880000, -4.500000, -0.420000>, <-0.940000, -4.800000, -0.600000>, 
      <-1.200000, -3.940000, -0.420000>, <-1.200000, -4.180000, -0.420000>, <-1.260000, -4.560000, -0.600000>, <-1.260000, -4.800000, -0.600000>, 
      <-1.500000, -4.000000, -0.600000>, <-1.500000, -4.240000, -0.600000>, <-1.500000, -4.560000, -0.600000>, <-1.500000, -4.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.500000, -3.200000, 0.000000>, <-0.439460, -3.369514, 0.000000>, <-0.479075, -3.632604, 0.062774>, <-0.500000, -3.800000, 0.000000>, 
      <-0.771724, -3.163770, -0.217379>, <-0.711183, -3.333284, -0.217379>, <-0.808022, -3.610674, -0.068805>, <-0.828947, -3.778070, -0.131579>, 
      <-1.200000, -3.200000, -0.420000>, <-1.128414, -3.429075, -0.420000>, <-1.200000, -3.700000, -0.420000>, <-1.200000, -3.940000, -0.420000>, 
      <-1.500000, -3.200000, -0.600000>, <-1.428414, -3.429075, -0.600000>, <-1.500000, -3.760000, -0.600000>, <-1.500000, -4.000000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-1.000000, -2.400000, 0.000000>, <-1.291099, -2.400000, -0.194066>, <-1.700000, -2.400000, -0.420000>, <-2.000000, -2.400000, -0.600000>, 
      <-1.035104, -2.680834, 0.000000>, <-1.326203, -2.680834, -0.194066>, <-1.550000, -2.640000, -0.420000>, <-1.850000, -2.640000, -0.600000>, 
      <-0.595190, -2.933469, 0.000000>, <-0.866914, -2.897239, -0.217379>, <-1.284418, -2.929864, -0.420000>, <-1.584418, -2.929864, -0.600000>, 
      <-0.500000, -3.200000, 0.000000>, <-0.771724, -3.163770, -0.217379>, <-1.200000, -3.200000, -0.420000>, <-1.500000, -3.200000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.000000, -3.400000, 0.600000>, <-0.222312, -3.400000, 0.504724>, <-0.312149, -3.225047, 0.150281>, <-0.500000, -3.200000, 0.000000>, 
      <-0.033734, -3.113260, 0.701202>, <-0.256046, -3.113260, 0.605926>, <-0.407338, -2.958516, 0.150281>, <-0.595190, -2.933469, 0.000000>, 
      <-0.232027, -2.704260, 0.600000>, <-0.512096, -2.717597, 0.493307>, <-0.785489, -2.680834, 0.166410>, <-1.035104, -2.680834, 0.000000>, 
      <-0.200000, -2.400000, 0.600000>, <-0.480069, -2.413337, 0.493307>, <-0.750385, -2.400000, 0.166410>, <-1.000000, -2.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.000000, -4.100000, 0.000000>, <0.015066, -4.310922, -0.180790>, <0.070000, -4.590000, -0.420000>, <0.100000, -4.800000, -0.600000>, 
      <-0.174484, -4.112463, 0.000000>, <-0.159418, -4.323385, -0.180790>, <-0.170000, -4.590000, -0.420000>, <-0.140000, -4.800000, -0.600000>, 
      <-0.337893, -3.810807, 0.064843>, <-0.379157, -4.140918, -0.058949>, <-0.400000, -4.500000, -0.420000>, <-0.460000, -4.800000, -0.600000>, 
      <-0.500000, -3.800000, 0.000000>, <-0.541264, -4.130111, -0.123792>, <-0.640000, -4.500000, -0.420000>, <-0.700000, -4.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.000000, -4.100000, 0.000000>, <-0.174484, -4.112463, 0.000000>, <-0.337893, -3.810807, 0.064843>, <-0.500000, -3.800000, 0.000000>, 
      <-0.014978, -3.890308, 0.179736>, <-0.189462, -3.902771, 0.179736>, <-0.316969, -3.643410, 0.127616>, <-0.479075, -3.632604, 0.062774>, 
      <0.030497, -3.659228, 0.508508>, <-0.191814, -3.659228, 0.413231>, <-0.251608, -3.394560, 0.150281>, <-0.439460, -3.369514, 0.000000>, 
      <0.000000, -3.400000, 0.600000>, <-0.222312, -3.400000, 0.504724>, <-0.312149, -3.225047, 0.150281>, <-0.500000, -3.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.900000, -3.700000, 0.000000>, <1.200000, -3.640000, 0.000000>, <1.600000, -3.560000, 0.000000>, <1.900000, -3.500000, 0.000000>, 
      <0.900000, -4.000719, -0.225539>, <1.200000, -3.940719, -0.225539>, <1.600000, -3.906964, -0.260223>, <1.900000, -3.846964, -0.260223>, 
      <0.900000, -4.470000, -0.420000>, <1.140000, -4.470000, -0.420000>, <1.520000, -4.410000, -0.420000>, <1.760000, -4.410000, -0.420000>, 
      <0.900000, -4.800000, -0.600000>, <1.140000, -4.800000, -0.600000>, <1.460000, -4.800000, -0.600000>, <1.700000, -4.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.900000, -3.700000, 0.000000>, <0.900000, -4.000719, -0.225539>, <0.900000, -4.470000, -0.420000>, <0.900000, -4.800000, -0.600000>, 
      <0.630000, -3.820000, 0.000000>, <0.630000, -4.120719, -0.225539>, <0.660000, -4.470000, -0.420000>, <0.660000, -4.800000, -0.600000>, 
      <0.294715, -4.078949, 0.000000>, <0.309781, -4.289871, -0.180790>, <0.310000, -4.590000, -0.420000>, <0.340000, -4.800000, -0.600000>, 
      <0.000000, -4.100000, 0.000000>, <0.015066, -4.310922, -0.180790>, <0.070000, -4.590000, -0.420000>, <0.100000, -4.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.900000, -3.200000, 0.600000>, <1.138356, -3.171958, 0.600000>, <1.460000, -3.200000, 0.600000>, <1.700000, -3.200000, 0.600000>, 
      <0.871159, -3.401889, 0.484635>, <1.109515, -3.373847, 0.484635>, <1.485849, -3.380944, 0.496603>, <1.725849, -3.380944, 0.496603>, 
      <0.900000, -3.512554, 0.140585>, <1.200000, -3.452554, 0.140585>, <1.600000, -3.392000, 0.126000>, <1.900000, -3.332000, 0.126000>, 
      <0.900000, -3.700000, 0.000000>, <1.200000, -3.640000, 0.000000>, <1.600000, -3.560000, 0.000000>, <1.900000, -3.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.900000, -3.200000, 0.600000>, <0.871159, -3.401889, 0.484635>, <0.900000, -3.512554, 0.140585>, <0.900000, -3.700000, 0.000000>, 
      <0.625308, -3.232317, 0.600000>, <0.596467, -3.434206, 0.484635>, <0.630000, -3.632554, 0.140585>, <0.630000, -3.820000, 0.000000>, 
      <0.254223, -3.400000, 0.708953>, <0.284720, -3.659228, 0.617461>, <0.279737, -3.869257, 0.179736>, <0.294715, -4.078949, 0.000000>, 
      <0.000000, -3.400000, 0.600000>, <0.030497, -3.659228, 0.508508>, <-0.014978, -3.890308, 0.179736>, <0.000000, -4.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.100000, -2.300000, 0.800000>, <1.083494, -2.580602, 0.766988>, <0.934837, -2.956139, 0.739349>, <0.900000, -3.200000, 0.600000>, 
      <0.711211, -2.361388, 0.759075>, <0.694705, -2.641990, 0.726063>, <0.660145, -2.988456, 0.739349>, <0.625308, -3.232317, 0.600000>, 
      <0.169437, -2.382408, 0.740738>, <0.137409, -2.686668, 0.740738>, <0.220489, -3.113260, 0.810155>, <0.254223, -3.400000, 0.708953>, 
      <-0.200000, -2.400000, 0.600000>, <-0.232027, -2.704260, 0.600000>, <-0.033734, -3.113260, 0.701202>, <0.000000, -3.400000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.100000, -2.300000, 0.800000>, <1.114106, -2.060198, 0.828212>, <1.031691, -1.737679, 0.831691>, <1.000000, -1.500000, 0.800000>, 
      <1.286410, -2.270567, 0.819622>, <1.300516, -2.030765, 0.847834>, <1.271691, -1.707679, 0.861691>, <1.240000, -1.470000, 0.830000>, 
      <1.511101, -2.112593, 0.787407>, <1.522824, -1.901582, 0.822575>, <1.545873, -1.641901, 0.898254>, <1.560000, -1.430000, 0.870000>, 
      <1.700000, -2.100000, 0.800000>, <1.711723, -1.888989, 0.835169>, <1.785873, -1.611901, 0.928253>, <1.800000, -1.400000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.100000, -2.300000, 0.800000>, <1.286410, -2.270567, 0.819622>, <1.511101, -2.112593, 0.787407>, <1.700000, -2.100000, 0.800000>, 
      <1.083494, -2.580602, 0.766988>, <1.269904, -2.551169, 0.786610>, <1.492748, -2.442944, 0.732348>, <1.681647, -2.430351, 0.744942>, 
      <0.934837, -2.956139, 0.739349>, <1.173194, -2.928097, 0.739349>, <1.418714, -2.910997, 0.765145>, <1.658714, -2.910997, 0.765145>, 
      <0.900000, -3.200000, 0.600000>, <1.138356, -3.171958, 0.600000>, <1.460000, -3.200000, 0.600000>, <1.700000, -3.200000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <2.700000, -0.500000, 0.600000>, <2.669920, -0.755681, 0.735360>, <2.516821, -1.114044, 0.849537>, <2.500000, -1.400000, 0.900000>, 
      <2.910000, -0.530000, 0.600000>, <2.879920, -0.785681, 0.735360>, <2.756821, -1.174044, 0.849537>, <2.740000, -1.460000, 0.900000>, 
      <3.192577, -0.555552, 0.600000>, <3.165139, -0.843653, 0.723472>, <3.077216, -1.230103, 0.848351>, <3.060000, -1.540000, 0.900000>, 
      <3.400000, -0.600000, 0.600000>, <3.372562, -0.888100, 0.723472>, <3.317216, -1.290103, 0.848351>, <3.300000, -1.600000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <2.700000, 0.300000, 0.000000>, <2.685019, 0.060299, 0.179776>, <2.731025, -0.236285, 0.460386>, <2.700000, -0.500000, 0.600000>, 
      <2.940000, 0.360000, 0.000000>, <2.925019, 0.120299, 0.179776>, <2.941025, -0.266285, 0.460386>, <2.910000, -0.530000, 0.600000>, 
      <3.263553, 0.572753, 0.000000>, <3.228839, 0.260324, 0.208286>, <3.225461, -0.210268, 0.452021>, <3.192577, -0.555552, 0.600000>, 
      <3.500000, 0.500000, 0.000000>, <3.465286, 0.187571, 0.208286>, <3.432884, -0.254716, 0.452021>, <3.400000, -0.600000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <2.800000, 1.100000, -0.600000>, <2.770000, 0.860000, -0.420000>, <2.715056, 0.540896, -0.180672>, <2.700000, 0.300000, 0.000000>, 
      <3.040000, 1.130000, -0.600000>, <3.010000, 0.890000, -0.420000>, <2.955056, 0.600896, -0.180672>, <2.940000, 0.360000, 0.000000>, 
      <3.364326, 1.254386, -0.600000>, <3.334326, 1.044386, -0.420000>, <3.289165, 0.803253, -0.153667>, <3.263553, 0.572753, 0.000000>, 
      <3.600000, 1.200000, -0.600000>, <3.570000, 0.990000, -0.420000>, <3.525611, 0.730501, -0.153667>, <3.500000, 0.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.300000, -1.600000, 0.000000>, <-0.630000, -1.600000, -0.180000>, <-1.070000, -1.600000, -0.420000>, <-1.400000, -1.600000, -0.600000>, 
      <-0.427823, -1.892167, 0.000000>, <-0.757823, -1.892167, -0.180000>, <-1.250000, -1.840000, -0.420000>, <-1.580000, -1.840000, -0.600000>, 
      <-0.960445, -2.083558, 0.000000>, <-1.251543, -2.083558, -0.194066>, <-1.520000, -2.160000, -0.420000>, <-1.820000, -2.160000, -0.600000>, 
      <-1.000000, -2.400000, 0.000000>, <-1.291099, -2.400000, -0.194066>, <-1.700000, -2.400000, -0.420000>, <-2.000000, -2.400000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.200000, -1.500000, 0.600000>, <-0.000749, -1.515442, 0.476462>, <-0.150000, -1.570000, 0.180000>, <-0.300000, -1.600000, 0.000000>, 
      <0.111870, -1.782016, 0.600000>, <-0.088879, -1.797458, 0.476462>, <-0.277823, -1.862167, 0.180000>, <-0.427823, -1.892167, 0.000000>, 
      <-0.169069, -2.106158, 0.600000>, <-0.449138, -2.119494, 0.493307>, <-0.710830, -2.083558, 0.166410>, <-0.960445, -2.083558, 0.000000>, 
      <-0.200000, -2.400000, 0.600000>, <-0.480069, -2.413337, 0.493307>, <-0.750385, -2.400000, 0.166410>, <-1.000000, -2.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.200000, -1.500000, 0.600000>, <0.111870, -1.782016, 0.600000>, <-0.169069, -2.106158, 0.600000>, <-0.200000, -2.400000, 0.600000>, 
      <0.410238, -1.483828, 0.729377>, <0.322108, -1.765844, 0.729377>, <0.200367, -2.088566, 0.740738>, <0.169437, -2.382408, 0.740738>, 
      <0.760000, -1.500000, 0.740000>, <0.791691, -1.737679, 0.771691>, <0.725317, -2.121586, 0.787287>, <0.711211, -2.361388, 0.759075>, 
      <1.000000, -1.500000, 0.800000>, <1.031691, -1.737679, 0.831691>, <1.114106, -2.060198, 0.828212>, <1.100000, -2.300000, 0.800000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.800000, -0.600000, 0.600000>, <1.786058, -0.823072, 0.725478>, <1.816901, -1.146481, 0.866197>, <1.800000, -1.400000, 0.900000>, 
      <2.067966, -0.555339, 0.600000>, <2.054024, -0.778411, 0.725478>, <2.026901, -1.146481, 0.866197>, <2.010000, -1.400000, 0.900000>, 
      <2.430000, -0.530000, 0.600000>, <2.399920, -0.785681, 0.735360>, <2.306821, -1.114044, 0.849537>, <2.290000, -1.400000, 0.900000>, 
      <2.700000, -0.500000, 0.600000>, <2.669920, -0.755681, 0.735360>, <2.516821, -1.114044, 0.849537>, <2.500000, -1.400000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.900000, 0.200000, 0.000000>, <1.916327, -0.028577, 0.195923>, <1.816399, -0.337612, 0.452407>, <1.800000, -0.600000, 0.600000>, 
      <2.134646, 0.258662, 0.000000>, <2.150973, 0.030084, 0.195923>, <2.084365, -0.292951, 0.452407>, <2.067966, -0.555339, 0.600000>, 
      <2.460000, 0.270000, 0.000000>, <2.445019, 0.030299, 0.179776>, <2.461025, -0.266285, 0.460386>, <2.430000, -0.530000, 0.600000>, 
      <2.700000, 0.300000, 0.000000>, <2.685019, 0.060299, 0.179776>, <2.731025, -0.236285, 0.460386>, <2.700000, -0.500000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.700000, 0.800000, -0.600000>, <1.760000, 0.620000, -0.420000>, <1.885837, 0.398280, -0.169954>, <1.900000, 0.200000, 0.000000>, 
      <2.037867, 0.853347, -0.600000>, <2.097867, 0.673347, -0.420000>, <2.120483, 0.456942, -0.169954>, <2.134646, 0.258662, 0.000000>, 
      <2.470000, 1.010000, -0.600000>, <2.440000, 0.770000, -0.420000>, <2.475056, 0.510896, -0.180672>, <2.460000, 0.270000, 0.000000>, 
      <2.800000, 1.100000, -0.600000>, <2.770000, 0.860000, -0.420000>, <2.715056, 0.540896, -0.180672>, <2.700000, 0.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.300000, -0.800000, 0.000000>, <-0.607097, -0.800000, -0.216775>, <-1.070000, -0.800000, -0.420000>, <-1.400000, -0.800000, -0.600000>, 
      <-0.336494, -1.037209, 0.000000>, <-0.643591, -1.037209, -0.216775>, <-1.055029, -1.039533, -0.420000>, <-1.385029, -1.039533, -0.600000>, 
      <-0.203804, -1.380122, 0.000000>, <-0.533803, -1.380122, -0.180000>, <-1.070000, -1.360000, -0.420000>, <-1.400000, -1.360000, -0.600000>, 
      <-0.300000, -1.600000, 0.000000>, <-0.630000, -1.600000, -0.180000>, <-1.070000, -1.600000, -0.420000>, <-1.400000, -1.600000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.100000, -0.300000, 0.000000>, <-0.541213, -0.275488, -0.147071>, <-1.080000, -0.090000, -0.420000>, <-1.500000, 0.000000, -0.600000>, 
      <-0.063178, -0.447287, 0.055233>, <-0.504392, -0.422775, -0.091839>, <-1.064913, -0.331397, -0.420000>, <-1.484913, -0.241397, -0.600000>, 
      <-0.275434, -0.640324, 0.000000>, <-0.582532, -0.640324, -0.216775>, <-1.085087, -0.558603, -0.420000>, <-1.415087, -0.558603, -0.600000>, 
      <-0.300000, -0.800000, 0.000000>, <-0.607097, -0.800000, -0.216775>, <-1.070000, -0.800000, -0.420000>, <-1.400000, -0.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.700000, 0.800000, -0.600000>, <-0.940000, 0.800000, -0.600000>, <-1.260000, 0.800000, -0.600000>, <-1.500000, 0.800000, -0.600000>, 
      <-0.520000, 0.470000, -0.420000>, <-0.760000, 0.470000, -0.420000>, <-1.260000, 0.560000, -0.600000>, <-1.500000, 0.560000, -0.600000>, 
      <-0.194991, 0.079966, -0.142487>, <-0.636205, 0.104478, -0.289558>, <-1.094971, 0.149533, -0.420000>, <-1.514971, 0.239533, -0.600000>, 
      <-0.100000, -0.300000, 0.000000>, <-0.541213, -0.275488, -0.147071>, <-1.080000, -0.090000, -0.420000>, <-1.500000, 0.000000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.300000, -0.100000, 0.000000>, <0.267164, 0.162690, -0.197017>, <0.160000, 0.530000, -0.420000>, <0.100000, 0.800000, -0.600000>, 
      <0.167661, -0.122056, 0.000000>, <0.134825, 0.140633, -0.197017>, <-0.080000, 0.530000, -0.420000>, <-0.140000, 0.800000, -0.600000>, 
      <0.027103, -0.307061, 0.042368>, <-0.067889, 0.072905, -0.100120>, <-0.280000, 0.470000, -0.420000>, <-0.460000, 0.800000, -0.600000>, 
      <-0.100000, -0.300000, 0.000000>, <-0.194991, 0.079966, -0.142487>, <-0.520000, 0.470000, -0.420000>, <-0.700000, 0.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.300000, -0.800000, 0.600000>, <0.072316, -0.800000, 0.486158>, <-0.092034, -0.800000, 0.146800>, <-0.300000, -0.800000, 0.000000>, 
      <0.286103, -0.994561, 0.683383>, <0.058419, -0.994561, 0.569541>, <-0.128528, -1.037209, 0.146800>, <-0.336494, -1.037209, 0.000000>, 
      <0.263274, -1.297524, 0.600000>, <0.062525, -1.312966, 0.476462>, <-0.053803, -1.350122, 0.180000>, <-0.203804, -1.380122, 0.000000>, 
      <0.200000, -1.500000, 0.600000>, <-0.000749, -1.515442, 0.476462>, <-0.150000, -1.570000, 0.180000>, <-0.300000, -1.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.300000, -0.800000, 0.600000>, <0.318120, -0.546323, 0.491281>, <0.327521, -0.320171, 0.165128>, <0.300000, -0.100000, 0.000000>, 
      <0.072316, -0.800000, 0.486158>, <0.090436, -0.546323, 0.377439>, <0.195183, -0.342227, 0.165128>, <0.167661, -0.122056, 0.000000>, 
      <-0.092034, -0.800000, 0.146800>, <-0.067468, -0.640324, 0.146800>, <0.063925, -0.454348, 0.097600>, <0.027103, -0.307061, 0.042368>, 
      <-0.300000, -0.800000, 0.000000>, <-0.275434, -0.640324, 0.000000>, <-0.063178, -0.447287, 0.055233>, <-0.100000, -0.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.900000, -0.800000, 0.600000>, <0.886354, -0.991041, 0.709166>, <0.971115, -1.283364, 0.771115>, <1.000000, -1.500000, 0.800000>, 
      <1.174160, -0.763445, 0.600000>, <1.160514, -0.954486, 0.709166>, <1.211115, -1.253364, 0.801115>, <1.240000, -1.470000, 0.830000>, 
      <1.527177, -0.645471, 0.600000>, <1.513235, -0.868542, 0.725478>, <1.576901, -1.176481, 0.836198>, <1.560000, -1.430000, 0.870000>, 
      <1.800000, -0.600000, 0.600000>, <1.786058, -0.823072, 0.725478>, <1.816901, -1.146481, 0.866197>, <1.800000, -1.400000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.900000, -0.800000, 0.600000>, <0.721579, -0.823789, 0.600000>, <0.460997, -0.800000, 0.680499>, <0.300000, -0.800000, 0.600000>, 
      <0.886354, -0.991041, 0.709166>, <0.707933, -1.014830, 0.709166>, <0.447100, -0.994561, 0.763882>, <0.286103, -0.994561, 0.683383>, 
      <0.971115, -1.283364, 0.771115>, <0.731115, -1.283364, 0.711115>, <0.473512, -1.281352, 0.729377>, <0.263274, -1.297524, 0.600000>, 
      <1.000000, -1.500000, 0.800000>, <0.760000, -1.500000, 0.740000>, <0.410238, -1.483828, 0.729377>, <0.200000, -1.500000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.100000, -0.100000, 0.000000>, <1.100000, -0.326416, 0.169812>, <0.917519, -0.554742, 0.459852>, <0.900000, -0.800000, 0.600000>, 
      <1.351930, -0.052763, 0.000000>, <1.351930, -0.279179, 0.169812>, <1.191679, -0.518187, 0.459852>, <1.174160, -0.763445, 0.600000>, 
      <1.651333, 0.137833, 0.000000>, <1.667660, -0.090744, 0.195923>, <1.543576, -0.383083, 0.452407>, <1.527177, -0.645471, 0.600000>, 
      <1.900000, 0.200000, 0.000000>, <1.916327, -0.028577, 0.195923>, <1.816399, -0.337612, 0.452407>, <1.800000, -0.600000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.100000, -0.100000, 0.000000>, <0.864111, -0.144229, 0.000000>, <0.536735, -0.060544, 0.000000>, <0.300000, -0.100000, 0.000000>, 
      <1.100000, -0.326416, 0.169812>, <0.864111, -0.370645, 0.169812>, <0.564256, -0.280715, 0.165128>, <0.327521, -0.320171, 0.165128>, 
      <0.917519, -0.554742, 0.459852>, <0.739097, -0.578531, 0.459852>, <0.479117, -0.546323, 0.571780>, <0.318120, -0.546323, 0.491281>, 
      <0.900000, -0.800000, 0.600000>, <0.721579, -0.823789, 0.600000>, <0.460997, -0.800000, 0.680499>, <0.300000, -0.800000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.900000, 0.800000, -0.600000>, <0.960000, 0.530000, -0.420000>, <1.100000, 0.164000, -0.198000>, <1.100000, -0.100000, 0.000000>, 
      <1.140000, 0.800000, -0.600000>, <1.200000, 0.530000, -0.420000>, <1.351930, 0.211237, -0.198000>, <1.351930, -0.052763, 0.000000>, 
      <1.462937, 0.762569, -0.600000>, <1.522937, 0.582569, -0.420000>, <1.637170, 0.336113, -0.169954>, <1.651333, 0.137833, 0.000000>, 
      <1.700000, 0.800000, -0.600000>, <1.760000, 0.620000, -0.420000>, <1.885837, 0.398280, -0.169954>, <1.900000, 0.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.900000, 0.800000, -0.600000>, <0.660000, 0.800000, -0.600000>, <0.340000, 0.800000, -0.600000>, <0.100000, 0.800000, -0.600000>, 
      <0.960000, 0.530000, -0.420000>, <0.720000, 0.530000, -0.420000>, <0.400000, 0.530000, -0.420000>, <0.160000, 0.530000, -0.420000>, 
      <1.100000, 0.164000, -0.198000>, <0.864111, 0.119771, -0.198000>, <0.503898, 0.202146, -0.197017>, <0.267164, 0.162690, -0.197017>, 
      <1.100000, -0.100000, 0.000000>, <0.864111, -0.144229, 0.000000>, <0.536735, -0.060544, 0.000000>, <0.300000, -0.100000, 0.000000>
    }
  }
  material {
    RoughStone
  }
  scale 8.0
  rotate 107.382278*z
  translate  <78.443731, 35.164431, 0.0>
}


union { // sPatchObj3
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <5.500000, -3.500000, 0.000000>, <5.525337, -3.905397, -0.152024>, <5.640000, -4.410000, -0.420000>, <5.700000, -4.800000, -0.600000>, 
      <5.854087, -3.562486, -0.124972>, <5.879424, -3.967883, -0.276996>, <5.880000, -4.410000, -0.420000>, <5.940000, -4.800000, -0.600000>, 
      <6.200000, -3.850000, -0.420000>, <6.200000, -4.090000, -0.420000>, <6.260000, -4.560000, -0.600000>, <6.260000, -4.800000, -0.600000>, 
      <6.500000, -4.000000, -0.600000>, <6.500000, -4.240000, -0.600000>, <6.500000, -4.560000, -0.600000>, <6.500000, -4.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <5.600000, -3.200000, 0.000000>, <5.583029, -3.293338, 0.000000>, <5.494458, -3.411324, 0.033254>, <5.500000, -3.500000, 0.000000>, 
      <5.859600, -3.200000, -0.194700>, <5.842629, -3.293338, -0.194700>, <5.848544, -3.473810, -0.091718>, <5.854087, -3.562486, -0.124972>, 
      <6.230000, -3.200000, -0.420000>, <6.230000, -3.440000, -0.420000>, <6.200000, -3.610000, -0.420000>, <6.200000, -3.850000, -0.420000>, 
      <6.500000, -3.200000, -0.600000>, <6.500000, -3.440000, -0.600000>, <6.500000, -3.760000, -0.600000>, <6.500000, -4.000000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <5.700000, -2.400000, 0.000000>, <5.716088, -2.641332, 0.000000>, <5.643267, -2.962034, 0.000000>, <5.600000, -3.200000, 0.000000>, 
      <5.940000, -2.400000, -0.180000>, <5.956088, -2.641332, -0.180000>, <5.902866, -2.962034, -0.194700>, <5.859600, -3.200000, -0.194700>, 
      <6.260000, -2.400000, -0.420000>, <6.260000, -2.640000, -0.420000>, <6.230000, -2.960000, -0.420000>, <6.230000, -3.200000, -0.420000>, 
      <6.500000, -2.400000, -0.600000>, <6.500000, -2.640000, -0.600000>, <6.500000, -2.960000, -0.600000>, <6.500000, -3.200000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.100000, -3.200000, 0.600000>, <3.860000, -3.200000, 0.600000>, <3.540000, -3.200000, 0.600000>, <3.300000, -3.200000, 0.600000>, 
      <4.112721, -2.971023, 0.714489>, <3.872721, -2.971023, 0.714489>, <3.540000, -2.976598, 0.725664>, <3.300000, -2.976598, 0.725664>, 
      <4.100000, -2.651930, 0.852763>, <3.864110, -2.651930, 0.896992>, <3.537894, -2.683649, 0.852763>, <3.300000, -2.651930, 0.852763>, 
      <4.100000, -2.400000, 0.900000>, <3.864110, -2.400000, 0.944229>, <3.537894, -2.431719, 0.900000>, <3.300000, -2.400000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.000000, -4.200000, 0.000000>, <3.785838, -4.242833, 0.000000>, <3.502782, -4.081113, 0.000000>, <3.300000, -4.000000, 0.000000>, 
      <4.000000, -4.501101, -0.180661>, <3.785838, -4.543933, -0.180661>, <3.502782, -4.321113, -0.180000>, <3.300000, -4.240000, -0.180000>, 
      <4.070000, -4.900000, -0.420000>, <3.806268, -4.949450, -0.420000>, <3.540000, -4.680000, -0.420000>, <3.300000, -4.560000, -0.420000>, 
      <4.100000, -5.200000, -0.600000>, <3.836268, -5.249450, -0.600000>, <3.540000, -4.920000, -0.600000>, <3.300000, -4.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.000000, -4.200000, 0.000000>, <3.785838, -4.242833, 0.000000>, <3.502782, -4.081113, 0.000000>, <3.300000, -4.000000, 0.000000>, 
      <4.000000, -3.898899, 0.180661>, <3.785838, -3.941732, 0.180661>, <3.502782, -3.841113, 0.180000>, <3.300000, -3.760000, 0.180000>, 
      <4.082573, -3.513683, 0.443159>, <3.842573, -3.513683, 0.443159>, <3.540000, -3.461473, 0.452922>, <3.300000, -3.461473, 0.452922>, 
      <4.100000, -3.200000, 0.600000>, <3.860000, -3.200000, 0.600000>, <3.540000, -3.200000, 0.600000>, <3.300000, -3.200000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.800000, -3.700000, 0.000000>, <4.800000, -3.921540, -0.204499>, <4.870000, -4.260000, -0.420000>, <4.900000, -4.500000, -0.600000>, 
      <4.997913, -3.607640, 0.000000>, <4.997913, -3.829181, -0.204499>, <5.110000, -4.350000, -0.420000>, <5.140000, -4.590000, -0.600000>, 
      <5.296842, -3.464148, 0.071703>, <5.322179, -3.869546, -0.080321>, <5.400000, -4.320000, -0.420000>, <5.460000, -4.710000, -0.600000>, 
      <5.500000, -3.500000, 0.000000>, <5.525337, -3.905397, -0.152024>, <5.640000, -4.410000, -0.420000>, <5.700000, -4.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.800000, -3.700000, 0.000000>, <4.543533, -3.819685, 0.000000>, <4.277524, -4.144496, 0.000000>, <4.000000, -4.200000, 0.000000>, 
      <4.800000, -3.921540, -0.204499>, <4.543533, -4.041226, -0.204499>, <4.277524, -4.445596, -0.180661>, <4.000000, -4.501101, -0.180661>, 
      <4.870000, -4.260000, -0.420000>, <4.630000, -4.470000, -0.420000>, <4.383442, -4.841230, -0.420000>, <4.070000, -4.900000, -0.420000>, 
      <4.900000, -4.500000, -0.600000>, <4.660000, -4.710000, -0.600000>, <4.413442, -5.141230, -0.600000>, <4.100000, -5.200000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.900000, -3.200000, 0.600000>, <4.883542, -3.413957, 0.501251>, <4.800000, -3.526425, 0.160223>, <4.800000, -3.700000, 0.000000>, 
      <5.156804, -3.200000, 0.497279>, <5.140346, -3.413957, 0.398529>, <4.997913, -3.434065, 0.160223>, <4.997913, -3.607640, 0.000000>, 
      <5.378731, -3.200000, 0.165952>, <5.361760, -3.293338, 0.165952>, <5.291299, -3.375472, 0.104957>, <5.296842, -3.464148, 0.071703>, 
      <5.600000, -3.200000, 0.000000>, <5.583029, -3.293338, 0.000000>, <5.494458, -3.411324, 0.033254>, <5.500000, -3.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.900000, -3.200000, 0.600000>, <4.677166, -3.200000, 0.689134>, <4.340000, -3.200000, 0.600000>, <4.100000, -3.200000, 0.600000>, 
      <4.883542, -3.413957, 0.501251>, <4.660708, -3.413957, 0.590384>, <4.322573, -3.513683, 0.443159>, <4.082573, -3.513683, 0.443159>, 
      <4.800000, -3.526425, 0.160223>, <4.543533, -3.646110, 0.160223>, <4.277524, -3.843394, 0.180661>, <4.000000, -3.898899, 0.180661>, 
      <4.800000, -3.700000, 0.000000>, <4.543533, -3.819685, 0.000000>, <4.277524, -4.144496, 0.000000>, <4.000000, -4.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.900000, -2.400000, 0.600000>, <4.900000, -2.640000, 0.600000>, <4.916722, -2.982619, 0.700330>, <4.900000, -3.200000, 0.600000>, 
      <5.161472, -2.400000, 0.452922>, <5.161472, -2.640000, 0.452922>, <5.173526, -2.982619, 0.597608>, <5.156804, -3.200000, 0.497279>, 
      <5.460000, -2.400000, 0.180000>, <5.476088, -2.641332, 0.180000>, <5.421998, -2.962034, 0.165952>, <5.378731, -3.200000, 0.165952>, 
      <5.700000, -2.400000, 0.000000>, <5.716088, -2.641332, 0.000000>, <5.643267, -2.962034, 0.000000>, <5.600000, -3.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.900000, -2.400000, 0.600000>, <4.676598, -2.400000, 0.725664>, <4.351930, -2.400000, 0.852763>, <4.100000, -2.400000, 0.900000>, 
      <4.900000, -2.640000, 0.600000>, <4.676598, -2.640000, 0.725664>, <4.351930, -2.651930, 0.805526>, <4.100000, -2.651930, 0.852763>, 
      <4.916722, -2.982619, 0.700330>, <4.693887, -2.982619, 0.789463>, <4.352721, -2.971023, 0.714489>, <4.112721, -2.971023, 0.714489>, 
      <4.900000, -3.200000, 0.600000>, <4.677166, -3.200000, 0.689134>, <4.340000, -3.200000, 0.600000>, <4.100000, -3.200000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <6.500000, -1.600000, -0.600000>, <6.200000, -1.630000, -0.420000>, <5.800000, -1.670000, -0.180000>, <5.500000, -1.700000, 0.000000>, 
      <6.500000, -1.840000, -0.600000>, <6.200000, -1.870000, -0.420000>, <5.814528, -1.887920, -0.180000>, <5.514528, -1.917920, 0.000000>, 
      <6.500000, -2.160000, -0.600000>, <6.260000, -2.160000, -0.420000>, <5.925472, -2.182081, -0.180000>, <5.685472, -2.182081, 0.000000>, 
      <6.500000, -2.400000, -0.600000>, <6.260000, -2.400000, -0.420000>, <5.940000, -2.400000, -0.180000>, <5.700000, -2.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.100000, -1.600000, 0.900000>, <3.860000, -1.600000, 0.900000>, <3.540000, -1.600000, 0.900000>, <3.300000, -1.600000, 0.900000>, 
      <4.100000, -1.835889, 0.944229>, <3.860000, -1.835889, 0.944229>, <3.526868, -1.836380, 0.939397>, <3.286868, -1.836380, 0.939397>, 
      <4.100000, -2.164111, 0.944229>, <3.864110, -2.164111, 0.988459>, <3.537894, -2.195830, 0.944229>, <3.300000, -2.164111, 0.944229>, 
      <4.100000, -2.400000, 0.900000>, <3.864110, -2.400000, 0.944229>, <3.537894, -2.431719, 0.900000>, <3.300000, -2.400000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.900000, -1.600000, 0.600000>, <4.917100, -1.839390, 0.600000>, <4.900000, -2.160000, 0.600000>, <4.900000, -2.400000, 0.600000>, 
      <5.080000, -1.630000, 0.420000>, <5.097099, -1.869390, 0.420000>, <5.161472, -2.160000, 0.452922>, <5.161472, -2.400000, 0.452922>, 
      <5.320000, -1.670000, 0.180000>, <5.334528, -1.887920, 0.180000>, <5.445472, -2.182081, 0.180000>, <5.460000, -2.400000, 0.180000>, 
      <5.500000, -1.700000, 0.000000>, <5.514528, -1.917920, 0.000000>, <5.685472, -2.182081, 0.000000>, <5.700000, -2.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.900000, -1.600000, 0.600000>, <4.660000, -1.600000, 0.690000>, <4.340000, -1.600000, 0.810000>, <4.100000, -1.600000, 0.900000>, 
      <4.917100, -1.839390, 0.600000>, <4.677099, -1.839390, 0.690000>, <4.340000, -1.835889, 0.854229>, <4.100000, -1.835889, 0.944229>, 
      <4.900000, -2.160000, 0.600000>, <4.676598, -2.160000, 0.725664>, <4.351930, -2.164111, 0.896992>, <4.100000, -2.164111, 0.944229>, 
      <4.900000, -2.400000, 0.600000>, <4.676598, -2.400000, 0.725664>, <4.351930, -2.400000, 0.852763>, <4.100000, -2.400000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <5.600000, -0.900000, 0.000000>, <5.618550, -1.141155, 0.000000>, <5.483912, -1.458668, 0.000000>, <5.500000, -1.700000, 0.000000>, 
      <5.865015, -0.868822, -0.187070>, <5.883566, -1.109977, -0.187070>, <5.783912, -1.428668, -0.180000>, <5.800000, -1.670000, -0.180000>, 
      <6.230000, -0.830000, -0.420000>, <6.230000, -1.070000, -0.420000>, <6.200000, -1.390000, -0.420000>, <6.200000, -1.630000, -0.420000>, 
      <6.500000, -0.800000, -0.600000>, <6.500000, -1.040000, -0.600000>, <6.500000, -1.360000, -0.600000>, <6.500000, -1.600000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <5.600000, -0.900000, 0.000000>, <5.865015, -0.868822, -0.187070>, <6.230000, -0.830000, -0.420000>, <6.500000, -0.800000, -0.600000>, 
      <5.587609, -0.738921, 0.000000>, <5.852624, -0.707743, -0.187070>, <6.230000, -0.590000, -0.420000>, <6.500000, -0.560000, -0.600000>, 
      <5.391052, -0.552111, 0.053686>, <5.749610, -0.446653, -0.072864>, <6.170000, -0.360000, -0.420000>, <6.500000, -0.240000, -0.600000>, 
      <5.400000, -0.400000, 0.000000>, <5.758558, -0.294542, -0.126550>, <6.170000, -0.120000, -0.420000>, <6.500000, 0.000000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <5.700000, 0.800000, -0.600000>, <5.610000, 0.440000, -0.420000>, <5.422842, -0.011678, -0.137055>, <5.400000, -0.400000, 0.000000>, 
      <5.933701, 0.737680, -0.600000>, <5.843701, 0.377680, -0.420000>, <5.781400, 0.093780, -0.263605>, <5.758558, -0.294542, -0.126550>, 
      <6.190000, 0.520000, -0.600000>, <6.220000, 0.400000, -0.600000>, <6.140000, 0.000000, -0.420000>, <6.170000, -0.120000, -0.420000>, 
      <6.400000, 0.400000, -0.600000>, <6.430000, 0.280000, -0.600000>, <6.470000, 0.120000, -0.600000>, <6.500000, 0.000000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.000000, -0.100000, 0.000000>, <4.000000, 0.160707, -0.195530>, <4.070000, 0.530000, -0.420000>, <4.100000, 0.800000, -0.600000>, 
      <3.814282, 0.042860, 0.000000>, <3.814282, 0.303567, -0.195530>, <3.886401, 0.586492, -0.420000>, <3.916401, 0.856492, -0.600000>, 
      <3.723946, 0.431094, 0.000000>, <3.749557, 0.661594, -0.153667>, <3.757174, 0.946806, -0.420000>, <3.787174, 1.156806, -0.600000>, 
      <3.500000, 0.500000, 0.000000>, <3.525611, 0.730501, -0.153667>, <3.570000, 0.990000, -0.420000>, <3.600000, 1.200000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.100000, -0.800000, 0.600000>, <3.890000, -0.740000, 0.600000>, <3.613556, -0.645762, 0.600000>, <3.400000, -0.600000, 0.600000>, 
      <4.114629, -1.019435, 0.731661>, <3.904629, -0.959434, 0.731661>, <3.586117, -0.933862, 0.723472>, <3.372562, -0.888100, 0.723472>, 
      <4.100000, -1.348070, 0.852763>, <3.860000, -1.348070, 0.852763>, <3.557216, -1.290103, 0.848351>, <3.317216, -1.290103, 0.848351>, 
      <4.100000, -1.600000, 0.900000>, <3.860000, -1.600000, 0.900000>, <3.540000, -1.600000, 0.900000>, <3.300000, -1.600000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.100000, -0.800000, 0.600000>, <4.084122, -0.561827, 0.457096>, <4.000000, -0.322567, 0.166925>, <4.000000, -0.100000, 0.000000>, 
      <3.890000, -0.740000, 0.600000>, <3.874122, -0.501827, 0.457096>, <3.814282, -0.179707, 0.166925>, <3.814282, 0.042860, 0.000000>, 
      <3.613556, -0.645762, 0.600000>, <3.646440, -0.300478, 0.452021>, <3.689232, 0.118665, 0.208286>, <3.723946, 0.431094, 0.000000>, 
      <3.400000, -0.600000, 0.600000>, <3.432884, -0.254716, 0.452021>, <3.465286, 0.187571, 0.208286>, <3.500000, 0.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.800000, -1.000000, 0.600000>, <4.814518, -1.159693, 0.687105>, <4.886999, -1.417981, 0.600000>, <4.900000, -1.600000, 0.600000>, 
      <5.079398, -1.018627, 0.488241>, <5.093915, -1.178320, 0.575346>, <5.066998, -1.447981, 0.420000>, <5.080000, -1.630000, 0.420000>, 
      <5.354817, -0.928845, 0.173070>, <5.373367, -1.170000, 0.173070>, <5.303912, -1.428668, 0.180000>, <5.320000, -1.670000, 0.180000>, 
      <5.600000, -0.900000, 0.000000>, <5.618550, -1.141155, 0.000000>, <5.483912, -1.458668, 0.000000>, <5.500000, -1.700000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.800000, -1.000000, 0.600000>, <4.597605, -0.986507, 0.680958>, <4.310000, -0.860000, 0.600000>, <4.100000, -0.800000, 0.600000>, 
      <4.814518, -1.159693, 0.687105>, <4.612122, -1.146200, 0.768063>, <4.324629, -1.079435, 0.731661>, <4.114629, -1.019435, 0.731661>, 
      <4.886999, -1.417981, 0.600000>, <4.646998, -1.417981, 0.690000>, <4.340000, -1.348070, 0.762763>, <4.100000, -1.348070, 0.852763>, 
      <4.900000, -1.600000, 0.600000>, <4.660000, -1.600000, 0.690000>, <4.340000, -1.600000, 0.810000>, <4.100000, -1.600000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.800000, -0.500000, 0.000000>, <4.789181, -0.694748, 0.129832>, <4.781360, -0.794954, 0.488157>, <4.800000, -1.000000, 0.600000>, 
      <4.978432, -0.538235, 0.000000>, <4.967613, -0.732983, 0.129832>, <5.060757, -0.813581, 0.376398>, <5.079398, -1.018627, 0.488241>, 
      <5.234180, -0.448771, 0.058525>, <5.225232, -0.600881, 0.112211>, <5.342426, -0.767766, 0.173070>, <5.354817, -0.928845, 0.173070>, 
      <5.400000, -0.400000, 0.000000>, <5.391052, -0.552111, 0.053686>, <5.587609, -0.738921, 0.000000>, <5.600000, -0.900000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.800000, -0.500000, 0.000000>, <4.537628, -0.443777, 0.000000>, <4.212683, -0.263603, 0.000000>, <4.000000, -0.100000, 0.000000>, 
      <4.789181, -0.694748, 0.129832>, <4.526809, -0.638525, 0.129832>, <4.212683, -0.486169, 0.166925>, <4.000000, -0.322567, 0.166925>, 
      <4.781360, -0.794954, 0.488157>, <4.578965, -0.781461, 0.569115>, <4.294122, -0.621827, 0.457096>, <4.084122, -0.561827, 0.457096>, 
      <4.800000, -1.000000, 0.600000>, <4.597605, -0.986507, 0.680958>, <4.310000, -0.860000, 0.600000>, <4.100000, -0.800000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.900000, 0.800000, -0.600000>, <4.870000, 0.410000, -0.420000>, <4.819882, -0.142117, -0.238589>, <4.800000, -0.500000, 0.000000>, 
      <5.140000, 0.800000, -0.600000>, <5.110000, 0.410000, -0.420000>, <4.998314, -0.180353, -0.238589>, <4.978432, -0.538235, 0.000000>, 
      <5.468104, 0.861839, -0.600000>, <5.378103, 0.501839, -0.420000>, <5.257022, -0.060448, -0.078530>, <5.234180, -0.448771, 0.058525>, 
      <5.700000, 0.800000, -0.600000>, <5.610000, 0.440000, -0.420000>, <5.422842, -0.011678, -0.137055>, <5.400000, -0.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <4.900000, 0.800000, -0.600000>, <4.660000, 0.800000, -0.600000>, <4.329387, 0.729419, -0.600000>, <4.100000, 0.800000, -0.600000>, 
      <4.870000, 0.410000, -0.420000>, <4.630000, 0.410000, -0.420000>, <4.299386, 0.459419, -0.420000>, <4.070000, 0.530000, -0.420000>, 
      <4.819882, -0.142117, -0.238589>, <4.557510, -0.085894, -0.238589>, <4.212683, -0.002896, -0.195530>, <4.000000, 0.160707, -0.195530>, 
      <4.800000, -0.500000, 0.000000>, <4.537628, -0.443777, 0.000000>, <4.212683, -0.263603, 0.000000>, <4.000000, -0.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <2.500000, -3.600000, 0.000000>, <2.740000, -3.720000, 0.000000>, <3.050864, -3.900346, 0.000000>, <3.300000, -4.000000, 0.000000>, 
      <2.500000, -3.921994, -0.241495>, <2.740000, -4.041994, -0.241495>, <3.050864, -4.140346, -0.180000>, <3.300000, -4.240000, -0.180000>, 
      <2.500000, -4.440000, -0.420000>, <2.740000, -4.440000, -0.420000>, <3.060000, -4.560000, -0.420000>, <3.300000, -4.560000, -0.420000>, 
      <2.500000, -4.800000, -0.600000>, <2.740000, -4.800000, -0.600000>, <3.060000, -4.800000, -0.600000>, <3.300000, -4.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <2.500000, -3.200000, 0.600000>, <2.740000, -3.200000, 0.600000>, <3.060000, -3.200000, 0.600000>, <3.300000, -3.200000, 0.600000>, 
      <2.487025, -3.381647, 0.483227>, <2.727025, -3.381647, 0.483227>, <3.060000, -3.461473, 0.452922>, <3.300000, -3.461473, 0.452922>, 
      <2.500000, -3.426934, 0.129800>, <2.740000, -3.546934, 0.129800>, <3.050864, -3.660346, 0.180000>, <3.300000, -3.760000, 0.180000>, 
      <2.500000, -3.600000, 0.000000>, <2.740000, -3.720000, 0.000000>, <3.050864, -3.900346, 0.000000>, <3.300000, -4.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <2.600000, -2.200000, 0.900000>, <2.600000, -1.961423, 0.939763>, <2.486012, -1.637789, 0.941963>, <2.500000, -1.400000, 0.900000>, 
      <2.810000, -2.260000, 0.900000>, <2.810000, -2.021423, 0.939763>, <2.726012, -1.697789, 0.941963>, <2.740000, -1.460000, 0.900000>, 
      <3.083512, -2.371135, 0.900000>, <3.083512, -2.135246, 0.944229>, <3.046868, -1.776380, 0.939397>, <3.060000, -1.540000, 0.900000>, 
      <3.300000, -2.400000, 0.900000>, <3.300000, -2.164111, 0.944229>, <3.286868, -1.836380, 0.939397>, <3.300000, -1.600000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <2.600000, -2.200000, 0.900000>, <2.810000, -2.260000, 0.900000>, <3.083512, -2.371135, 0.900000>, <3.300000, -2.400000, 0.900000>, 
      <2.600000, -2.510362, 0.848273>, <2.810000, -2.570362, 0.848273>, <3.083512, -2.623065, 0.852763>, <3.300000, -2.651930, 0.852763>, 
      <2.518871, -2.935806, 0.769839>, <2.758871, -2.935806, 0.769839>, <3.060000, -2.976598, 0.725664>, <3.300000, -2.976598, 0.725664>, 
      <2.500000, -3.200000, 0.600000>, <2.740000, -3.200000, 0.600000>, <3.060000, -3.200000, 0.600000>, <3.300000, -3.200000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.700000, -4.800000, -0.600000>, <1.760000, -4.410000, -0.420000>, <1.900000, -3.846964, -0.260223>, <1.900000, -3.500000, 0.000000>, 
      <1.940000, -4.800000, -0.600000>, <2.000000, -4.410000, -0.420000>, <2.080000, -3.876964, -0.260223>, <2.080000, -3.530000, 0.000000>, 
      <2.260000, -4.800000, -0.600000>, <2.260000, -4.440000, -0.420000>, <2.320000, -3.891994, -0.241495>, <2.320000, -3.570000, 0.000000>, 
      <2.500000, -4.800000, -0.600000>, <2.500000, -4.440000, -0.420000>, <2.500000, -3.921994, -0.241495>, <2.500000, -3.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.700000, -3.200000, 0.600000>, <1.940000, -3.200000, 0.600000>, <2.260000, -3.200000, 0.600000>, <2.500000, -3.200000, 0.600000>, 
      <1.725849, -3.380944, 0.496603>, <1.965849, -3.380944, 0.496603>, <2.247025, -3.381647, 0.483227>, <2.487025, -3.381647, 0.483227>, 
      <1.900000, -3.332000, 0.126000>, <2.080000, -3.362000, 0.126000>, <2.320000, -3.396934, 0.129800>, <2.500000, -3.426934, 0.129800>, 
      <1.900000, -3.500000, 0.000000>, <2.080000, -3.530000, 0.000000>, <2.320000, -3.570000, 0.000000>, <2.500000, -3.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.700000, -2.100000, 0.800000>, <1.972106, -2.081860, 0.818141>, <2.330000, -2.170000, 0.870000>, <2.600000, -2.200000, 0.900000>, 
      <1.681647, -2.430351, 0.744942>, <1.953754, -2.412211, 0.763082>, <2.330000, -2.480362, 0.818273>, <2.600000, -2.510362, 0.848273>, 
      <1.658714, -2.910997, 0.765145>, <1.898714, -2.910997, 0.765145>, <2.278871, -2.935806, 0.769839>, <2.518871, -2.935806, 0.769839>, 
      <1.700000, -3.200000, 0.600000>, <1.940000, -3.200000, 0.600000>, <2.260000, -3.200000, 0.600000>, <2.500000, -3.200000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.700000, -2.100000, 0.800000>, <1.711723, -1.888989, 0.835169>, <1.785873, -1.611901, 0.928253>, <1.800000, -1.400000, 0.900000>, 
      <1.972106, -2.081860, 0.818141>, <1.983829, -1.870849, 0.853309>, <1.995873, -1.611901, 0.928253>, <2.010000, -1.400000, 0.900000>, 
      <2.330000, -2.170000, 0.870000>, <2.330000, -1.931423, 0.909763>, <2.276012, -1.637789, 0.941963>, <2.290000, -1.400000, 0.900000>, 
      <2.600000, -2.200000, 0.900000>, <2.600000, -1.961423, 0.939763>, <2.486012, -1.637789, 0.941963>, <2.500000, -1.400000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.500000, -3.800000, 0.000000>, <-0.541264, -4.130111, -0.123792>, <-0.640000, -4.500000, -0.420000>, <-0.700000, -4.800000, -0.600000>, 
      <-0.828947, -3.778070, -0.131579>, <-0.870211, -4.108181, -0.255370>, <-0.880000, -4.500000, -0.420000>, <-0.940000, -4.800000, -0.600000>, 
      <-1.200000, -3.940000, -0.420000>, <-1.200000, -4.180000, -0.420000>, <-1.260000, -4.560000, -0.600000>, <-1.260000, -4.800000, -0.600000>, 
      <-1.500000, -4.000000, -0.600000>, <-1.500000, -4.240000, -0.600000>, <-1.500000, -4.560000, -0.600000>, <-1.500000, -4.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.500000, -3.200000, 0.000000>, <-0.439460, -3.369514, 0.000000>, <-0.479075, -3.632604, 0.062774>, <-0.500000, -3.800000, 0.000000>, 
      <-0.771724, -3.163770, -0.217379>, <-0.711183, -3.333284, -0.217379>, <-0.808022, -3.610674, -0.068805>, <-0.828947, -3.778070, -0.131579>, 
      <-1.200000, -3.200000, -0.420000>, <-1.128414, -3.429075, -0.420000>, <-1.200000, -3.700000, -0.420000>, <-1.200000, -3.940000, -0.420000>, 
      <-1.500000, -3.200000, -0.600000>, <-1.428414, -3.429075, -0.600000>, <-1.500000, -3.760000, -0.600000>, <-1.500000, -4.000000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-1.000000, -2.400000, 0.000000>, <-1.291099, -2.400000, -0.194066>, <-1.700000, -2.400000, -0.420000>, <-2.000000, -2.400000, -0.600000>, 
      <-1.035104, -2.680834, 0.000000>, <-1.326203, -2.680834, -0.194066>, <-1.550000, -2.640000, -0.420000>, <-1.850000, -2.640000, -0.600000>, 
      <-0.595190, -2.933469, 0.000000>, <-0.866914, -2.897239, -0.217379>, <-1.284418, -2.929864, -0.420000>, <-1.584418, -2.929864, -0.600000>, 
      <-0.500000, -3.200000, 0.000000>, <-0.771724, -3.163770, -0.217379>, <-1.200000, -3.200000, -0.420000>, <-1.500000, -3.200000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.000000, -3.400000, 0.600000>, <-0.222312, -3.400000, 0.504724>, <-0.312149, -3.225047, 0.150281>, <-0.500000, -3.200000, 0.000000>, 
      <-0.033734, -3.113260, 0.701202>, <-0.256046, -3.113260, 0.605926>, <-0.407338, -2.958516, 0.150281>, <-0.595190, -2.933469, 0.000000>, 
      <-0.232027, -2.704260, 0.600000>, <-0.512096, -2.717597, 0.493307>, <-0.785489, -2.680834, 0.166410>, <-1.035104, -2.680834, 0.000000>, 
      <-0.200000, -2.400000, 0.600000>, <-0.480069, -2.413337, 0.493307>, <-0.750385, -2.400000, 0.166410>, <-1.000000, -2.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.000000, -4.100000, 0.000000>, <0.015066, -4.310922, -0.180790>, <0.070000, -4.590000, -0.420000>, <0.100000, -4.800000, -0.600000>, 
      <-0.174484, -4.112463, 0.000000>, <-0.159418, -4.323385, -0.180790>, <-0.170000, -4.590000, -0.420000>, <-0.140000, -4.800000, -0.600000>, 
      <-0.337893, -3.810807, 0.064843>, <-0.379157, -4.140918, -0.058949>, <-0.400000, -4.500000, -0.420000>, <-0.460000, -4.800000, -0.600000>, 
      <-0.500000, -3.800000, 0.000000>, <-0.541264, -4.130111, -0.123792>, <-0.640000, -4.500000, -0.420000>, <-0.700000, -4.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.000000, -4.100000, 0.000000>, <-0.174484, -4.112463, 0.000000>, <-0.337893, -3.810807, 0.064843>, <-0.500000, -3.800000, 0.000000>, 
      <-0.014978, -3.890308, 0.179736>, <-0.189462, -3.902771, 0.179736>, <-0.316969, -3.643410, 0.127616>, <-0.479075, -3.632604, 0.062774>, 
      <0.030497, -3.659228, 0.508508>, <-0.191814, -3.659228, 0.413231>, <-0.251608, -3.394560, 0.150281>, <-0.439460, -3.369514, 0.000000>, 
      <0.000000, -3.400000, 0.600000>, <-0.222312, -3.400000, 0.504724>, <-0.312149, -3.225047, 0.150281>, <-0.500000, -3.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.900000, -3.700000, 0.000000>, <1.200000, -3.640000, 0.000000>, <1.600000, -3.560000, 0.000000>, <1.900000, -3.500000, 0.000000>, 
      <0.900000, -4.000719, -0.225539>, <1.200000, -3.940719, -0.225539>, <1.600000, -3.906964, -0.260223>, <1.900000, -3.846964, -0.260223>, 
      <0.900000, -4.470000, -0.420000>, <1.140000, -4.470000, -0.420000>, <1.520000, -4.410000, -0.420000>, <1.760000, -4.410000, -0.420000>, 
      <0.900000, -4.800000, -0.600000>, <1.140000, -4.800000, -0.600000>, <1.460000, -4.800000, -0.600000>, <1.700000, -4.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.900000, -3.700000, 0.000000>, <0.900000, -4.000719, -0.225539>, <0.900000, -4.470000, -0.420000>, <0.900000, -4.800000, -0.600000>, 
      <0.630000, -3.820000, 0.000000>, <0.630000, -4.120719, -0.225539>, <0.660000, -4.470000, -0.420000>, <0.660000, -4.800000, -0.600000>, 
      <0.294715, -4.078949, 0.000000>, <0.309781, -4.289871, -0.180790>, <0.310000, -4.590000, -0.420000>, <0.340000, -4.800000, -0.600000>, 
      <0.000000, -4.100000, 0.000000>, <0.015066, -4.310922, -0.180790>, <0.070000, -4.590000, -0.420000>, <0.100000, -4.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.900000, -3.200000, 0.600000>, <1.138356, -3.171958, 0.600000>, <1.460000, -3.200000, 0.600000>, <1.700000, -3.200000, 0.600000>, 
      <0.871159, -3.401889, 0.484635>, <1.109515, -3.373847, 0.484635>, <1.485849, -3.380944, 0.496603>, <1.725849, -3.380944, 0.496603>, 
      <0.900000, -3.512554, 0.140585>, <1.200000, -3.452554, 0.140585>, <1.600000, -3.392000, 0.126000>, <1.900000, -3.332000, 0.126000>, 
      <0.900000, -3.700000, 0.000000>, <1.200000, -3.640000, 0.000000>, <1.600000, -3.560000, 0.000000>, <1.900000, -3.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.900000, -3.200000, 0.600000>, <0.871159, -3.401889, 0.484635>, <0.900000, -3.512554, 0.140585>, <0.900000, -3.700000, 0.000000>, 
      <0.625308, -3.232317, 0.600000>, <0.596467, -3.434206, 0.484635>, <0.630000, -3.632554, 0.140585>, <0.630000, -3.820000, 0.000000>, 
      <0.254223, -3.400000, 0.708953>, <0.284720, -3.659228, 0.617461>, <0.279737, -3.869257, 0.179736>, <0.294715, -4.078949, 0.000000>, 
      <0.000000, -3.400000, 0.600000>, <0.030497, -3.659228, 0.508508>, <-0.014978, -3.890308, 0.179736>, <0.000000, -4.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.100000, -2.300000, 0.800000>, <1.083494, -2.580602, 0.766988>, <0.934837, -2.956139, 0.739349>, <0.900000, -3.200000, 0.600000>, 
      <0.711211, -2.361388, 0.759075>, <0.694705, -2.641990, 0.726063>, <0.660145, -2.988456, 0.739349>, <0.625308, -3.232317, 0.600000>, 
      <0.169437, -2.382408, 0.740738>, <0.137409, -2.686668, 0.740738>, <0.220489, -3.113260, 0.810155>, <0.254223, -3.400000, 0.708953>, 
      <-0.200000, -2.400000, 0.600000>, <-0.232027, -2.704260, 0.600000>, <-0.033734, -3.113260, 0.701202>, <0.000000, -3.400000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.100000, -2.300000, 0.800000>, <1.114106, -2.060198, 0.828212>, <1.031691, -1.737679, 0.831691>, <1.000000, -1.500000, 0.800000>, 
      <1.286410, -2.270567, 0.819622>, <1.300516, -2.030765, 0.847834>, <1.271691, -1.707679, 0.861691>, <1.240000, -1.470000, 0.830000>, 
      <1.511101, -2.112593, 0.787407>, <1.522824, -1.901582, 0.822575>, <1.545873, -1.641901, 0.898254>, <1.560000, -1.430000, 0.870000>, 
      <1.700000, -2.100000, 0.800000>, <1.711723, -1.888989, 0.835169>, <1.785873, -1.611901, 0.928253>, <1.800000, -1.400000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.100000, -2.300000, 0.800000>, <1.286410, -2.270567, 0.819622>, <1.511101, -2.112593, 0.787407>, <1.700000, -2.100000, 0.800000>, 
      <1.083494, -2.580602, 0.766988>, <1.269904, -2.551169, 0.786610>, <1.492748, -2.442944, 0.732348>, <1.681647, -2.430351, 0.744942>, 
      <0.934837, -2.956139, 0.739349>, <1.173194, -2.928097, 0.739349>, <1.418714, -2.910997, 0.765145>, <1.658714, -2.910997, 0.765145>, 
      <0.900000, -3.200000, 0.600000>, <1.138356, -3.171958, 0.600000>, <1.460000, -3.200000, 0.600000>, <1.700000, -3.200000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <2.700000, -0.500000, 0.600000>, <2.669920, -0.755681, 0.735360>, <2.516821, -1.114044, 0.849537>, <2.500000, -1.400000, 0.900000>, 
      <2.910000, -0.530000, 0.600000>, <2.879920, -0.785681, 0.735360>, <2.756821, -1.174044, 0.849537>, <2.740000, -1.460000, 0.900000>, 
      <3.192577, -0.555552, 0.600000>, <3.165139, -0.843653, 0.723472>, <3.077216, -1.230103, 0.848351>, <3.060000, -1.540000, 0.900000>, 
      <3.400000, -0.600000, 0.600000>, <3.372562, -0.888100, 0.723472>, <3.317216, -1.290103, 0.848351>, <3.300000, -1.600000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <2.700000, 0.300000, 0.000000>, <2.685019, 0.060299, 0.179776>, <2.731025, -0.236285, 0.460386>, <2.700000, -0.500000, 0.600000>, 
      <2.940000, 0.360000, 0.000000>, <2.925019, 0.120299, 0.179776>, <2.941025, -0.266285, 0.460386>, <2.910000, -0.530000, 0.600000>, 
      <3.263553, 0.572753, 0.000000>, <3.228839, 0.260324, 0.208286>, <3.225461, -0.210268, 0.452021>, <3.192577, -0.555552, 0.600000>, 
      <3.500000, 0.500000, 0.000000>, <3.465286, 0.187571, 0.208286>, <3.432884, -0.254716, 0.452021>, <3.400000, -0.600000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <2.800000, 1.100000, -0.600000>, <2.770000, 0.860000, -0.420000>, <2.715056, 0.540896, -0.180672>, <2.700000, 0.300000, 0.000000>, 
      <3.040000, 1.130000, -0.600000>, <3.010000, 0.890000, -0.420000>, <2.955056, 0.600896, -0.180672>, <2.940000, 0.360000, 0.000000>, 
      <3.364326, 1.254386, -0.600000>, <3.334326, 1.044386, -0.420000>, <3.289165, 0.803253, -0.153667>, <3.263553, 0.572753, 0.000000>, 
      <3.600000, 1.200000, -0.600000>, <3.570000, 0.990000, -0.420000>, <3.525611, 0.730501, -0.153667>, <3.500000, 0.500000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.300000, -1.600000, 0.000000>, <-0.630000, -1.600000, -0.180000>, <-1.070000, -1.600000, -0.420000>, <-1.400000, -1.600000, -0.600000>, 
      <-0.427823, -1.892167, 0.000000>, <-0.757823, -1.892167, -0.180000>, <-1.250000, -1.840000, -0.420000>, <-1.580000, -1.840000, -0.600000>, 
      <-0.960445, -2.083558, 0.000000>, <-1.251543, -2.083558, -0.194066>, <-1.520000, -2.160000, -0.420000>, <-1.820000, -2.160000, -0.600000>, 
      <-1.000000, -2.400000, 0.000000>, <-1.291099, -2.400000, -0.194066>, <-1.700000, -2.400000, -0.420000>, <-2.000000, -2.400000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.200000, -1.500000, 0.600000>, <-0.000749, -1.515442, 0.476462>, <-0.150000, -1.570000, 0.180000>, <-0.300000, -1.600000, 0.000000>, 
      <0.111870, -1.782016, 0.600000>, <-0.088879, -1.797458, 0.476462>, <-0.277823, -1.862167, 0.180000>, <-0.427823, -1.892167, 0.000000>, 
      <-0.169069, -2.106158, 0.600000>, <-0.449138, -2.119494, 0.493307>, <-0.710830, -2.083558, 0.166410>, <-0.960445, -2.083558, 0.000000>, 
      <-0.200000, -2.400000, 0.600000>, <-0.480069, -2.413337, 0.493307>, <-0.750385, -2.400000, 0.166410>, <-1.000000, -2.400000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.200000, -1.500000, 0.600000>, <0.111870, -1.782016, 0.600000>, <-0.169069, -2.106158, 0.600000>, <-0.200000, -2.400000, 0.600000>, 
      <0.410238, -1.483828, 0.729377>, <0.322108, -1.765844, 0.729377>, <0.200367, -2.088566, 0.740738>, <0.169437, -2.382408, 0.740738>, 
      <0.760000, -1.500000, 0.740000>, <0.791691, -1.737679, 0.771691>, <0.725317, -2.121586, 0.787287>, <0.711211, -2.361388, 0.759075>, 
      <1.000000, -1.500000, 0.800000>, <1.031691, -1.737679, 0.831691>, <1.114106, -2.060198, 0.828212>, <1.100000, -2.300000, 0.800000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.800000, -0.600000, 0.600000>, <1.786058, -0.823072, 0.725478>, <1.816901, -1.146481, 0.866197>, <1.800000, -1.400000, 0.900000>, 
      <2.067966, -0.555339, 0.600000>, <2.054024, -0.778411, 0.725478>, <2.026901, -1.146481, 0.866197>, <2.010000, -1.400000, 0.900000>, 
      <2.430000, -0.530000, 0.600000>, <2.399920, -0.785681, 0.735360>, <2.306821, -1.114044, 0.849537>, <2.290000, -1.400000, 0.900000>, 
      <2.700000, -0.500000, 0.600000>, <2.669920, -0.755681, 0.735360>, <2.516821, -1.114044, 0.849537>, <2.500000, -1.400000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.900000, 0.200000, 0.000000>, <1.916327, -0.028577, 0.195923>, <1.816399, -0.337612, 0.452407>, <1.800000, -0.600000, 0.600000>, 
      <2.134646, 0.258662, 0.000000>, <2.150973, 0.030084, 0.195923>, <2.084365, -0.292951, 0.452407>, <2.067966, -0.555339, 0.600000>, 
      <2.460000, 0.270000, 0.000000>, <2.445019, 0.030299, 0.179776>, <2.461025, -0.266285, 0.460386>, <2.430000, -0.530000, 0.600000>, 
      <2.700000, 0.300000, 0.000000>, <2.685019, 0.060299, 0.179776>, <2.731025, -0.236285, 0.460386>, <2.700000, -0.500000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.700000, 0.800000, -0.600000>, <1.760000, 0.620000, -0.420000>, <1.885837, 0.398280, -0.169954>, <1.900000, 0.200000, 0.000000>, 
      <2.037867, 0.853347, -0.600000>, <2.097867, 0.673347, -0.420000>, <2.120483, 0.456942, -0.169954>, <2.134646, 0.258662, 0.000000>, 
      <2.470000, 1.010000, -0.600000>, <2.440000, 0.770000, -0.420000>, <2.475056, 0.510896, -0.180672>, <2.460000, 0.270000, 0.000000>, 
      <2.800000, 1.100000, -0.600000>, <2.770000, 0.860000, -0.420000>, <2.715056, 0.540896, -0.180672>, <2.700000, 0.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.300000, -0.800000, 0.000000>, <-0.607097, -0.800000, -0.216775>, <-1.070000, -0.800000, -0.420000>, <-1.400000, -0.800000, -0.600000>, 
      <-0.336494, -1.037209, 0.000000>, <-0.643591, -1.037209, -0.216775>, <-1.055029, -1.039533, -0.420000>, <-1.385029, -1.039533, -0.600000>, 
      <-0.203804, -1.380122, 0.000000>, <-0.533803, -1.380122, -0.180000>, <-1.070000, -1.360000, -0.420000>, <-1.400000, -1.360000, -0.600000>, 
      <-0.300000, -1.600000, 0.000000>, <-0.630000, -1.600000, -0.180000>, <-1.070000, -1.600000, -0.420000>, <-1.400000, -1.600000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.100000, -0.300000, 0.000000>, <-0.541213, -0.275488, -0.147071>, <-1.080000, -0.090000, -0.420000>, <-1.500000, 0.000000, -0.600000>, 
      <-0.063178, -0.447287, 0.055233>, <-0.504392, -0.422775, -0.091839>, <-1.064913, -0.331397, -0.420000>, <-1.484913, -0.241397, -0.600000>, 
      <-0.275434, -0.640324, 0.000000>, <-0.582532, -0.640324, -0.216775>, <-1.085087, -0.558603, -0.420000>, <-1.415087, -0.558603, -0.600000>, 
      <-0.300000, -0.800000, 0.000000>, <-0.607097, -0.800000, -0.216775>, <-1.070000, -0.800000, -0.420000>, <-1.400000, -0.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <-0.700000, 0.800000, -0.600000>, <-0.940000, 0.800000, -0.600000>, <-1.260000, 0.800000, -0.600000>, <-1.500000, 0.800000, -0.600000>, 
      <-0.520000, 0.470000, -0.420000>, <-0.760000, 0.470000, -0.420000>, <-1.260000, 0.560000, -0.600000>, <-1.500000, 0.560000, -0.600000>, 
      <-0.194991, 0.079966, -0.142487>, <-0.636205, 0.104478, -0.289558>, <-1.094971, 0.149533, -0.420000>, <-1.514971, 0.239533, -0.600000>, 
      <-0.100000, -0.300000, 0.000000>, <-0.541213, -0.275488, -0.147071>, <-1.080000, -0.090000, -0.420000>, <-1.500000, 0.000000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.300000, -0.100000, 0.000000>, <0.267164, 0.162690, -0.197017>, <0.160000, 0.530000, -0.420000>, <0.100000, 0.800000, -0.600000>, 
      <0.167661, -0.122056, 0.000000>, <0.134825, 0.140633, -0.197017>, <-0.080000, 0.530000, -0.420000>, <-0.140000, 0.800000, -0.600000>, 
      <0.027103, -0.307061, 0.042368>, <-0.067889, 0.072905, -0.100120>, <-0.280000, 0.470000, -0.420000>, <-0.460000, 0.800000, -0.600000>, 
      <-0.100000, -0.300000, 0.000000>, <-0.194991, 0.079966, -0.142487>, <-0.520000, 0.470000, -0.420000>, <-0.700000, 0.800000, -0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.300000, -0.800000, 0.600000>, <0.072316, -0.800000, 0.486158>, <-0.092034, -0.800000, 0.146800>, <-0.300000, -0.800000, 0.000000>, 
      <0.286103, -0.994561, 0.683383>, <0.058419, -0.994561, 0.569541>, <-0.128528, -1.037209, 0.146800>, <-0.336494, -1.037209, 0.000000>, 
      <0.263274, -1.297524, 0.600000>, <0.062525, -1.312966, 0.476462>, <-0.053803, -1.350122, 0.180000>, <-0.203804, -1.380122, 0.000000>, 
      <0.200000, -1.500000, 0.600000>, <-0.000749, -1.515442, 0.476462>, <-0.150000, -1.570000, 0.180000>, <-0.300000, -1.600000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.300000, -0.800000, 0.600000>, <0.318120, -0.546323, 0.491281>, <0.327521, -0.320171, 0.165128>, <0.300000, -0.100000, 0.000000>, 
      <0.072316, -0.800000, 0.486158>, <0.090436, -0.546323, 0.377439>, <0.195183, -0.342227, 0.165128>, <0.167661, -0.122056, 0.000000>, 
      <-0.092034, -0.800000, 0.146800>, <-0.067468, -0.640324, 0.146800>, <0.063925, -0.454348, 0.097600>, <0.027103, -0.307061, 0.042368>, 
      <-0.300000, -0.800000, 0.000000>, <-0.275434, -0.640324, 0.000000>, <-0.063178, -0.447287, 0.055233>, <-0.100000, -0.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.900000, -0.800000, 0.600000>, <0.886354, -0.991041, 0.709166>, <0.971115, -1.283364, 0.771115>, <1.000000, -1.500000, 0.800000>, 
      <1.174160, -0.763445, 0.600000>, <1.160514, -0.954486, 0.709166>, <1.211115, -1.253364, 0.801115>, <1.240000, -1.470000, 0.830000>, 
      <1.527177, -0.645471, 0.600000>, <1.513235, -0.868542, 0.725478>, <1.576901, -1.176481, 0.836198>, <1.560000, -1.430000, 0.870000>, 
      <1.800000, -0.600000, 0.600000>, <1.786058, -0.823072, 0.725478>, <1.816901, -1.146481, 0.866197>, <1.800000, -1.400000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.900000, -0.800000, 0.600000>, <0.721579, -0.823789, 0.600000>, <0.460997, -0.800000, 0.680499>, <0.300000, -0.800000, 0.600000>, 
      <0.886354, -0.991041, 0.709166>, <0.707933, -1.014830, 0.709166>, <0.447100, -0.994561, 0.763882>, <0.286103, -0.994561, 0.683383>, 
      <0.971115, -1.283364, 0.771115>, <0.731115, -1.283364, 0.711115>, <0.473512, -1.281352, 0.729377>, <0.263274, -1.297524, 0.600000>, 
      <1.000000, -1.500000, 0.800000>, <0.760000, -1.500000, 0.740000>, <0.410238, -1.483828, 0.729377>, <0.200000, -1.500000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.100000, -0.100000, 0.000000>, <1.100000, -0.326416, 0.169812>, <0.917519, -0.554742, 0.459852>, <0.900000, -0.800000, 0.600000>, 
      <1.351930, -0.052763, 0.000000>, <1.351930, -0.279179, 0.169812>, <1.191679, -0.518187, 0.459852>, <1.174160, -0.763445, 0.600000>, 
      <1.651333, 0.137833, 0.000000>, <1.667660, -0.090744, 0.195923>, <1.543576, -0.383083, 0.452407>, <1.527177, -0.645471, 0.600000>, 
      <1.900000, 0.200000, 0.000000>, <1.916327, -0.028577, 0.195923>, <1.816399, -0.337612, 0.452407>, <1.800000, -0.600000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <1.100000, -0.100000, 0.000000>, <0.864111, -0.144229, 0.000000>, <0.536735, -0.060544, 0.000000>, <0.300000, -0.100000, 0.000000>, 
      <1.100000, -0.326416, 0.169812>, <0.864111, -0.370645, 0.169812>, <0.564256, -0.280715, 0.165128>, <0.327521, -0.320171, 0.165128>, 
      <0.917519, -0.554742, 0.459852>, <0.739097, -0.578531, 0.459852>, <0.479117, -0.546323, 0.571780>, <0.318120, -0.546323, 0.491281>, 
      <0.900000, -0.800000, 0.600000>, <0.721579, -0.823789, 0.600000>, <0.460997, -0.800000, 0.680499>, <0.300000, -0.800000, 0.600000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.900000, 0.800000, -0.600000>, <0.960000, 0.530000, -0.420000>, <1.100000, 0.164000, -0.198000>, <1.100000, -0.100000, 0.000000>, 
      <1.140000, 0.800000, -0.600000>, <1.200000, 0.530000, -0.420000>, <1.351930, 0.211237, -0.198000>, <1.351930, -0.052763, 0.000000>, 
      <1.462937, 0.762569, -0.600000>, <1.522937, 0.582569, -0.420000>, <1.637170, 0.336113, -0.169954>, <1.651333, 0.137833, 0.000000>, 
      <1.700000, 0.800000, -0.600000>, <1.760000, 0.620000, -0.420000>, <1.885837, 0.398280, -0.169954>, <1.900000, 0.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 5,
      <0.900000, 0.800000, -0.600000>, <0.660000, 0.800000, -0.600000>, <0.340000, 0.800000, -0.600000>, <0.100000, 0.800000, -0.600000>, 
      <0.960000, 0.530000, -0.420000>, <0.720000, 0.530000, -0.420000>, <0.400000, 0.530000, -0.420000>, <0.160000, 0.530000, -0.420000>, 
      <1.100000, 0.164000, -0.198000>, <0.864111, 0.119771, -0.198000>, <0.503898, 0.202146, -0.197017>, <0.267164, 0.162690, -0.197017>, 
      <1.100000, -0.100000, 0.000000>, <0.864111, -0.144229, 0.000000>, <0.536735, -0.060544, 0.000000>, <0.300000, -0.100000, 0.000000>
    }
  }
  material {
    RoughStone
  }
  scale <7.0, 7.9, 8.0>
  rotate -97.441826*z
  translate  <156.887462, -47.507161, 0.322519>
}


#declare RotSweep001 = lathe {
  linear_spline
  4  // control points
  <0.469214, -1.583864>,
  <0.2569, 1.488323>,
  <0.2569, 1.679406>,
  <0.2569, 1.488323>
  rotate <90,0,90>
  material {
    LH_Wall
  }
  scale 6.0
  translate  11.0*z
}
union { // Lighthouse
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    material {
      LH_1
    }
    scale <0.1, 0.1, 1.95>
    translate  <0.0, -2.9, 21.05>
  }
  torus { // Torus001
    1.025, 0.025  rotate -x*90
    sturm
    material {
      LH_1
    }
    scale <2.9, 2.9, 1.0>
    translate  23.0*z
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      LH_1
    }
    scale <3.0, 3.0, 0.2>
    translate  21.0*z
  }
  object { RotSweep001 }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      RoughStone_1
    }
    scale <3.2, 3.2, 2.0>
    translate  -0.381018*z
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 open
    material {
      LH_1
    }
    scale <1.5, 1.5, 2.5>
    translate  21.0*z
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    material {
      LH_1
    }
    scale <0.1, 0.1, 1.95>
    translate  <0.0, 2.9, 21.05>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    material {
      LH_1
    }
    scale <0.1, 0.1, 1.95>
    translate  <2.9, 0.0, 21.05>
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    material {
      LH_1
    }
    scale <0.1, 0.1, 1.95>
    translate  <-2.9, 0.0, 21.05>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    material {
      LH_1
    }
    scale <0.1, 0.1, 1.95>
    rotate 45.0*z
    translate  <2.05061, -2.05061, 21.05>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    material {
      LH_1
    }
    scale <0.1, 0.1, 1.95>
    rotate 45.0*z
    translate  <-2.05061, 2.05061, 21.05>
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    material {
      LH_1
    }
    scale <0.1, 0.1, 1.95>
    rotate 45.0*z
    translate  <2.05061, 2.05061, 21.05>
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    material {
      LH_1
    }
    scale <0.1, 0.1, 1.95>
    rotate 45.0*z
    translate  <-2.05061, -2.05061, 21.05>
  }
  sphere { // Sphere003
    <0,0,0>,1
    material {
      T_Glass1
    }
    scale 0.5
    rotate 45.0*z
    translate  24.2*z
  }
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      LH_1
    }
    scale <1.5, 1.5, 0.8>
    rotate <180.0, 0.0, 45.0>
    translate  26.2*z
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 open
    material {
      T_Glass1
    }
    scale <1.4, 1.4, 2.0>
    rotate 45.0*z
    translate  23.4*z
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 open
    material {
      LH_1
    }
    scale <0.2, 0.2, 2.0>
    rotate 45.0*z
    translate  21.8*z
  }
  scale 1.5
  rotate -45.0*z
  translate  <139.4, -59.3, 7.0>
}


