// dmwave.pov

// development switches
#declare Fog = 0;
#declare Blob = 1;
#declare ShowGrid = 0;
#declare Ocean = 1;
#declare MainWavelet = 1;
#declare Wavelets = 1;
#declare Boats = 1;
#declare White = 1;
#declare ConeLength = 0;

#include "wavelet.inc"
#include "grid.inc"
#include "spot.inc"
#include "boat.inc"

// Parameters
#declare Light = <1.5, 1.5, 1.5>;
#declare FillLight = <0.3, 0.3, 0.3>;
#declare FogColour = <1.4, 0.7, 0.4>;
#declare z_MainWave = 30;
#declare S1 = seed(364);
#declare Fuji = <5,0,40>;

#declare Camera1 = camera {
	location <0, 3, 0>
	look_at <0,3,10>
}

#declare Camera2 = camera {
	location <0, 3, 15>
	look_at <0,3,20>
}

camera { Camera1 }

// ***** LIGHTS *****

/*
light_source { <-40, 30, -50>, rgb Light
}
light_source { <40, 20, -10>, rgb FillLight
	shadowless
}
*/
#declare OceanBlue = <0,0.5,1.5>;
#declare OceanGreen = <0,0.8,0.8>;
#declare Red = <2,0,0>;
#declare FoamWhite = <1.5,1.5,1.5>;
#declare SkyYellow0 = <1.3,1.2,0.9>;

#if (Ocean)
// main wave
Spot(<-1,5,27>, <0,10,30>, OceanBlue, 20, 40, ConeLength)
Spot(<0,5,27>, <-1,10,30>, OceanGreen, 20, 40, ConeLength)
Spot(<0,5,20>, <-8,10,30>, OceanBlue, 20, 40, ConeLength)
Spot(<0,5,25>, <-7,10,28>, OceanGreen, 20, 40, ConeLength)
Spot(<0,5,20>, <-10,4,25>, OceanBlue, 20, 40, ConeLength)
Spot(<0,3,25>, <-10,6,20>, OceanGreen, 20, 40, ConeLength)
Spot(<0,3,20>, <-10,6,25>, OceanBlue, 20, 40, ConeLength)
Spot(<0,5,25>, <-6,4,30>, OceanGreen, 20, 40, ConeLength)
Spot(<0,5,10>, <-10,4,15>, OceanBlue, 20, 40, ConeLength)
Spot(<0,5,15>, <-10,4,10>, OceanGreen, 20, 40, ConeLength)
// water above and behind main wave
Spot(<-15,15,22>, <-18,4,28>, OceanBlue, 20, 40, ConeLength)
// foreground
#declare x1 = -10;
#while (x1 <= 10)
	Spot(<x1,0,0>, <x1+5,0,10>, OceanBlue/2, 20, 40, ConeLength)
	Spot(<x1,0,0>, <x1-5,0,10>, OceanGreen/2, 20, 40, ConeLength)
	#declare x1 = x1 + 5;
#end
// bit behind foreground bulge at right
Spot(<0,1,5>, <5,0,10>, OceanBlue/2, 20, 40, ConeLength)
// background area
#declare x1 = -5;
#while (x1 <= 10)
	Spot(<x1,0,14>, <x1+5,-4,30>, OceanBlue, 20, 40, ConeLength)
	Spot(<x1,0,14>, <x1-5,-4,30>, OceanGreen, 20, 40, ConeLength)
	#declare x1 = x1 + 5;
#end

// white top highlights - main wave
Spot(<0,15,25>, <-1,10,30>, FoamWhite, 20, 40, ConeLength)
Spot(<-2,15,25>, <-3,10,30>, FoamWhite, 20, 40, ConeLength)
Spot(<5,10,25>, <2,9,30>, FoamWhite, 20, 40, ConeLength)
Spot(<-7,19,25>, <-6,10,28>, FoamWhite, 20, 40, ConeLength)
Spot(<-10,17,20>, <-9,10,23>, FoamWhite, 20, 40, ConeLength)
Spot(<-14,15,10>, <-12,10,14>, FoamWhite, 20, 40, ConeLength)
Spot(<-14,12,5>, <-12,8,9>, FoamWhite, 20, 40, ConeLength)
// main bulge at left
Spot(<-3,8,8>, <-2,0,10>, FoamWhite, 20, 40, ConeLength)
Spot(<-8,5,8>, <-6,0,10>, FoamWhite, 20, 40, ConeLength)
// bulge at right front
Spot(<4,5,5>, <5,0,7>, FoamWhite, 20, 40, ConeLength)
// bulge at right rear
Spot(<16,8,30>, <20,0,32>, FoamWhite, 20, 40, ConeLength)
#end // if (Ocean)

// Mount Fuji
Spot(Fuji + <0,4,-1>, Fuji + <0,-2,0>, FoamWhite, 20, 25, ConeLength)

// sky
#declare x1 = -38;
#declare x2 = 0;
#while (x1 <= 30)
	#declare SkyYellow = SkyYellow0;
	#declare y1 = 25;
	#while (y1 > -1)
		#if (x2 = 0)
			#declare x2 = 3.5;
		#else
			#declare x2 = 0;
		#end
		Spot(<x1+x2,y1,43>, <x1+x2+7,y1,50>, SkyYellow, 30, 60, ConeLength)
		#declare y1 = y1 - 5;
		#declare SkyYellow = SkyYellow * 0.8;
	#end
	#declare x1 = x1 + 7;
#end


// ***** END LIGHTS *****

#declare T_wave = texture {
	pigment { rgb <1,1,1> }
	normal { gradient z 1
		sine_wave
		turbulence 0.7
	}
}

#if (Ocean)
#if (Blob)
blob { threshold 0.5
#else
union {
#end
	#declare R1 = 10;
	#declare R2 = 5;
	#declare R3 = 1;
	#declare Bs = 6;
	#declare Sta = -20;
	#declare Swa = 100;
	#declare Num = 50;
	#declare X = -R1;
	#declare Y = 0;
	#declare Z = z_MainWave;
	#declare Xr = 0;
	#declare Yr = 0;
	#declare Zr = 0;
	#declare C = <0,0,0>;
	// main wave
	#if (MainWavelet)
		Wavelet(R1, R2, R3, Bs, Sta, Swa, Num, X, Y, Z, Xr, Yr, Zr, C)
	#end
	// water above and left of wave
	sphere { <0,0,0>, 5, 1
		scale <2,1,2>
		rotate <0,0,-30>
		translate <-14,4,Z>
	}
	sphere { <0,0,0>, 5, 1
		scale <2,1,2>
		rotate <0,0,-30>
		translate <-17,7,Z>
	}
	// main sea
	sphere { <0,0,0>, 5, 1
		scale <1,0.5,1>
		rotate <0,0,-30>
		translate <-5.5,0,Z-15>
		//texture { pigment { rgb <1,0,0> } }
	}
	sphere { <0,0,0>, 5, 1
		scale <4,1,4>
		translate <-8,-8,Z>
	}
	sphere { <0,0,0>, 5, 1
		scale <4,1,4>
		translate <4,-10,Z>
	}
	sphere { <0,0,0>, 5, 1
		scale <4,1,4>
		translate <-2,-8,Z-6>
	}
	sphere { <0,0,0>, 5, 1
		scale <4,1,4>
		translate <10,-8,Z-6>
	}
	// bulge at background right
	#declare i = 0;
	#while (i < 1)
		sphere { <0,0,0>, 5-i, 1
			scale <8-7*sqrt(i),1,2-i>
			translate <22,-8+12*i*i,Z+2>
		}
		#declare i = i + 0.05;
	#end
	// bulge at background centre, blending in to main wave
	#declare i = 0;
	#while (i < 1)
		sphere { <0,0,0>, 5-i, 1
			scale <6-5*sqrt(i),1,2-i>
			translate <-7,-7+7*i*i,Z+4>
		}
		#declare i = i + 0.05;
	#end
	// main bulge at left
	#declare i = 0;
	#while (i < 1)
		sphere { <0,0,0>, 3-2*i, 1
			scale <6-5*i,1,2-i>
			translate <-2,-4+5*i*i+i,Z-18>
		}
		#declare i = i + 0.05;
	#end
	// extra bulging, far left
	#declare i = 0;
	#while (i < 1)
		sphere { <0,0,0>, 3-2*i, 1
			scale <6-5*i,1,2-i>
			translate <-4,-4+3*i*i+i,Z-18>
		}
		#declare i = i + 0.1;
	#end
	#declare i = 0;
	#while (i < 1)
		sphere { <0,0,0>, 3-2*i, 1
			scale <6-5*i,1,2-i>
			translate <-5.6,-4+2.6*i*i+i,Z-18>
		}
		#declare i = i + 0.1;
	#end
	#declare i = 0;
	#while (i < 1)
		sphere { <0,0,0>, 3-2*i, 1
			scale <6-5*i,1,2-i>
			translate <-8,-4+4*i*i+i,Z-18>
		}
		#declare i = i + 0.1;
	#end
	// extra bulging, right of big left bulge
	#declare j = 0;
	#while (j < 11)
		#declare i = 0;
		#while (i < 1)
			sphere { <0,0,0>, 3-2*i, 1
				scale <6-2*i,1,2-i>
				translate <j,-4+(2+j*j/60)*i*i+i,Z-18>
			}
			#declare i = i + 0.1;
		#end
		#declare j = j + 2;
	#end
	// bulge at foreground right
	#declare i = 0;
	#while (i < 1)
		sphere { <0,0,0>, 3-2*i, 1
			scale <6-5*i,1,2-i>
			translate <5,-4+4*i*i+i,Z-23>
		}
		#declare i = i + 0.05;
	#end
	// wavelets
	#if (Wavelets)
		#declare R1 = 0.8;
		#declare R2 = 0.4;
		#declare R3 = 0.05;
		#declare Bs = 1;
		#declare Sta = 50;
		#declare Swa = 100;
		#declare Num = 30;
		#declare X = 0;
		#declare Y = 11;
		#declare Z = z_MainWave+2;
		// main wave curl
		WaveGroup3(R1, R2, R3, Bs, Sta, Swa, Num, X, Y, Z, 0, 0, 0, C)
		WaveGroup3(R1, R2, R3, Bs, Sta, Swa, Num, X+2, Y-1, Z-1, 0, 10, 0, C)
		WaveGroup3(R1, R2, R3, Bs, Sta, Swa, Num, X+2, Y-2.5, Z, 0, 0, -30, C)
		// wave top
		WaveGroup3(R1, R2, R3, Bs, Sta, Swa, Num, X-0.5, Y+1, Z-1, 0, 0, 0, C)
		WaveGroup3(R1, R2, R3, Bs, Sta, Swa, Num, X-1.5, Y, Z-1, 0, 0, 0, C)
		// running down edge
		WaveGroup2(R1, R2, R3, Bs, Sta, Swa, Num, X-5, Y, Z-4, 0, 0, 0, C)
		WaveGroup2(R1, R2, R3, Bs, Sta, Swa, Num, X-5.5, Y-1, Z-6, 0, 0, 0, C)
		WaveGroup2(R1, R2, R3, Bs, Sta, Swa, Num, X-6.5, Y-2.5, Z-9, 0, 0, -20, C)
		WaveGroup3(R1, R2, R3, Bs, Sta, Swa, Num, X-6.5, Y-5, Z-10, 0, 0, 0, C)
		WaveGroup2(R1, R2, R3, Bs, Sta, Swa, Num, X-7, Y-5.5, Z-14, 0, 0, 0, C)
		// near bottom
		WaveGroup3(R1, R2, R3, Bs, Sta, Swa, Num, X-7, Y-8, Z-16, 0, 10, 0, C)
		WaveGroup3(R1, R2, R3, Bs, Sta, Swa, Num, X-5, Y-9, Z-17, 0, 10, 0, C)
		WaveGroup2(R1, R2, R3, Bs, Sta, Swa, Num, X-6.5, Y-10, Z-19, 0, 10, 0, C)
		#declare R1 = 0.4;
		#declare R2 = 0.2;
		#declare R3 = 0.025;
		WaveGroup3(R1, R2, R3, Bs, Sta, Swa, Num, X-6, Y-8, Z-16.5, 0, 10, 0, C)
		WaveGroup3(R1, R2, R3, Bs, Sta, Swa, Num, X-5.5, Y-10, Z-19.5, 0, 10, 0, C)
		// on main bulge
		WaveGroup3(R1, R2, R3, Bs, Sta, Swa, Num, X-4.5, Y-12, Z-19.6, 0, 10, 0, C)
		WaveGroup3(R1, R2, R3, Bs, Sta, Swa, Num, X-3, Y-12, Z-19.8, 0, 0, 0, C)
		WaveGroup3(R1, R2, R3, Bs, Sta, Swa, Num, X-1, Y-12, Z-19.9, 0, 0, 0, C)
		WaveGroup3(R1, R2, R3, Bs, Sta, Swa, Num, X-0, Y-11.5, Z-19.7, 0, 20, 0, C)
	#end // if (Wavelets)
	texture { T_wave }
}
#end // if (Ocean)

#if (ShowGrid)
union {
	Grid(0, 10)
	Grid(1, 10)
	translate <0,0,z_MainWave>
}
#end

#if (Boats)
	#if (Ocean)
		object { Boat
			rotate <10,0,30>
			translate <13,-3,34>
		}
		object { Boat
			scale 0.55
			rotate <15,0,0>
			translate <3,-1,10>
		}
		object { Boat
			scale 0.7
			rotate <-15,10,-30>
			translate <-6,2,15>
		}
	#else
		object { Boat
			translate <0,0,z_MainWave>
		}
		object { Boat
			rotate <-45,0,0>
			translate <0,4,z_MainWave>
		}
	#end
#end

// Mount Fuji
cone { <0,-5,0>, 4, <0,-1,0>, 0.5
	texture {
		pigment { rgb <1,1,1> }
		normal { radial 0.3
			frequency 50
			turbulence 0.3
		}
		finish { brilliance 0.1 }
	}
	translate Fuji
}

// text box
box { <0,0,0>, <1,1,0.01>
	texture {
		pigment { image_map { png "box.png" } }
		finish { ambient 0.4 }
	}
	scale <38/15, 137/15, 1>
	translate <-29,16,49.999>
}

// sky
plane { -z, -50
	texture {
		pigment { rgb <1,1,1> }
		normal { crackle -0.8
			scale <3,1,1>
			turbulence 0.5
		}
		//finish { brilliance 0.4 }
	}
}

#if (Fog)
// fog layer
fog {
	fog_type 2
	rgb FogColour
	distance 3000
	fog_offset 30
	fog_alt 20
}
#end
