// grid.inc

#macro Grid(Axes, Size)
union {
	#local i = 0;
	#while (i <= Size)
		cylinder { <-i, -Size, 0>, <-i, Size, 0>, 0.02 }
		cylinder { <i, -Size, 0>, <i, Size, 0>, 0.02 }
		cylinder { <-Size, -i, 0>, <Size, -i, 0>, 0.02 }
		cylinder { <-Size, i, 0>, <Size, i, 0>, 0.02 }
		#local i = i + 1;
	#end
	#if (Axes = 1)
		rotate <90,0,0>
	#end
	#if (Axes = 2)
		rotate <0,90,0>
	#end
	texture {
		pigment { rgb <1,0,0> }
		finish { ambient 0.6 }
	}
}
#end