// wavelet.inc
//
// Requires variable Blob to be defined in including file before macro is called.
// If Blob=true, generates a blob of sphere components
// If Blob=false, generates a union of spheres
//
// R1         = torus major radius
// R2         = torus minor radius at base of wavelet
// R3         = torus minor radius at point
// BaseScale  = stretching of base spheres in transverse direction
// StartAngle = angle with vertical at base of wavelet
// SweepAngle = angle of sweep for wavelet torus
// NumSpheres = number of spheres in blob/union
// X, Y, Z    = translation of whole wavelet from <0,0,0>
// Xr, Yr, Zr = rotation of whole wavelet
// C          = rgb colour for debugging, set to <0,g,b> for default

#macro Wavelet(R1, R2, R3, BaseScale, StartAngle, SweepAngle, NumSpheres, X, Y, Z, Xr, Yr, Zr, C)
	#local N = NumSpheres - 1;
	#local i = 0;
	#while (i < NumSpheres)
		#local R = ((N - i)*R2 + i*R3) / N;
		#local A = i*SweepAngle / N;
		#if (Blob)
		sphere { <0,0,0>, R, 1
		#else
		sphere { <0,0,0>, R*0.8
		#end
			scale <1,1,((N - i)*BaseScale + i) / N>
			translate <-R1, 0, 0>
			rotate <0, 0, -A>
			translate <R1, 0, 0>
			rotate <0, 0, -StartAngle>
			rotate <Xr, Yr, Zr>
			translate <X, Y, Z>
			#if (!White)
				texture {
					#if (C.x > 0)
						pigment { rgb C }
					#else
						pigment { rgb <i/N, 0.5 + 0.5*i/N, 1> }
					#end
				}
			#end
		}
		#local i = i + 1;
	#end
#end

#macro WaveGroup(R1, R2, R3, B, Start, Sweep, NumS, X, Y, Z, Xr, Yr, Zr, C)
	Wavelet(R1, R2, R3, B, Start,                 Sweep, NumS, X, Y, Z, Xr, Yr, Zr, C)
	Wavelet(R1, R2, R3, B, Start+50+20*rand(S1),  Sweep, NumS, X, Y, Z, Xr, Yr, Zr, C)
	Wavelet(R1, R2, R3, B, Start+110+20*rand(S1), Sweep, NumS, X, Y, Z, Xr, Yr, Zr, C)
#end

#macro WaveGroup2(R1, R2, R3, B, Start, Sweep, NumS, X, Y, Z, Xr, Yr, Zr, C)
	WaveGroup(R1, R2, R3, B, Start,                Sweep, NumS, X,   Y, Z,   Xr, Yr, Zr, C)
	WaveGroup(R1, R2, R3, B, Start-10-20*rand(S1), Sweep, NumS, X-1, Y, Z-1, Xr, Yr+10, Zr, C)
	WaveGroup(R1, R2, R3, B, Start+10+20*rand(S1), Sweep, NumS, X-2, Y, Z-2, Xr, Yr+20, Zr, C)
#end

#macro WaveGroup3(R1, R2, R3, B, Start, Sweep, NumS, X, Y, Z, Xr, Yr, Zr, C)
	WaveGroup2(R1, R2, R3, B, Start,             Sweep, NumS, X,     Y,     Z,     Xr,    Yr, Zr, C)
	WaveGroup2(R1, R2, R3, B, Start-20*rand(S1), Sweep, NumS, X-0.5, Y+0.5, Z-0.5, Xr+10, Yr, Zr, C)
	WaveGroup2(R1, R2, R3, B, Start+20*rand(S1), Sweep, NumS, X-1.0, Y+1.0, Z-1.0, Xr+20, Yr, Zr, C)
#end
