
// LIGHTHOUSE
// by Dan S Allsop
// panthus@xtra.co.nz
// for POV-Ray competition July-August 2000: 'The Sea'.

//**********************************************************************************ELEMENTS
#declare Buildings_Switch = on;
#declare Ocean_Switch = on;
#declare Rock_Switch = on;
//*************************************************************************************PAINT
#declare LightHouseTex = texture { 
        pigment { rgb <1.0, 1.0, 1.0> }
        finish { specular 0.2 roughness 0.8 ambient 0.3 }
        normal { gradient y 0.1 scale 0.4 turbulence 1 }
}
#declare LightHouseMetalTex = texture { 
        pigment { rgb <0.6, 0.4, 0.2> }
        finish { specular 0.8 roughness 0.05 reflection 0.1 }
}
#declare LightHouseMetalTurretTex = texture { 
        pigment { rgb <0.6, 0.4, 0.2> }
        finish { specular 0.8 roughness 0.05 reflection 0.1 }
        normal { radial 0.05 frequency 30 }
}
#declare LightHouseWindowTex = texture { 
        pigment { rgbf <0.9, 0.9, 0.9, 0.9> }
        finish { specular 0.2 roughness 0.05 reflection 0.2 }
}
#declare LightHouseLightBulbTex = texture { 
        pigment { rgbf <1, 1, 1, 0.8> }
        finish { specular 0.2 roughness 0.05 }
}
#declare LightHouseBaseTex = texture { 
        pigment { rgb <0.4, 0.4, 0.4> }
        finish { specular 0.2 roughness 0.8 ambient 0.2 }
        normal { bumps 0.05 scale 0.05 }
}
#declare GarageBrickTex = texture { 
        pigment { rgb <0.6, 0.35, 0.2> }
        finish { specular 0.2 roughness 0.3 ambient 0.3 }
        normal { granite 0.025 scale 0.025 }
}
#declare GarageRoofTex = texture { 
        pigment { rgb <0.6, 0.3, 0.2> }
        finish { specular 0.3 roughness 0.2 ambient 0.3 }
        normal { gradient y 0.05 scale 0.05 }
}
#declare GarageWoodTex = texture { 
        pigment { rgb <0.8, 0.65, 0.4> }
        finish { specular 0.2 roughness 0.8 ambient 0.2 }
        normal { radial 0.025 frequency 1000 turbulence 0.5 }
}
#declare GarageVentMetalTex = texture { 
        pigment { rgb <0.8, 0.8, 0.8> }
        finish { specular 0.7 roughness 0.001 reflection 0.2 }
}
#declare GarageDoorTex = texture { 
        pigment { bozo color_map { [ 0.8 rgb <0.6, 0.6, 0.7> ] [ 0.9 rgb <0.4, 0.4, 0.5> ] }
                scale 0.05 turbulence 1 }
        finish { specular 0.1 roughness 0.8 ambient 0.2 }
        normal { gradient z 0.025 scale 0.1 }
}
#declare LampPostBallTex = texture { 
        pigment { rgbf <0.7, 0.7, 0.7, 0.7> }
        finish { specular 0.2 roughness 0.05 reflection 0.2 }
}
#declare FenceTex = texture { 
        pigment { rgb <0.9, 0.9, 0.9> }
        finish { specular 0.4 roughness 0.05 ambient 0.3 }
}
#declare FenceGrillTex =  
        texture {
                pigment { gradient x color_map { [ 0.1 rgb <0.9, 0.9, 0.9> ] 
                [ 0.1 rgbf <1, 1, 1, 1> ] } rotate <0, 0, 45> scale 0.1 }
        }
        texture {
                pigment { gradient x color_map { [ 0.1 rgb <0.9, 0.9, 0.9> ] 
                [ 0.1 rgbf <1, 1, 1, 1> ] } rotate <0, 0, -45> scale 0.1 }
}
#declare SeaBirdTex = texture {
        pigment { rgb <0.9, 0.9, 0.9> }
        finish { ambient 0.3 specular 0.3 roughness 0.8 }
}
#declare HouseWhiteTex = texture {
        pigment { bozo color_map { [ 0.8 rgb <1.0, 1.0, 0.95> ] [ 0.8 rgb 0.95 ] } scale 0.05 }
        finish { ambient 0.4 specular 0.1 roughness 0.01 }
}
#declare HouseBlindTex = texture {
        pigment { rgb <0.9, 0.9, 0.5> }
        finish { ambient 0.7 specular 0.2 roughness 0.7 }
}
#declare HouseRoofTex = texture {
        pigment { rgb <0.5, 0.2, 0.1> }
        finish { ambient 0.3 specular 0.8 roughness 0.001 }
        normal { gradient y 0.05 scale 0.05 }
}
#declare HouseWoodTex = texture { 
        pigment { rgb <0.5, 0.35, 0.1> }
        finish { specular 0.2 roughness 0.8 ambient 0.2 }
        normal { radial 0.025 frequency 1000 turbulence 0.5 }
}
#declare HouseMetalTex = texture { 
        pigment { rgb <0.9, 0.9, 0.9> }
        finish { specular 0.8 roughness 0.001 ambient 0.3 }
}
//********************************************************************************LIGHTHOUSE
#declare LightHouseHull = union {
        difference {
                cone { <0, -2, 0>, 1.8, <0, 6, 0>, 1 }
                cone { <0, -2, 0>, 1.7, <0, 6, 0>, 0.9 }
                cylinder { <0, 5.8, -2>, <0, 5.8, 0>, 0.1 }
                cylinder { <0, 5.8, -2>, <0, 5.8, -1>, 0.15 }
                box { <-0.15, 1, -2>, <0.15, 1.6, 0> }
        }
        cylinder { <0, 6, 0>, <0, 6.2, 0>, 1 }
        cone { <0, 6.2, 0>, 1, <0, 6.5, 0>, 1.2 }
        torus { 1, 0.05 sturm translate <0, 6, 0> }
        torus { 1, 0.05 sturm translate <0, 6.2, 0> }
        torus { 1.05, 0.05 sturm translate <0, 5.6, 0> }
        cylinder { <0, 4.4, 0>, <0, 4.6, 0>, 1.25 }
        cylinder { <0, 5.8, -0.98>, <0, 5.8, -0.97>, 0.15 texture { LightHouseWindowTex } }
        box { <-0.2, 0.9, -1.42>, <0.2, 1.65, -1.41> texture { LightHouseWindowTex } }
        union {
                cylinder { <0, 0.9, -1.42>, <0, 1.65, -1.42>, 0.015 }
                cylinder { <-0.2, 1.2, -1.42>, <0.2, 1.2, -1.42>, 0.015 }
                cylinder { <-0.2, 1.4, -1.42>, <0.2, 1.4, -1.42>, 0.015 }
                texture { LightHouseMetalTex } 
        }
        texture { LightHouseTex }
}
#declare LightHouseTurret = union {
        cylinder { <0, 0.1, 0>, <0, 0.2, 0>, 1.25 }
        difference {
                torus { 1.25, 0.1 sturm translate <0, 0.2, 0> }
                box { <-2, 0.2, -2>, <2, 1, 2> }
        }
        cylinder { <0, 0.2, 0>, <0, 0.25, 0>, 1.45 }
        torus { 1.4, 0.015 sturm translate <0, 0.9, 0> }
        #declare RailCounter=0;
        #while (RailCounter<60)
                cylinder { <0, 0.2, 1.4>, <0, 0.9, 1.4>, 0.015 rotate <0, RailCounter*6, 0> }
                #declare RailCounter=RailCounter+1;
        #end
        cylinder { <0, 1.4, 0>, <0, 1.5, 0>, 0.95 }
        difference {
                torus { 0.95, 0.1 sturm translate <0, 1.5, 0> }
                box { <-2, 1.5, -2>, <2, 2, 2> }
        }
        cylinder { <0, 1.5, 0>, <0, 1.55, 0>, 1.15 }
        torus { 1.1, 0.015 sturm translate <0, 1.9, 0> }
        torus { 1.1, 0.015 sturm translate <0, 2.3, 0> }
        #declare RailCounter=0;
        #while (RailCounter<20)
                cylinder { <0, 1.5, 1.1>, <0, 2.3, 1.1>, 0.015 rotate <0, RailCounter*18, 0> }
                #declare RailCounter=RailCounter+1;
        #end
        cylinder { <0, 0.1, 0>, <0, 1.4, 0>, 0.95 texture { LightHouseMetalTurretTex} }
        difference {
                cylinder { <0, 3.7, 0>, <0, 4.1, 0>, 0.3 }
                torus { 0.3, 0.25 sturm scale <1, 2, 1> translate <0, 4.1, 0> }
        }
        torus { 0.15, 0.025 sturm translate <0, 3.725, 0> }
        torus { 0.1, 0.025 sturm translate <0, 3.85, 0> }
        sphere { <0, 4.05, 0>, 0.1 }
        cone { <0, 4.05, 0>, 0.025, <0, 6.5, 0>, 0 }
        #declare WindowCounter=0;
        #while (WindowCounter<12)
                union {
                        box { <-0.225, 1.5, 0.84>, <0.225, 3.2, 0.85> 
                                texture { LightHouseWindowTex } }
                        cylinder { <0.225, 1.5, 0.85>, <0.225, 3.2, 0.85>, 0.015 }
                        cylinder { <-0.225, 2.1, 0.85>, <0.225, 2.1, 0.85>, 0.015 }
                        cylinder { <-0.225, 2.65, 0.85>, <0.225, 2.65, 0.85>, 0.015 }
                        rotate <0, WindowCounter*30, 0> 
                }
                #declare WindowCounter=WindowCounter+1;
        #end
        difference {
                cylinder { <0, 3.2, 0>, <0, 3.3, 0>, 1 }
                torus { 1, 0.1 sturm translate <0, 3.2, 0> }
        }
        cone { <0, 3.3, 0>, 1, <0, 3.7, 0>, 0.15 }
        texture { LightHouseMetalTex }
}
#declare LightHouseLight = union {
        cylinder { <0, 0, 0>, <0, 0.2, 0>, 0.4 }
        box { <-0.2, 0, -0.2>, <0.2, 0.6, 0.2> }
        cylinder { <-0.2, 0.5, -0.3>, <-0.2, 0.6, 0.3>, 0.1 }
        union {
                difference {
                        box { <-0.4, 0, -0.25>, <0, 0.5, 0.25> }
                        box { <-1, -1, -0.2>, <-0.2, 0.45, 0.2> }
                        sphere { <-0.2, 0.225, 0>, 0.2 }
                }
                sphere { <-0.2, 0.225, 0>, 0.2 texture { LightHouseLightBulbTex } }
                rotate <0, 0, 0>
                translate <-0.1, 0.6, 0>
        }
        texture { LightHouseMetalTex }
}
#declare LightHouse = union {
        object { LightHouseHull }
        object { LightHouseTurret translate <0, 6.4, 0> }
        object { LightHouseLight rotate <0, 10, 0> translate <0, 7.95, 0> }
        box { <-2, -5, -2>, <2, -2, 2> texture { LightHouseBaseTex } }
}
//************************************************************************************GARAGE
#declare Brick_X_Random=seed(12345);
#declare Brick_Z_Random=seed(54321);
#declare Brick_Colour_Random=seed(12321);
#declare SideWall = union {
        //1st Layer
        #declare Bricks_Y_Counter=0;
        #while (Bricks_Y_Counter<5)
        #declare Bricks_X_Counter=0;
        #declare Brick_Y=Bricks_Y_Counter/5;
                #while (Bricks_X_Counter<10)
                #declare Brick_X=Bricks_X_Counter/5;
                #declare Brick_Z=rand(Brick_Z_Random)/100;
                #declare Brick_Colour=rand(Brick_Colour_Random)/10;
                box { <Brick_X, Brick_Y, Brick_Z>, <Brick_X+0.2, Brick_Y+0.1, Brick_Z+0.1> 
                        pigment { rgb <Brick_Colour+0.6, Brick_Colour+0.35, Brick_Colour+0.2> }
                        normal { granite 0.025 scale 0.025 } 
                        finish { specular 0.2 roughness 0.3 ambient 0.3 }
                }
                #declare Bricks_X_Counter=Bricks_X_Counter+1;
                #end
        #declare Bricks_Y_Counter=Bricks_Y_Counter+1;
        #end
        //2nd Layer
        #declare Bricks_Y_Counter=0;
        #while (Bricks_Y_Counter<5)
        #declare Bricks_X_Counter=0;
        #declare Brick_Y=(Bricks_Y_Counter/5)+0.1;
                #while (Bricks_X_Counter<9)
                #declare Brick_X=(Bricks_X_Counter/5)+0.1;
                #declare Brick_Z=rand(Brick_Z_Random)/100;
                #declare Brick_Colour=rand(Brick_Colour_Random)/10;
                box { <Brick_X, Brick_Y, Brick_Z>, <Brick_X+0.2, Brick_Y+0.1, Brick_Z+0.1> 
                        pigment { rgb <Brick_Colour+0.6, Brick_Colour+0.35, Brick_Colour+0.2> }
                        normal { granite 0.025 scale 0.025 } 
                        finish { specular 0.2 roughness 0.3 ambient 0.3 }
                }
                #declare Bricks_X_Counter=Bricks_X_Counter+1;
                #end
        #declare Bricks_Y_Counter=Bricks_Y_Counter+1;
        #end
        box { <0, 0.1, 0>, <0.1, 0.2, 0.1> texture { GarageBrickTex } }
        box { <0, 0.3, 0>, <0.1, 0.4, 0.1> texture { GarageBrickTex } }
        box { <0, 0.5, 0>, <0.1, 0.6, 0.1> texture { GarageBrickTex } }
        box { <0, 0.7, 0>, <0.1, 0.8, 0.1> texture { GarageBrickTex } }
        box { <0, 0.9, 0>, <0.1, 1, 0.1> texture { GarageBrickTex } }
}        
#declare FrontWall = union {
        //1st Layer
        #declare Bricks_Y_Counter=0;
        #while (Bricks_Y_Counter<5)
        #declare Bricks_Z_Counter=0;
        #declare Brick_Y=Bricks_Y_Counter/5;
                #while (Bricks_Z_Counter<9)
                #declare Brick_Z=(Bricks_Z_Counter/5)+0.1;
                #declare Brick_X=rand(Brick_X_Random)/100;
                #declare Brick_Colour=rand(Brick_Colour_Random)/10;
                box { <Brick_X-0.1, Brick_Y, Brick_Z>, <Brick_X, Brick_Y+0.1, Brick_Z+0.2> 
                        pigment { rgb <Brick_Colour+0.6, Brick_Colour+0.35, Brick_Colour+0.2> }
                        normal { granite 0.025 scale 0.025 } 
                        finish { specular 0.2 roughness 0.3 ambient 0.3 }
                }
                #declare Bricks_Z_Counter=Bricks_Z_Counter+1;
                #end
        #declare Bricks_Y_Counter=Bricks_Y_Counter+1;
        #end
        //2nd Layer
        #declare Bricks_Y_Counter=0;
        #while (Bricks_Y_Counter<5)
        #declare Bricks_Z_Counter=0;
        #declare Brick_Y=(Bricks_Y_Counter/5)+0.1;
                #while (Bricks_Z_Counter<10)
                #declare Brick_Z=Bricks_Z_Counter/5;
                #declare Brick_X=rand(Brick_X_Random)/100;
                #declare Brick_Colour=rand(Brick_Colour_Random)/10;
                box { <Brick_X-0.1, Brick_Y, Brick_Z>, <Brick_X, Brick_Y+0.1, Brick_Z+0.2> 
                        pigment { rgb <Brick_Colour+0.6, Brick_Colour+0.35, Brick_Colour+0.2> }
                        normal { granite 0.025 scale 0.025 } 
                        finish { specular 0.2 roughness 0.3 ambient 0.3 }
                }
                #declare Bricks_Z_Counter=Bricks_Z_Counter+1;
                #end
        #declare Bricks_Y_Counter=Bricks_Y_Counter+1;
        #end
        box { <-0.1, 0, 1.9>, <0, 0.1, 2> texture { GarageBrickTex } }
        box { <-0.1, 0.2, 1.9>, <0, 0.3, 2> texture { GarageBrickTex } }
        box { <-0.1, 0.4, 1.9>, <0, 0.5, 2> texture { GarageBrickTex } }
        box { <-0.1, 0.6, 1.9>, <0, 0.7, 2> texture { GarageBrickTex } }
        box { <-0.1, 0.8, 1.9>, <0, 0.9, 2> texture { GarageBrickTex } }
}        
#declare Garage = union {
        difference {
                union {
                        object { SideWall translate <-1, 0, -1> }
                        object { FrontWall translate <1, 0, -1> }
                }
                box { <-0.525, 0.4, -2>, <-0.275, 0.85, 0> } 
                box { <0.275, 0.4, -2>, <0.525, 0.85, 0> } 
                box { <-0.55, 0.8, -2>, <-0.25, 0.85, -0.99> }
                box { <0.25, 0.8, -2>, <0.55, 0.85, -0.99> }
                box { <0, -0.1, -0.7>, <2, 0.85, 0.7> } 
                texture { GarageBrickTex }
        }
        difference {
                box { <-1, 0, -1>, <1, 1, 1> }
                box { <-0.9, 0.001, -0.9>, <0.9, 2, 0.9> }
                box { <-2, 0.001, -2>, <2, 2, 0> rotate <0, -45, 0> }
                texture { GarageBrickTex }
        }
        difference {
                box { <0.925, 0, -0.8>, <0.95, 0.9, 0.8> }
                box { <0, -0.1, -0.65>, <1, 0.8, 0.65> }
                texture { GarageWoodTex }
        }
        box { <1, 0, -0.8>, <1.025, 0.9, 0> texture { GarageDoorTex } }
        box { <-0.55, 0.8, -1>, <-0.25, 0.85, -0.9> texture { GarageWoodTex } }
        box { <0.25, 0.8, -1>, <0.55, 0.85, -0.9> texture { GarageWoodTex } }
        box { <-0.525, 0.37, -1.03>, <-0.275, 0.41, -0.9> texture { GarageWoodTex } }
        box { <0.275, 0.37, -1.03>, <0.525, 0.41, -0.9> texture { GarageWoodTex } }
        difference {
                cylinder { <-0.5, 0.65, 0>, <-0.3, 0.65, 0>, 0.15 }
                box { <-1, 0, -1>, <0, 0.65, 1> }
                scale <1, 1, 1.5> translate <0, 0, -0.95>
                texture { GarageVentMetalTex }
        }
        box { <-0.5, 0.6, -1.175>, <-0.3, 0.65, -0.9> texture { GarageVentMetalTex } }
        #declare ShuttersCounter=0;
        #while (ShuttersCounter<7)
                box { <-0.6, 0, 0>, <0.6, 0.05, 0.01> rotate <15, 0, 0>
                        translate <0, 0.41+(ShuttersCounter/18), -0.98>
                        texture { GarageWoodTex } }
                #declare ShuttersCounter=ShuttersCounter+1;
        #end
        difference {
                box { <-1.05, 1, -1.05>, <1.05, 2, 1.05> }
                box { <-2, 0, 0>, <2, 3, 3> rotate <-70, 0, 0> translate <0, 1, 1.05> }
                box { <-2, 0, -3>, <2, 3, 0> rotate <70, 0, 0> translate <0, 1, -1.05> }
                box { <-3, 0, -2>, <0, 3, 2> rotate <0, 0, -60> translate <-1.05, 1, 0> }
                box { <0, 0, -2>, <3, 3, 2> rotate <0, 0, 60> translate <1.05, 1, 0> }
                texture { GarageRoofTex }
        }
        difference {
                box { <-1.03, 0.8, -1.03>, <1.03, 1, 1.03> }
                box { <-2, -1, 0>, <2, 0, 1> rotate <40, 0, 0> translate <0, 1, 1.03> }
                box { <-2, -1, -1>, <2, 0, 0> rotate <-40, 0, 0> translate <0, 1, -1.03> }
                box { <-1, -1, -2>, <0, 0, 2> rotate <0, 0, 40> translate <-1.03, 1, 0> }
                box { <0, -1, -2>, <1, 0, 2> rotate <0, 0, -40> translate <1.03, 1, 0> }
                texture { GarageWoodTex }
        }
}
//*************************************************************************************HOUSE
#declare Blind_Height=seed(6956);
#declare TiledWall = union {
        #declare TilesCounter=0;
        #while (TilesCounter<10)
                #declare TilesXCounter=0;
                #while (TilesXCounter<20)
                	box { <-0.14, 0, 0>, <0, 0.15, 0.01> rotate <15, 0, 0>
                        	translate <-(TilesXCounter/10)*1.5, (TilesCounter/10)*1.5, 0>
                        }
                        #declare TilesXCounter=TilesXCounter+1;
                #end
                #declare TilesCounter=TilesCounter+1;
        #end
}
#declare HorizontalWall = union {
        #declare BoardsCounter=0;
        #while (BoardsCounter<10)
                box { <-2, 0, 0>, <0, 0.1, 0.01> rotate <15, 0, 0>
                        translate <0, BoardsCounter/10, 0>
                }
                #declare BoardsCounter=BoardsCounter+1;
        #end
}
#declare HouseWindow = union {
        difference {
                box { <0, 0.1, 0.025>, <0.5, 1, 0.1> }
                box { <0.08, 0.55, 0>, <0.42, 0.88, 1> }
                box { <0.08, 0.23, 0>, <0.42, 0.52, 1> }
                texture { HouseMetalTex }
        }
        box { <0, 0.55, 0.05>, <0.5, 1, 0.075> texture { LightHouseWindowTex } }
        box { <0, 0.1, 0.075>, <0.5, 0.55, 0.1> texture { LightHouseWindowTex } }
}
#declare HouseWoodBorder = union {
	difference {
		box { <-2.05, 1, -0.05>, <0.05, 1.05, 2.05> }
		box { <-3, 0, 0.2>, <1, 2, 1.8> }
		texture { HouseWoodTex } 
	}
	difference {
		box { <-2.025, 0.95, -0.025>, <0.025, 1.05, 2.025> }
		box { <-3, 0, 0.2>, <1, 2, 1.8> }
		texture { HouseWoodTex } 
	}
}
#declare HouseDoor = union {
        difference {
                box { <-0.04, 0, 0.025>, <0.39, 0.89, 0.1> }
                box { <0.02, 0.44, 0>, <0.33, 0.83, 1> }
                box { <0.02, 0.06, 0>, <0.33, 0.38, 1> }
        }
        union {
        	cylinder { <0.26, 0.87, 0.02>, <0.5, 0.87, 0.02>, 0.01 }
	        cylinder { <0.3, 0.87, 0.02>, <0.32, 0.87, 0.02>, 0.015 }
               	texture { HouseMetalTex } 
        }
        box { <0.02, 0.06, 0.05>, <0.35, 0.83, 0.075> texture { LightHouseWindowTex } }
}
#declare Chimney = union {
	box { <-0.1, 0, -0.1>, <0.1, 0.5, 0.1> texture { GarageBrickTex  
		normal { brick 0.1 scale 1.5 } } }
	box { <-0.1, 0.5, -0.1>, <0.1, 0.55, 0.1> texture { HouseWoodTex } }
	cylinder { <0, 0.5, 0>, <0, 0.6, 0>, 0.075 pigment { rgb <0.1, 0.1, 0.1> } }
}
#declare HouseLeftMost = union {
	difference {
		object { HorizontalWall translate <0, 0, 0> }
                box { <-1.55, 0.1, -1>, <-1.15, 0.81, 1> }
                box { <-1.05, -0.1, -1>, <-0.6, 0.81, 1> }
        }
	object { HorizontalWall rotate <0, -90, 0> translate <0, 0, 2> }
	difference {
		box { <-1.95, 0, 0.05>, <-0.05, 1, 1.95> }
		box { <-1.9, -0.1, 0.1>, <-0.1, 0.9, 1.9> }
                box { <-1.55, 0.1, -1>, <-1.15, 0.81, 1> }
                box { <-1.05, -0.1, -1>, <-0.6, 0.81, 1> }
        }
        object { HouseWindow translate <-1.6, -0.1, 0> }
        box { <0, 0.6, 0.075>, <0.5, 1, 0.1> texture { HouseBlindTex } 
        	translate <-1.6, rand(Blind_Height)/8-0.1, 0> }
        object { HouseDoor translate <-1, -0.1, 0> }
       	box { <-2.04, -0.05, -1.2>, <0.04, 0, 0> rotate <-30, 0, 0> translate <0, 1.65, 1> 
       		texture { HouseRoofTex } }
       	box { <-2.04, -0.05, 0>, <0.04, 0, 1.2> rotate <30, 0, 0> translate <0, 1.65, 1> 
       		texture { HouseRoofTex } }
	object { HouseWoodBorder }
	difference {
		object { HorizontalWall rotate <0, -90, 0> translate <0, 1, 2> }
	       	box { <-3, -0.025, -2>, <1, 1, 1> rotate <-30, 0, 0> translate <0, 1.65, 1> }
	       	box { <-3, -0.025, -1>, <1, 1, 2> rotate <30, 0, 0> translate <0, 1.65, 1> } 
       	}
	difference {
		box { <-2.05, 1, 0.05>, <-0.05, 2, 1.95> }
	       	box { <-3, -0.025, -2>, <1, 1, 1> rotate <-30, 0, 0> translate <0, 1.65, 1> }
	       	box { <-3, -0.025, -1>, <1, 1, 2> rotate <30, 0, 0> translate <0, 1.65, 1> } 
       	}
       	cylinder { <-0.1, 0, -0.05>, <-0.1, 0.95, -0.05>, 0.025 texture { HouseMetalTex } }
}
#declare HouseLeftNext = union {
	difference {
		object { HorizontalWall translate <0, 0, 0> }
		box { <-0.4, 0.1, -1>, <1, 0.81, 1> }
	}
	difference {
		object { HorizontalWall translate <2, 0, 0> }
                box { <0.25, 0.1, -1>, <0.65, 0.81, 1> }
        }
	object { HouseWindow translate <-0.45, -0.1, 0> }
        box { <0, 0.6, 0.075>, <0.5, 1, 0.1> texture { HouseBlindTex } 
        	translate <-0.45, rand(Blind_Height)/8-0.1, 0> }
	object { HouseWindow translate <0.2, 0, 0> }
        box { <0, 0.6, 0.075>, <0.5, 1, 0.1> texture { HouseBlindTex } 
        	translate <0.2, rand(Blind_Height)/8-0.1, 0> }
	difference {
		box { <-1.95, 0, 0.05>, <1.95, 1, 1.95> }
		box { <-1.9, -0.1, 0.1>, <1.9, 0.9, 1.9> }
                box { <-0.4, 0.2, -1>, <0, 0.91, 1> }
                box { <0.25, 0.2, -1>, <0.65, 0.91, 1> }
        }
	object { HouseWoodBorder }
	object { HouseWoodBorder translate <2, 0, 0> }
       	box { <-1.04, -0.05, -1.35>, <2.04, 0, 0> rotate <-39, 0, 0> translate <0, 1.9, 1> 
       		texture { HouseRoofTex } }
       	box { <-1.04, -0.05, 0>, <2.04, 0, 1.35> rotate <39, 0, 0> translate <0, 1.9, 1> 
       		texture { HouseRoofTex } }
	difference {
		box { <-0.95, 1, 0.05>, <1.95, 2, 1.95> }
	       	box { <-3, -0.025, -2>, <3, 1, 1> rotate <-39, 0, 0> translate <0, 1.9, 1> }
	       	box { <-3, -0.025, -1>, <3, 1, 2> rotate <39, 0, 0> translate <0, 1.9, 1> } 
       	}
	translate <1, 0, 0.6>
}
#declare HouseLeft = union {
	difference {
		object { HorizontalWall translate <0, 0, 0> }
		box { <-1, 0.1, -1>, <-0.6, 0.81, 1> }
	}
	object { HouseWindow translate <-1.05, -0.1, 0> }
        box { <0, 0.6, 0.075>, <0.5, 1, 0.1> texture { HouseBlindTex } 
        	translate <-1.05, rand(Blind_Height)/8-0.1, 0> }
	difference {
		box { <-1.95, 0, 0.05>, <-0.05, 1, 1.95> }
		box { <-1.9, -0.1, 0.1>, <-0.1, 0.9, 1.9> }
                box { <-1, 0.1, -1>, <-0.6, 0.81, 1> }
        }
	object { HouseWoodBorder }
	difference {
		object { TiledWall translate <0, 1.05, 0> }
		box { <-4, 0, -1>, <-2, 3, 1> }
		box { <-4, 1.7, -1>, <1, 3, 1> }
	}
	difference {
		box { <-1.95, 1, 0.05>, <-0.05, 1.7, 1.95> }
		box { <-1.9, 0, 0.1>, <-0.1, 1.6, 1.9> }
        }
	object { HouseWoodBorder translate <0, 0.7, 0> }	
       	difference {
       		union {
       			box { <-2.04, -0.05, -1.2>, <0.04, 0, 0> rotate <-30, 0, 0> 
       				translate <0, 2.35, 1> texture { HouseRoofTex } }
		       	box { <-2.04, -0.05, 0>, <0.04, 0, 1.2> rotate <30, 0, 0> 
		       		translate <0, 2.35, 1> texture { HouseRoofTex } }
		}
		box { <-1.45, 1.5, 0.15>, <-0.05, 2.5, 2.05> }
		box { <-2, -1, -1>, <0, 2, 3> rotate <0, 0, -10> translate <-2.04, 1.75, 0> }
	}
	difference {
		box { <-1.95, 1.7, 0.05>, <-0.05, 2.7, 1.95> }
	       	box { <-3, -0.025, -2>, <0, 1, 1> rotate <-30, 0, 0> translate <0, 2.35, 1> }
	       	box { <-3, -0.025, -1>, <0, 1, 2> rotate <30, 0, 0> translate <0, 2.35, 1> } 
		box { <-2, -1, -1>, <0, 2, 3> rotate <0, 0, -10> translate <-1.95, 1.75, 0> }
       	}
       	difference {
       		cylinder { <-1.8, 0, -0.05>, <-1.8, 1.65, -0.05>, 0.025 }
       		box { <-2, 0.9, -1>, <-1, 1.1, 1> }
       		texture { HouseMetalTex } 
       	}
       	torus { 0.1, 0.025 sturm rotate <0, 0, 90> translate <-1.8, 1, -0.05>
       		texture { HouseMetalTex } }
	translate <4.5, 0.1, -0.4> 	
}
#declare HouseLeftTop = union {
	difference {
		object { HorizontalWall translate <0, 0, 0> }
		box { <-1.7, 0.5, -1>, <-1.3, 0.8, 1> }
	}
	difference {
		box { <-1.95, 0, 0.05>, <-0.05, 1, 1.95> }
		box { <-1.9, -0.1, 0.1>, <-0.1, 0.9, 1.9> }
		box { <-1.7, 0.5, -1>, <-1.3, 0.8, 1> }
        }
        difference {
        	box { <-1.75, 0.45, 0.025>, <-1.25, 0.85, 0.1> }
        	box { <-1.67, 0.53, 0>, <-1.33, 0.77, 1> }
        	texture { HouseMetalTex }
        }
        box { <-1.7, 0.5, 0.05>, <-1.3, 0.8, 0.075> texture { LightHouseWindowTex } }
	object { HouseWoodBorder }
       	difference {
       		union {
       			box { <-2.04, -0.05, -1.2>, <0.04, 0, 0> rotate <-30, 0, 0> 
       				translate <0, 1.65, 1> texture { HouseRoofTex } }
       			box { <-2.04, -0.05, 0>, <0.04, 0, 1.2> rotate <30, 0, 0> 
       				translate <0, 1.65, 1> texture { HouseRoofTex } }
       		}
		box { <-2, -1, -1>, <0, 2, 3> rotate <0, 0, -60> translate <-2.04, 1.05, 0> }
	}
	object { Chimney translate <-0.5, 1.4, 1> }       		
	difference {
		box { <-1.95, 1, 0.05>, <-0.05, 2, 1.95> }
	       	box { <-3, -0.025, -2>, <1, 1, 1> rotate <-30, 0, 0> translate <0, 1.65, 1> }
	       	box { <-3, -0.025, -1>, <1, 1, 2> rotate <30, 0, 0> translate <0, 1.65, 1> } 
		box { <-2, -1, -1>, <0, 2, 3> rotate <0, 0, -60> translate <-1.95, 1.05, 0> }
       	}
	translate <5, 1.5, -0.3>
}
#declare HouseMain = union {
	difference {
		object { HorizontalWall translate <0, 0, 0> }
		box { <-1.4, 0.1, -1>, <-1, 0.81, 1> }
	}
	difference {
		object { HorizontalWall translate <1, 0, 0> }
		box { <0, 0.1, -1>, <0.4, 0.81, 1> }
	}
	difference {
		box { <-1.95, 0, 0.05>, <0.95, 1, 1.95> }
		box { <-1.9, -0.1, 0.1>, <0.9, 0.9, 1.9> }
		box { <-1.4, 0.1, -1>, <-1, 0.81, 1> }
		box { <0, 0.1, -1>, <0.4, 0.81, 1> }
		box { <-1, -0.1, 0.35>, <1, 0.81, 0.8> }
        }
	difference {
		object { HorizontalWall rotate <0, -90, 0> translate <1, 0, 2> }
		box { <-1, -0.1, 0.35>, <1, 0.81, 0.8> }
	}
	object { HouseWindow translate <-1.45, -0.1, 0> }
        box { <0, 0.6, 0.075>, <0.5, 1, 0.1> texture { HouseBlindTex } 
        	translate <-1.45, rand(Blind_Height)/8-0.1, 0> }
	object { HouseWindow translate <-0.05, -0.1, 0> }
        box { <0, 0.6, 0.075>, <0.5, 1, 0.1> texture { HouseBlindTex } 
        	translate <-0.05, rand(Blind_Height)/8-0.1, 0> }
	object { HouseDoor rotate <0, -90, 0> translate <1, -0.1, 0.4> }
	object { HouseWoodBorder }
	object { HouseWoodBorder translate <1, 0, 0> }
	difference {
		object { TiledWall translate <1, 1.05, 0> }
		box { <-1.05, 1.59, -1>, <-0.65, 2.3, 1> }
		box { <-0.35, 1.59, -1>, <0.05, 2.3, 1> }
		box { <-3, 0, -1>, <0, 3, 3> rotate <0, 0, -40> translate <-2, 1.6, 0> }
		box { <0, 0, -1>, <3, 3, 3> rotate <0, 0, 40> translate <1, 1.6, 0> }
	}
	difference {
		box { <-1.95, 1, 0.05>, <0.95, 2.5, 1.95> }
		box { <-1.9, 0, 0.1>, <0.9, 2.4, 1.9> }
		box { <-1.05, 1.59, -1>, <-0.65, 2.3, 1> }
		box { <-0.35, 1.59, -1>, <0.05, 2.3, 1> }
		box { <-3, 0, -1>, <0, 3, 3> rotate <0, 0, -40> translate <-2, 1.6, 0> }
		box { <0, 0, -1>, <3, 3, 3> rotate <0, 0, 40> translate <1, 1.6, 0> }
        }
	object { HouseWindow translate <-1.1, 1.38, 0.01> }
        box { <0, 0.6, 0.075>, <0.5, 1, 0.1> texture { HouseBlindTex } 
        	translate <-1.1, rand(Blind_Height)/8+1.38, 0.01> }
	object { HouseWindow translate <-0.4, 1.38, 0.01> }
        box { <0, 0.6, 0.075>, <0.5, 1, 0.1> texture { HouseBlindTex } 
        	translate <-0.4, rand(Blind_Height)/8+1.38, 0.01> }
	difference {
		box { <-1.5, 2.5, 0>, <0.5, 3.6, 2> }
		box { <-1.4, 0, 0.1>, <0.4, 3.5, 1.9> }
		box { <-0.63, 2.7, -1>, <-0.37, 3.18, 1> }
		box { <-3, 0, -1>, <0, 3, 3> rotate <0, 0, -40> translate <-2, 1.6, 0> }
		box { <0, 0, -1>, <3, 3, 3> rotate <0, 0, 40> translate <1, 1.6, 0> }
		#declare VertCounter=0;
	        #while (VertCounter<20)
        	        box { <-1.5, 2, -1>, <-1.49, 4, 0.05> 
        	        	translate <VertCounter/10, 0, 0> 
        	        }
                	#declare VertCounter=VertCounter+1;
        	#end
        }
        difference {
        	box { <-0.65, 2.65, 0.025>, <-0.35, 3.2, 0.1> }
        	box { <-0.6, 2.73, 0>, <-0.4, 3.15, 1> }
        	texture { HouseMetalTex }
        }
        box { <-0.63, 2.7, 0.05>, <-0.37, 3.18, 0.075> texture { LightHouseWindowTex } }
	difference {
		object { HouseWoodBorder translate <0, 1.5, 0> }
		box { <-3, 0, -1>, <0, 3, 3> rotate <0, 0, -40> translate <-2, 1.6, 0> }
	}		
	difference {
		object { HouseWoodBorder translate <1, 1.5, 0> }
		box { <0, 0, -1>, <3, 3, 3> rotate <0, 0, 40> translate <1, 1.6, 0> }
	}
	union {
		box { <0, -0.035, -0.06>, <2.41, 0, 4> rotate <0, 0, -50> 
			translate <-0.5, 3.55, 0> texture { HouseRoofTex } }
		box { <-2.4, -0.035, -0.06>, <0, 0, 4> rotate <0, 0, 50> 
			translate <-0.5, 3.55, 0> texture { HouseRoofTex } }
	}
	object { Chimney translate <-0.5, 3.3, 0.5> }
	object { Chimney translate <-0.5, 3.3, 3.5> }
	union {
		box { <0, -0.1, -0.025>, <2.41, 0, 4> rotate <0, 0, -50> 
			translate <-0.5, 3.5, 0> }
       		box { <-2.4, -0.1, -0.025>, <0, 0, 4> rotate <0, 0, 50> 
       			translate <-0.5, 3.5, 0> }
		box { <0, -0.05, -0.05>, <2.41, 0, 4> rotate <0, 0, -50> 
       			translate <-0.5, 3.5, 0> }
       		box { <-2.4, -0.05, -0.05>, <0, 0, 4> rotate <0, 0, 50> 
       			translate <-0.5, 3.5, 0> }
       		texture { HouseWoodTex } 
	}
	difference {
		union {
			box { <-2.05, 1.65, -0.05>, <1.05, 1.7, 0> }
			box { <-2.025, 1.6, -0.05>, <1.025, 1.7, 0> }
		}
		box { <-1.8, 1.5, -1>, <0.8, 2, 1> }
		texture { HouseWoodTex }
	}		
        translate <6, 0.1, -0.8>
}
#declare HouseRight = union {
	difference {
		object { HorizontalWall translate <1.55, 0, 0> }
		box { <-3, -1, -1>, <-0.1, 2, 1> }
		box { <0, -0.1, -1>, <2, 0.85, 1> }
	}
	difference {
		box { <0.8, 0, 0.05>, <1.5, 1, 3.75> }
		box { <0.85, -0.1, 0.1>, <1.45, 0.9, 3.7> }
		box { <1.05, -0.1, -1>, <1.45, 0.55, 1> }
		cylinder { <1.25, 0.55, -1>, <1.25, 0.55, 1>, 0.2 }
		box { <0, 0.1, 3>, <2, 0.81, 3.4> }
		box { <0, 0.1, 2.1>, <2, 0.81, 2.5> }
        }
	object { HouseWoodBorder translate <1.55, 0, 0> }
	difference {
		box { <1, 0, -0.025>, <1.525, 0.85, 0.05> }
		box { <1.05, -0.1, -1>, <1.45, 0.55, 1> }
		cylinder { <1.25, 0.55, -1>, <1.25, 0.55, 1>, 0.2 }
		texture { HouseWoodTex }
	}
	box { <1.5, 0, -0.05>, <1.55, 1, 0> texture { HouseWoodTex } }
	box { <1, 0.8, -0.05>, <1.55, 0.85, 0> texture { HouseWoodTex } }
	difference {
		object { TiledWall translate <1.75, 1.05, 0> }
		box { <0, -3, -1>, <3, 3, 1> rotate <0, 0, 40> translate <1, 1.6, 0> }
		box { <-3, 0, -1>, <0.9, 3, 1> }
	}
	difference {
		box { <0.95, 1, 0.05>, <1.7, 2.5, 3.75> }
		box { <1, 0, 0.1>, <1.65, 2.4, 3.7> }
		box { <0, -3, -1>, <3, 3, 4> rotate <0, 0, 40> translate <1, 1.6, 0> }
        }
	box { <2.4, -0.035, -0.06>, <3.25, 0, 3.8> rotate <0, 0, -50> 
		translate <-0.5, 3.55, 0> texture { HouseRoofTex } }
	union {
		box { <2.4, -0.1, -0.025>, <3.2, 0, 3.8> rotate <0, 0, -50> 
			translate <-0.5, 3.5, 0> }
		box { <2.4, -0.05, -0.05>, <3.2, 0, 3.8> rotate <0, 0, -50> 
       			translate <-0.5, 3.5, 0> }
       		texture { HouseWoodTex } 
	}
	object { HorizontalWall rotate <0, -90, 0> translate <1.55, 0, 2> }
	difference {
		object { HorizontalWall rotate <0, -90, 0> translate <1.55, 0, 3.8> }
		box { <0, 0.2, 3>, <2, 0.91, 3.4> }
		box { <0, 0.2, 2.1>, <2, 0.91, 2.5> }
	}
	object { HouseWindow rotate <0, -90, 0> translate <0, -0.1, 2.95> }
        box { <0, 0.6, 0.075>, <0.5, 1, 0.1> texture { HouseBlindTex } 
        	rotate <0, -90, 0> translate <0, rand(Blind_Height)/8-0.1, 2.95> }
	object { HouseWindow rotate <0, -90, 0> translate <0, -0.1, 2.05> }
        box { <0, 0.6, 0.075>, <0.5, 1, 0.1> texture { HouseBlindTex } 
        	rotate <0, -90, 0> translate <0, rand(Blind_Height)/8-0.1, 2.05> }
	object { HouseWoodBorder rotate <0, -90, 0> translate <1.55, 0, 2> }
	object { HouseWoodBorder rotate <0, -90, 0> translate <1.55, 0, 3.8> }
	translate <6, 0.1, -0.6>
}
#declare HouseRightTop = union {
	difference {
		object { HorizontalWall }
		box { <-1.5, 0.1, -1>, <-1.1, 0.81, 1> }
		box { <-0.9, 0.1, -1>, <-0.5, 0.81, 1> }
	}
	object { HorizontalWall rotate <0, 90, 0> translate <-2, 0, 0> }
	difference {
		box { <-1.95, 0, 0.05>, <-0.05, 1, 1.95> }
		box { <-1.9, -0.1, 0.1>, <-0.1, 0.9, 1.9> }
		box { <-1.5, 0.1, -1>, <-1.1, 0.81, 1> }
		box { <-0.9, 0.1, -1>, <-0.5, 0.81, 1> }
        }
        object { HouseWindow translate <-1.55, -0.1, 0> }
        box { <0, 0.6, 0.075>, <0.5, 1, 0.1> texture { HouseBlindTex } 
        	translate <-1.55, rand(Blind_Height)/8-0.1, 0> }
        object { HouseWindow translate <-0.95, -0.1, 0> }
        box { <0, 0.6, 0.075>, <0.5, 1, 0.1> texture { HouseBlindTex } 
        	translate <-0.95, rand(Blind_Height)/8-0.1, 0> }
	object { HouseWoodBorder }
	object { HouseWoodBorder rotate <0, 90, 0> translate <-2, 0, 0> }
       	difference {
       		box { <-2.04, 1.05, -0.04>, <0.04, 2.3, 2.04> }
       		box { <-3, -1, -1>, <0, 3, 3> rotate <0, 0, -45> translate <-2.04, 1.05, 0> }
       		box { <0, -1, -1>, <3, 3, 3> rotate <0, 0, 45> translate <0.04, 1.05, 0> }
       		box { <-3, 0, -3>, <1, 3, 0> rotate <40, 0, 0> translate <0, 1.05, -0.04> }
       		texture { HouseRoofTex }
       	}
       	rotate <0, -90, 0> 
       	translate <7.3, 1.3, 3>
}
#declare HouseComplete = union {
	object { HouseLeftMost }
	object { HouseLeftNext }
	object { HouseLeft }
	object { HouseLeftTop }
	object { HouseMain }
	object { HouseRight }
	object { HouseRightTop }
	texture { HouseWhiteTex }
}
//**********************************************************************************LAMPPOST
#declare LampPostArm = union {
        cylinder { <0, 0, 0>, <1, 0, 0>, 0.1 }
        sphere { <1, 0, 0>, 0.1 }
        cylinder { <1, 0, 0>, <1, 0.5, 0>, 0.1 }
        torus { 0.1, 0.1 sturm translate <1, 0.5, 0> }
        sphere { <1, 1.05, 0>, 0.5 texture { LampPostBallTex } }
        texture { LightHouseMetalTex }
        translate <0, 1, 0>
}
#declare LampPost = union {
        cylinder { <0, -3, 0>, <0, 1, 0>, 0.1 }
        torus { 0.1, 0.1 sturm translate <0, 0.8, 0> }
        torus { 0.1, 0.1 sturm translate <0, 0.5, 0> }
        sphere { <0, 1, 0>, 0.1 }
        object { LampPostArm rotate <0, 0, 0> }
        object { LampPostArm rotate <0, 120, 0> }
        object { LampPostArm rotate <0, 240, 0> }
        texture { LightHouseMetalTex }
}        
//*************************************************************************************FENCE
#declare FenceWobble=seed(4065);
#declare FenceBob=seed(8255);
#declare Fence = union {
        #declare PostCounter=0;
        #while (PostCounter<4)
                union {
                        cylinder { <0, -1, 0>, <0, 1, 0>, 0.06 }
                        sphere { <0, 1, 0>, 0.06 }
                        cylinder { <0, 0.3, 0>, <2, 0.3, 0>, 0.03 }
                        cylinder { <0, 0.6, 0>, <2, 0.6, 0>, 0.03 }
                        cylinder { <0, 0.9, 0>, <2, 0.9, 0>, 0.03 }
                        rotate <0, 0, rand(FenceWobble)*6-3>
                        translate <PostCounter*2, rand(FenceBob)/10, 0>
                        texture { FenceTex } 
                }
                #declare PostCounter=PostCounter+1;
        #end
        union {
                cylinder { <8, -1, 0>, <8, 1, 0>, 0.06 }
                sphere { <8, 1, 0>, 0.06 }
                cylinder { <8, 0.3, 0>, <10, -0.1, 0>, 0.03 }
                cylinder { <8, 0.6, 0>, <10, 0.2, 0>, 0.03 }
                cylinder { <8, 0.9, 0>, <10, 0.5, 0>, 0.03 }
                texture { FenceTex }
        }
        union {
                #declare PostCounter=5;
                #while (PostCounter<15)
                        union {
                                cylinder { <0, -1, 0>, <0, 1, 0>, 0.06 }
                                sphere { <0, 1, 0>, 0.06 }
                                cylinder { <0, 0.3, 0>, <2, 0.3, 0>, 0.03 }
                                cylinder { <0, 0.6, 0>, <2, 0.6, 0>, 0.03 }
                                cylinder { <0, 0.9, 0>, <2, 0.9, 0>, 0.03 }
                                rotate <0, 0, rand(FenceWobble)*6-3>
                                translate <PostCounter*2, rand(FenceBob)/10, 0>
                                texture { FenceTex } 
                        }
                        #declare PostCounter=PostCounter+1;
                #end
                rotate <0, 0, 1> translate <0, -0.7, 0>
        }
        union {
                cylinder { <-0.1, -1, 0>, <-0.1, 1, 0>, 0.03 texture { FenceTex } }
                #declare PostCounter=1;
                #while (PostCounter<10)
                        union {
                                cylinder { <0, -1, 0>, <0, 1, 0>, 0.03 }
                                cylinder { <0, 0.5, 0>, <0.5, 0.5, 0>, 0.03 }
                                cylinder { <0, 1, 0>, <0.5, 1, 0>, 0.03 }
                                box { <0, 0, -0.001>, <0.5, 1, 0.001> 
                                        texture { FenceGrillTex } }
                                rotate <0, 0, rand(FenceWobble)*6-3>
                                translate <-((PostCounter/2)+0.1), rand(FenceBob)/10, 0>
                                texture { FenceTex } 
                        }
                        #declare PostCounter=PostCounter+1;
                #end
                rotate <0, 0, -2>
        }
        //LOOKOUT
        union {
                cylinder { <-4, -1, 1>, <-4, 1.5, 1>, 0.03 }
                cylinder { <-4, 1.4, 1>, <-4, 1.5, 1>, 0.05 }
                difference {
                        box { <-4.25, 1.5, 0.7>, <-3.75, 1.9, 1.3> }
                        box { <-1, -1, -1>, <0, 1, 1> rotate <0, 0, 20> 
                                translate <-4.25, 1.9, 1> }
                        box { <-4, 1, 0.8>, <-3, 1.8, 1.2> }
                        texture { GarageVentMetalTex }
                }
                box { <-4, 1.65, 0.69>, <-3.8, 1.8, 0.8> pigment { rgb <1, 0.8, 0.7> } }
                texture { LightHouseMetalTex }
        }
}        
//***********************************************************************************SEABIRD
#declare SeaBird = union {
	sphere { <0, 0, 0> 0.75 scale <2, 0.75, 1> }
	intersection {
		difference {
			sphere { <0, 0, 0>, 1 }
			sphere { <0, 0, 0>, 0.99 }
		}
		sphere { <0, 0, 0>, 1 scale <0.5, 1, 1> translate <0, 0.5, -0.5> }
		scale 2 translate <0, -2, -1> rotate <40, 0, 0>
	}
	intersection {
		difference {
			sphere { <0, 0, 0>, 1 }
			sphere { <0, 0, 0>, 0.99 }
		}
		sphere { <0, 0, 0>, 1 scale <0.5, 1, 1> translate <0, 0.5, 0.5> }
		scale 2 translate <0, -2, 1> rotate <-40, 0, 0>
	}
	union {
		cylinder { <0, -1, -0.2>, <0, 0, -0.2>, 0.1 }
		cylinder { <0, -1, 0.2>, <0, 0, 0.2>, 0.1 }
		rotate <0, 0, -20>
	}
	texture { SeaBirdTex }
	scale <1, 1, 2>
}        
//*************************************************************************************OCEAN
#if (Ocean_Switch=on)
#declare OceanRadius=seed(3654);        #declare OceanScaleX=seed(8965);
#declare OceanScaleZ=seed(5487);        #declare OceanPositionX=seed(5839);
#declare OceanPositionY=seed(9473);     #declare OceanPositionZ=seed(2846);
#declare OceanRearDensity=1500;		#declare OceanRearCounter=0;
#declare OceanMidDensity=1500;		#declare OceanMidCounter=0;
#declare OceanForeDensity=7000;		#declare OceanForeCounter=0;
#declare OceanSlice = blob {
        threshold 0.5
        #while (OceanRearCounter<OceanRearDensity)
                sphere { 0, rand(OceanRadius)+1, rand(OceanRadius)+1
                        scale <rand(OceanScaleX)+0.5, 0.25, rand(OceanScaleZ)+0.5>
                        translate <rand(OceanPositionX)*15-20, rand(OceanPositionZ)/4,
                                rand(OceanPositionZ)*100+10>
                }
                #declare OceanRearCounter=OceanRearCounter+1;
        #end
        #while (OceanMidCounter<OceanMidDensity)
                sphere { 0, rand(OceanRadius)/4+0.5, rand(OceanRadius)/4+0.5
                        scale <rand(OceanScaleX)+0.5, 0.5, rand(OceanScaleZ)+0.5>
                        translate <rand(OceanPositionX)*5-7, rand(OceanPositionZ)/4,
                                rand(OceanPositionZ)*20-5>
                }
                #declare OceanMidCounter=OceanMidCounter+1;
        #end
        #while (OceanForeCounter<OceanForeDensity)
                sphere { 0, rand(OceanRadius)/8+0.25, rand(OceanRadius)/8+0.25
                        scale <rand(OceanScaleX)+0.5, 0.5, rand(OceanScaleZ)+0.5>
                        translate <rand(OceanPositionX)*6-3, rand(OceanPositionZ)/8+0.25,
                                rand(OceanPositionZ)*11-12>
                }
                #declare OceanForeCounter=OceanForeCounter+1;
        #end
        sturm
        scale <2, 1, 1>
}
#declare Ocean = difference {
	object { OceanSlice }
	object { OceanSlice translate <0, -0.001, 0> }
       	pigment { gradient y color_map { [ 0.0 rgbf <0.3, 0.5, 0.5, 0.4> ]
       		[ 1.0 rgb <0.75, 0.75, 0.8> ] } scale 2 turbulence 1 }
	finish { specular 0.8 roughness 0.001 reflection 0.4 }
	normal { ripples 0.05 frequency 1000 scale 50 }
        translate <0, 1.6, 0>
}
#declare OceanEnd = difference {
	plane { y, 1.65 }
        box { <-20, 0, -15>, <20, 2, 110> }
       	pigment { rgbf <0.3, 0.5, 0.5, 0.4> }
       	finish { specular 0.8 roughness 0.001 reflection 0.4 ambient 0.2 }
       	normal { bumps 1 scale 5 scale <2, 1, 1> }
}
#declare OceanFloor = plane { y, 0 pigment { rgb <0.2, 0.1, 0.0> } }
#end
//*************************************************************************************ROCKS
#if (Rock_Switch=on)
#declare Rock_Bit_Radius_Rand=seed(4109);       #declare Rock_Bit_Scale_X_Rand=seed(5040);
#declare Rock_Bit_Scale_Y_Rand=seed(5891);      #declare Rock_Bit_Scale_Z_Rand=seed(4960);
#declare Rock_Scale_X_Rand=seed(2547);          #declare Rock_Scale_Y_Rand=seed(2278);
#declare Rock_Scale_Z_Rand=seed(7453);          #declare Rock_Rotate_X_Rand=seed(7722); 
#declare Rock_Position_X_Rand=seed(8901);       #declare Rock_Position_Y_Rand=seed(6561);
#declare Rock_Position_Z_Rand=seed(1099);       #declare Rock_Colour_Rand=seed(3439);  
#declare Rock_Density=10000;                   

#declare Rock_Counter=0;
#declare Rocks = union {
        #while (Rock_Counter<Rock_Density)
        #declare Rock_Bit = sphere { 0, rand(Rock_Bit_Radius_Rand)+0.5
                scale <rand(Rock_Bit_Scale_X_Rand)+0.5, 
                        rand(Rock_Bit_Scale_Y_Rand)+0.5,
                        rand(Rock_Bit_Scale_Z_Rand)+0.5>
        }
        #declare Rock = union {
                intersection {
                        object { Rock_Bit }
                        box { <-2, -2, -2>, <2, 0, 2> }
                        scale <1, 5, 1>
                }
                object { Rock_Bit }
        }
        object { Rock
                #declare Rock_Colour=rand(Rock_Colour_Rand)/8;
                scale <rand(Rock_Scale_X_Rand)+0.5, rand(Rock_Scale_Y_Rand)/5+0.25, 
                        rand(Rock_Scale_Z_Rand)+0.5>
                scale 0.125
                rotate <-(rand(Rock_Rotate_X_Rand)*30), 0, 0>
                #declare Rock_Position_X = rand(Rock_Position_X_Rand)*18-9;
                #declare Rock_Position_Y = rand(Rock_Position_Y_Rand)*2.5+1;
                #declare Rock_Position_Z = rand(Rock_Position_Z_Rand)*15-5;
                #while (Rock_Position_X<-4.5 & Rock_Position_Y>3 |
                        Rock_Position_X<-5 & Rock_Position_Y>2.75 |
                        Rock_Position_X<-5.5 & Rock_Position_Y>2.5 |
                        Rock_Position_X<-6 & Rock_Position_Y>2.25 |
                        Rock_Position_X<-6.5 & Rock_Position_Y>2 |
                        Rock_Position_X<-7 & Rock_Position_Y>1.75 |
                        Rock_Position_X<-7.5 & Rock_Position_Y>1.5 |
                        Rock_Position_X<-8 & Rock_Position_Y>1.25 |
                        Rock_Position_X<-8.5 & Rock_Position_Y>1 )
                        #declare Rock_Position_X = rand(Rock_Position_X_Rand)*18-9;
                #end
                #while (Rock_Position_Z<0 & Rock_Position_Y>3 |
                        Rock_Position_Z<-0.5 & Rock_Position_Y>2.75 |
                        Rock_Position_Z<-1 & Rock_Position_Y>2.5 |
                        Rock_Position_Z<-1.5 & Rock_Position_Y>2.25 |
                        Rock_Position_Z<-2 & Rock_Position_Y>2 |
                        Rock_Position_Z<-2.5 & Rock_Position_Y>1.75 |
                        Rock_Position_Z<-3 & Rock_Position_Y>1.5 |
                        Rock_Position_Z<-3.5 & Rock_Position_Y>1.25 |
                        Rock_Position_Z<-4 & Rock_Position_Y>1 )
                        #declare Rock_Position_Z = rand(Rock_Position_Z_Rand)*15-5;
                #end
                #if (Rock_Position_Z<-1) scale -Rock_Position_Z #end 
                pigment { rgb <Rock_Colour+0.4, Rock_Colour+0.3, Rock_Colour+0.2> }
                normal { gradient x 0.25 scale 0.05 turbulence 1 rotate <0, 0, -45> }
                finish { specular 0.1 roughness 0.01 ambient 0.3 }
                #if (Rock_Position_Y>3.2) pigment { gradient y color_map {
                	[ 0.7 rgb <Rock_Colour+0.4, Rock_Colour+0.3, Rock_Colour+0.2> ]
                	[ 1.0 rgb <Rock_Colour+0.35, Rock_Colour+0.4, Rock_Colour+0.2> ] }
                	scale 2 turbulence 1 translate <0, -1.5, 0> }
                #end
                #if (Rock_Position_Y<2.4)
                	pigment { rgb <Rock_Colour+0.35, Rock_Colour+0.25, Rock_Colour+0.15> }
                	finish { specular 0.2 roughness 0.01 ambient 0.3 }
                #end
                #if (Rock_Position_Y<2.2)
                	pigment { rgb <Rock_Colour+0.3, Rock_Colour+0.2, Rock_Colour+0.1> }
                	finish { specular 0.3 roughness 0.01 ambient 0.3 }
                #end
                #if (Rock_Position_Y<2.0)
                	pigment { rgb <Rock_Colour+0.25, Rock_Colour+0.15, Rock_Colour+0.05> }
                	finish { specular 0.4 roughness 0.01 ambient 0.3 }
                #end
                translate <Rock_Position_X, Rock_Position_Y, Rock_Position_Z>                             
        }
        #declare Rock_Counter=Rock_Counter+1;
        #end
}
#end
//***********************************************************************************DISPLAY
sky_sphere { pigment { gradient y color_map { [ 0.0 rgb <0.1, 0.25, 0.3> ] 
        [ 0.05 rgb <0.8, 0.85, 0.9> ] [ 1.0 rgb <0.2, 0.35, 0.5> ] } scale 0.5 }
        pigment { bozo color_map { [ 0.1 rgbf <1, 1, 1, 0.2> ]
        [ 0.7 rgbf <1, 1, 1, 1> ] } turbulence 1 scale <0.25, 0.1, 0.1> } }
#if (Rock_Switch=on)
	object { Rocks rotate <0, 0, 0> translate <1.2, 0.1, 0> } 
#end
#if (Ocean_Switch=on) 
	object { Ocean } 
	object { OceanEnd }
	object { OceanFloor }
#end
#if (Buildings_Switch=on)
	object { LightHouse rotate <0, 40, 0> translate <2, 5.5, 25> }
	object { Garage scale 1.8 rotate <0, 25, 0> translate <-2.5, 4, 20> }
	object { HouseComplete scale 1.1 rotate <0, 35, 0> translate <5.3, 3.8, 20> }
	object { LampPost scale 0.3 rotate <0, 20, 0> translate <0.6, 4.8, 18> }
	object { Fence scale 0.5 rotate <0, 15, 0> translate <-2.7, 3.8, 11> }
#end
object { SeaBird scale 0.05 rotate <0, 50, 0> translate <-9, 12, 29> }
object { SeaBird scale <0.05, 0.05, 0.03> rotate <30, 70, 40> translate <-9, 12, 24> }
light_source { <-10, 20, -20> color rgb <1, 1, 1> }
camera { location <0, 3, -15> look_at <0, 3, 25> direction 1.5*z }
