/////////////////////////////////////////////////////////////////
// "Sky" (reverse ior test)
////////////////////////////////////
// made by Miroslav Hundak in 1999.

#declare TEXTURE_PREVIEW = 0;
#declare THEFOG = 1;
#declare THESEA = 1;
#declare SKY = 1;
#declare CLOUDPLANE = 0;
#declare CLOUDOBJECT = 0;
#declare DUMMIE = 0;
#declare BALL = 1;

#declare CAM_N = 1;

#include "texture.inc"
#include "skies.inc"

global_settings {
	ambient_light rgb <0.5, 0.5, 1> 
	max_trace_level 100
	radiosity {
		distance_maximum 50000
	}
}

#if(CAM_N = 1)
camera {
	location <0, 15, 0>
	look_at <0, 0, 100>
	angle 60
	rotate x*(-10)
}
#end
#if(CAM_N = 2)
camera {
	location <0, 20, 0>
	look_at <0, 20, 100>
	angle 60
	rotate x*(-10)
}
#end


light_source { <0, 20000, 100000> color rgb <1, 0.8, 0.1> }
//light_source { <0, 10000, -10000> color rgb <0.1, 0.2, 0.7>*0.3 }

#if(SKY)
sky_sphere {
	pigment {
		gradient y
		color_map {
			[0.0 color rgb <1, 0.3, 0.2>]
			[0.5 color rgb <0.1, 0.3, 0.7>]
			[0.8 color rgb <0.0, 0.3, 0.5>]
			[1 color rgb <0.0, 0.2, 0.4>]
		}
		scale 0.65
		rotate x*(-2)
	}
	pigment {
		radial
		color_map {
			[0.15 color rgbf <1, 0.8, 0, 0.6> ]
			[0.23 color rgbf <1, 0.8, 0, 1.0> ]
			[0.77 color rgbf <1, 0.8, 0, 1.0> ]
			[0.85 color rgbf <1, 0.8, 0, 0.6> ]
			[1.00 color rgbf <1, 0.8, 0, 0.6> ]
		}
		scale 0.65
		rotate x*90
		rotate x*(-2)
		frequency 18
	}
	pigment {
		onion
		color_map {
			[0.006 color rgbf <1, 1, 0, 0>*2 ]
			[0.013 color rgbf <1, 1, 0, 0.5>*2 ]
			[0.050 color rgbf <1, 1, 1, 0.5>*2 ]
			[0.100 color rgbf <1, 0.8, 0.1, 1> ]
		}
		scale <5, 1, 1>
		scale 0.3
		translate z*1000 
		rotate x*(-2)
	}
}
#end

#if(THEFOG)
fog {
	fog_type 2
	distance 1000
	color rgbf <1, 0.6, 0.1, 0.3>*1
	fog_offset 0
	fog_alt 20
	turbulence 0.3
}
#end

#if(THESEA)
plane { y, 0
	texture {
		txWater_1
		scale 5
		translate <20, 2, 65>
		//scale <8, 1, 1>*3
	}
}
#end

#if(CLOUDPLANE)
mesh { 
	triangle { <-20, 2, 50>*2000, <-20, 2, -10>*2000, <20, 2, 50>*2000 }
	triangle { <20, 2, 50>*2000, <20, 2, -10>*2000, <-20, 2, -10>*2000 }
	texture {
		pigment { P_Cloud1 }
		finish {
			//ambient 0.5
		}
		scale 300
		translate x*(-1000)
	}
}
#end

#if(CLOUDOBJECT)

#macro Cloud(A)
sphere { <0, 0, 0>, 1.5
	pigment { color rgbt 1 }
	interior {
		media {
      		scattering { 1, color rgb <1, 1, 1> }
      		intervals 10
      		samples 1, 10
      		confidence 0.9999
      		variance 1/1000
      		density {
        		spherical
        		ramp_wave
        		turbulence 1
        		color_map {
          			[0.0 color rgb <0, 0, 0>]
          			[0.1 color rgb <1, 0, 0>]
          			[1.0 color rgb <1, 1, 0>]
        		} 
      		}
			scale 1
		}
	}
	hollow
}
#end

object { 
	Cloud(0.0)
	scale <2, 1, 2>*1000
	translate <2000, 6000, 10000>
}

#end

// dummie object
#if(DUMMIE)
sphere { <0, 0, 0>, 1
	translate z*4
	texture {
		pigment {
			radial
			color_map {
				[0.0 color rgbt <1, 0.8, 0.1, 0.5> ]
				[0.4 color rgbt <1, 0.8, 0.1, 0.5> ]
				[0.41 color rgbt <1, 0.8, 0.1, 1> ]
				[1 color rgbt <1, 1, 1, 1> ]
			}
			scale 1
			rotate x*90
			frequency 12
			//translate y*4
		}
		finish { ambient 1 }
	}
}
sphere { <0, 0, 0>, 0.95
	translate z*4
	texture { txBlank
		finish { ambient 1 }
	}
}
#end

// ball on sea
#if(BALL)
sphere { <0, 0, 0>, 4
	texture { 
		pigment {
			spiral1 1
			color_map {
				[ 0 color rgb <1, 0, 0> ]
				[ 0.5 color rgb <1, 0, 0> ]
				[ 0.501 color rgb <1, 1, 1> ]
				[ 1.0 color rgb <1, 1, 1> ]
			}
			frequency 1
			//turbulence 0.1
		}
		finish {
			phong 1
			phong_size 60
			ambient 0.25
		} 
		scale 4
		rotate <-10, 45, 0>
	}
/*
	texture {
		pigment {
			radial
			color_map {
				[ 0 color rgbt <1, 0, 0, 0> ]
				[ 0.3 color rgbt <1, 0, 0, 0> ]
				[ 0.301 color rgbt <1, 1, 1, 1> ]
				[ 1 color rgbt <1, 1, 1, 1> ]
			}
			frequency 8
		}
		finish {
			phong 1
			phong_size 60
			ambient 0.4
		}
		rotate <-105, 47, 0>
	}
*/
	translate <20, 2, 70>
}
#end