#version unofficial MegaPov 0.5;

#declare correct = <1, 1, 1>/<1, 1, .9>;

#macro Ciel(CLOUDS)
  #local correct = <1, 1, 1>/<1, .95, .9>;
  #if (CLOUDS = 1)
    //#declare dark_color=rgb <0.78, 0.8, 0.8>;
    #declare dark_color=rgb 1.05;
    #declare light_color=rgb 1.05;
    #declare height=8000*100;
    #declare cloud_level=.58;//.90
    #declare planes=20;
    #declare pdist=2000*100/planes;
    #declare ppatt=pigment{wrinkles}
    #declare pturb=.9;//<.4, .4, .4>;
    #declare pocta=9;
    #declare plamb=3;
    #declare pomeg=.5;
    #declare tdist=pdist-1000*100;
    #declare sfactor=<10000, 10000, 10000>*100;
    #declare dfactor=.9;
    #declare border=.15;
    #declare fstart=.7;
    #declare fend=.8;
    object{
      clouds(
	dark_color,         // color for lower parts
	light_color,        // color for upper parts
	height,             // heigth to first layer
	cloud_level,        // level of "cloudiness"(?)
	planes,             // number of planes
	pdist,              // distance between planes
	ppatt,              // pigment pattern
	pturb,              // amount of turbulence
	pocta,              // and its modifiers
	plamb,
	pomeg,
	tdist,              // distance between textures
	sfactor,            // scaling factor
	dfactor,            // darkening factor
	border,             // width of change zone
	fstart,             // filter for lower layer
	fend                // filter for upper layer
      )
      hollow
      no_shadow
      rotate 5*y
      rotate 5*z
    }
  #end
#end

sky_sphere{
  pigment{
    gradient y color_map{
      [0 rgb <.5, .6, .7>*1.5*1.2*correct]
      //[.5 rgb <.3, .3, .6>]
      [.5 rgb <.7, .85, 1.0>*1.2*correct]
    }
    turbulence .1
    translate -.2*y
  }
}

#macro Fog()
  fog {
    distance 10000
    color rgbft<.990, .990, 1, 0.9, 0.2>
    fog_type 2
    fog_offset 1000
    fog_alt -600
    up -y
    turbulence 200 turb_depth 0.9 omega 10 lambda .5 octaves 5 scale 1e6
}
#end
