// ******************************
// *** NON-MEDIA CLOUDS MACRO ***
// ******************************

// Jaime Vives Piqueres, (?)1999.
// jaime@ctav.es
// http://members.xoom.com/jaimevives

// macro : clouds(dc,lc,h,cl,np,pd,ptr,pturb,pocta,plamb,pomeg,td,s,df,b,fs,fe)
//
// Useful for day/night skies, but not for dawn/sunset, due to the "horizontal
// nature of the trick (a stack of planes).
//
//   parameters:
//
//       + dark color       : color for lower layer
//       + light color      : color for upper layer
//       + height           : height of the lower layer
//       + clouds level     : level of clouds (0=none, 1=full)
//       + number of planes : number of layers (resolution)
//       + planes distance  : distance between succesive layers
//       + pigment pattern  : i.e. pigment{granite}
//       + texture distance : distance between succesive textures
//       + scale            : scaling factor
//       + dark factor      : texture darkening factor
//       + border width     : width of transition zone
//       + filter start     : filter starts at n.n (0..1)
//       + filter end       : filter ends at n.n (0..1)
//
// note : don't forget to raise max_trace_level!!!

#macro clouds(dc,lc,h,cl,np,pd,ptr,pturb,pocta,plamb,pomeg,td,ss,df,b,fs,fe)

#local cnt=1;
#local cl_tmp=((1-cl-b)/np);

union{

#while (cnt<=np)

 #local p1=dc*(1-(cnt/np))+lc*(cnt/np);
 #local p2=dc*(1-(cnt/np))*df+lc*(cnt/np)*df;

// sphere{
//  <0, -1000000, 0>, 1000000
  plane {-y, 0
  texture{
   pigment{
    ptr
    octaves pocta
    lambda plamb
    omega pomeg
    turbulence pturb
    color_map{
     [0.0  rgbf <1, 1, 1, 1>]
     [cl   rgbf <1, 1, 1, 1>]
     [cl+b p1 filter fs+(fe-fs)*(cnt/np)]
     [1.0  p2 filter fs+(fe-fs)*(cnt/np)]
    }
    scale ss
   }
   finish{ambient 1 diffuse 0}
   translate (h+td*cnt)*y
  }
  translate (h+pd*cnt)*y
  clipped_by {
  	plane {
  		y, -50
  		inverse
  	}
  }
 }
 #local cl=cl+cl_tmp*.5;
 #local cnt=cnt+1;
#end

}

#end // of macro (yet! it's so simple!)

