#version unofficial MegaPov 0.5;  
global_settings {max_trace_level 40} 
              
camera { 
	location <0, 0.5, -1>
	look_at <0, 0.53, 0.0> 
}

light_source {
    <0, 4, 12> 
    color rgb <0.8, 0.75, 0.5>                                                                             
    spotlight
    point_at <0, 0, -2>
    tightness 0
    radius 120
    falloff 150  
} 

// Fire bottom - (0,0) top - (0,4) radius - 1

#declare AreaLightSelected = 0; // 1 - smooth shadows
#declare SamplingSelected = 1;  // 1 - smooth flame
#declare LightColor = color rgb <1, 0.6, 0.3>; 

#declare AreaLight = light_source {
    0 
    color LightColor 
    area_light x, y, 8, 8
    adaptive 1 
    fade_distance 2 
    fade_power 2
}

#declare NormalLight = light_source {
    0 
    color LightColor
    fade_distance 2 
    fade_power 2
}

#declare Fire = merge {
    sphere {0, 1}
    difference {
        sphere {0, 1 scale <1, 3, 1>}
        plane {y, 0}
    }   
    
    #if(AreaLightSelected)
        object {AreaLight} 
    #else
        object {NormalLight}
    #end
      
    pigment{rgbf 1}
    interior {
        media {
            emission rgb 1
            absorption rgb 0.01
            density {
                spherical 
                color_map {
                    [0.00 rgb 0] 
                    [0.10 rgb <1, 0.1, 0>*2.8]
                    [0.20 rgb <1, 0.5, 0>*2.8]
                    [0.35 rgb <1, 1, 0>*2.8]
                    [0.50 rgb 1*2.5] 
                    [0.60 rgb <1, 0.9, 1>*2.5]
                    [0.65 rgb 0]
                } 
                scale <1, 1.6, 1> 
                translate -0.8*y 
                turbulence <0.15, 0.3, 0.15> 
                octaves 5 
                lambda 5 
                omega 1
            }
            #if(SamplingSelected) 
                samples 1, 200 
                variance 0.001 
                confidence 0.999
            #end
        }
    }
    translate y*1
    scale <1, 2, 1>
    hollow
}                

// origin 0, 0, 0
#macro BubblesCube(w, h, d, maxBubbleRadius, numOfBubbles, seedValue)
    #local lseed = seed(seedValue);
    #local counter=0;  
    #while (counter != numOfBubbles)
        #local lx = w * rand(lseed);
        #local ly = h * rand(lseed); 
        #local lz = d * rand(lseed);
        sphere {
            <lx, ly, lz>, 
            maxBubbleRadius * rand(lseed)
            no_shadow
        }  
        #local counter = counter + 1;
    #end
#end

#macro BubblesSphere(bunchRadius, bunchHeight, cutLevel, maxBubbleRadius, numOfBubbles, seedValue)
    #local lseed = seed(seedValue);
    #local counter=0;  
    #while (counter != numOfBubbles)
        #local alfa = 2*pi*rand(lseed);
        #local beta = acos(2 * rand(lseed) - 1);
        #local lx = bunchRadius * cos(alfa) * sin(beta);
        #local ly = (bunchHeight/2 * sin(alfa) * sin(beta)) + bunchHeight/2; 
        #local lz = bunchRadius * cos(beta);
        #if(ly <= cutLevel)
            sphere {
                <lx, ly, lz>, 
                maxBubbleRadius * rand(lseed)
                no_shadow
            }  
        #end
        #local counter = counter + 1;
    #end
#end  

#macro BubblesSphereExtended(bunchRadius, bunchHeight, cutLevel, maxBubbleRadius, numOfBubbles, seedValue, extender)
    #local lseed = seed(seedValue);
    #local counter=0;  
    #while (counter != numOfBubbles)
        #local alfa = 2*pi*rand(lseed);
        #local beta = acos(2 * rand(lseed) - 1);
        #local lx = bunchRadius * cos(alfa) * sin(beta);
        #local ly = (bunchHeight/2 * sin(alfa) * sin(beta)) + bunchHeight/2 + (extender * rand(lseed)); 
        #local lz = bunchRadius * cos(beta);
        #if(ly <= cutLevel)
            sphere {
                <lx, ly, lz>, 
                maxBubbleRadius * rand(lseed)
                no_shadow
            }  
        #end
        #local counter = counter + 1;
    #end
#end

#macro BubblesCylinder(bunchRadius, bunchHeight, maxBubbleRadius, numOfBubbles, seedValue)
    #local lseed = seed(seedValue);
    #local counter=0;  
    #while (counter != numOfBubbles)
        #local alfa = 2*pi*rand(lseed);
        #local beta = acos(2 * rand(lseed) - 1);
        #local lx = bunchRadius * cos(alfa) * sin(beta);
        #local ly = bunchHeight*rand(lseed); 
        #local lz = bunchRadius * cos(beta);
        sphere {
            <lx, ly, lz>, 
            maxBubbleRadius * rand(lseed)
            no_shadow
        }  
        #local counter = counter + 1;
    #end
#end 
    
#declare Candle = union { 
    object {Fire scale <1, 1, 1> scale 1/3 scale <0.7, 0.7, 0.7> translate -y*0.18}
    union{BubblesSphere(0.2, 0.4, 0.4, 0.02, 400, 1000) translate -y*0.2}
    union {BubblesCylinder(0.2, 5, 0.03, 400, 1000) translate -y*5} 
    union {BubblesCylinder(0.2, 5, 0.01, 3000, 1000) translate -y*5}
    pigment{ rgbft <1, 1, 1, 0.8, 0.1>}
    finish {ambient 0.1 phong 1 phong_size 60}
    interior{ior 1.2}      
}

#declare Sea = height_field {   // sea level = -1.4
    pattern 4000, 4000 {
        hf_gray_16
		wrinkles
		color_map {
			[ 0.0 color rgb 0.0 ]
			[ 0.5 color rgb 0.05 ]
			[ 1.0 color rgb 0.0 ]
		} 
		scale 0.015
	}  
	texture { 
	    pigment {color rgb <0, 0.09, 0.2>}
	    finish {ambient 0 phong 0.8 phong_size 30 
	        reflection 0.35
	    }
	}    
	translate <-0.5, 0, -0.5>    
	scale <25, 0.5, 15> 
	translate -y*1.4 
}
	
#declare Clouds = box {
    <-200000, -400000, -200000>, 
    <200000, 5000, 200000>
    material{
        texture{pigment{ rgbf 1}}
        interior{
            media{            
                scattering {2, 0.005 extinction 1}
                method 2
                samples 30, 30  
                intervals 1
                density { 
                    wrinkles  
                    ramp_wave                                      
                    octaves 5
                    turbulence 0.4                                                    
                    color_map {           
                        [0.00 rgb 0]
                        [0.45 rgb 0]         
                        [0.50 rgb 0.275]   
                        [0.65 rgb 0.475]   
                        [0.80 rgb 0]
                        [1.00 rgb 0]        
                    } 
                    scale <10000, 1000, 10000>
                    translate <1000, 197000,0>
                } 
                    
                density {
                    wrinkles
                    poly_wave
                    color_map {           
                        [0.00 rgb 0]
                        [0.40 rgb 0]          
                        [0.47 rgb 0.3]
                        [0.65 rgb .5]
                        [0.80 rgb 0]
                        [1.00 rgb 0]         
                    }             
                    scale <10000, 1000, 10000>
                    translate <1000, 197000, 0>
                } 
            }
        }
    }
    hollow
    rotate <23, 0, 0>
    translate -y*700   
}          

#declare Flame = union { 
    object {Fire scale <0.9, 1, 0.9> scale 1/3}
    union {
        union{BubblesSphere(0.2, 0.4, 0.4, 0.02, 400, 1000) translate -y*0.2}
        union {BubblesCylinder(0.2, 5, 0.035, 800, 1000) translate -y*5}
        pigment{ rgbft <1, 1, 1, 0.8, 0.1>}
        finish {ambient 0.1 phong 1 phong_size 60}
        interior{ior 1.2} 
        translate y*0.2
    }
}  

#declare Submarine = union { 
    // body
    union{BubblesSphere(5, 10, 5, 0.4, 400, 1000) translate -y*5 rotate -z*90} 
    union{BubblesSphere(5, 10, 5, 0.3, 1000, 1000) translate -y*5 rotate -z*90}
    
    union {BubblesCylinder(5, 50, 0.4, 1500, 1000) rotate -z*90} 
    union {BubblesCylinder(5, 50, 0.3, 1500, 1000) rotate -z*90}
    
    union{BubblesSphereExtended(5, 10 * 10, 5 * 10, 0.4, 3000, 1000, 10) translate -y*5*10 rotate z*90 translate x*50} 
    union{BubblesSphereExtended(5, 10 * 10, 5 * 10, 0.3, 3000, 1000, 10) translate -y*5*10 rotate z*90 translate x*50}
    
    // top
    union {BubblesCylinder(1, 3.5, 0.4, 60, 1000) translate <17, 5, 0>}
    union {BubblesCube(12, 4, 2, 0.4, 300, 1000) translate <18, 5, -1>} 
    union {BubblesCylinder(1, 3.5, 0.4, 60, 1000) translate <30, 5, 0>}
    // per.
    union {BubblesCylinder(0.2, 6, 0.2, 100, 1000) translate <26, 8.5, 0>} 
    union {BubblesCylinder(0.3, 4, 0.2, 100, 1000) translate <27, 8.5, 0>}
    // tail
    union {BubblesCube(4, 5.5, 1, 0.4, 150, 1000) rotate -z*20 translate <92, 1.5, -0.5>} 
    union {BubblesCylinder(0.3, 6, 0.4, 60, 1000) rotate -z*90 translate <94, 6, 0>} 
    union {BubblesCube(4, 4, 1, 0.4, 100, 1000) rotate z*10 translate <93, -5.2, -0.5>}
    
    pigment{ rgbft <1, 1, 1, 0.8, 0.1>}
    finish {ambient 0.1 phong 1 phong_size 60}
    interior{ior 1.2}
    scale 0.11
}      
    
sky_sphere {
    pigment {
        gradient y 
        color_map { 
            [0.0 color rgb <1, 0.9, 0.65>*3] 
            [0.6 color rgb<0.4, 0.6, 0.8>*4] 
        }
        rotate <10, 0, 0>
    }
}     
    
object {Sea}
object {Sea translate -x*0.5*25*2}
object {Clouds translate x*15}
object {Flame translate <0, -0.75, 3>} 
object {Candle rotate y*10 translate <-2.6, 2.45, 4>} 
object {Candle rotate y*60 translate <-1.9, -0.1, 4.5>} 
object {Candle rotate y*30 translate <-1.1, 0.7, 6>}   
object {Candle rotate y*90 translate <1.3, 0.7, 5>}  
object {Candle rotate y*120 translate <2.2, 3.1, 5.5>} 
object {Candle rotate y*160 translate <2.5, 0.4, 4>}   
object {Submarine scale 0.65 translate <-3.3, 1.9, 5>} 

 
