//	Persistence of Vision Ray Tracer Scene Description File
//	File: erupt2.pov
//	Date: 000715
//	Author: Joost Egelie
//	Deep Sea Eruption
//	Made with Unofficial MacMegaPOV v0.5 by
//	Yvo & Ren Smellenbergh ( smellenbergh@skynet.be )
//	

#include "colors.inc"
#include "textures.inc"

#version unofficial MegaPov 0.5;

#declare RenderAtmos=on;

#declare Camera_Location = <0.0, 5.1, 14>;
#declare Camera_Lookat = <0.0, 1, 0.001>;
 
global_settings {
	ambient_light rgb <0.099001, 0.122469, 0.299992>
	assumed_gamma 1.8
}


camera {
	cylinder  2
	location Camera_Location
	up x*9 right y*16
	angle 80
	look_at Camera_Lookat
	normal{bozo 1 turbulence <1,0.1,1>}
	aperture 2
	blur_samples 32
	focal_point Camera_Lookat

}


#if(RenderAtmos=on)
	fog {
		fog_type 1	//constant_fog
		distance 7.0
		rgb <0.05, 0.25, 0.25>
		turbulence 1
		turb_depth 0.4
	}
	
	media {
		absorption rgb <0.0399992, 1, 1.000000>/8
		emission rgb <0.000031, 0.619989, 0.7>/100
		samples 1,  1
		confidence 0.9
		variance 1/64
		ratio 0.7
	}
#end

height_field {
	png "soil.PNG"
	smooth 
	hollow
	texture  {
		material_map {
			png "magma.png"
			map_type 0	//planar
			once
			texture {
				pigment{rgbf <0.192157, 0.192157, 0.192157, 0.0>}
			}
			texture {
				pigment{rgbf <0.369986, 0.236790, 0.241245, 0.0>}				
			}
			texture{
				pigment {
					gradient y
					color_map {
						[ 0.0 rgbf <0.192157, 0.192157, 0.192157, 0.0> ]
						[ 0.9 rgbf <0.369986, 0.236790, 0.241245, 0.0> ]
						[ 0.98 rgbf <0.869993, 0.096284, 0.69612, 0.4> ]
						[ 0.998 rgbf <1.000000, 0.456001, 0.180018, 0.8> ]
						[ 1.0 rgbf <1.000000, 0.799985, 0.730007, 1> ]
					}
					turbulence 1
					rotate<0,90,0>
					scale <0.25,0.125,0.25>
				}
			}
		}
	}
	#if(RenderAtmos = on)
		interior {
			ior 1.3
			media {
				scattering {
					1,	//isotropic_scattering
					rgb <0.849989, 0.259937, 0.127520>
					extinction -10
				}
			}
		}
	#end
	translate -0.5
	scale<50,5,50>
}

#declare rnd=seed(123);
#declare C = 0;
#declare Copies = 8192;

union{
	#while ( C < Copies)
			#declare rx = sin(rand(rnd)*pi);
			#declare ry = cos(rand(rnd)*pi/2);
			#declare rz = sin(rand(rnd)*pi);
		sphere {
			<0.0, 0.0, 0.0>, (1-(sqrt(pow((1-2*rx),2)+pow((1-2*rz),2)/2)))/1.5
			translate x*rx*6
			translate y*ry*5
			translate z*rz*6
		}
		#declare C = C +1;
	#end
	texture{
		pigment {
			rgbf <1,1,1,0.49>
		}
		finish {Dull}
	}
	hollow
	translate<-3,-1,-3>
	scale 2
	translate<0,2,0>
}


//In order to crank up the poor emission from those light_sources,
//we just double the stakes.
//These light sources would be from the submarine.

#declare Lamp1 = light_source {
	<2,0,0>
	rgb <0.860014, 0.974350, 1.000000>
	spotlight
 	translate Camera_Location
	point_at <2.0, 5.5, -0.5>
	radius 25
	falloff 90
	tightness 10
	media_attenuation
}
object {Lamp1}
object {Lamp1}

#declare Lamp2 = light_source {
	Camera_Location
	rgb <0.860014, 0.974350, 1.000000> 
	spotlight
	point_at Camera_Lookat
	radius 25
	falloff 90
	tightness 10
	fade_distance 24.0
	fade_power 1
	media_attenuation
}
object {Lamp2}
object {Lamp2}