#include "colors.inc"
#include "boats.inc"
#include "starshape.inc"

camera {
	location -z*5
	up <0, 5/3, 0>
	right <8/3, 0, 0>
	orthographic
}

background { SlateBlue }

#declare TitleTex = texture {
	pigment { Red+0.1*(y+z) }
	finish { ambient 1 }
}
#declare SmallTitleTex = texture {
	pigment { Yellow+0.1*z }
	finish { ambient 1 }
}
#declare EdgeTex = texture {
	pigment { SlateBlue*0.7 }
	finish { ambient 1 }
}
#declare BoatTex = texture {
	pigment { LightGray }
	finish { ambient 1 }
}
#declare StickerTex = texture {
	pigment { Red+0.1*(y+z) }
	finish { ambient 1 }
}
#declare StickerWordsTex = texture {
	pigment { Yellow+0.1*z }
	finish { ambient 1 }
}

text {
	ttf "ariblk.ttf" // Arial Black
	"SEA"
	0.1,
	x*0.1
	texture { TitleTex }
	scale 1.5
	translate <-6.75, 2.5, 0>
}

text {
	ttf "ariblk.ttf" // Arial Black
	"BATTLES"
	0.1,
	x*0.1
	texture { TitleTex }
	scale 1.5
	translate <-6.75, 1.25, 0>
}

text {
	ttf "ariblk.ttf" // Arial Black
	"" // the registered trademark sign has ASCII value 168 in Arial Black
	0.1,
	0
	texture { TitleTex }
	scale 0.4
	translate <1.75, 2, 0>
}

text {
	ttf "arial.ttf"
	"The Game of Naval Warfare"
	0.1,
	x*0.05
	texture { SmallTitleTex }
	scale 0.8
	translate < -6.75, 0.5, 0>
}

#declare edge = 0.9;

prism { linear_sweep linear_spline 0, 1, 10,
	<-8, -5>, <8, -5>, <8, 5>, <-8, 5>, <-8, -5>,
	<-8+edge, -5+edge>, <8-edge, -5+edge>, <8-edge, 5-edge>, <-8+edge, 5-edge>, <-8+edge, -5+edge>
	texture { EdgeTex }
	rotate -x*90
	translate z*3
}

#declare Boat1 = object {
	SmallBoat
	texture { BoatTex }
	scale 0.4
}

#declare Boat2 = object {
	MediumBoat
	texture { BoatTex }
	scale 0.4
}

#declare Boat3 = object {
	LargeBoat
	texture { BoatTex }
	scale 0.4
}

// 20-spiked sticker
union {
	object {
		Star(20,1,1.3)
		rotate -90*x
		texture { StickerTex }
		scale <2, 1, 1>
		translate <1.6, -0.1, 2>
	}

	text {
		ttf "ariblk.ttf" // Arial Black
		"Now With"
		0.1,
		x*0.05
		texture { StickerWordsTex }
		scale 0.5
		translate x*0.3
	}

	text {
		ttf "ariblk.ttf" // Arial Black
		"Real Water!"
		0.1,
		x*0.05
		texture { StickerWordsTex }
		scale 0.5
		translate <0, -0.5, 0>
	}
	scale 1.25
	rotate z*30
	translate <3.75, 2.25, 0>
}

object { Boat1 translate <-6.7, -4, 0> }
object { Boat1 translate <1.5, -4, 0> }
object { Boat2 translate <3.7, -4, 0> }
object { Boat3 translate <-4.3, -4, 0> }