#include "colors.inc"
#include "boats.inc"
#include "metals.inc"
#include "woods.inc"

global_settings {
	number_of_waves 15
	radiosity {
		brightness 5
		distance_maximum 0.15
		count 500
		minimum_reuse 0.001
		recursion_limit 2
	}
}

camera {
	up 5/8*y
	right x
	location <0, 4, -6>
	look_at <0, 3, 0>
}

light_source {
	<0, 6.5, 0>
	color White*1.7
	area_light x*2, z*2, 5, 5
	adaptive 1
	jitter
}

#declare WallTex = texture {
	pigment { White }
}
#declare GameBoardTex = texture {
	pigment { color rgb<51/255,204/255,255/255>*0.7 }
	finish { reflection 0.35 specular 1 }
	normal { ripples 2 turbulence 0.9 scale 0.2 }
}
#declare BoatTexA = texture {
	T_Brass_2B
}
#declare BoatTexB = texture {
	T_Silver_2B
}

#declare Room = union {
	plane { y, 0 pigment { Red } }
	plane { -y, -8 pigment { LightGray } }
	plane { x, -10 pigment { LightGray } }
	plane { -x, -10 pigment { LightGray } }
	plane { z, -10 pigment { LightGray } }
	plane { -z, -10 pigment { LightGray } }
}

#declare Picture = box {
	<0, 0, 9.999>, <1, 1, 9.8>
	pigment { image_map { png "triplet3.png" } }
	scale <4, 3, 1>
	translate <2, 3, 0>
}

#declare PictureFrame = difference {
	box { <-0.1, -0.1, 9.998>, <1.1, 1.1, 9.8> }
	box { <0, 0, 9.999>, <1, 1, 9.799> }
	scale <4, 3, 1>
	texture { T_Wood8 }
	translate <2, 3, 0>
}

#declare Table = union {
	box { <-3, 2.3, -2>, <3, 2.5, 2> }
	cylinder { <-2.7, 2.3, -1.7>, <-2.7, 0, -1.7>, 0.2 }
	cylinder { <2.7, 2.3, -1.7>, <2.7, 0, -1.7>, 0.2 }
	cylinder { <2.7, 2.3, 1.7>, <2.7, 0, 1.7>, 0.2 }
	cylinder { <-2.7, 2.3, 1.7>, <-2.7, 0, 1.7>, 0.2 }
	
	texture { T_Wood3 }
}

#declare GameBoard = box {
	<-0.75, 2.5, -1.5>, <2.75, 2.55, 1.5>
	texture { GameBoardTex }
}

#declare Boat1A = object {
	SmallBoat
	texture { BoatTexA }
	scale 0.03
}

#declare Boat2A = object {
	MediumBoat
	texture { BoatTexA }
	scale 0.03
}

#declare Boat3A = object {
	LargeBoat
	texture { BoatTexA }
	scale 0.03
}

#declare Boat1B = object {
	SmallBoat
	texture { BoatTexB }
	scale 0.03
}

#declare Boat2B = object {
	MediumBoat
	texture { BoatTexB }
	scale 0.03
}

#declare Boat3B = object {
	LargeBoat
	texture { BoatTexB }
	scale 0.03
}

// Game Box
box { 0, 1
	pigment { image_map { png "box_cover.png" } }
	finish { ambient 0.7 }
	normal { crackle scale 0.01 }
	scale <8/5, 1, 0.1>
	rotate -35*y
	translate <-2.4, 2.5, -1.5>
}

// Brass Player's On-Board Pieces
#declare NumBoat1A = 5;
#declare NumBoat2A = 4;
#declare NumBoat3A = 2;

#declare Ra = seed(53839);
#declare Rb = seed(5438);

#declare num = 0;
#while (num < NumBoat1A)
	object { Boat1A translate <-0.7+(int(rand(Ra)*17)/10), 2.55, -1.4+(int(rand(Rb)*29)/10)> }
	#declare num = num + 1;
#end

#declare num = 0;
#while (num < NumBoat2A)
	object { Boat2A translate <-0.7+(int(rand(Ra)*17)/10), 2.55, -1.4+(int(rand(Rb)*29)/10)> }
	#declare num = num + 1;
#end

#declare num = 0;
#while (num < NumBoat3A)
	object { Boat3A
		rotate -90*y
		translate <-0.7+(int(rand(Ra)*17)/10), 2.55, -1.4+(int(rand(Rb)*29)/10)> }
	#declare num = num + 1;
#end

// Silver Player's On-Board Pieces
#declare NumBoat1B = 4;
#declare NumBoat2B = 6;
#declare NumBoat3B = 1;

#declare Rc = seed(72844);
#declare Rd = seed(1284);

#declare num = 0;
#while (num < NumBoat1B)
	object { Boat1B translate <1.1+(int(rand(Rc)*15)/10), 2.55, -1.4+(int(rand(Rd)*29)/10)> }
	#declare num = num + 1;
#end

#declare num = 0;
#while (num < NumBoat2B)
	object { Boat2B
		rotate 180*y
		translate <1.1+(int(rand(Rc)*15)/10), 2.55, -1.4+(int(rand(Rd)*29)/10)> }
	#declare num = num + 1;
#end

#declare num = 0;
#while (num < NumBoat3B)
	object { Boat3B
		rotate 90*y
		translate <1.1+(int(rand(Rc)*15)/10), 2.55, -1.4+(int(rand(Rd)*29)/10)> }
	#declare num = num + 1;
#end

// Brass Player's Side-Board Pieces
object { Boat3A rotate -90*y translate <-0.8, 2.5, 1.6> }
object { Boat3A rotate -90*y translate <-0.6, 2.5, 1.6> }
object { Boat2A rotate -90*y translate <-0.4, 2.5, 1.6> }
object { Boat2A rotate -90*y translate <-0.2, 2.5, 1.6> }
object { Boat1A rotate -90*y translate <0, 2.5, 1.6> }
object { Boat1A rotate -90*y translate <0.1, 2.5, 1.6> }

// Silver Player's Side-Board Pieces
// Silver Player keeps a messy Side-Board
#declare R1 = seed(67);
#declare R2 = seed(34553);

#declare down = int(rand(R1)*2);
object { Boat3B
	rotate -90*y
	rotate down*-90*z
	rotate (int(rand(R2)*90)-45)*y
	translate <-0.7, 2.5+(0.06*down), -1.9>
}

#declare down = int(rand(R1)*2);
object {
	Boat2B
	rotate -90*y
	rotate down*-90*z
	rotate (int(rand(R2)*90)-45)*y
	translate <-0.4, 2.5+(0.06*down), -1.9>
}

#declare down = int(rand(R1)*2);
object {
	Boat2B
	rotate -90*y
	rotate down*-90*z
	rotate (int(rand(R2)*90)-45)*y
	translate <-0.1, 2.5+(0.06*down), -1.9>
}

#declare down = int(rand(R1)*2);
object {
	Boat2B
	rotate -90*y
	rotate down*-90*z 
	rotate (int(rand(R2)*90)-45)*y
	translate <0.2, 2.5+(0.06*down), -1.9>
}

#declare down = int(rand(R1)*2);
object {
	Boat1B
	rotate -90*y
	rotate down*-90*z 
	rotate (int(rand(R2)*90)-45)*y
	translate <0.5, 2.5+(0.03*down), -1.9>
}

#declare down = int(rand(R1)*2);
object {
	Boat1B
	rotate -90*y
	rotate down*-90*z 
	rotate (int(rand(R2)*90)-45)*y
	translate <0.8, 2.5+(0.03*down), -1.9>
}

#declare down = int(rand(R1)*2);
object {
	Boat1B
	rotate -90*y
	rotate down*-90*z 
	rotate (int(rand(R2)*90)-45)*y
	translate <1, 2.5+(0.03*down), -1.9>
}

object { Room }
object { Picture }
object { PictureFrame }
object { Table }
object { GameBoard }
