// starshape.inc - Macro to generate star-shaped prisms.
//
// Author: Kevin Jackson-Mead (jacksonmead@mindspring.com)
// Date:   23 August 2000
// Usage:  object { Star(16, 1, 1.7) texture { MyTexture } }

#macro Star(points, inner_radius, outer_radius)
	prism { linear_sweep linear_spline 0, 1, (points*2)+1,
	#local Angle = 360/points;
	#local Theta1 = 0;
	#local Theta2 = Angle/2;
	#while (Theta1 < 359.9)
		inner_radius*<cos(radians(Theta1)), sin(radians(Theta1))>,
		outer_radius*<cos(radians(Theta2)), sin(radians(Theta2))>,
		#local Theta1 = Theta1 + Angle;
		#local Theta2 = Theta2 + Angle;
	#end
	inner_radius*<1, 0> }
#end
		